/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.lateralgm.components.CustomFileChooser;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.main.LGM;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Include;
import org.lateralgm.subframes.InstantiableResourceFrame;

public class IncludeFrame
extends InstantiableResourceFrame<Include, Include.PInclude> {
    private static final long serialVersionUID = -2341007814035473389L;
    private CustomFileChooser fc = new CustomFileChooser("/org/lateralgm", "LAST_INCLUDE_FILE_DIR");
    private JButton saveDataBut;
    private JButton loadDataBut;
    private JLabel originalNameLabel;
    private JLabel sizeLabel;

    public IncludeFrame(Include r, ResNode node) {
        super(r, node);
        this.getRootPane().setDefaultButton(this.save);
        this.setDefaultCloseOperation(1);
        this.setLayout(new BorderLayout());
        this.saveDataBut = new JButton(LGM.getIconForKey("IncludeFrame.SAVE_DATA"));
        this.saveDataBut.setText(Messages.getString("IncludeFrame.SAVE_DATA"));
        this.saveDataBut.setToolTipText(Messages.getString("IncludeFrame.SAVE_TIP"));
        this.saveDataBut.addActionListener(this);
        this.loadDataBut = new JButton(LGM.getIconForKey("IncludeFrame.LOAD_DATA"));
        this.loadDataBut.setText(Messages.getString("IncludeFrame.LOAD_DATA"));
        this.loadDataBut.setToolTipText(Messages.getString("IncludeFrame.LOAD_TIP"));
        this.loadDataBut.addActionListener(this);
        JLabel nameLabel = new JLabel(Messages.getString("IncludeFrame.NAME"));
        this.originalNameLabel = new JLabel();
        this.sizeLabel = new JLabel();
        this.updateStatusLabels();
        JLabel fileNameLabel = new JLabel(Messages.getString("IncludeFrame.FILE_NAME"));
        JTextField fileNameField = new JTextField();
        this.plf.make(fileNameField.getDocument(), Include.PInclude.FILENAME);
        JCheckBox store = new JCheckBox(Messages.getString("IncludeFrame.STORE_EDITABLE"));
        this.plf.make(store, Include.PInclude.STORE);
        JCheckBox removeEnd = new JCheckBox(Messages.getString("IncludeFrame.REMOVE_FILES_AT_END"));
        this.plf.make(removeEnd, Include.PInclude.REMOVEATGAMEEND);
        JCheckBox freeMemory = new JCheckBox(Messages.getString("IncludeFrame.FREE_MEMORY"));
        this.plf.make(freeMemory, Include.PInclude.FREEMEMORY);
        JCheckBox overwrite = new JCheckBox(Messages.getString("IncludeFrame.OVERWRITE_EXISTING"));
        this.plf.make(overwrite, Include.PInclude.OVERWRITE);
        JPanel p = new JPanel();
        GroupLayout gl = new GroupLayout(p);
        p.setLayout(gl);
        gl.setAutoCreateGaps(true);
        gl.setAutoCreateContainerGaps(true);
        JPanel exportActionPanel = new JPanel();
        exportActionPanel.setLayout(new BoxLayout(exportActionPanel, 1));
        exportActionPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("IncludeFrame.EXPORT_ACTION")));
        final JTextField customFolderField = new JTextField();
        customFolderField.setEnabled(r.get(Include.PInclude.EXPORTACTION) == Include.ExportAction.CUSTOM_FOLDER);
        this.plf.make(customFolderField.getDocument(), Include.PInclude.EXPORTFOLDER);
        JRadioButton dontExport = new JRadioButton(Messages.getString("IncludeFrame.DONT_EXPORT"));
        JRadioButton tempDirectory = new JRadioButton(Messages.getString("IncludeFrame.TEMP_DIRECTORY"));
        JRadioButton sameFolder = new JRadioButton(Messages.getString("IncludeFrame.SAME_FOLDER"));
        JRadioButton customFolder = new JRadioButton(Messages.getString("IncludeFrame.CUSTOM_FOLDER"));
        customFolder.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                customFolderField.setEnabled(e.getStateChange() == 1);
            }
        });
        exportActionPanel.add(dontExport);
        exportActionPanel.add(tempDirectory);
        exportActionPanel.add(sameFolder);
        exportActionPanel.add(customFolder);
        exportActionPanel.add(customFolderField);
        ButtonGroup bg = new ButtonGroup();
        bg.add(dontExport);
        bg.add(tempDirectory);
        bg.add(sameFolder);
        bg.add(customFolder);
        this.plf.make(bg, Include.PInclude.EXPORTACTION, Include.ExportAction.class);
        this.save.setText(Messages.getString("IncludeFrame.SAVE"));
        gl.setHorizontalGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addComponent(nameLabel).addComponent(this.name, -1, -2, Integer.MAX_VALUE)).addComponent(this.originalNameLabel, 0, 0, -1).addComponent(this.sizeLabel, 0, 0, -1).addGroup(gl.createSequentialGroup().addComponent(fileNameLabel).addComponent(fileNameField, -1, -2, Integer.MAX_VALUE)).addComponent(store).addComponent(removeEnd).addComponent(freeMemory).addComponent(overwrite).addComponent(exportActionPanel, -1, -2, Integer.MAX_VALUE).addGroup(gl.createSequentialGroup().addComponent(this.save, -1, -2, Integer.MAX_VALUE).addComponent(this.loadDataBut, -1, -2, Integer.MAX_VALUE).addComponent(this.saveDataBut, -1, -2, Integer.MAX_VALUE)));
        gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(nameLabel).addComponent(this.name)).addComponent(this.originalNameLabel).addComponent(this.sizeLabel).addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(fileNameLabel).addComponent(fileNameField)).addComponent(store).addComponent(removeEnd).addComponent(freeMemory).addComponent(overwrite).addComponent(exportActionPanel, -1, -1, -2).addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.save).addComponent(this.loadDataBut).addComponent(this.saveDataBut)));
        this.add((Component)p, "Center");
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    private void updateStatusLabels() {
        this.saveDataBut.setEnabled(((Include)this.res).data != null && ((Include)this.res).data.length > 0);
        String filePathText = Messages.format("IncludeFrame.ORIGINAL_FILE", ((Include)this.res).get(Include.PInclude.FILEPATH));
        this.originalNameLabel.setText(filePathText);
        String sizeText = Messages.format("IncludeFrame.SIZE", ((Include)this.res).get(Include.PInclude.SIZE));
        this.sizeLabel.setText(sizeText);
        this.originalNameLabel.setToolTipText(filePathText);
        this.sizeLabel.setToolTipText(sizeText);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        super.actionPerformed(ev);
        Object source = ev.getSource();
        if (source == this.loadDataBut) {
            if (this.fc.showOpenDialog(LGM.frame) != 0) {
                return;
            }
            File f = this.fc.getSelectedFile();
            if (!f.exists()) {
                return;
            }
            ((Include)this.res).put(Include.PInclude.FILENAME, f.getName());
            ((Include)this.res).put(Include.PInclude.FILEPATH, f.getAbsolutePath());
            try {
                ((Include)this.res).data = Files.readAllBytes(f.toPath());
            }
            catch (IOException e) {
                LGM.showDefaultExceptionHandler(e);
            }
            ((Include)this.res).put(Include.PInclude.SIZE, ((Include)this.res).data.length);
            this.updateStatusLabels();
            return;
        }
        if (source == this.saveDataBut) {
            this.fc.setSelectedFile(new File(((Include)this.res).get(Include.PInclude.FILENAME).toString()));
            if (this.fc.showSaveDialog(LGM.frame) != 0) {
                return;
            }
            File f = this.fc.getSelectedFile();
            try {
                Files.write(f.toPath(), ((Include)this.res).data, new OpenOption[0]);
            }
            catch (IOException e) {
                LGM.showDefaultExceptionHandler(e);
            }
            return;
        }
    }

    @Override
    public void commitChanges() {
    }

    public void setComponents(Include inc) {
    }

    @Override
    public boolean resourceChanged() {
        this.commitChanges();
        return !((Include)this.res).properties.equals(((Include)this.resOriginal).properties);
    }

    @Override
    public void revertResource() {
        ((Include)this.res).properties.putAll(((Include)this.resOriginal).properties);
    }
}

