/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lateralgm.components.ActionList;
import org.lateralgm.components.ActionListEditor;
import org.lateralgm.components.CodeTextArea;
import org.lateralgm.components.NumberField;
import org.lateralgm.components.ResourceMenu;
import org.lateralgm.components.impl.EventNode;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.components.mdi.MDIFrame;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Listener;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Sprite;
import org.lateralgm.resources.library.LibAction;
import org.lateralgm.resources.library.LibManager;
import org.lateralgm.resources.sub.Action;
import org.lateralgm.resources.sub.Event;
import org.lateralgm.resources.sub.MainEvent;
import org.lateralgm.subframes.InstantiableResourceFrame;
import org.lateralgm.subframes.ResourceInfoFrame;
import org.lateralgm.util.PropertyMap;

public class GmObjectFrame
extends InstantiableResourceFrame<GmObject, GmObject.PGmObject>
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon INFO_ICON = LGM.getIconForKey("GmObjectFrame.INFO");
    public ResourceMenu<Sprite> sprite;
    public JButton newSprite;
    public JButton editSprite;
    public JButton information;
    public JCheckBox visible;
    public JCheckBox solid;
    public JCheckBox persistent;
    public NumberField depth;
    public ResourceMenu<GmObject> parent;
    public ResourceMenu<Sprite> mask;
    public EventTree events;
    public AbstractAction eventAddAct;
    public AbstractAction eventReplaceAct;
    public AbstractAction eventDuplicateAct;
    public AbstractAction eventEditAct;
    public AbstractAction eventDeleteAct;
    public EventGroupNode rootEvent;
    private MListener mListener = new MListener();
    public ActionList actions;
    public CodeTextArea code;
    private JComponent editor;
    private ResourceInfoFrame infoFrame;
    private DefaultMutableTreeNode lastValidEventSelection;
    private JCheckBox physics;
    private JPanel phyPane;
    private PropertyMap.PropertyUpdateListener<GmObject.PGmObject> propUpdateListener;

    public GmObjectFrame(GmObject res, ResNode node) {
        super(res, node);
        this.getRootPane().setDefaultButton(this.save);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.setLayout(layout);
        JPanel propPane = this.makePropertiesPane();
        this.phyPane = this.makePhysicsPane();
        JPanel evtPane = new JPanel(new BorderLayout());
        JPanel labPane = Util.makeLabelPane(Messages.getString("GmObjectFrame.EVENTS"));
        this.makeEventTree(res);
        JScrollPane scroll = new JScrollPane(this.events);
        scroll.setPreferredSize(new Dimension(140, 260));
        evtPane.add((Component)scroll, "Center");
        JPanel eventTitlePane = new JPanel(new BorderLayout());
        this.eventAddAct = new EventAction("ADD");
        this.eventReplaceAct = new EventAction("REPLACE");
        this.eventDuplicateAct = new EventAction("DUPLICATE");
        this.eventEditAct = new EventAction("EDIT");
        this.eventDeleteAct = new EventAction("DELETE");
        JToolBar eventToolBar = new JToolBar();
        eventToolBar.setFloatable(false);
        eventToolBar.add(this.eventAddAct);
        eventToolBar.add(this.eventReplaceAct);
        eventToolBar.add(this.eventDuplicateAct);
        eventToolBar.add(this.eventEditAct);
        eventToolBar.add(Box.createHorizontalGlue());
        eventToolBar.add(this.eventDeleteAct);
        eventTitlePane.add((Component)labPane, "North");
        eventTitlePane.add((Component)eventToolBar, "Center");
        evtPane.add((Component)eventTitlePane, "North");
        this.actions = new ActionList(this);
        if (Prefs.enableDragAndDrop) {
            this.editor = new ActionListEditor(this.actions);
        }
        GroupLayout.ParallelGroup pg = null;
        GroupLayout.SequentialGroup sg = layout.createSequentialGroup();
        if (Prefs.rightOrientation) {
            if (Prefs.enableDragAndDrop) {
                sg.addComponent(this.editor);
                sg.addGap(4);
            }
            sg.addComponent(evtPane).addComponent(this.phyPane, -1, -2, -2).addComponent(propPane, -1, -2, -2);
        } else {
            sg.addComponent(propPane, -1, -2, -2).addComponent(this.phyPane, -1, -2, -2).addComponent(evtPane);
            if (Prefs.enableDragAndDrop) {
                sg.addGap(4);
                sg.addComponent(this.editor);
            }
        }
        layout.setHorizontalGroup(sg);
        pg = layout.createParallelGroup().addComponent(propPane).addComponent(this.phyPane).addComponent(evtPane);
        if (Prefs.enableDragAndDrop) {
            pg.addComponent(this.editor);
        }
        layout.setVerticalGroup(pg);
        this.pack();
        this.phyPane.setVisible((Boolean)res.properties.get(GmObject.PGmObject.PHYSICS_OBJECT));
        this.propUpdateListener = new PropertyMap.PropertyUpdateListener<GmObject.PGmObject>(){

            @Override
            public void updated(PropertyMap.PropertyUpdateEvent<GmObject.PGmObject> e) {
                if (e.key == GmObject.PGmObject.PHYSICS_OBJECT) {
                    GmObjectFrame.this.phyPane.setVisible((Boolean)e.map.get((GmObject.PGmObject)((Object)e.key)));
                }
            }
        };
        res.properties.updateSource.addListener(this.propUpdateListener);
        TreeNode event = (TreeNode)this.events.getModel().getRoot();
        while (event.getChildCount() > 0) {
            event = event.getChildAt(0);
        }
        if (event != this.events.getModel().getRoot()) {
            this.events.setSelectionPath(new TreePath(((DefaultMutableTreeNode)event).getPath()));
        }
    }

    private JPanel makePhysicsPane() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(Messages.getString("GmObjectFrame.PHYSICS_PROPERTIES")));
        JCheckBox awakeCB = new JCheckBox(Messages.getString("GmObjectFrame.AWAKE"));
        this.plf.make(awakeCB, GmObject.PGmObject.PHYSICS_AWAKE);
        JCheckBox kinematicCB = new JCheckBox(Messages.getString("GmObjectFrame.KINEMATIC"));
        this.plf.make(kinematicCB, GmObject.PGmObject.PHYSICS_KINEMATIC);
        JCheckBox sensorCB = new JCheckBox(Messages.getString("GmObjectFrame.SENSOR"));
        this.plf.make(sensorCB, GmObject.PGmObject.PHYSICS_SENSOR);
        JLabel densityLabel = new JLabel(Messages.getString("GmObjectFrame.DENSITY"));
        NumberField densityField = new NumberField(0.0);
        this.plf.make(densityField, GmObject.PGmObject.PHYSICS_DENSITY);
        JLabel restLabel = new JLabel(Messages.getString("GmObjectFrame.RESTITUTION"));
        NumberField restField = new NumberField(0.0);
        this.plf.make(restField, GmObject.PGmObject.PHYSICS_RESTITUTION);
        JLabel groupLabel = new JLabel(Messages.getString("GmObjectFrame.COLLISION_GROUP"));
        NumberField groupField = new NumberField(0);
        this.plf.make(groupField, GmObject.PGmObject.PHYSICS_GROUP);
        JLabel linearLabel = new JLabel(Messages.getString("GmObjectFrame.DAMPING_LINEAR"));
        NumberField linearField = new NumberField(0.0);
        this.plf.make(linearField, GmObject.PGmObject.PHYSICS_DAMPING_LINEAR);
        JLabel angularLabel = new JLabel(Messages.getString("GmObjectFrame.DAMPING_ANGULAR"));
        NumberField angularField = new NumberField(0.0);
        this.plf.make(angularField, GmObject.PGmObject.PHYSICS_DAMPING_ANGULAR);
        JLabel frictionLabel = new JLabel(Messages.getString("GmObjectFrame.FRICTION"));
        NumberField frictionField = new NumberField(0.0);
        this.plf.make(frictionField, GmObject.PGmObject.PHYSICS_FRICTION);
        JButton shapeBT = new JButton(Messages.getString("GmObjectFrame.COLLISION_SHAPE"));
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(shapeBT).addGroup(layout.createSequentialGroup().addComponent(awakeCB).addComponent(kinematicCB)).addComponent(sensorCB).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(densityLabel).addComponent(restLabel).addComponent(groupLabel).addComponent(linearLabel).addComponent(angularLabel).addComponent(frictionLabel)).addGroup(layout.createParallelGroup().addComponent(densityField).addComponent(restField).addComponent(groupField).addComponent(linearField).addComponent(angularField).addComponent(frictionField))));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(shapeBT).addGroup(layout.createParallelGroup().addComponent(awakeCB).addComponent(kinematicCB)).addComponent(sensorCB).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(densityLabel).addComponent(densityField, -2, -2, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(restLabel).addComponent(restField, -2, -2, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(groupLabel).addComponent(groupField, -2, -2, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(linearLabel).addComponent(linearField, -2, -2, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(angularLabel).addComponent(angularField, -2, -2, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(frictionLabel).addComponent(frictionField, -2, -2, -2)));
        return panel;
    }

    private JPanel makePropertiesPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        panel.setLayout(layout);
        JLabel nLabel = new JLabel(Messages.getString("GmObjectFrame.NAME"));
        JPanel origin = new JPanel();
        GroupLayout oLayout = new GroupLayout(origin);
        origin.setLayout(oLayout);
        origin.setBorder(BorderFactory.createTitledBorder(Messages.getString("GmObjectFrame.SPRITE")));
        String t = Messages.getString("GmObjectFrame.NO_SPRITE");
        this.sprite = new ResourceMenu(Sprite.class, t, 144);
        this.plf.make(this.sprite, GmObject.PGmObject.SPRITE);
        this.newSprite = new JButton(Messages.getString("GmObjectFrame.NEW"));
        this.newSprite.addActionListener(this);
        this.editSprite = new JButton(Messages.getString("GmObjectFrame.EDIT"));
        this.editSprite.addActionListener(this);
        oLayout.setHorizontalGroup(oLayout.createSequentialGroup().addContainerGap(4, 4).addGroup(oLayout.createParallelGroup().addComponent(this.sprite).addGroup(oLayout.createSequentialGroup().addComponent(this.newSprite, -1, -1, Integer.MAX_VALUE).addGap(4).addComponent(this.editSprite, -1, -1, Integer.MAX_VALUE))).addContainerGap(4, 4));
        oLayout.setVerticalGroup(oLayout.createSequentialGroup().addComponent(this.sprite, -1, -1, -2).addGap(2).addGroup(oLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newSprite).addComponent(this.editSprite)).addContainerGap(4, 4));
        this.visible = new JCheckBox(Messages.getString("GmObjectFrame.VISIBLE"));
        this.plf.make(this.visible, GmObject.PGmObject.VISIBLE);
        this.solid = new JCheckBox(Messages.getString("GmObjectFrame.SOLID"));
        this.plf.make(this.solid, GmObject.PGmObject.SOLID);
        JLabel dLabel = new JLabel(Messages.getString("GmObjectFrame.DEPTH"));
        this.depth = new NumberField(0);
        this.plf.make(this.depth, GmObject.PGmObject.DEPTH);
        this.persistent = new JCheckBox(Messages.getString("GmObjectFrame.PERSISTENT"));
        this.plf.make(this.persistent, GmObject.PGmObject.PERSISTENT);
        this.physics = new JCheckBox(Messages.getString("GmObjectFrame.PHYSICS"));
        this.plf.make(this.physics, GmObject.PGmObject.PHYSICS_OBJECT);
        JLabel pLabel = new JLabel(Messages.getString("GmObjectFrame.PARENT"));
        t = Messages.getString("GmObjectFrame.NO_PARENT");
        this.parent = new ResourceMenu(GmObject.class, t, 110);
        this.plf.make(this.parent, GmObject.PGmObject.PARENT);
        JLabel mLabel = new JLabel(Messages.getString("GmObjectFrame.MASK"));
        t = Messages.getString("GmObjectFrame.SAME_AS_SPRITE");
        this.mask = new ResourceMenu(Sprite.class, t, 110);
        this.plf.make(this.mask, GmObject.PGmObject.MASK);
        this.information = new JButton(Messages.getString("GmObjectFrame.INFO"), INFO_ICON);
        this.information.addActionListener(this);
        this.save.setText(Messages.getString("GmObjectFrame.SAVE"));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(nLabel).addComponent(this.name, -1, 120, Integer.MAX_VALUE)).addComponent(origin).addGroup(layout.createSequentialGroup().addComponent(dLabel).addComponent(this.depth)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(pLabel).addComponent(mLabel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.parent, -1, 120, Integer.MAX_VALUE).addComponent(this.mask, -1, 120, Integer.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.visible).addComponent(this.solid)).addGroup(layout.createParallelGroup().addComponent(this.persistent).addComponent(this.physics))).addComponent(this.information, -1, -1, Integer.MAX_VALUE).addComponent(this.save, -1, -1, Integer.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(nLabel).addComponent(this.name)).addComponent(origin).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(dLabel).addComponent(this.depth)).addComponent(pLabel).addGap(4).addComponent(this.parent, -1, -1, -2).addComponent(mLabel).addGap(4).addComponent(this.mask, -1, -1, -2).addGap(8).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.visible).addComponent(this.solid)).addGroup(layout.createSequentialGroup().addComponent(this.persistent).addComponent(this.physics))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 0, Integer.MAX_VALUE).addComponent(this.information).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.save));
        return panel;
    }

    public void addEvent(Event e) {
        EventInstanceNode ein;
        int i = 0;
        while (i < this.rootEvent.getChildCount()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)this.rootEvent.getChildAt(i);
            if (n instanceof EventGroupNode) {
                EventGroupNode group = (EventGroupNode)n;
                if (group.mainId == e.mainId) {
                    if (!group.contains(e)) {
                        group.add(new EventInstanceNode(e));
                        group.sortChildren();
                    }
                    group.select(e);
                    return;
                }
            } else {
                ein = (EventInstanceNode)n;
                if (ein.getUserObject().mainId == e.mainId) {
                    if (!ein.getUserObject().matchesType(e)) {
                        EventGroupNode group = new EventGroupNode(e.mainId);
                        int ind = this.rootEvent.getIndex(ein);
                        this.rootEvent.remove(ind);
                        this.rootEvent.insert(group, ind);
                        group.add(ein);
                        group.add(new EventInstanceNode(e));
                        group.sortChildren();
                        group.select(e);
                    } else {
                        this.rootEvent.select(e);
                    }
                    return;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.rootEvent.getChildCount()) {
            int mid = this.rootEvent.getChildAt(i) instanceof EventInstanceNode ? ((EventInstanceNode)this.rootEvent.getChildAt((int)i)).getUserObject().mainId : ((EventGroupNode)this.rootEvent.getChildAt((int)i)).mainId;
            if (mid > e.mainId) {
                ein = new EventInstanceNode(e);
                this.rootEvent.insert(ein, i);
                this.rootEvent.select(e);
                return;
            }
            ++i;
        }
        EventInstanceNode ein2 = new EventInstanceNode(e);
        this.rootEvent.add(ein2);
        this.rootEvent.select(e);
    }

    public void removeEvent(EventInstanceNode n) {
        DefaultMutableTreeNode p = (DefaultMutableTreeNode)n.getParent();
        if (p == null) {
            return;
        }
        DefaultMutableTreeNode next = n.getNextSibling();
        if (next == null) {
            next = n.getPreviousSibling();
        }
        if (p == this.rootEvent) {
            n.removeFromParent();
        } else if (p.getChildCount() < 3) {
            n.removeFromParent();
            this.rootEvent.insert((DefaultMutableTreeNode)p.getChildAt(0), this.rootEvent.getIndex(p));
            p.removeFromParent();
        } else {
            n.removeFromParent();
        }
        if (next == null && this.rootEvent.getChildCount() != 0) {
            next = (DefaultMutableTreeNode)this.rootEvent.getChildAt(0);
        }
        if (next == null) {
            this.actions.setActionContainer(null);
        } else {
            TreePath path = new TreePath((next instanceof EventInstanceNode ? next : (DefaultMutableTreeNode)next.getChildAt(0)).getPath());
            this.events.setSelectionPath(path);
            this.events.scrollPathToVisible(path);
        }
        this.events.updateUI();
    }

    public void functionEvent(int mainId, int id, ResourceReference<GmObject> other, TreePath path) {
        this.functionEvent(0, mainId, id, other, path);
    }

    public void functionEvent(int func, int mainId, int id, ResourceReference<GmObject> other, TreePath path) {
        if (path == null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.events.getLastSelectedPathComponent();
            TreePath treePath = path = node == null ? null : new TreePath(node.getPath());
        }
        if (path == null) {
            func = 0;
        }
        switch (func) {
            case 0: {
                this.addEvent(new Event(mainId, id, other));
                break;
            }
            case 1: {
                DefaultMutableTreeNode dropNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (!(dropNode instanceof EventInstanceNode) || dropNode.getParent() == null) {
                    return;
                }
                EventInstanceNode drop = (EventInstanceNode)dropNode;
                this.removeEvent(drop);
                Event ev = drop.getUserObject();
                ev.mainId = mainId;
                ev.id = id;
                ev.other = other;
                this.addEvent(ev);
                break;
            }
            case 2: {
                DefaultMutableTreeNode dropNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (!(dropNode instanceof EventInstanceNode) || dropNode.getParent() == null) {
                    return;
                }
                EventInstanceNode drop = (EventInstanceNode)dropNode;
                Event ev = drop.getUserObject();
                this.actions.save();
                Event ev2 = ev.copy();
                ev2.mainId = mainId;
                ev2.id = id;
                ev2.other = other;
                this.addEvent(ev2);
            }
        }
    }

    public void makeEventTree(GmObject res) {
        this.rootEvent = new EventGroupNode(-1);
        int m = 0;
        while (m < 12) {
            MainEvent me = res.mainEvents.get(m);
            List<Event> ale = me.events;
            if (ale.size() == 1) {
                this.rootEvent.add(new EventInstanceNode(ale.get(0)));
            }
            if (ale.size() > 1) {
                EventGroupNode node = new EventGroupNode(m);
                this.rootEvent.add(node);
                for (Event e : ale) {
                    node.add(new EventInstanceNode(e));
                }
            }
            ++m;
        }
        if (res.getNode().newRes && this.rootEvent.getChildCount() == 0) {
            this.rootEvent.add(new EventInstanceNode(new Event(0, 0, null)));
            this.rootEvent.add(new EventInstanceNode(new Event(3, 0, null)));
            this.rootEvent.add(new EventInstanceNode(new Event(8, 0, null)));
        }
        this.events = new EventTree(this.rootEvent);
        this.events.setScrollsOnExpand(true);
        this.events.setCellRenderer(new EventNodeRenderer());
        this.events.setRootVisible(false);
        this.events.setShowsRootHandles(true);
        this.events.setExpandsSelectedPaths(false);
        this.events.addMouseListener(this.mListener);
        this.events.getSelectionModel().setSelectionMode(4);
        this.events.addTreeSelectionListener(this);
        if (Prefs.expandEventTree) {
            int i = 0;
            while (i < this.events.getRowCount()) {
                this.events.expandRow(i);
                ++i;
            }
        }
        if (LGM.javaVersion >= 10600) {
            this.events.setDragEnabled(true);
            this.events.setDropMode(DropMode.ON);
            this.events.setTransferHandler(new EventNodeTransferHandler());
        }
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GmObjectFrame.this.editSelectedEvent();
                }
            }
        };
        this.events.addMouseListener(ml);
    }

    public void showInfoFrame() {
        this.saveEvents();
        if (this.infoFrame == null) {
            this.infoFrame = new ResourceInfoFrame();
        }
        this.infoFrame.updateObjectInfo(((GmObject)this.res).reference);
        this.infoFrame.setVisible(true);
    }

    public void saveEvents() {
        this.actions.save();
        Enumeration<TreeNode> dfe = this.rootEvent.depthFirstEnumeration();
        for (MainEvent me : ((GmObject)this.res).mainEvents) {
            me.events.clear();
        }
        while (dfe.hasMoreElements()) {
            TreeNode o = dfe.nextElement();
            if (!(o instanceof EventInstanceNode)) continue;
            EventInstanceNode ein = (EventInstanceNode)o;
            if (ein.getUserObject().actions.isEmpty()) continue;
            Event e = ein.getUserObject();
            ((GmObject)this.res).mainEvents.get((int)e.mainId).events.add(e);
        }
    }

    @Override
    protected boolean areResourceFieldsEqual() {
        return Util.areInherentlyUniquesEqual(((GmObject)this.res).mainEvents, ((GmObject)this.resOriginal).mainEvents);
    }

    @Override
    public void commitChanges() {
        this.saveEvents();
        ((GmObject)this.res).setName(this.name.getText());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.newSprite) {
            ResNode n = Listener.getPrimaryParent(Sprite.class);
            Sprite spr = LGM.currentFile.resMap.getList(Sprite.class).add();
            Listener.putNode(LGM.tree, n, n, Sprite.class, n.getChildCount(), spr);
            ((GmObject)this.res).put(GmObject.PGmObject.SPRITE, spr.reference);
            return;
        }
        if (e.getSource() == this.editSprite) {
            Sprite spr = Util.deRef(this.sprite.getSelected());
            if (spr == null) {
                return;
            }
            spr.getNode().openFrame();
            return;
        }
        if (e.getSource() == this.information) {
            this.showInfoFrame();
            return;
        }
        super.actionPerformed(e);
    }

    private TreeNode[] findEvent(DefaultMutableTreeNode node, int mainid, int id) {
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode[] ret;
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            if (child instanceof EventInstanceNode) {
                EventInstanceNode evtNode = (EventInstanceNode)child;
                Event evt = evtNode.getUserObject();
                if (evt.mainId != mainid || evt.id != id) continue;
                return evtNode.getPath();
            }
            if (!(child instanceof EventGroupNode) || (ret = this.findEvent(child, mainid, id)) == null) continue;
            return ret;
        }
        return null;
    }

    private TreeNode[] findEvent(int mainid, int id) {
        return this.findEvent((DefaultMutableTreeNode)this.events.getModel().getRoot(), mainid, id);
    }

    public void setSelectedEvent(int mainid, int id) {
        Object[] nodes = this.findEvent(mainid, id);
        if (nodes != null) {
            TreePath path = new TreePath(nodes);
            this.events.makeVisible(path);
            this.events.setSelectionPath(path);
        }
    }

    private void editSelectedEvent() {
        if (this.events.getModel().getChildCount(this.events.getModel().getRoot()) == 0) {
            return;
        }
        Action a = null;
        LibAction la = null;
        Boolean prependNew = true;
        int i = 0;
        while (i < this.actions.model.list.size()) {
            a = this.actions.model.list.get(i);
            la = a.getLibAction();
            if (la.actionKind == 7) {
                prependNew = false;
                break;
            }
            ++i;
        }
        if (prependNew.booleanValue()) {
            a = new Action(LibManager.codeAction);
            ((ActionList.ActionListModel)this.actions.getModel()).add(0, a);
            this.actions.setSelectedValue(a, true);
        }
        MDIFrame af = this.actions.openActionFrame((MDIFrame)this.actions.parent.get(), a);
        EventInstanceNode evnode = (EventInstanceNode)this.events.getLastSelectedPathComponent();
        af.setTitle(Messages.format("GmObjectFrame.EDIT_TITLE", this.name.getText(), evnode.toString()));
        af.setFrameIcon(LGM.getIconForKey("EventNode.EVENT" + evnode.getUserObject().mainId));
    }

    private static boolean isValidEventInstanceNode(Object node) {
        return node != null && node instanceof EventInstanceNode && ((EventInstanceNode)node).getParent() != null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.events.removeTreeSelectionListener(this);
        this.events.setModel(null);
        this.events.setTransferHandler(null);
        this.information.removeActionListener(this);
        this.newSprite.removeActionListener(this);
        this.editSprite.removeActionListener(this);
        if (this.infoFrame != null) {
            this.infoFrame.dispose();
        }
        ((GmObject)this.res).properties.updateSource.removeListener(this.propUpdateListener);
        if (this.editor != null) {
            ((ActionListEditor)this.editor).dispose();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.events.getLastSelectedPathComponent();
        if (node == null || !node.isLeaf() || !(node.getUserObject() instanceof Event)) {
            if (node != null && !node.isLeaf() && node.getParent() != null) {
                TreePath path = new TreePath(node.getPath());
                if (this.events.isExpanded(path)) {
                    this.events.collapsePath(path);
                } else {
                    this.events.expandPath(path);
                }
            }
            if (this.lastValidEventSelection != null) {
                this.events.setSelectionPath(new TreePath(this.lastValidEventSelection.getPath()));
            }
            return;
        }
        this.lastValidEventSelection = node;
        this.actions.setActionContainer((Event)node.getUserObject());
    }

    @Override
    public void exceptionThrown(Exception e) {
        if (e instanceof GmObject.ParentLoopException) {
            String msg = Messages.getString("GmObjectFrame.LOOPING_PARENTS");
            String ttl = Messages.getString("GmObjectFrame.WARNING");
            JOptionPane.showMessageDialog(this, msg, ttl, 2);
            return;
        }
        super.exceptionThrown(e);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension p = this.getContentPane().getSize();
        Dimension l = this.getContentPane().getMinimumSize();
        Dimension s = this.getSize();
        l.width += s.width - p.width;
        l.height += s.height - p.height;
        return l;
    }

    public class EventAction
    extends AbstractAction {
        private static final long serialVersionUID = -6590532160318334567L;

        public EventAction(String key) {
            this.putValue("SmallIcon", LGM.getIconForKey("GmObjectFrame." + key + "_EVENT"));
            this.putValue("Name", Messages.getString("GmObjectFrame." + key));
            this.putValue("ShortDescription", Messages.getString("GmObjectFrame." + key + "_EVENT"));
            this.putValue("ActionCommandKey", "GmObjectFrame." + key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd == null) {
                return;
            }
            if (cmd.endsWith(".ADD")) {
                LGM.showEventPanel(0);
            } else if (cmd.endsWith(".REPLACE")) {
                LGM.showEventPanel(1);
            } else if (cmd.endsWith(".DUPLICATE")) {
                LGM.showEventPanel(2);
            } else if (cmd.endsWith(".EDIT")) {
                GmObjectFrame.this.editSelectedEvent();
            } else if (cmd.endsWith(".DELETE")) {
                DefaultMutableTreeNode comp = (DefaultMutableTreeNode)GmObjectFrame.this.events.getLastSelectedPathComponent();
                if (!GmObjectFrame.isValidEventInstanceNode(comp)) {
                    return;
                }
                GmObjectFrame.this.removeEvent((EventInstanceNode)comp);
            }
        }
    }

    public class EventGroupNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        public int mainId;

        public EventGroupNode(int mainId) {
            super(Messages.getString("MainEvent.EVENT" + mainId));
            this.mainId = mainId;
        }

        public boolean contains(Event e) {
            int i = 0;
            while (i < this.getChildCount()) {
                if (this.getChildAt(i) instanceof EventInstanceNode ? ((EventInstanceNode)this.getChildAt(i)).getUserObject().matchesType(e) : ((EventGroupNode)this.getChildAt(i)).contains(e)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void sortChildren() {
            Collections.sort(this.children);
        }

        public TreePath childPath(Event e) {
            int i = 0;
            while (i < this.getChildCount()) {
                if (this.getChildAt(i) instanceof EventInstanceNode && ((EventInstanceNode)this.getChildAt(i)).getUserObject().matchesType(e)) {
                    return new TreePath(((EventInstanceNode)this.getChildAt(i)).getPath());
                }
                ++i;
            }
            return null;
        }

        public void select(Event e) {
            TreePath p = this.childPath(e);
            GmObjectFrame.this.events.setSelectionPath(p);
            GmObjectFrame.this.events.updateUI();
            GmObjectFrame.this.events.scrollPathToVisible(p);
            GmObjectFrame.this.events.updateUI();
        }
    }

    public static class EventInstanceNode
    extends DefaultMutableTreeNode
    implements Comparable<EventInstanceNode> {
        private static final long serialVersionUID = 1L;

        public EventInstanceNode(Event e) {
            super(e);
        }

        @Override
        public Event getUserObject() {
            return (Event)super.getUserObject();
        }

        @Override
        public int compareTo(EventInstanceNode n) {
            return this.getUserObject().compareTo(n.getUserObject());
        }
    }

    public static class EventNodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ImageIcon i;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            int mid = -1;
            if (value instanceof EventNode) {
                mid = ((EventNode)value).mainId;
            }
            if (value instanceof EventInstanceNode) {
                mid = ((EventInstanceNode)value).getUserObject().mainId;
            }
            if (value instanceof EventGroupNode) {
                mid = ((EventGroupNode)value).mainId;
            }
            if ((i = LGM.getIconForKey("EventNode." + (leaf ? "EVENT" : "GROUP") + mid)) != null && i.getIconWidth() != -1) {
                this.setIcon(i);
            }
            return this;
        }
    }

    private class EventNodeTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        @Override
        protected Transferable createTransferable(JComponent c) {
            return null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 0;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(EventNode.DATA_FLAVOR)) {
                return false;
            }
            if (!GmObjectFrame.isValidEventInstanceNode(GmObjectFrame.this.events.getLastSelectedPathComponent())) {
                return false;
            }
            DataFlavor[] dataFlavorArray = support.getDataFlavors();
            int n = dataFlavorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor f = dataFlavorArray[n2];
                if (f == EventNode.DATA_FLAVOR) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            EventNode t;
            block4: {
                if (!this.canImport(support)) {
                    return false;
                }
                try {
                    t = (EventNode)support.getTransferable().getTransferData(EventNode.DATA_FLAVOR);
                    if (t.isValid()) break block4;
                    return false;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return false;
                }
            }
            Point p = support.getDropLocation().getDropPoint();
            TreePath path = GmObjectFrame.this.events.getPathForLocation(p.x, p.y);
            GmObjectFrame.this.functionEvent(t.mainId, t.eventId, t.other, path);
            return true;
        }
    }

    public static class EventTree
    extends JTree {
        private static final long serialVersionUID = 1L;

        public EventTree(TreeNode n) {
            super(n);
            this.setToolTipText("");
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Point p = e.getPoint();
            TreePath path = this.getPathForLocation(p.x, p.y);
            if (path == null) {
                return null;
            }
            Object c = path.getLastPathComponent();
            if (c instanceof EventInstanceNode) {
                EventInstanceNode node = (EventInstanceNode)c;
                Event ev = node.getUserObject();
                return Messages.format("MainEvent.EVENT_HINT" + ev.mainId, ev.toString());
            }
            return Messages.format("MainEvent.EVENTS", c.toString());
        }
    }

    private class MListener
    extends MouseAdapter {
        private MListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() != GmObjectFrame.this.events) {
                return;
            }
            int button = e.getButton();
            if (button == 3) {
                TreePath path = GmObjectFrame.this.events.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node.isLeaf()) {
                    GmObjectFrame.this.lastValidEventSelection = node;
                    GmObjectFrame.this.actions.setActionContainer((Event)node.getUserObject());
                    GmObjectFrame.this.events.setSelectionPath(path);
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(GmObjectFrame.this.eventAddAct).setToolTipText(null);
                    menu.add(GmObjectFrame.this.eventReplaceAct).setToolTipText(null);
                    menu.add(GmObjectFrame.this.eventDuplicateAct).setToolTipText(null);
                    menu.addSeparator();
                    menu.add(GmObjectFrame.this.eventEditAct).setToolTipText(null);
                    menu.addSeparator();
                    menu.add(GmObjectFrame.this.eventDeleteAct).setToolTipText(null);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

