/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.lateralgm.components.ColorSelect;
import org.lateralgm.components.CustomFileChooser;
import org.lateralgm.components.NumberField;
import org.lateralgm.components.impl.CustomFileFilter;
import org.lateralgm.components.impl.IndexButtonGroup;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.components.visual.FileChooserImagePreview;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.file.iconio.ICOFile;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.GameSettings;
import org.lateralgm.resources.Include;
import org.lateralgm.subframes.ResourceFrame;

public class GameSettingFrame
extends ResourceFrame<GameSettings, GameSettings.PGameSettings> {
    private static final long serialVersionUID = 1L;
    private static final int MAX_VIEWABLE_ICON_SIZE = 64;
    boolean imagesChanged = false;
    public JPanel cardPane;
    public NumberField gameId;
    public JButton randomise;
    public ColorSelect colorbutton;
    public JCheckBox startFullscreen;
    public IndexButtonGroup scaling;
    public NumberField scale;
    public JCheckBox interpolatecolors;
    public JCheckBox resizeWindow;
    public JCheckBox stayOnTop;
    public JCheckBox noWindowBorder;
    public JCheckBox noWindowButtons;
    public JCheckBox displayMouse;
    public JCheckBox freezeGame;
    public JCheckBox disableScreensavers;
    public JCheckBox softwareVertexProcessing;
    public JCheckBox synchronised;
    public JCheckBox setResolution;
    public ButtonGroup colorDepth;
    public ButtonGroup resolution;
    public ButtonGroup frequency;
    public JPanel resolutionPane;
    public JCheckBox esc;
    public JCheckBox close;
    public JCheckBox f1;
    public JCheckBox f4;
    public JCheckBox f5;
    public JCheckBox f9;
    public ButtonGroup gamePriority;
    public JCheckBox showCustomLoadImage;
    public BufferedImage customLoadingImage;
    public JButton changeCustomLoad;
    public JCheckBox imagePartiallyTransparent;
    public NumberField loadImageAlpha;
    public ButtonGroup loadBarMode;
    public JRadioButton pbCustom;
    public JButton backLoad;
    public JButton frontLoad;
    public BufferedImage backLoadImage;
    public BufferedImage frontLoadImage;
    public JCheckBox scaleProgressBar;
    public JList<Include> includes;
    public ButtonGroup exportFolder;
    public JCheckBox overwriteExisting;
    public JCheckBox removeAtGameEnd;
    private CustomFileChooser includesFc;
    JCheckBox displayErrors;
    JCheckBox writeToLog;
    JCheckBox abortOnError;
    JCheckBox treatUninitialisedAs0;
    JCheckBox errorOnArgs;
    JTextField author;
    JTextField version;
    JTextField lastChanged;
    JTextArea information;
    public JLabel iconPreview;
    public ICOFile gameIcon;
    public JButton changeIcon;
    private CustomFileChooser iconFc;
    NumberField versionMajorField;
    NumberField versionMinorField;
    NumberField versionReleaseField;
    NumberField versionBuildField;
    JTextField companyField;
    JTextField productField;
    JTextField copyrightField;
    JTextField descriptionField;
    public JButton discardButton;
    public JTree tree;

    private JPanel makeGeneralPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        JLabel backcolor = new JLabel(Messages.getString("GameSettingFrame.BACKCOLOR"));
        this.colorbutton = new ColorSelect();
        this.plf.make(this.colorbutton, GameSettings.PGameSettings.COLOR_OUTSIDE_ROOM);
        JCheckBox useNewAudio = new JCheckBox(Messages.getString("GameSettingFrame.USE_NEW_AUDIO"));
        this.plf.make(useNewAudio, GameSettings.PGameSettings.USE_NEW_AUDIO);
        JCheckBox shortCircuitEval = new JCheckBox(Messages.getString("GameSettingFrame.SHORT_CIRCUIT_EVAL"));
        this.plf.make(shortCircuitEval, GameSettings.PGameSettings.SHORT_CIRCUIT_EVAL);
        JCheckBox useFastCollision = new JCheckBox(Messages.getString("GameSettingFrame.USE_FAST_COLLISION"));
        this.plf.make(useFastCollision, GameSettings.PGameSettings.USE_FAST_COLLISION);
        JCheckBox fastCollisionCompat = new JCheckBox(Messages.getString("GameSettingFrame.FAST_COLLISION_COMPAT"));
        this.plf.make(fastCollisionCompat, GameSettings.PGameSettings.FAST_COLLISION_COMPAT);
        JLabel lId = new JLabel(Messages.getString("GameSettingFrame.GAME_ID"));
        this.gameId = new NumberField(0, 100000000);
        this.plf.make(this.gameId, GameSettings.PGameSettings.GAME_ID);
        this.randomise = new JButton(Messages.getString("GameSettingFrame.RANDOMIZE"));
        this.randomise.addActionListener(this);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(lId).addComponent(this.gameId, -1, -1, -2))).addGroup(layout.createParallelGroup().addComponent(this.randomise, -1, -1, Integer.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(backcolor).addComponent(this.colorbutton)).addComponent(useNewAudio).addComponent(shortCircuitEval).addComponent(useFastCollision).addComponent(fastCollisionCompat));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lId).addComponent(this.gameId).addComponent(this.randomise)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(backcolor).addComponent(this.colorbutton)).addComponent(useNewAudio).addComponent(shortCircuitEval).addComponent(useFastCollision).addComponent(fastCollisionCompat));
        return panel;
    }

    private JPanel makeGraphicsPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        this.startFullscreen = new JCheckBox(Messages.getString("GameSettingFrame.FULLSCREEN"));
        this.plf.make(this.startFullscreen, GameSettings.PGameSettings.START_FULLSCREEN);
        JPanel scalegroup = new JPanel();
        GroupLayout sLayout = new GroupLayout(scalegroup);
        scalegroup.setLayout(sLayout);
        String t = Messages.getString("GameSettingFrame.SCALING_TITLE");
        scalegroup.setBorder(BorderFactory.createTitledBorder(t));
        this.scaling = new IndexButtonGroup(3, true, false, this);
        JRadioButton osFixed = new JRadioButton(Messages.getString("GameSettingFrame.SCALING_FIXED"));
        this.scaling.add(osFixed, 1);
        this.scale = new NumberField(1, 999, 100);
        JRadioButton osRatio = new JRadioButton(Messages.getString("GameSettingFrame.SCALING_RATIO"));
        this.scaling.add(osRatio, -1);
        JRadioButton osFull = new JRadioButton(Messages.getString("GameSettingFrame.SCALING_FULL"));
        this.scaling.add(osFull, 0);
        sLayout.setHorizontalGroup(sLayout.createParallelGroup().addGroup(sLayout.createSequentialGroup().addComponent(osFixed).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scale, -1, -1, -2).addContainerGap()).addComponent(osRatio).addComponent(osFull));
        sLayout.setVerticalGroup(sLayout.createSequentialGroup().addGroup(sLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(osFixed).addComponent(this.scale)).addComponent(osRatio).addComponent(osFull));
        int s = (Integer)((GameSettings)this.res).properties.get(GameSettings.PGameSettings.SCALING);
        this.scaling.setValue(s > 1 ? 1 : s);
        if (s > 1) {
            this.scale.setValue(s);
        }
        this.scale.setEnabled(s > 0);
        t = Messages.getString("GameSettingFrame.INTERPOLATE");
        this.interpolatecolors = new JCheckBox(t);
        this.plf.make(this.interpolatecolors, GameSettings.PGameSettings.INTERPOLATE);
        this.resizeWindow = new JCheckBox(Messages.getString("GameSettingFrame.RESIZE"));
        this.stayOnTop = new JCheckBox(Messages.getString("GameSettingFrame.STAYONTOP"));
        this.noWindowBorder = new JCheckBox(Messages.getString("GameSettingFrame.NOBORDER"));
        this.noWindowButtons = new JCheckBox(Messages.getString("GameSettingFrame.NOBUTTONS"));
        this.displayMouse = new JCheckBox(Messages.getString("GameSettingFrame.DISPLAYCURSOR"));
        this.freezeGame = new JCheckBox(Messages.getString("GameSettingFrame.FREEZE"));
        this.disableScreensavers = new JCheckBox(Messages.getString("GameSettingFrame.DISABLE_SCREENSAVERS"));
        this.softwareVertexProcessing = new JCheckBox(Messages.getString("GameSettingFrame.FORCE_SOFTWARE_VERTEX_PROCESSING"));
        this.plf.make(this.resizeWindow, GameSettings.PGameSettings.ALLOW_WINDOW_RESIZE);
        this.plf.make(this.stayOnTop, GameSettings.PGameSettings.ALWAYS_ON_TOP);
        this.plf.make(this.noWindowBorder, GameSettings.PGameSettings.DONT_DRAW_BORDER);
        this.plf.make(this.noWindowButtons, GameSettings.PGameSettings.DONT_SHOW_BUTTONS);
        this.plf.make(this.displayMouse, GameSettings.PGameSettings.DISPLAY_CURSOR);
        this.plf.make(this.freezeGame, GameSettings.PGameSettings.FREEZE_ON_LOSE_FOCUS);
        this.plf.make(this.disableScreensavers, GameSettings.PGameSettings.DISABLE_SCREENSAVERS);
        this.plf.make(this.softwareVertexProcessing, GameSettings.PGameSettings.FORCE_SOFTWARE_VERTEX_PROCESSING);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.startFullscreen).addComponent(scalegroup).addComponent(this.interpolatecolors).addComponent(this.resizeWindow).addComponent(this.stayOnTop).addComponent(this.noWindowBorder).addComponent(this.noWindowButtons).addComponent(this.displayMouse).addComponent(this.freezeGame).addComponent(this.disableScreensavers).addComponent(this.softwareVertexProcessing));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.startFullscreen).addComponent(scalegroup).addComponent(this.interpolatecolors).addComponent(this.resizeWindow).addComponent(this.stayOnTop).addComponent(this.noWindowBorder).addComponent(this.noWindowButtons).addComponent(this.displayMouse).addComponent(this.freezeGame).addComponent(this.disableScreensavers).addComponent(this.softwareVertexProcessing).addGap(4, 4, Integer.MAX_VALUE));
        return panel;
    }

    private <V extends Enum<V>> JPanel makeRadioPane(String title, ButtonGroup bg, GameSettings.PGameSettings prop, Class<V> optsClass, String[] vals) {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder(title));
        p.setLayout(new BoxLayout(p, 3));
        String[] stringArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            JRadioButton but = new JRadioButton(Messages.getString(s));
            bg.add(but);
            p.add(but);
            ++n2;
        }
        this.plf.make(bg, prop, optsClass);
        return p;
    }

    private JPanel makeResolutionPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHonorsVisibility(false);
        panel.setLayout(layout);
        this.synchronised = new JCheckBox(Messages.getString("GameSettingFrame.USE_SYNC"));
        this.plf.make(this.synchronised, GameSettings.PGameSettings.USE_SYNCHRONIZATION);
        this.setResolution = new JCheckBox(Messages.getString("GameSettingFrame.SET_RESOLUTION"));
        this.plf.make(this.setResolution, GameSettings.PGameSettings.SET_RESOLUTION);
        this.setResolution.addActionListener(this);
        this.resolutionPane = new JPanel();
        GroupLayout rpLayout = new GroupLayout(this.resolutionPane);
        rpLayout.setAutoCreateGaps(true);
        this.resolutionPane.setLayout(rpLayout);
        String[] colDepths = new String[]{"GameSettingFrame.NO_CHANGE", "GameSettingFrame.16_BIT", "GameSettingFrame.32_BIT"};
        String[] resolutions = new String[]{"GameSettingFrame.NO_CHANGE", "GameSettingFrame.320X240", "GameSettingFrame.640X480", "GameSettingFrame.800X600", "GameSettingFrame.1024X768", "GameSettingFrame.1280X1024", "GameSettingFrame.1600X1200"};
        String[] freqs = new String[]{"GameSettingFrame.NO_CHANGE", "GameSettingFrame.60HZ", "GameSettingFrame.70HZ", "GameSettingFrame.85HZ", "GameSettingFrame.100HZ", "GameSettingFrame.120HZ"};
        this.colorDepth = new ButtonGroup();
        JPanel depth = this.makeRadioPane(Messages.getString("GameSettingFrame.TITLE_COLOR_DEPTH"), this.colorDepth, GameSettings.PGameSettings.COLOR_DEPTH, GameSettings.ColorDepth.class, colDepths);
        this.resolution = new ButtonGroup();
        JPanel resol = this.makeRadioPane(Messages.getString("GameSettingFrame.TITLE_RESOLUTION"), this.resolution, GameSettings.PGameSettings.RESOLUTION, GameSettings.Resolution.class, resolutions);
        this.frequency = new ButtonGroup();
        JPanel freq = this.makeRadioPane(Messages.getString("GameSettingFrame.TITLE_FREQUENCY"), this.frequency, GameSettings.PGameSettings.FREQUENCY, GameSettings.Frequency.class, freqs);
        rpLayout.setHorizontalGroup(rpLayout.createSequentialGroup().addComponent(depth, -1, -1, Integer.MAX_VALUE).addComponent(resol, -1, -1, Integer.MAX_VALUE).addComponent(freq, -1, -1, Integer.MAX_VALUE));
        rpLayout.setVerticalGroup(rpLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(depth, -1, -1, Integer.MAX_VALUE).addComponent(resol, -1, -1, Integer.MAX_VALUE).addComponent(freq, -1, -1, Integer.MAX_VALUE));
        this.resolutionPane.setVisible(this.setResolution.isSelected());
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.synchronised).addComponent(this.setResolution).addComponent(this.resolutionPane));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.synchronised).addComponent(this.setResolution).addComponent(this.resolutionPane));
        return panel;
    }

    private JPanel makeOtherPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        String t = Messages.getString("GameSettingFrame.TITLE_KEYS");
        JPanel dKeys = new JPanel();
        dKeys.setBorder(BorderFactory.createTitledBorder(t));
        dKeys.setLayout(new BoxLayout(dKeys, 3));
        this.esc = new JCheckBox(Messages.getString("GameSettingFrame.KEY_ENDGAME"));
        this.close = new JCheckBox(Messages.getString("GameSettingFrame.KEY_CLOSEGAME"));
        this.f1 = new JCheckBox(Messages.getString("GameSettingFrame.KEY_INFO"));
        this.f4 = new JCheckBox(Messages.getString("GameSettingFrame.KEY_SWITCHFULLSCREEN"));
        this.f5 = new JCheckBox(Messages.getString("GameSettingFrame.SAVELOAD"));
        this.f9 = new JCheckBox(Messages.getString("GameSettingFrame.KEY_SCREENSHOT"));
        dKeys.add(this.esc);
        dKeys.add(this.close);
        dKeys.add(this.f1);
        dKeys.add(this.f4);
        dKeys.add(this.f5);
        dKeys.add(this.f9);
        this.plf.make(this.esc, GameSettings.PGameSettings.LET_ESC_END_GAME);
        this.plf.make(this.close, GameSettings.PGameSettings.TREAT_CLOSE_AS_ESCAPE);
        this.plf.make(this.f1, GameSettings.PGameSettings.LET_F1_SHOW_GAME_INFO);
        this.plf.make(this.f4, GameSettings.PGameSettings.LET_F4_SWITCH_FULLSCREEN);
        this.plf.make(this.f5, GameSettings.PGameSettings.LET_F5_SAVE_F6_LOAD);
        this.plf.make(this.f9, GameSettings.PGameSettings.LET_F9_SCREENSHOT);
        String[] priorities = new String[]{"GameSettingFrame.PRIORITY_NORMAL", "GameSettingFrame.PRIORITY_HIGH", "GameSettingFrame.PRIORITY_HIHGEST"};
        this.gamePriority = new ButtonGroup();
        JPanel priority = this.makeRadioPane(Messages.getString("GameSettingFrame.TITLE_PRIORITY"), this.gamePriority, GameSettings.PGameSettings.GAME_PRIORITY, GameSettings.Priority.class, priorities);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(dKeys, -1, -1, Integer.MAX_VALUE).addComponent(priority, -1, -1, Integer.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(dKeys).addComponent(priority));
        return panel;
    }

    private JPanel makeTextureAtlasesPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        return panel;
    }

    private JPanel makeLoadingPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        JPanel loadImage = new JPanel();
        String t = Messages.getString("GameSettingFrame.TITLE_LOADING_IMAGE");
        loadImage.setBorder(BorderFactory.createTitledBorder(t));
        GroupLayout liLayout = new GroupLayout(loadImage);
        loadImage.setLayout(liLayout);
        this.showCustomLoadImage = new JCheckBox(Messages.getString("GameSettingFrame.CUSTOM_LOAD_IMAGE"));
        this.plf.make(this.showCustomLoadImage, GameSettings.PGameSettings.SHOW_CUSTOM_LOAD_IMAGE);
        this.showCustomLoadImage.addActionListener(this);
        this.customLoadingImage = (BufferedImage)((GameSettings)this.res).properties.get(GameSettings.PGameSettings.LOADING_IMAGE);
        this.changeCustomLoad = new JButton(Messages.getString("GameSettingFrame.CHANGE_IMAGE"));
        this.changeCustomLoad.setEnabled(this.showCustomLoadImage.isSelected());
        this.changeCustomLoad.addActionListener(this);
        this.imagePartiallyTransparent = new JCheckBox(Messages.getString("GameSettingFrame.MAKE_TRANSPARENT"));
        this.plf.make(this.imagePartiallyTransparent, GameSettings.PGameSettings.IMAGE_PARTIALLY_TRANSPARENTY);
        JLabel lAlpha = new JLabel(Messages.getString("GameSettingFrame.ALPHA_TRANSPARENCY"));
        this.loadImageAlpha = new NumberField(0, 255);
        this.plf.make(this.loadImageAlpha, GameSettings.PGameSettings.LOAD_IMAGE_ALPHA);
        liLayout.setHorizontalGroup(liLayout.createParallelGroup().addGroup(liLayout.createSequentialGroup().addComponent(this.showCustomLoadImage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.changeCustomLoad)).addComponent(this.imagePartiallyTransparent).addGroup(liLayout.createSequentialGroup().addContainerGap().addComponent(lAlpha).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadImageAlpha, -1, -1, -2).addContainerGap()));
        liLayout.setVerticalGroup(liLayout.createSequentialGroup().addGroup(liLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showCustomLoadImage).addComponent(this.changeCustomLoad)).addComponent(this.imagePartiallyTransparent).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(liLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lAlpha).addComponent(this.loadImageAlpha)).addContainerGap());
        JPanel progBar = new JPanel();
        GroupLayout pbLayout = new GroupLayout(progBar);
        t = Messages.getString("GameSettingFrame.TITLE_LOADING_PROGRESS_BAR");
        progBar.setBorder(BorderFactory.createTitledBorder(t));
        progBar.setLayout(pbLayout);
        this.loadBarMode = new ButtonGroup();
        JRadioButton pbNo = new JRadioButton(Messages.getString("GameSettingFrame.NO_PROGRESS_BAR"));
        this.loadBarMode.add(pbNo);
        JRadioButton pbDef = new JRadioButton(Messages.getString("GameSettingFrame.DEF_PROGRESS_BAR"));
        this.loadBarMode.add(pbDef);
        this.pbCustom = new JRadioButton(Messages.getString("GameSettingFrame.CUSTOM_PROGRESS_BAR"));
        this.loadBarMode.add(this.pbCustom);
        this.plf.make(this.loadBarMode, GameSettings.PGameSettings.LOAD_BAR_MODE, GameSettings.ProgressBar.class);
        this.backLoad = new JButton(Messages.getString("GameSettingFrame.BACK_IMAGE"));
        this.backLoad.addActionListener(this);
        this.backLoadImage = (BufferedImage)((GameSettings)this.res).properties.get(GameSettings.PGameSettings.BACK_LOAD_BAR);
        this.frontLoad = new JButton(Messages.getString("GameSettingFrame.FRONT_IMAGE"));
        this.frontLoad.addActionListener(this);
        this.frontLoadImage = (BufferedImage)((GameSettings)this.res).properties.get(GameSettings.PGameSettings.FRONT_LOAD_BAR);
        this.backLoad.setEnabled(this.pbCustom.isSelected());
        this.frontLoad.setEnabled(this.backLoad.isEnabled());
        this.scaleProgressBar = new JCheckBox(Messages.getString("GameSettingFrame.SCALE_IMAGE"));
        this.plf.make(this.scaleProgressBar, GameSettings.PGameSettings.SCALE_PROGRESS_BAR);
        pbLayout.setHorizontalGroup(pbLayout.createParallelGroup().addComponent(pbNo).addComponent(pbDef).addComponent(this.pbCustom).addGroup(pbLayout.createSequentialGroup().addContainerGap().addComponent(this.backLoad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.frontLoad).addContainerGap()).addComponent(this.scaleProgressBar));
        pbLayout.setVerticalGroup(pbLayout.createSequentialGroup().addComponent(pbNo).addComponent(pbDef).addComponent(this.pbCustom).addGroup(pbLayout.createParallelGroup().addComponent(this.backLoad).addComponent(this.frontLoad)).addComponent(this.scaleProgressBar));
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new CustomFileFilter(Messages.getString("GameSettingFrame.ICO_FILES"), ".ico"));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(loadImage, -1, -1, Integer.MAX_VALUE).addComponent(progBar, -1, -1, Integer.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(loadImage).addComponent(progBar));
        return panel;
    }

    private JPanel makeIncludePane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        String[] incFolders = new String[]{"GameSettingFrame.SAME_FOLDER", "GameSettingFrame.TEMP_DIRECTORY"};
        this.exportFolder = new ButtonGroup();
        JPanel folderPanel = this.makeRadioPane(Messages.getString("GameSettingFrame.EXPORT_TO"), this.exportFolder, GameSettings.PGameSettings.INCLUDE_FOLDER, GameSettings.IncludeFolder.class, incFolders);
        this.overwriteExisting = new JCheckBox(Messages.getString("GameSettingFrame.OVERWRITE_EXISTING"));
        this.removeAtGameEnd = new JCheckBox(Messages.getString("GameSettingFrame.REMOVE_FILES_AT_END"));
        this.plf.make(this.overwriteExisting, GameSettings.PGameSettings.OVERWRITE_EXISTING);
        this.plf.make(this.removeAtGameEnd, GameSettings.PGameSettings.REMOVE_AT_GAME_END);
        this.includesFc = new CustomFileChooser("/org/lateralgm", "LAST_INCLUDES_DIR");
        this.includesFc.setMultiSelectionEnabled(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(folderPanel).addGap(4, 8, Integer.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent(this.overwriteExisting).addComponent(this.removeAtGameEnd)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(folderPanel).addGroup(layout.createSequentialGroup().addComponent(this.overwriteExisting).addComponent(this.removeAtGameEnd)));
        return panel;
    }

    private JPanel makeErrorPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        this.displayErrors = new JCheckBox(Messages.getString("GameSettingFrame.ERRORS_DISPLAY"));
        this.writeToLog = new JCheckBox(Messages.getString("GameSettingFrame.ERRORS_LOG"));
        this.abortOnError = new JCheckBox(Messages.getString("GameSettingFrame.ERRORS_ABORT"));
        this.treatUninitialisedAs0 = new JCheckBox(Messages.getString("GameSettingFrame.UNINITZERO"));
        this.errorOnArgs = new JCheckBox(Messages.getString("GameSettingFrame.ERRORS_ARGS"));
        this.plf.make(this.displayErrors, GameSettings.PGameSettings.DISPLAY_ERRORS);
        this.plf.make(this.writeToLog, GameSettings.PGameSettings.WRITE_TO_LOG);
        this.plf.make(this.abortOnError, GameSettings.PGameSettings.ABORT_ON_ERROR);
        this.plf.make(this.treatUninitialisedAs0, GameSettings.PGameSettings.TREAT_UNINIT_AS_0);
        this.plf.make(this.errorOnArgs, GameSettings.PGameSettings.ERROR_ON_ARGS);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.displayErrors).addComponent(this.writeToLog).addComponent(this.abortOnError).addComponent(this.treatUninitialisedAs0).addComponent(this.errorOnArgs));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.displayErrors).addComponent(this.writeToLog).addComponent(this.abortOnError).addComponent(this.treatUninitialisedAs0).addComponent(this.errorOnArgs));
        return panel;
    }

    private JPanel makeInfoPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JLabel lAuthor = new JLabel(Messages.getString("GameSettingFrame.AUTHOR"));
        this.author = new JTextField();
        JLabel lVersion = new JLabel(Messages.getString("GameSettingFrame.VERSION"));
        this.version = new JTextField();
        JLabel lChanged = new JLabel(Messages.getString("GameSettingFrame.LASTCHANGED"));
        this.lastChanged = new JTextField(ProjectFile.gmTimeToString(((GameSettings)this.res).getLastChanged()));
        this.lastChanged.setEditable(false);
        JLabel lInfo = new JLabel(Messages.getString("GameSettingFrame.INFORMATION"));
        this.information = new JTextArea();
        this.information.setLineWrap(true);
        JScrollPane infoScroll = new JScrollPane(this.information);
        this.plf.make(this.author.getDocument(), GameSettings.PGameSettings.AUTHOR);
        this.plf.make(this.version.getDocument(), GameSettings.PGameSettings.VERSION);
        this.plf.make(this.information.getDocument(), GameSettings.PGameSettings.INFORMATION);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lAuthor).addComponent(lVersion).addComponent(lChanged)).addGroup(layout.createParallelGroup().addComponent(this.author, -1, 240, Integer.MAX_VALUE).addComponent(this.version, -1, 240, Integer.MAX_VALUE).addComponent(this.lastChanged, -1, 240, Integer.MAX_VALUE))).addComponent(lInfo, -1, 320, Integer.MAX_VALUE).addComponent(infoScroll));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lAuthor).addComponent(this.author)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lVersion).addComponent(this.version)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lChanged).addComponent(this.lastChanged)).addComponent(lInfo).addComponent(infoScroll));
        panel.setLayout(layout);
        return panel;
    }

    private static BufferedImage scale_image(BufferedImage src, int imgType, int destSize) {
        if (src == null) {
            return null;
        }
        BufferedImage dest = new BufferedImage(destSize, destSize, imgType);
        Graphics2D g = dest.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform at = AffineTransform.getScaleInstance((float)destSize / (float)src.getWidth(), (float)destSize / (float)src.getHeight());
        g.drawRenderedImage(src, at);
        g.dispose();
        return dest;
    }

    private void setIconPreviewToGameIcon() {
        BufferedImage src = null;
        if (this.gameIcon != null && (src = (BufferedImage)this.gameIcon.getDisplayImage()) != null && (src.getWidth() > 32 || src.getHeight() > 32)) {
            src = GameSettingFrame.scale_image(src, 2, 64);
        }
        this.iconPreview.setIcon(new ImageIcon(src));
    }

    private JPanel makeWindowsPane() {
        JPanel panel = new JPanel();
        this.gameIcon = (ICOFile)((GameSettings)this.res).properties.get(GameSettings.PGameSettings.GAME_ICON);
        this.iconPreview = new JLabel(Messages.getString("GameSettingFrame.GAME_ICON"));
        this.setIconPreviewToGameIcon();
        this.iconPreview.setHorizontalTextPosition(2);
        this.changeIcon = new JButton(Messages.getString("GameSettingFrame.CHANGE_ICON"));
        this.changeIcon.addActionListener(this);
        this.iconFc = new CustomFileChooser("/org/lateralgm", "LAST_ICON_DIR");
        this.iconFc.setAccessory(new FileChooserImagePreview(this.iconFc));
        this.iconFc.setFileFilter(new CustomFileFilter(Messages.getString("GameSettingFrame.ICO_FILES"), ".ico"));
        JPanel versionPanel = new JPanel();
        versionPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("GameSettingFrame.VERSION_INFORMATION")));
        JLabel versionLabel = new JLabel(Messages.getString("GameSettingFrame.VERSION"));
        this.versionMajorField = new NumberField(0);
        this.plf.make(this.versionMajorField, GameSettings.PGameSettings.VERSION_MAJOR);
        this.versionMinorField = new NumberField(0);
        this.plf.make(this.versionMinorField, GameSettings.PGameSettings.VERSION_MINOR);
        this.versionReleaseField = new NumberField(0);
        this.plf.make(this.versionReleaseField, GameSettings.PGameSettings.VERSION_RELEASE);
        this.versionBuildField = new NumberField(0);
        this.plf.make(this.versionBuildField, GameSettings.PGameSettings.VERSION_BUILD);
        JLabel companyLabel = new JLabel(Messages.getString("GameSettingFrame.COMPANY"));
        this.companyField = new JTextField();
        this.plf.make(this.companyField.getDocument(), GameSettings.PGameSettings.COMPANY);
        JLabel productLabel = new JLabel(Messages.getString("GameSettingFrame.PRODUCT"));
        this.productField = new JTextField();
        this.plf.make(this.productField.getDocument(), GameSettings.PGameSettings.PRODUCT);
        JLabel copyrightLabel = new JLabel(Messages.getString("GameSettingFrame.COPYRIGHT"));
        this.copyrightField = new JTextField();
        this.plf.make(this.copyrightField.getDocument(), GameSettings.PGameSettings.COPYRIGHT);
        JLabel descriptionLabel = new JLabel(Messages.getString("GameSettingFrame.DESCRIPTION"));
        this.descriptionField = new JTextField();
        this.plf.make(this.descriptionField.getDocument(), GameSettings.PGameSettings.DESCRIPTION);
        GroupLayout vl = new GroupLayout(versionPanel);
        vl.setAutoCreateGaps(true);
        vl.setAutoCreateContainerGaps(true);
        vl.setHorizontalGroup(vl.createSequentialGroup().addGroup(vl.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(versionLabel).addComponent(companyLabel).addComponent(productLabel).addComponent(copyrightLabel).addComponent(descriptionLabel)).addGroup(vl.createParallelGroup().addGroup(vl.createSequentialGroup().addComponent(this.versionMajorField).addComponent(this.versionMinorField).addComponent(this.versionReleaseField).addComponent(this.versionBuildField)).addComponent(this.companyField).addComponent(this.productField).addComponent(this.copyrightField).addComponent(this.descriptionField)));
        vl.setVerticalGroup(vl.createSequentialGroup().addGroup(vl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(versionLabel).addComponent(this.versionMajorField, -2, -2, -2).addComponent(this.versionMinorField, -2, -2, -2).addComponent(this.versionReleaseField, -2, -2, -2).addComponent(this.versionBuildField, -2, -2, -2)).addGroup(vl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(companyLabel).addComponent(this.companyField, -2, -2, -2)).addGroup(vl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(productLabel).addComponent(this.productField, -2, -2, -2)).addGroup(vl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(copyrightLabel).addComponent(this.copyrightField, -2, -2, -2)).addGroup(vl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(descriptionLabel).addComponent(this.descriptionField, -2, -2, -2)));
        versionPanel.setLayout(vl);
        GroupLayout gl = new GroupLayout(panel);
        gl.setAutoCreateGaps(true);
        gl.setAutoCreateContainerGaps(true);
        gl.setHorizontalGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addComponent(this.iconPreview).addComponent(this.changeIcon)).addComponent(versionPanel));
        gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup().addComponent(this.iconPreview).addComponent(this.changeIcon)).addComponent(versionPanel));
        panel.setLayout(gl);
        return panel;
    }

    private JPanel makeSteamPane() {
        JPanel panel = new JPanel();
        GroupLayout gl = new GroupLayout(panel);
        gl.setAutoCreateGaps(true);
        gl.setAutoCreateContainerGaps(true);
        JPanel appIdPanel = new JPanel();
        appIdPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("GameSettingFrame.STEAM_APP_ID")));
        GroupLayout al = new GroupLayout(appIdPanel);
        al.setAutoCreateGaps(true);
        al.setAutoCreateContainerGaps(true);
        JLabel windowsSteamLabel = new JLabel(Messages.getString("GameSettingFrame.WINDOWS_STEAM_ID"));
        JLabel macSteamLabel = new JLabel(Messages.getString("GameSettingFrame.MAC_STEAM_ID"));
        JLabel linuxSteamLabel = new JLabel(Messages.getString("GameSettingFrame.LINUX_STEAM_ID"));
        NumberField windowsSteamAppId = new NumberField(0);
        this.plf.make(windowsSteamAppId, GameSettings.PGameSettings.WINDOWS_STEAM_ID);
        NumberField macSteamAppId = new NumberField(0);
        this.plf.make(macSteamAppId, GameSettings.PGameSettings.MAC_STEAM_ID);
        NumberField linuxSteamAppId = new NumberField(0);
        this.plf.make(linuxSteamAppId, GameSettings.PGameSettings.LINUX_STEAM_ID);
        JCheckBox windowsSteamEnable = new JCheckBox(Messages.getString("GameSettingFrame.WINDOWS_STEAM_ENABLE"));
        this.plf.make(windowsSteamEnable, GameSettings.PGameSettings.WINDOWS_STEAM_ENABLE);
        JCheckBox macSteamEnable = new JCheckBox(Messages.getString("GameSettingFrame.MAC_STEAM_ENABLE"));
        this.plf.make(macSteamEnable, GameSettings.PGameSettings.MAC_STEAM_ENABLE);
        JCheckBox linuxSteamEnable = new JCheckBox(Messages.getString("GameSettingFrame.LINUX_STEAM_ENABLE"));
        this.plf.make(linuxSteamEnable, GameSettings.PGameSettings.LINUX_STEAM_ENABLE);
        al.setHorizontalGroup(al.createSequentialGroup().addGroup(al.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(windowsSteamLabel).addComponent(macSteamLabel).addComponent(linuxSteamLabel)).addGroup(al.createParallelGroup().addComponent(windowsSteamAppId).addComponent(macSteamAppId).addComponent(linuxSteamAppId)).addGroup(al.createParallelGroup().addComponent(windowsSteamEnable).addComponent(macSteamEnable).addComponent(linuxSteamEnable)));
        al.setVerticalGroup(al.createSequentialGroup().addGroup(al.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(windowsSteamLabel).addComponent(windowsSteamAppId, -1, -1, -2).addComponent(windowsSteamEnable)).addGroup(al.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(macSteamLabel).addComponent(macSteamAppId, -1, -1, -2).addComponent(macSteamEnable)).addGroup(al.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(linuxSteamLabel).addComponent(linuxSteamAppId, -1, -1, -2).addComponent(linuxSteamEnable)));
        appIdPanel.setLayout(al);
        gl.setHorizontalGroup(gl.createParallelGroup().addComponent(appIdPanel));
        gl.setVerticalGroup(gl.createSequentialGroup().addComponent(appIdPanel));
        panel.setLayout(gl);
        return panel;
    }

    public GameSettingFrame(GameSettings res) {
        this(res, (ResNode)null);
    }

    public void updateTitle() {
        this.setTitle(String.valueOf(Messages.getString("GameSettingFrame.TITLE")) + " : " + ((GameSettings)this.resOriginal).getName());
    }

    public GameSettingFrame(GameSettings res, ResNode node) {
        super(res, node, Messages.getString("GameSettingFrame.TITLE"), true, true, true, true);
        this.setDefaultCloseOperation(1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        layout.setAutoCreateGaps(true);
        this.setLayout(layout);
        String t = Messages.getString("GameSettingFrame.BUTTON_SAVE");
        this.save.setText(t);
        this.getRootPane().setDefaultButton(this.save);
        t = Messages.getString("GameSettingFrame.BUTTON_DISCARD");
        this.discardButton = new JButton(t);
        this.discardButton.addActionListener(this);
        this.discardButton.setIcon(LGM.getIconForKey("GameSettingFrame.BUTTON_DISCARD"));
        this.discardButton.setMinimumSize(this.save.getMaximumSize());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Preferences");
        this.tree = new JTree(new DefaultTreeModel(root));
        this.tree.setEditable(false);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        this.tree.setCellRenderer(renderer);
        this.buildTabs(root);
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)GameSettingFrame.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                CardLayout cl = (CardLayout)GameSettingFrame.this.cardPane.getLayout();
                String nodeInfo = node.getUserObject().toString();
                cl.show(GameSettingFrame.this.cardPane, nodeInfo);
                nodeInfo = Integer.toString(node.hashCode());
                cl.show(GameSettingFrame.this.cardPane, nodeInfo);
            }
        });
        JSplitPane split = new JSplitPane(1, true, new JScrollPane(this.tree), this.cardPane);
        split.setDividerLocation(200);
        Component horizontalSpacer = Box.createHorizontalGlue();
        layout.linkSize(this.save, this.discardButton);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(split).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.save).addComponent(horizontalSpacer).addComponent(this.discardButton).addContainerGap()));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(split).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup().addComponent(this.save).addComponent(horizontalSpacer).addComponent(this.discardButton)).addContainerGap());
        this.pack();
        this.setSize(600, 500);
    }

    private DefaultMutableTreeNode buildTab(DefaultMutableTreeNode root, String key, JComponent pane) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(Messages.getString(key));
        root.add(node);
        if (pane != null) {
            pane.setName(key);
            this.cardPane.add((Component)pane, Integer.toString(node.hashCode()));
        }
        return node;
    }

    private void buildTabs(DefaultMutableTreeNode root) {
        this.cardPane = new JPanel(new CardLayout());
        this.buildTab(root, "GameSettingFrame.TAB_GENERAL", this.makeGeneralPane());
        this.buildTab(root, "GameSettingFrame.TAB_GRAPHICS", this.makeGraphicsPane());
        this.buildTab(root, "GameSettingFrame.TAB_RESOLUTION", this.makeResolutionPane());
        this.buildTab(root, "GameSettingFrame.TAB_OTHER", this.makeOtherPane());
        this.buildTab(root, "GameSettingFrame.TAB_LOADING", this.makeLoadingPane());
        this.buildTab(root, "GameSettingFrame.TAB_INCLUDE", this.makeIncludePane());
        this.buildTab(root, "GameSettingFrame.TAB_ERRORS", this.makeErrorPane());
        this.buildTab(root, "GameSettingFrame.TAB_INFO", this.makeInfoPane());
        this.buildTab(root, "GameSettingFrame.TAB_TEXTUREATLASES", this.makeTextureAtlasesPane());
        DefaultMutableTreeNode pnode = this.buildTab(root, "GameSettingFrame.TAB_PLATFORMS", null);
        this.buildTab(pnode, "GameSettingFrame.TAB_WINDOWS", this.makeWindowsPane());
        this.buildTab(pnode, "GameSettingFrame.TAB_MAC", null);
        this.buildTab(pnode, "GameSettingFrame.TAB_UBUNTU", null);
        this.buildTab(pnode, "GameSettingFrame.TAB_STEAM", this.makeSteamPane());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.discardButton) {
            this.revertResource();
            this.close();
            return;
        }
        String name = null;
        Component[] componentArray = this.cardPane.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            name = comp.getName();
            if (comp.isVisible() && name != null) break;
            ++n2;
        }
        if (name == null) {
            return;
        }
        if (name.endsWith(".TAB_GENERAL") && e.getSource() == this.randomise) {
            this.gameId.setValue(new Random().nextInt(100000001));
        }
        if (name.endsWith(".TAB_GRAPHICS")) {
            if (e.getSource() instanceof JRadioButton) {
                this.scale.setEnabled(this.scaling.getValue() > 0);
            }
        } else if (name.endsWith(".TAB_RESOLUTION")) {
            this.resolutionPane.setVisible(this.setResolution.isSelected());
        } else if (name.endsWith(".TAB_LOADING")) {
            this.loadActionPerformed(e);
        } else if (name.endsWith(".TAB_WINDOWS")) {
            this.windowsActionPerformed(e);
        }
    }

    private void windowsActionPerformed(ActionEvent e) {
        File f;
        if (e.getSource() == this.changeIcon && this.iconFc.showOpenDialog(LGM.frame) == 0 && (f = this.iconFc.getSelectedFile()).exists()) {
            try {
                FileInputStream fis = new FileInputStream(f);
                this.gameIcon = new ICOFile(fis);
                fis.close();
                this.setIconPreviewToGameIcon();
                this.imagesChanged = true;
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void loadActionPerformed(ActionEvent e) {
        BufferedImage img;
        if (e.getSource() == this.showCustomLoadImage) {
            this.changeCustomLoad.setEnabled(this.showCustomLoadImage.isSelected());
        } else if (e.getSource() == this.changeCustomLoad) {
            try {
                this.customLoadingImage = Util.getValidImage();
                this.imagesChanged = true;
            }
            catch (Throwable ex) {
                JOptionPane.showMessageDialog(LGM.frame, Messages.getString("GameSettingFrame.ERROR_LOADING_IMAGE"));
            }
        } else if (e.getSource() instanceof JRadioButton) {
            this.backLoad.setEnabled(this.pbCustom.isSelected());
            this.frontLoad.setEnabled(this.backLoad.isEnabled());
        } else if (e.getSource() == this.backLoad) {
            BufferedImage img2 = Util.getValidImage();
            if (img2 != null) {
                this.backLoadImage = img2;
                this.imagesChanged = true;
            }
        } else if (e.getSource() == this.frontLoad && (img = Util.getValidImage()) != null) {
            this.frontLoadImage = img;
            this.imagesChanged = true;
        }
    }

    @Override
    public void commitChanges() {
        ((GameSettings)this.res).put(GameSettings.PGameSettings.SCALING, (Object)(this.scaling.getValue() > 0 ? this.scale.getIntValue().intValue() : this.scaling.getValue()));
        ((GameSettings)this.res).put(GameSettings.PGameSettings.LOADING_IMAGE, (Object)this.customLoadingImage);
        ((GameSettings)this.res).put(GameSettings.PGameSettings.BACK_LOAD_BAR, (Object)this.backLoadImage);
        ((GameSettings)this.res).put(GameSettings.PGameSettings.FRONT_LOAD_BAR, (Object)this.frontLoadImage);
        ((GameSettings)this.res).put(GameSettings.PGameSettings.GAME_ICON, (Object)this.gameIcon);
    }

    public void setComponents(GameSettings g) {
        int s = (Integer)g.get(GameSettings.PGameSettings.SCALING);
        this.scaling.setValue(s > 1 ? 1 : s);
        if (s > 1) {
            this.scale.setValue(s);
        }
        this.scale.setEnabled(s > 0);
        this.lastChanged.setText(ProjectFile.gmTimeToString(g.getLastChanged()));
        this.customLoadingImage = (BufferedImage)g.get(GameSettings.PGameSettings.LOADING_IMAGE);
        this.backLoadImage = (BufferedImage)g.get(GameSettings.PGameSettings.BACK_LOAD_BAR);
        this.frontLoadImage = (BufferedImage)g.get(GameSettings.PGameSettings.FRONT_LOAD_BAR);
        this.gameIcon = (ICOFile)g.get(GameSettings.PGameSettings.GAME_ICON);
        this.setIconPreviewToGameIcon();
        this.imagesChanged = true;
    }

    @Override
    public String getConfirmationName() {
        return this.getTitle();
    }

    @Override
    public boolean resourceChanged() {
        this.commitChanges();
        if (this.frameListener != null && this.frameListener.resourceChanged()) {
            return true;
        }
        if (this.imagesChanged) {
            return true;
        }
        return !((GameSettings)this.res).properties.equals(((GameSettings)this.resOriginal).properties);
    }

    @Override
    public void revertResource() {
        if (this.frameListener != null) {
            this.frameListener.revertResource();
        }
        ((GameSettings)this.res).properties.putAll(((GameSettings)this.resOriginal).properties);
        this.setComponents((GameSettings)this.res);
        this.plf.setMap(((GameSettings)this.res).properties);
        this.imagesChanged = false;
    }

    @Override
    public void updateResource(boolean commit) {
        super.updateResource(commit);
        this.imagesChanged = false;
    }
}

