/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.rtf.RTFEditorKit;
import org.lateralgm.components.CustomFileChooser;
import org.lateralgm.components.NumberField;
import org.lateralgm.components.impl.CustomFileFilter;
import org.lateralgm.components.impl.DocumentUndoManager;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.components.impl.TextAreaFocusTraversalPolicy;
import org.lateralgm.main.LGM;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.GameInformation;
import org.lateralgm.subframes.ResourceFrame;

public class GameInformationFrame
extends ResourceFrame<GameInformation, GameInformation.PGameInformation> {
    private static final long serialVersionUID = 1L;
    protected SettingsFrame settings;
    protected JEditorPane editor;
    private RTFEditorKit rtf = new RTFEditorKit();
    protected JMenuBar menubar;
    protected JToolBar toolbar;
    protected JComboBox<String> cbFonts;
    protected JSpinner sSizes;
    protected JToggleButton tbBold;
    protected JToggleButton tbItalic;
    protected JToggleButton tbUnderline;
    protected JToggleButton tbLeft;
    protected JToggleButton tbCenter;
    protected JToggleButton tbRight;
    private JMenuItem miBold;
    private JMenuItem miItalic;
    private JMenuItem miUnderline;
    private JMenuItem miLeft;
    private JMenuItem miCenter;
    private JMenuItem miRight;
    protected DocumentUndoManager undoManager = new DocumentUndoManager();
    private CustomFileChooser fc;
    protected Color fgColor;
    protected boolean fFamilyChange = false;
    protected boolean fSizeChange = false;
    public JTextField sTitle;
    public NumberField sX;
    public NumberField sY;
    public NumberField sWidth;
    public NumberField sHeight;
    public JCheckBox sShowBorder;
    public JCheckBox sAllowResize;
    public JCheckBox sAlwaysOnTop;
    public JCheckBox sPauseGame;
    public JCheckBox sEmbed;
    public JButton sCloseButton;

    private JMenuBar makeMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(Messages.getString("GameInformationFrame.MENU_FILE"));
        menuBar.add(menu);
        menu.addActionListener(this);
        JMenuItem item = this.addItem("GameInformationFrame.LOAD");
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.LOAD")));
        menu.add(item);
        item = this.addItem("GameInformationFrame.FILESAVE");
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.FILESAVE")));
        menu.add(item);
        menu.addSeparator();
        item = this.addItem("GameInformationFrame.SETTINGS");
        menu.add(item);
        item = this.addItem("GameInformationFrame.PRINT");
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.PRINT")));
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(Messages.getString("GameInformationFrame.CLOSESAVE"));
        item.setIcon(this.save.getIcon());
        item.setActionCommand("GameInformationFrame.CLOSESAVE");
        item.addActionListener(this);
        menu.add(item);
        menu = new JMenu(Messages.getString("GameInformationFrame.MENU_EDIT"));
        menuBar.add(menu);
        item = this.addItem("GameInformationFrame.CUT");
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.CUT")));
        menu.add(item);
        item = this.addItem("GameInformationFrame.COPY");
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.COPY")));
        menu.add(item);
        item = this.addItem("GameInformationFrame.PASTE");
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.PASTE")));
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(this.undoManager.getUndoAction());
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.UNDO")));
        menu.add(item);
        item = new JMenuItem(this.undoManager.getRedoAction());
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.REDO")));
        menu.add(item);
        menu.addSeparator();
        item = this.addItem("GameInformationFrame.SELECTALL");
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.SELECTALL")));
        menu.add(item);
        menu = new JMenu(Messages.getString("GameInformationFrame.MENU_FORMAT"));
        menuBar.add(menu);
        this.miBold = this.addItem("GameInformationFrame.BOLD");
        this.miBold.setActionCommand("GameInformationFrame.MENU_BOLD");
        this.miBold.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.BOLD")));
        menu.add(this.miBold);
        this.miItalic = this.addItem("GameInformationFrame.ITALIC");
        this.miItalic.setActionCommand("GameInformationFrame.MENU_ITALIC");
        this.miItalic.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.ITALIC")));
        menu.add(this.miItalic);
        this.miUnderline = this.addItem("GameInformationFrame.UNDERLINE");
        this.miUnderline.setActionCommand("GameInformationFrame.MENU_UNDERLINE");
        this.miUnderline.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.UNDERLINE")));
        menu.add(this.miUnderline);
        menu.addSeparator();
        this.miLeft = this.addItem("GameInformationFrame.ALIGN_LEFT");
        this.miLeft.setActionCommand("GameInformationFrame.ALIGN_LEFT");
        this.miLeft.setSelected(true);
        menu.add(this.miLeft);
        this.miCenter = this.addItem("GameInformationFrame.ALIGN_CENTER");
        this.miCenter.setActionCommand("GameInformationFrame.ALIGN_CENTER");
        menu.add(this.miCenter);
        this.miRight = this.addItem("GameInformationFrame.ALIGN_RIGHT");
        this.miRight.setActionCommand("GameInformationFrame.ALIGN_RIGHT");
        menu.add(this.miRight);
        menu.addSeparator();
        item = this.addItem("GameInformationFrame.FONTCOLOR");
        menu.add(item);
        item = this.addItem("GameInformationFrame.COLOR");
        menu.add(item);
        return menuBar;
    }

    private JToolBar makeToolBar() {
        JToolBar tool = new JToolBar();
        tool.setFloatable(false);
        this.save.setRequestFocusEnabled(false);
        tool.add(this.save);
        tool.addSeparator();
        JButton button = this.addToolButton("GameInformationFrame.CUT");
        tool.add(button);
        button = this.addToolButton("GameInformationFrame.COPY");
        tool.add(button);
        button = this.addToolButton("GameInformationFrame.PASTE");
        tool.add(button);
        tool.addSeparator();
        button = new JButton(this.undoManager.getUndoAction());
        button.setText("");
        button.setToolTipText(Messages.getString("GameInformationFrame.UNDO"));
        tool.add(button);
        button = new JButton(this.undoManager.getRedoAction());
        button.setText("");
        button.setToolTipText(Messages.getString("GameInformationFrame.REDO"));
        tool.add(button);
        tool.addSeparator();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        this.cbFonts = new JComboBox<String>(fontNames);
        this.cbFonts.setRequestFocusEnabled(false);
        this.cbFonts.setMaximumSize(this.cbFonts.getPreferredSize());
        this.cbFonts.setEditable(true);
        ActionListener lst = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GameInformationFrame.this.fFamilyChange) {
                    GameInformationFrame.this.fFamilyChange = false;
                    return;
                }
                GameInformationFrame.this.editor.grabFocus();
                GameInformationFrame.this.setSelectionAttribute(StyleConstants.Family, GameInformationFrame.this.cbFonts.getSelectedItem().toString());
            }
        };
        this.cbFonts.addActionListener(lst);
        tool.add(this.cbFonts);
        tool.addSeparator();
        this.sSizes = new JSpinner(new SpinnerNumberModel(12, 1, 100, 1));
        this.sSizes.setRequestFocusEnabled(false);
        this.sSizes.setMaximumSize(this.sSizes.getPreferredSize());
        this.sSizes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (GameInformationFrame.this.fSizeChange) {
                    GameInformationFrame.this.fSizeChange = false;
                    return;
                }
                GameInformationFrame.this.setSelectionAttribute(StyleConstants.Size, GameInformationFrame.this.sSizes.getValue());
                GameInformationFrame.this.editor.grabFocus();
            }
        });
        tool.add(this.sSizes);
        tool.addSeparator();
        this.tbBold = this.addToggleButton("GameInformationFrame.BOLD");
        this.tbBold.setRequestFocusEnabled(false);
        tool.add(this.tbBold);
        this.tbItalic = this.addToggleButton("GameInformationFrame.ITALIC");
        this.tbItalic.setRequestFocusEnabled(false);
        tool.add(this.tbItalic);
        this.tbUnderline = this.addToggleButton("GameInformationFrame.UNDERLINE");
        this.tbUnderline.setRequestFocusEnabled(false);
        tool.add(this.tbUnderline);
        tool.addSeparator();
        this.tbLeft = this.addToggleButton("GameInformationFrame.ALIGN_LEFT");
        this.tbLeft.setRequestFocusEnabled(false);
        this.tbLeft.setSelected(true);
        tool.add(this.tbLeft);
        this.tbCenter = this.addToggleButton("GameInformationFrame.ALIGN_CENTER");
        this.tbCenter.setRequestFocusEnabled(false);
        tool.add(this.tbCenter);
        this.tbRight = this.addToggleButton("GameInformationFrame.ALIGN_RIGHT");
        this.tbRight.setRequestFocusEnabled(false);
        tool.add(this.tbRight);
        tool.addSeparator();
        JButton butFontColor = new JButton(LGM.getIconForKey("GameInformationFrame.FONTCOLOR"));
        butFontColor.setRequestFocusEnabled(false);
        butFontColor.setActionCommand("GameInformationFrame.FONTCOLOR");
        butFontColor.addActionListener(this);
        butFontColor.setToolTipText(Messages.getString("GameInformationFrame.FONTCOLOR"));
        tool.add(butFontColor);
        JButton but = new JButton(LGM.getIconForKey("GameInformationFrame.COLOR"));
        but.setRequestFocusEnabled(false);
        but.setActionCommand("GameInformationFrame.COLOR");
        but.addActionListener(this);
        but.setToolTipText(Messages.getString("GameInformationFrame.COLOR"));
        tool.add(but);
        return tool;
    }

    private JPanel makeSettings() {
        JPanel p = new JPanel();
        GroupLayout gl = new GroupLayout(p);
        p.setLayout(gl);
        gl.setAutoCreateGaps(true);
        gl.setAutoCreateContainerGaps(true);
        JLabel lTitle = new JLabel(Messages.getString("GameInformationFrame.WINDOW_TITLE"));
        this.sTitle = new JTextField();
        this.plf.make(this.sTitle.getDocument(), GameInformation.PGameInformation.FORM_CAPTION);
        JPanel position = new JPanel();
        position.setBorder(BorderFactory.createTitledBorder(Messages.getString("GameInformationFrame.POSITION")));
        GroupLayout pl = new GroupLayout(position);
        position.setLayout(pl);
        pl.setAutoCreateGaps(true);
        pl.setAutoCreateContainerGaps(true);
        JLabel lX = new JLabel(Messages.getString("GameInformationFrame.X"));
        JLabel lY = new JLabel(Messages.getString("GameInformationFrame.Y"));
        JLabel lWidth = new JLabel(Messages.getString("GameInformationFrame.WIDTH"));
        JLabel lHeight = new JLabel(Messages.getString("GameInformationFrame.HEIGHT"));
        this.sX = new NumberField(0);
        this.sY = new NumberField(0);
        this.sWidth = new NumberField(0);
        this.sHeight = new NumberField(0);
        this.plf.make(this.sX, GameInformation.PGameInformation.LEFT);
        this.plf.make(this.sY, GameInformation.PGameInformation.TOP);
        this.plf.make(this.sWidth, GameInformation.PGameInformation.WIDTH);
        this.plf.make(this.sHeight, GameInformation.PGameInformation.HEIGHT);
        this.sShowBorder = new JCheckBox(Messages.getString("GameInformationFrame.SHOW_BORDER"));
        this.sAllowResize = new JCheckBox(Messages.getString("GameInformationFrame.RESIZABLE"));
        this.sAlwaysOnTop = new JCheckBox(Messages.getString("GameInformationFrame.ALWAYS_ON_TOP"));
        this.sPauseGame = new JCheckBox(Messages.getString("GameInformationFrame.PAUSE"));
        this.sEmbed = new JCheckBox(Messages.getString("GameInformationFrame.EMBED"));
        this.plf.make(this.sShowBorder, GameInformation.PGameInformation.SHOW_BORDER);
        this.plf.make(this.sAllowResize, GameInformation.PGameInformation.ALLOW_RESIZE);
        this.plf.make(this.sAlwaysOnTop, GameInformation.PGameInformation.STAY_ON_TOP);
        this.plf.make(this.sPauseGame, GameInformation.PGameInformation.PAUSE_GAME);
        this.plf.make(this.sEmbed, GameInformation.PGameInformation.EMBED_GAME_WINDOW);
        pl.setHorizontalGroup(pl.createSequentialGroup().addGroup(pl.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lX).addComponent(lWidth)).addGroup(pl.createParallelGroup().addComponent(this.sX).addComponent(this.sWidth)).addGroup(pl.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lY).addComponent(lHeight)).addGroup(pl.createParallelGroup().addComponent(this.sY).addComponent(this.sHeight)));
        pl.setVerticalGroup(pl.createSequentialGroup().addGroup(pl.createParallelGroup().addComponent(lX).addComponent(this.sX, -1, -2, -2).addComponent(lY).addComponent(this.sY, -1, -2, -2)).addGroup(pl.createParallelGroup().addComponent(lWidth).addComponent(this.sWidth, -1, -2, -2).addComponent(lHeight).addComponent(this.sHeight, -1, -2, -2)));
        this.sCloseButton = new JButton(Messages.getString("GameInformationFrame.CLOSE"));
        this.sCloseButton.setActionCommand("GameInformationFrame.CLOSE");
        this.sCloseButton.addActionListener(this);
        gl.setHorizontalGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addComponent(lTitle).addComponent(this.sTitle)).addComponent(position).addComponent(this.sShowBorder).addComponent(this.sAllowResize).addComponent(this.sAlwaysOnTop).addComponent(this.sPauseGame).addComponent(this.sEmbed).addComponent(this.sCloseButton, GroupLayout.Alignment.CENTER));
        gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup().addComponent(lTitle).addComponent(this.sTitle, -1, -2, -2)).addComponent(position).addComponent(this.sShowBorder).addComponent(this.sAllowResize).addComponent(this.sAlwaysOnTop).addComponent(this.sPauseGame).addComponent(this.sEmbed).addComponent(this.sCloseButton));
        return p;
    }

    public GameInformationFrame(GameInformation res) {
        this(res, (ResNode)null);
    }

    public GameInformationFrame(GameInformation res, ResNode node) {
        super(res, node, Messages.getString("GameInformationFrame.TITLE"), true);
        this.setDefaultCloseOperation(1);
        this.menubar = this.makeMenuBar();
        this.setJMenuBar(this.menubar);
        this.toolbar = this.makeToolBar();
        this.add((Component)this.toolbar, "North");
        this.fgColor = Color.BLACK;
        this.editor = new JEditorPane();
        this.editor.setEditorKit(this.rtf);
        this.setFocusTraversalPolicy(new TextAreaFocusTraversalPolicy(this.editor));
        this.editor.addCaretListener(this.undoManager);
        this.editor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                GameInformationFrame.this.fFamilyChange = true;
                GameInformationFrame.this.fSizeChange = true;
                StyledDocument d = (StyledDocument)GameInformationFrame.this.editor.getDocument();
                int dot = ce.getDot();
                if (ce.getMark() <= dot) {
                    --dot;
                }
                AttributeSet as = d.getCharacterElement(dot).getAttributes();
                String f = StyleConstants.getFontFamily(as);
                GameInformationFrame.this.fgColor = StyleConstants.getForeground(as);
                int s = StyleConstants.getFontSize(as);
                boolean b = StyleConstants.isBold(as);
                boolean i = StyleConstants.isItalic(as);
                boolean u = StyleConstants.isUnderline(as);
                GameInformationFrame.this.cbFonts.setSelectedItem(f);
                GameInformationFrame.this.sSizes.setValue(s);
                GameInformationFrame.this.miBold.setSelected(b);
                GameInformationFrame.this.tbBold.setSelected(b);
                GameInformationFrame.this.tbItalic.setSelected(i);
                GameInformationFrame.this.miItalic.setSelected(i);
                GameInformationFrame.this.tbUnderline.setSelected(u);
                GameInformationFrame.this.miUnderline.setSelected(u);
                GameInformationFrame.this.setAlignmentOptions(StyleConstants.getAlignment(as));
            }
        });
        this.revertResource();
        this.editor.getDocument().addUndoableEditListener(this.undoManager);
        this.add((Component)new JScrollPane(this.editor), "Center");
        this.fc = new CustomFileChooser("/org/lateralgm", "LAST_GAMEINFO_DIR");
        this.fc.setFileFilter(new CustomFileFilter(Messages.getString("GameInformationFrame.TYPE_RTF"), ".rtf"));
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = this.addItem("GameInformationFrame.CUT");
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.CUT")));
        popup.add(item);
        item = this.addItem("GameInformationFrame.COPY");
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.COPY")));
        popup.add(item);
        item = this.addItem("GameInformationFrame.PASTE");
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.PASTE")));
        popup.add(item);
        popup.addSeparator();
        item = new JMenuItem(this.undoManager.getUndoAction());
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.UNDO")));
        popup.add(item);
        item = new JMenuItem(this.undoManager.getRedoAction());
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.REDO")));
        popup.add(item);
        popup.addSeparator();
        item = this.addItem("GameInformationFrame.SELECTALL");
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("GameInformationFrame.SELECTALL")));
        popup.add(item);
        this.editor.setComponentPopupMenu(popup);
        this.pack();
        this.setSize(this.getWidth(), 480);
    }

    public void setEditorBackground(Color c) {
        this.editor.setBackground(c);
        Color sc = new Color(c.getRed() > 127 ? 0 : 255, c.getGreen() > 127 ? 0 : 255, c.getBlue() > 127 ? 0 : 255);
        this.editor.setSelectedTextColor(c);
        this.editor.setSelectionColor(sc);
        Color cc = new Color((c.getRed() + sc.getRed()) / 2, (c.getGreen() + sc.getGreen()) / 2, (c.getBlue() + sc.getBlue()) / 2);
        this.editor.setCaretColor(cc);
    }

    public void setSelectionAttribute(Object key, Object value) {
        int b;
        StyledDocument sd = (StyledDocument)this.editor.getDocument();
        int a = this.editor.getSelectionStart();
        if (a == (b = this.editor.getSelectionEnd())) {
            this.rtf.getInputAttributes().addAttribute(key, value);
            return;
        }
        SimpleAttributeSet sas = new SimpleAttributeSet();
        sas.addAttribute(key, value);
        sd.setCharacterAttributes(a, b - a, sas, false);
    }

    public JMenuItem addItem(String key) {
        JMenuItem item = new JMenuItem(Messages.getString(key));
        item.setIcon(LGM.getIconForKey(key));
        item.setActionCommand(key);
        item.addActionListener(this);
        return item;
    }

    public JButton addToolButton(String key) {
        JButton item = new JButton();
        item.setToolTipText(Messages.getString(key));
        item.setIcon(LGM.getIconForKey(key));
        item.setActionCommand(key);
        item.addActionListener(this);
        return item;
    }

    public JToggleButton addToggleButton(String key) {
        JToggleButton item = new JToggleButton();
        item.setToolTipText(Messages.getString(key));
        item.setIcon(LGM.getIconForKey(key));
        item.setActionCommand(key);
        item.addActionListener(this);
        return item;
    }

    public void loadFromFile() {
        this.fc.setDialogTitle(Messages.getString("GameInformationFrame.LOAD_TITLE"));
        while (true) {
            if (this.fc.showOpenDialog(LGM.frame) != 0) {
                return;
            }
            if (this.fc.getSelectedFile().exists()) break;
            JOptionPane.showMessageDialog(this.fc, String.valueOf(this.fc.getSelectedFile().getName()) + Messages.getString("GameInformationFrame.FILE_MISSING"), Messages.getString("GameInformationFrame.LOAD_TITLE"), 2);
        }
        try {
            FileInputStream i = new FileInputStream(this.fc.getSelectedFile());
            this.editor.setText("");
            this.rtf.read(i, this.editor.getDocument(), 0);
            i.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveToFile() {
        this.fc.setDialogTitle(Messages.getString("GameInformationFrame.SAVE_TITLE"));
        if (this.fc.showSaveDialog(this) != 0) {
            return;
        }
        String name = this.fc.getSelectedFile().getPath();
        if (CustomFileFilter.getExtension(name) == null) {
            name = String.valueOf(name) + ".rtf";
        }
        try {
            FileOutputStream out = new FileOutputStream(new File(name));
            StyledDocument doc = (StyledDocument)this.editor.getDocument();
            this.rtf.write(out, (Document)doc, doc.getStartPosition().getOffset(), doc.getLength());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getUserObject() {
        if (this.node != null) {
            return this.node.getUserObject();
        }
        int m = 0;
        while (m < LGM.root.getChildCount()) {
            ResNode n = (ResNode)LGM.root.getChildAt(m);
            if (n.kind == GameInformation.class) {
                return n.getUserObject();
            }
            ++m;
        }
        return Messages.getString("LGM.GMI");
    }

    public void setAlignmentOptions(int alignment) {
        this.miLeft.setSelected(alignment == 0);
        this.miCenter.setSelected(alignment == 1);
        this.miRight.setSelected(alignment == 2);
        this.tbLeft.setSelected(alignment == 0);
        this.tbCenter.setSelected(alignment == 1);
        this.tbRight.setSelected(alignment == 2);
    }

    public void setSelectionAlignment(int alignment) {
        this.setAlignmentOptions(alignment);
        StyledDocument sd = (StyledDocument)this.editor.getDocument();
        int a = this.editor.getSelectionStart();
        int b = this.editor.getSelectionEnd();
        if (a == b) {
            this.rtf.getInputAttributes().addAttribute(StyleConstants.Alignment, alignment);
            return;
        }
        SimpleAttributeSet sas = new SimpleAttributeSet();
        StyleConstants.setAlignment(sas, alignment);
        sd.setParagraphAttributes(a, b - a, sas, false);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        super.actionPerformed(ev);
        String com = ev.getActionCommand();
        if (com.equals("GameInformationFrame.LOAD")) {
            this.loadFromFile();
        } else {
            if (com.equals("GameInformationFrame.PRINT")) {
                try {
                    this.editor.print();
                }
                catch (Exception pex) {
                    LGM.showDefaultExceptionHandler(pex);
                }
                return;
            }
            if (com.equals("GameInformationFrame.SETTINGS")) {
                if (this.settings == null) {
                    this.settings = new SettingsFrame();
                }
                this.settings.setLocationRelativeTo(this);
                this.settings.setVisible(true);
            } else {
                if (com.equals("GameInformationFrame.FILESAVE")) {
                    this.saveToFile();
                    return;
                }
                if (com.equals("GameInformationFrame.FONTCOLOR")) {
                    String colorStr = Messages.getString("GameInformationFrame.FONTCOLOR");
                    Color c = JColorChooser.showDialog(this, colorStr, this.fgColor);
                    if (c != null) {
                        this.fgColor = c;
                        this.setSelectionAttribute(StyleConstants.Foreground, c);
                    }
                    return;
                }
                if (com.equals("GameInformationFrame.BOLD")) {
                    this.miBold.setSelected(this.tbBold.isSelected());
                    this.setSelectionAttribute(StyleConstants.Bold, this.tbBold.isSelected());
                    return;
                }
                if (com.equals("GameInformationFrame.ITALIC")) {
                    this.miItalic.setSelected(this.tbItalic.isSelected());
                    this.setSelectionAttribute(StyleConstants.Italic, this.tbItalic.isSelected());
                    return;
                }
                if (com.equals("GameInformationFrame.UNDERLINE")) {
                    this.miUnderline.setSelected(this.tbUnderline.isSelected());
                    this.setSelectionAttribute(StyleConstants.Underline, this.tbUnderline.isSelected());
                    return;
                }
                if (com.equals("GameInformationFrame.MENU_BOLD")) {
                    this.miBold.setSelected(!this.miBold.isSelected());
                    this.tbBold.setSelected(this.miBold.isSelected());
                    this.setSelectionAttribute(StyleConstants.Bold, this.miBold.isSelected());
                    return;
                }
                if (com.equals("GameInformationFrame.MENU_ITALIC")) {
                    this.miItalic.setSelected(!this.miItalic.isSelected());
                    this.tbItalic.setSelected(this.miItalic.isSelected());
                    this.setSelectionAttribute(StyleConstants.Italic, this.miItalic.isSelected());
                    return;
                }
                if (com.equals("GameInformationFrame.MENU_UNDERLINE")) {
                    this.miUnderline.setSelected(!this.miUnderline.isSelected());
                    this.tbUnderline.setSelected(this.miUnderline.isSelected());
                    this.setSelectionAttribute(StyleConstants.Underline, this.miUnderline.isSelected());
                    return;
                }
                if (com.equals("GameInformationFrame.ALIGN_LEFT")) {
                    this.setSelectionAlignment(0);
                    return;
                }
                if (com.equals("GameInformationFrame.ALIGN_CENTER")) {
                    this.setSelectionAlignment(1);
                    return;
                }
                if (com.equals("GameInformationFrame.ALIGN_RIGHT")) {
                    this.setSelectionAlignment(2);
                    return;
                }
                if (com.equals("GameInformationFrame.COLOR")) {
                    String colorStr = Messages.getString("GameInformationFrame.COLOR");
                    Color c = JColorChooser.showDialog(this, colorStr, this.editor.getBackground());
                    if (c != null) {
                        this.setEditorBackground(c);
                    }
                    return;
                }
                if (com.equals("GameInformationFrame.CUT")) {
                    this.editor.cut();
                    return;
                }
                if (com.equals("GameInformationFrame.COPY")) {
                    this.editor.copy();
                    return;
                }
                if (com.equals("GameInformationFrame.PASTE")) {
                    this.editor.paste();
                    return;
                }
                if (com.equals("GameInformationFrame.SELECTALL")) {
                    this.editor.selectAll();
                    return;
                }
                if (com.equals("GameInformationFrame.CLOSESAVE")) {
                    this.doDefaultSaveAction();
                    return;
                }
                if (com.equals("GameInformationFrame.CLOSE")) {
                    this.settings.setVisible(false);
                }
            }
        }
    }

    @Override
    public void commitChanges() {
        ((GameInformation)this.res).put(GameInformation.PGameInformation.BACKGROUND_COLOR, (Object)this.editor.getBackground());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            StyledDocument doc = (StyledDocument)this.editor.getDocument();
            this.rtf.write(baos, (Document)doc, doc.getStartPosition().getOffset(), doc.getLength());
            ((GameInformation)this.res).put(GameInformation.PGameInformation.TEXT, (Object)baos.toString("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setComponents(GameInformation info) {
        this.setEditorBackground((Color)((GameInformation)this.res).get(GameInformation.PGameInformation.BACKGROUND_COLOR));
        this.editor.setText(null);
        try {
            this.rtf.read(new ByteArrayInputStream(((String)((GameInformation)this.res).get(GameInformation.PGameInformation.TEXT)).getBytes("UTF-8")), this.editor.getDocument(), 0);
            this.editor.setCaretPosition(0);
        }
        catch (IOException iOException) {
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.undoManager.discardAllEdits();
        this.undoManager.updateActions();
    }

    @Override
    public String getConfirmationName() {
        return (String)this.getUserObject();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible != this.isVisible()) {
            if (this.undoManager != null) {
                this.undoManager.discardAllEdits();
                this.undoManager.updateActions();
            }
            if (this.settings != null) {
                this.settings.setVisible(false);
            }
        }
        super.setVisible(visible);
    }

    @Override
    public boolean resourceChanged() {
        this.commitChanges();
        if (this.undoManager.canUndo()) {
            return true;
        }
        for (Map.Entry entry : ((GameInformation)this.res).properties.entrySet()) {
            if (entry.getKey() == GameInformation.PGameInformation.TEXT || entry.getValue().equals(((GameInformation)this.resOriginal).get((GameInformation.PGameInformation)((Object)entry.getKey())))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void revertResource() {
        ((GameInformation)this.res).properties.putAll(((GameInformation)this.resOriginal).properties);
        this.setComponents((GameInformation)this.res);
        this.plf.setMap(((GameInformation)this.res).properties);
    }

    public class SettingsFrame
    extends JDialog {
        private static final long serialVersionUID = 1L;

        public SettingsFrame() {
            super((Frame)LGM.frame, true);
            this.setDefaultCloseOperation(1);
            this.setTitle(Messages.getString("GameInformationFrame.SETTINGS"));
            this.setIconImage(LGM.getIconForKey("GameInformationFrame.SETTINGS").getImage());
            this.add(GameInformationFrame.this.makeSettings());
            this.getRootPane().setDefaultButton(GameInformationFrame.this.sCloseButton);
            this.pack();
            this.setResizable(false);
        }
    }
}

