/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.lateralgm.components.AutoComboBox;
import org.lateralgm.components.CustomFileChooser;
import org.lateralgm.components.NumberField;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Font;
import org.lateralgm.resources.sub.CharacterRange;
import org.lateralgm.subframes.InstantiableResourceFrame;
import org.lateralgm.ui.swing.propertylink.ComboBoxLink;
import org.lateralgm.ui.swing.propertylink.PropertyLinkFactory;
import org.lateralgm.ui.swing.util.ArrayListModel;
import org.lateralgm.util.PropertyMap;

public class FontFrame
extends InstantiableResourceFrame<Font, Font.PFont>
implements ListSelectionListener,
ListDataListener,
UpdateSource.UpdateListener {
    private static final long serialVersionUID = 1L;
    public JComboBox<String> fonts;
    public NumberField size;
    public JCheckBox italic;
    public JCheckBox bold;
    public JComboBox<String> aa;
    public NumberField charMin;
    public NumberField charMax;
    private PropertyLinkFactory<CharacterRange.PCharacterRange> rplf;
    public JEditorPane previewText;
    public JTextArea previewRange;
    private JMenuItem cutItem;
    private JMenuItem copyItem;
    private JMenuItem pasteItem;
    private JMenuItem selAllItem;
    private CharacterRange lastRange = null;
    public JList<CharacterRange> rangeList;
    private final JPanel crPane;
    private PropertyMap.PropertyUpdateListener<Font.PFont> propUpdateListener;

    @Override
    public void dispose() {
        super.dispose();
        ((Font)this.res).properties.updateSource.removeListener(this.propUpdateListener);
        ((Font)this.res).rangeUpdateSource.removeListener(this);
    }

    public FontFrame(Font res, ResNode node) {
        super(res, node);
        this.getRootPane().setDefaultButton(this.save);
        ((JComponent)this.getContentPane()).setBorder(new EmptyBorder(4, 4, 4, 4));
        this.rplf = new PropertyLinkFactory(null, this);
        this.addSecondaryPropertyLinkFactory(this.rplf);
        this.propUpdateListener = new PropertyMap.PropertyUpdateListener<Font.PFont>(){

            @Override
            public void updated(PropertyMap.PropertyUpdateEvent<Font.PFont> e) {
                FontFrame.this.updatePreviewText();
                FontFrame.this.updatePreviewRange();
            }
        };
        res.properties.updateSource.addListener(this.propUpdateListener);
        res.rangeUpdateSource.addListener(this);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(false);
        this.setLayout(layout);
        JLabel lName = new JLabel(Messages.getString("FontFrame.NAME"));
        JLabel lFont = new JLabel(Messages.getString("FontFrame.FONT"));
        this.fonts = new AutoComboBox<String>((T[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.plf.make(this.fonts, Font.PFont.FONT_NAME, null);
        JLabel lSize = new JLabel(Messages.getString("FontFrame.SIZE"));
        this.size = new NumberField(1, 99);
        this.plf.make(this.size, Font.PFont.SIZE);
        this.bold = new JCheckBox(Messages.getString("FontFrame.BOLD"));
        this.plf.make(this.bold, Font.PFont.BOLD);
        this.italic = new JCheckBox(Messages.getString("FontFrame.ITALIC"));
        this.plf.make(this.italic, Font.PFont.ITALIC);
        String aaprefix = "FontFrame.AA";
        String[] aalevels = new String[4];
        int i = 0;
        while (i < aalevels.length) {
            aalevels[i] = Messages.getString(String.valueOf(aaprefix) + i);
            ++i;
        }
        this.aa = new JComboBox<String>(aalevels);
        this.plf.make(this.aa, Font.PFont.ANTIALIAS, new ComboBoxLink.IndexComboBoxConversion());
        JLabel aaLabel = new JLabel(Messages.getString("FontFrame.ANTIALIAS"));
        this.crPane = this.makeCRPane();
        this.previewText = new JEditorPane();
        this.previewRange = new JTextArea();
        this.previewRange.setEditable(false);
        this.previewRange.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                FontFrame.this.previewRange.getCaret().setVisible(true);
                FontFrame.this.previewRange.getCaret().setSelectionVisible(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                FontFrame.this.previewRange.getCaret().setVisible(false);
                FontFrame.this.previewRange.getCaret().setSelectionVisible(false);
            }
        });
        this.previewRange.setWrapStyleWord(false);
        this.rangeList = new JList();
        this.rangeList.setModel(new ArrayListModel<CharacterRange>(res.characterRanges));
        this.rangeList.setSelectionMode(0);
        RangeListComponentRenderer renderer = new RangeListComponentRenderer();
        this.rangeList.setCellRenderer(renderer);
        this.rangeList.getModel().addListDataListener(this);
        this.rangeList.addListSelectionListener(this);
        this.rangeList.setSelectedIndex(0);
        this.rangeList.setLayoutOrientation(0);
        this.rangeList.setVisibleRowCount(6);
        if (res.getNode().newRes && res.characterRanges.isEmpty()) {
            res.addRange();
            this.updateResource(false);
        }
        String keyString = Messages.getKeyboardString("FontFrame.REM_RANGE");
        KeyStroke stroke = KeyStroke.getKeyStroke(keyString);
        this.rangeList.getInputMap().put(stroke, "REM_RANGE");
        this.rangeList.getActionMap().put("REM_RANGE", new AbstractAction(){
            private static final long serialVersionUID = 5308536583486764117L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FontFrame.this.deleteSelectedRange();
            }
        });
        JToolBar rangesTB = new JToolBar();
        rangesTB.setFloatable(false);
        JButton fromPreview = new JButton(Messages.getString("FontFrame.FROMPREVIEW"));
        fromPreview.setActionCommand("FromPreview");
        fromPreview.addActionListener(this);
        JButton fromString = new JButton(Messages.getString("FontFrame.FROMSTRING"));
        fromString.setActionCommand("FromString");
        fromString.addActionListener(this);
        JButton fromFile = new JButton(Messages.getString("FontFrame.FROMFILE"));
        fromFile.setActionCommand("FromFile");
        fromFile.addActionListener(this);
        JButton addRange = new JButton();
        addRange.setIcon(LGM.getIconForKey("FontFrame.ADD_RANGE"));
        addRange.setActionCommand("Add");
        addRange.addActionListener(this);
        JButton remRange = new JButton();
        remRange.setIcon(LGM.getIconForKey("FontFrame.REMOVE_RANGE"));
        remRange.setActionCommand("Remove");
        remRange.addActionListener(this);
        JButton clearRange = new JButton(Messages.getString("FontFrame.CLEAR"));
        clearRange.setActionCommand("Clear");
        clearRange.addActionListener(this);
        rangesTB.add(addRange);
        rangesTB.addSeparator();
        rangesTB.add(fromPreview);
        rangesTB.addSeparator();
        rangesTB.add(fromString);
        rangesTB.addSeparator();
        rangesTB.add(fromFile);
        rangesTB.addSeparator();
        rangesTB.add(remRange);
        rangesTB.addSeparator();
        rangesTB.add(clearRange);
        JScrollPane listScroller = new JScrollPane(this.rangeList);
        listScroller.setPreferredSize(new Dimension(250, 80));
        this.add(listScroller);
        this.previewText.setText(Messages.getString("FontFrame.PREVIEW_DEFAULT"));
        this.makeContextMenu();
        JScrollPane previewTextScroll = new JScrollPane(this.previewText);
        JScrollPane previewRangeScroll = new JScrollPane(this.previewRange);
        previewRangeScroll.setHorizontalScrollBarPolicy(32);
        this.previewText.setSize(500, 500);
        this.updatePreviewText();
        this.updatePreviewRange();
        this.save.setText(Messages.getString("FontFrame.SAVE"));
        GroupLayout.SequentialGroup orientationGroup = layout.createSequentialGroup();
        if (Prefs.rightOrientation) {
            orientationGroup.addGroup(layout.createParallelGroup().addComponent(previewTextScroll, 0, 500, Integer.MAX_VALUE).addComponent(previewRangeScroll, 0, 500, Integer.MAX_VALUE));
        }
        orientationGroup.addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lName).addComponent(lFont).addComponent(lSize)).addGroup(layout.createParallelGroup().addComponent(this.name, -1, 120, Integer.MAX_VALUE).addComponent(this.fonts, 120, 160, Integer.MAX_VALUE).addComponent(this.size))).addGroup(layout.createSequentialGroup().addComponent(aaLabel).addComponent(this.aa).addComponent(this.bold).addComponent(this.italic)).addComponent(rangesTB).addGroup(layout.createSequentialGroup().addComponent(listScroller, 120, 220, Integer.MAX_VALUE)).addComponent(this.crPane).addComponent(this.save, -1, -1, Integer.MAX_VALUE));
        if (!Prefs.rightOrientation) {
            orientationGroup.addGroup(layout.createParallelGroup().addComponent(previewTextScroll, 0, 500, Integer.MAX_VALUE).addComponent(previewRangeScroll, 0, 500, Integer.MAX_VALUE));
        }
        layout.setHorizontalGroup(orientationGroup);
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lName).addComponent(this.name)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lFont).addComponent(this.fonts)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lSize).addComponent(this.size)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.aa).addComponent(aaLabel).addComponent(this.bold).addComponent(this.italic)).addComponent(rangesTB, -1, -2, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(listScroller, -1, 120, Integer.MAX_VALUE)).addComponent(this.crPane).addComponent(this.save)).addGroup(layout.createSequentialGroup().addComponent(previewTextScroll, -1, 100, Integer.MAX_VALUE).addComponent(previewRangeScroll, -1, 100, Integer.MAX_VALUE)));
        Util.setComponentTreeEnabled(this.crPane, !this.rangeList.isSelectionEmpty());
        this.pack();
    }

    public JMenuItem addItem(String key) {
        JMenuItem item = new JMenuItem(Messages.getString(key));
        item.setIcon(LGM.getIconForKey(key));
        item.setActionCommand(key);
        item.addActionListener(this);
        return item;
    }

    public void makeContextMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.cutItem = this.addItem("FontFrame.CUT");
        this.cutItem.setAccelerator(Messages.getKeyboardStroke("FontFrame.CUT"));
        popup.add(this.cutItem);
        this.copyItem = this.addItem("FontFrame.COPY");
        this.copyItem.setAccelerator(Messages.getKeyboardStroke("FontFrame.COPY"));
        popup.add(this.copyItem);
        this.pasteItem = this.addItem("FontFrame.PASTE");
        this.pasteItem.setAccelerator(Messages.getKeyboardStroke("FontFrame.PASTE"));
        popup.add(this.pasteItem);
        popup.addSeparator();
        this.selAllItem = this.addItem("FontFrame.SELECTALL");
        this.selAllItem.setAccelerator(Messages.getKeyboardStroke("FontFrame.SELECTALL"));
        popup.add(this.selAllItem);
        this.previewText.setComponentPopupMenu(popup);
        popup = new JPopupMenu();
        this.copyItem = this.addItem("FontFrame.COPY");
        this.copyItem.setAccelerator(Messages.getKeyboardStroke("FontFrame.COPY"));
        this.copyItem.setActionCommand("COPYRANGE");
        popup.add(this.copyItem);
        popup.addSeparator();
        this.selAllItem = this.addItem("FontFrame.SELECTALL");
        this.selAllItem.setAccelerator(Messages.getKeyboardStroke("FontFrame.SELECTALL"));
        this.selAllItem.setActionCommand("SELECTALLRANGE");
        popup.add(this.selAllItem);
        this.previewRange.setComponentPopupMenu(popup);
    }

    private JPanel makeCRPane() {
        JPanel panel = new JPanel();
        String title = Messages.getString("FontFrame.CHARRANGE");
        panel.setBorder(BorderFactory.createTitledBorder(title));
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        this.charMin = new NumberField(0, Integer.MAX_VALUE);
        this.charMin.setCommitsOnValidEdit(false);
        JLabel lTo = new JLabel(Messages.getString("FontFrame.TO"));
        this.charMax = new NumberField(0, Integer.MAX_VALUE);
        this.charMax.setCommitsOnValidEdit(false);
        JButton crNormal = new JButton(Messages.getString("FontFrame.NORMAL"));
        crNormal.setActionCommand("Normal");
        crNormal.addActionListener(this);
        JButton crAll = new JButton(Messages.getString("FontFrame.ASCII"));
        crAll.setActionCommand("ASCII");
        crAll.addActionListener(this);
        JButton crDigits = new JButton(Messages.getString("FontFrame.DIGITS"));
        crDigits.setActionCommand("Digits");
        crDigits.addActionListener(this);
        JButton crLetters = new JButton(Messages.getString("FontFrame.LETTERS"));
        crLetters.setActionCommand("Letters");
        crLetters.addActionListener(this);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.charMin).addComponent(lTo).addComponent(this.charMax)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(crNormal, -1, -1, Integer.MAX_VALUE).addComponent(crDigits, -1, -1, Integer.MAX_VALUE)).addGroup(layout.createParallelGroup().addComponent(crAll, -1, -1, Integer.MAX_VALUE).addComponent(crLetters, -1, -1, Integer.MAX_VALUE))));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.charMin).addComponent(lTo).addComponent(this.charMax)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(crNormal).addComponent(crAll)).addGroup(layout.createParallelGroup().addComponent(crDigits).addComponent(crLetters))));
        return panel;
    }

    @Override
    protected boolean areResourceFieldsEqual() {
        return ((Font)this.res).characterRanges.equals(((Font)this.resOriginal).characterRanges);
    }

    @Override
    public void commitChanges() {
        this.charMin.commitOrRevert();
        this.charMax.commitOrRevert();
        ((Font)this.res).setName(this.name.getText());
    }

    private void deleteSelectedRange() {
        int sel = this.rangeList.getSelectedIndex();
        if (sel != -1) {
            ((Font)this.res).characterRanges.remove(sel);
        }
        if (sel >= ((Font)this.res).characterRanges.size()) {
            if (((Font)this.res).characterRanges.isEmpty()) {
                this.rangeList.clearSelection();
            } else {
                this.rangeList.setSelectedIndex(((Font)this.res).characterRanges.size() - 1);
            }
        } else {
            this.fireRangeUpdate();
        }
    }

    private void setRange(int min, int max) {
        CharacterRange cr = this.rangeList.getSelectedValue();
        if (cr != null) {
            cr.properties.put(CharacterRange.PCharacterRange.RANGE_MIN, (Object)min);
            cr.properties.put(CharacterRange.PCharacterRange.RANGE_MAX, (Object)max);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        switch (ev.getActionCommand()) {
            case "Normal": {
                this.setRange(32, 127);
                break;
            }
            case "ASCII": {
                this.setRange(0, 255);
                break;
            }
            case "Digits": {
                this.setRange(48, 57);
                break;
            }
            case "Letters": {
                this.setRange(65, 122);
                break;
            }
            case "FromPreview": {
                ((Font)this.res).addRangesFromString(this.previewText.getText());
                break;
            }
            case "FromString": {
                String result = JOptionPane.showInputDialog(this, "", "Character Sequence", -1);
                if (result == null) break;
                ((Font)this.res).addRangesFromString(result);
                break;
            }
            case "FromFile": {
                CustomFileChooser fc = new CustomFileChooser("/org/lateralgm", "LAST_FILE_DIR");
                fc.setMultiSelectionEnabled(false);
                if (fc.showOpenDialog(LGM.frame) != 0) break;
                ((Font)this.res).addRangesFromFile(fc.getSelectedFile());
                break;
            }
            case "Add": {
                ((Font)this.res).addRange();
                break;
            }
            case "Remove": {
                this.deleteSelectedRange();
                break;
            }
            case "Clear": {
                ((Font)this.res).characterRanges.clear();
                this.rangeList.clearSelection();
                return;
            }
            case "FontFrame.CUT": {
                this.previewText.cut();
                break;
            }
            case "FontFrame.COPY": {
                this.previewText.copy();
                break;
            }
            case "FontFrame.PASTE": {
                this.previewText.paste();
                break;
            }
            case "FontFrame.SELECTALL": {
                this.previewText.selectAll();
                break;
            }
            case "SELECTALLRANGE": {
                this.previewRange.selectAll();
                break;
            }
            case "COPYRANGE": {
                this.previewRange.copy();
                break;
            }
            default: {
                super.actionPerformed(ev);
            }
        }
    }

    public void updatePreviewText() {
        this.previewText.setFont(((Font)this.res).getAWTFont());
    }

    public void updatePreviewRange() {
        StringBuilder text = new StringBuilder();
        for (CharacterRange cr : ((Font)this.res).characterRanges) {
            int min = (Integer)cr.properties.get(CharacterRange.PCharacterRange.RANGE_MIN);
            int max = (Integer)cr.properties.get(CharacterRange.PCharacterRange.RANGE_MAX);
            if (max - min > 1000 || max < min) {
                max = min + 1000;
            }
            int i = min;
            while (i <= max) {
                if (i == 10) {
                    text.append(' ');
                } else {
                    text.append(Character.toChars(i));
                }
                ++i;
            }
            text.append('\n');
        }
        this.previewRange.setText(text.toString());
        this.previewRange.setFont(((Font)this.res).getAWTFont());
    }

    public void fireRangeUpdate() {
        CharacterRange cr = this.rangeList.getSelectedValue();
        if (this.lastRange == cr) {
            return;
        }
        this.lastRange = cr;
        this.rplf.removeAllLinks();
        if (cr == null) {
            return;
        }
        this.rplf.setMap(cr.properties);
        this.rplf.make(this.charMin, CharacterRange.PCharacterRange.RANGE_MIN);
        this.rplf.make(this.charMax, CharacterRange.PCharacterRange.RANGE_MAX);
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        if (e.source == ((Font)this.res).rangeUpdateSource) {
            this.rangeList.setPrototypeCellValue(null);
        }
        this.updatePreviewRange();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource() == this.rangeList) {
            this.fireRangeUpdate();
            Util.setComponentTreeEnabled(this.crPane, !this.rangeList.isSelectionEmpty());
        }
    }

    @Override
    public void contentsChanged(ListDataEvent arg0) {
        this.updatePreviewRange();
    }

    @Override
    public void intervalAdded(ListDataEvent arg0) {
        this.updatePreviewRange();
    }

    @Override
    public void intervalRemoved(ListDataEvent arg0) {
        this.updatePreviewRange();
    }

    private static class RangeListComponentRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 6095060644468207193L;

        private RangeListComponentRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object val, int ind, boolean selected, boolean focus) {
            Component comp = super.getListCellRendererComponent(list, val, ind, selected, focus);
            if (!(val instanceof CharacterRange)) {
                return comp;
            }
            CharacterRange cr = (CharacterRange)val;
            this.setText(Messages.format("FontFrame.CHARRANGE_FORMAT", cr.properties.get(CharacterRange.PCharacterRange.RANGE_MIN), cr.properties.get(CharacterRange.PCharacterRange.RANGE_MAX)));
            return comp;
        }
    }
}

