/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.lateralgm.components.CustomFileChooser;
import org.lateralgm.components.impl.DocumentUndoManager;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.main.LGM;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.ExtensionPackages;
import org.lateralgm.subframes.ResourceFrame;

public class ExtensionPackagesFrame
extends ResourceFrame<ExtensionPackages, ExtensionPackages.PExtensionPackages>
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected DocumentUndoManager undoManager = new DocumentUndoManager();
    private CustomFileChooser fc;
    JList<JCheckBox> packageList;
    private JButton closeButton;
    private JButton installButton;
    private JButton uninstallButton;

    public ExtensionPackagesFrame(ExtensionPackages res) {
        this(res, (ResNode)null);
    }

    public ExtensionPackagesFrame(ExtensionPackages res, ResNode node) {
        super(res, node, Messages.getString("ExtensionPackagesFrame.TITLE"), true);
        this.setDefaultCloseOperation(1);
        this.closeButton = new JButton(Messages.getString("ExtensionPackagesFrame.CLOSE"));
        this.closeButton.addActionListener(this);
        this.installButton = new JButton(Messages.getString("ExtensionPackagesFrame.INSTALL"));
        this.installButton.addActionListener(this);
        this.uninstallButton = new JButton(Messages.getString("ExtensionPackagesFrame.UNINSTALL"));
        this.uninstallButton.addActionListener(this);
        JCheckBox[] cbArray = new JCheckBox[]{new JCheckBox(Messages.getString("ExtensionPackagesFrame.NONE_INSTALLED"))};
        this.packageList = new JList<JCheckBox>(cbArray);
        this.packageList.setCellRenderer(new CheckBoxListRenderer());
        JScrollPane listScroll = new JScrollPane(this.packageList);
        JPanel descPanel = new JPanel();
        descPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ExtensionPackagesFrame.ABOUT")));
        JPanel centerPanel = new JPanel();
        GroupLayout gl = new GroupLayout(centerPanel);
        centerPanel.setLayout(gl);
        gl.setAutoCreateGaps(true);
        gl.setAutoCreateContainerGaps(true);
        gl.setHorizontalGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addComponent(this.closeButton).addComponent(this.installButton).addComponent(this.uninstallButton)).addComponent(listScroll).addComponent(descPanel));
        gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup().addComponent(this.closeButton).addComponent(this.installButton).addComponent(this.uninstallButton)).addComponent(listScroll).addComponent(descPanel));
        this.add((Component)centerPanel, "Center");
        this.pack();
        this.setSize(this.getWidth(), 400);
    }

    public Object getUserObject() {
        if (this.node != null) {
            return this.node.getUserObject();
        }
        int m = 0;
        while (m < LGM.root.getChildCount()) {
            ResNode n = (ResNode)LGM.root.getChildAt(m);
            if (n.kind == ExtensionPackages.class) {
                return n.getUserObject();
            }
            ++m;
        }
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        super.actionPerformed(ev);
        if (ev.getSource() == this.closeButton) {
            this.setVisible(false);
            return;
        }
        if (ev.getSource() == this.installButton) {
            return;
        }
        if (ev.getSource() == this.uninstallButton) {
            return;
        }
    }

    @Override
    public void commitChanges() {
    }

    public void setComponents(ExtensionPackages ext) {
    }

    @Override
    public String getConfirmationName() {
        return (String)this.getUserObject();
    }

    @Override
    public boolean resourceChanged() {
        this.commitChanges();
        return !((ExtensionPackages)this.res).properties.equals(((ExtensionPackages)this.resOriginal).properties);
    }

    @Override
    public void revertResource() {
        ((ExtensionPackages)this.res).properties.putAll(((ExtensionPackages)this.resOriginal).properties);
    }

    private class CheckBoxListRenderer
    implements ListCellRenderer<JCheckBox> {
        private CheckBoxListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JCheckBox> comp, JCheckBox value, int index, boolean isSelected, boolean hasFocus) {
            JCheckBox item = new JCheckBox(value.getText());
            item.setEnabled(comp.isEnabled());
            item.setSelected(value.isSelected());
            item.setFont(comp.getFont());
            if (isSelected) {
                item.setBackground(comp.getSelectionBackground());
                item.setForeground(comp.getSelectionForeground());
            } else {
                item.setBackground(comp.getBackground());
                item.setForeground(comp.getForeground());
            }
            return item;
        }
    }
}

