/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import org.lateralgm.components.ResourceMenu;
import org.lateralgm.components.impl.IndexButtonGroup;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.sub.Event;
import org.lateralgm.subframes.GmObjectFrame;

public class EventPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
UpdateSource.UpdateListener {
    private static final long serialVersionUID = 4801776050696461727L;
    public static final int FUNCTION_ADD = 0;
    public static final int FUNCTION_REPLACE = 1;
    public static final int FUNCTION_DUPLICATE = 2;
    public IndexButtonGroup function;
    public ResourceMenu<GmObject> linkSelect;
    public WeakReference<GmObjectFrame> linkedFrame;
    public JCheckBox stayOpen;
    private EventAction collisionBt;
    private JMenu collisionMenu;

    public EventPanel() {
        GroupLayout layout = new GroupLayout(this);
        JPanel settingsLabelPane = Util.makeLabelPane(Messages.getString("EventPanel.SETTINGS"));
        this.function = new IndexButtonGroup(3, true, false);
        JRadioButton ra = new JRadioButton(Messages.getString("EventPanel.ADD"));
        JRadioButton rr = new JRadioButton(Messages.getString("EventPanel.REPLACE"));
        JRadioButton rd = new JRadioButton(Messages.getString("EventPanel.DUPLICATE"));
        this.function.add(ra);
        this.function.add(rr);
        this.function.add(rd);
        this.function.setValue(0);
        JLabel contextLabel = new JLabel(Messages.getString("EventPanel.CONTEXT"));
        this.linkSelect = new ResourceMenu(GmObject.class, Messages.getString("EventPanel.NO_LINK"), false, 120, true, true);
        this.linkSelect.addActionListener(this);
        this.stayOpen = new JCheckBox(Messages.getString("EventPanel.STAY_OPEN"));
        JPanel basicLabelPane = Util.makeLabelPane(Messages.getString("EventPanel.BASIC"));
        JToolBar basicTB = this.makeBasicToolBar();
        JPanel specialLabelPane = Util.makeLabelPane(Messages.getString("EventPanel.SPECIAL"));
        JToolBar specialTB = this.makeSpecialToolBar();
        JPanel inputLabelPane = Util.makeLabelPane(Messages.getString("EventPanel.INPUT"));
        JToolBar inputTB = this.makeInputToolBar();
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(4).addComponent(basicLabelPane).addComponent(basicTB).addComponent(specialLabelPane).addComponent(specialTB).addComponent(inputLabelPane).addComponent(inputTB).addComponent(settingsLabelPane).addGroup(layout.createParallelGroup().addComponent(ra).addComponent(rr).addComponent(rd)).addComponent(this.stayOpen).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(contextLabel).addComponent(this.linkSelect)).addGap(4));
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(4).addGroup(layout.createParallelGroup().addComponent(basicLabelPane).addComponent(basicTB).addComponent(specialLabelPane).addComponent(specialTB).addComponent(inputLabelPane).addComponent(inputTB).addComponent(settingsLabelPane).addGroup(layout.createSequentialGroup().addComponent(ra).addComponent(rr).addComponent(rd)).addComponent(this.stayOpen).addGroup(layout.createSequentialGroup().addComponent(contextLabel).addComponent(this.linkSelect))).addGap(4));
        this.setLayout(layout);
        this.reload();
    }

    private JToolBar makeBasicToolBar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        EventAction createBt = new EventAction(0);
        EventAction stepBt = new EventAction(3);
        JMenu stepMenu = new JMenu();
        int i = 0;
        while (i <= 2) {
            stepMenu.add(new EventAction(3, i));
            ++i;
        }
        stepBt.setEventMenu(stepMenu);
        EventAction drawBt = new EventAction(8);
        JMenu drawMenu = new JMenu();
        drawMenu.add(new EventAction(8, 0));
        drawMenu.add(new EventAction(8, 64));
        drawMenu.addSeparator();
        int i2 = 72;
        while (i2 <= 77) {
            drawMenu.add(new EventAction(8, i2));
            ++i2;
        }
        drawMenu.insertSeparator(5);
        drawMenu.insertSeparator(8);
        drawMenu.addSeparator();
        drawMenu.add(new EventAction(8, 65));
        drawBt.setEventMenu(drawMenu);
        EventAction destroyBt = new EventAction(1);
        tb.add(createBt);
        tb.add(stepBt);
        tb.add(drawBt);
        tb.add(destroyBt);
        return tb;
    }

    private JToolBar makeSpecialToolBar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        this.collisionBt = new EventAction(4);
        this.collisionMenu = new JMenu();
        this.collisionBt.setEventMenu(this.collisionMenu);
        EventAction alarmBt = new EventAction(2);
        JMenu alarmMenu = new JMenu();
        int i = 0;
        while (i <= 11) {
            alarmMenu.add(new EventAction(2, i));
            ++i;
        }
        alarmBt.setEventMenu(alarmMenu);
        ImageIcon otherGroupIcon = LGM.getIconForKey("EventNode.GROUP7");
        EventAction otherBt = new EventAction(7);
        JMenu otherMenu = new JMenu();
        int i2 = 0;
        while (i2 <= 5) {
            otherMenu.add(new EventAction(7, i2));
            ++i2;
        }
        otherMenu.insertSeparator(2);
        JMenu viewsMenu = new JMenu(Messages.getString("EventPanel.VIEWS"));
        viewsMenu.setIcon(otherGroupIcon);
        int i3 = 0;
        while (i3 <= 7) {
            viewsMenu.add(new EventAction(7, 40 + i3));
            ++i3;
        }
        viewsMenu.addSeparator();
        i3 = 0;
        while (i3 <= 7) {
            viewsMenu.add(new EventAction(7, 50 + i3));
            ++i3;
        }
        otherMenu.insert(viewsMenu, 3);
        otherMenu.insertSeparator(4);
        otherMenu.insertSeparator(7);
        otherMenu.insertSeparator(10);
        otherMenu.add(new EventAction(7, 6));
        otherMenu.add(new EventAction(7, 9));
        otherMenu.addSeparator();
        otherMenu.add(new EventAction(7, 7));
        otherMenu.add(new EventAction(7, 8));
        otherMenu.addSeparator();
        otherMenu.add(new EventAction(7, 30));
        otherMenu.addSeparator();
        JMenu userMenu = new JMenu(Messages.getString("EventPanel.USER_DEFINED"));
        userMenu.setIcon(otherGroupIcon);
        int i4 = 0;
        while (i4 <= 15) {
            userMenu.add(new EventAction(7, 10 + i4));
            ++i4;
        }
        otherMenu.add(userMenu);
        otherMenu.addSeparator();
        JMenu asynchronousMenu = new JMenu(Messages.getString("EventPanel.ASYNCHRONOUS"));
        asynchronousMenu.setIcon(otherGroupIcon);
        asynchronousMenu.add(new EventAction(7, 60));
        asynchronousMenu.add(new EventAction(7, 61));
        asynchronousMenu.add(new EventAction(7, 62));
        asynchronousMenu.add(new EventAction(7, 63));
        asynchronousMenu.add(new EventAction(7, 66));
        asynchronousMenu.add(new EventAction(7, 67));
        asynchronousMenu.add(new EventAction(7, 68));
        asynchronousMenu.add(new EventAction(7, 69));
        asynchronousMenu.add(new EventAction(7, 70));
        asynchronousMenu.add(new EventAction(7, 71));
        asynchronousMenu.add(new EventAction(7, 72));
        asynchronousMenu.add(new EventAction(7, 73));
        asynchronousMenu.add(new EventAction(7, 74));
        asynchronousMenu.add(new EventAction(7, 75));
        otherMenu.add(asynchronousMenu);
        otherBt.setEventMenu(otherMenu);
        tb.add(this.collisionBt);
        tb.add(alarmBt);
        tb.add(otherBt);
        return tb;
    }

    private EventAction makeKeyboardAction(int mid) {
        EventAction keyBt = new EventAction(mid);
        JMenu keyMenu = new JMenu();
        ImageIcon keyGroupIcon = LGM.getIconForKey("EventNode.GROUP" + mid);
        keyMenu.add(new EventAction(mid, 0));
        keyMenu.add(new EventAction(mid, 1));
        keyMenu.addSeparator();
        keyMenu.add(new EventAction(mid, 37));
        keyMenu.add(new EventAction(mid, 39));
        keyMenu.add(new EventAction(mid, 38));
        keyMenu.add(new EventAction(mid, 40));
        keyMenu.addSeparator();
        keyMenu.add(new EventAction(mid, 17));
        keyMenu.add(new EventAction(mid, 18));
        keyMenu.add(new EventAction(mid, 16));
        keyMenu.add(new EventAction(mid, 32));
        keyMenu.add(new EventAction(mid, 13));
        keyMenu.addSeparator();
        JMenu keypadMenu = new JMenu(Messages.getString("EventPanel.KEYPAD"));
        keypadMenu.setIcon(keyGroupIcon);
        int i = 96;
        while (i <= 105) {
            keypadMenu.add(new EventAction(mid, i));
            ++i;
        }
        keypadMenu.add(new EventAction(mid, 111));
        keypadMenu.add(new EventAction(mid, 106));
        keypadMenu.add(new EventAction(mid, 109));
        keypadMenu.add(new EventAction(mid, 107));
        keypadMenu.add(new EventAction(mid, 110));
        keyMenu.add(keypadMenu);
        JMenu digitsMenu = new JMenu(Messages.getString("EventPanel.DIGITS"));
        digitsMenu.setIcon(keyGroupIcon);
        int i2 = 48;
        while (i2 <= 57) {
            digitsMenu.add(new EventAction(mid, i2));
            ++i2;
        }
        keyMenu.add(digitsMenu);
        JMenu lettersMenu = new JMenu(Messages.getString("EventPanel.LETTERS"));
        lettersMenu.setIcon(keyGroupIcon);
        int i3 = 65;
        while (i3 <= 90) {
            lettersMenu.add(new EventAction(mid, i3));
            ++i3;
        }
        keyMenu.add(lettersMenu);
        JMenu funcMenu = new JMenu(Messages.getString("EventPanel.FUNCTION_KEYS"));
        funcMenu.setIcon(keyGroupIcon);
        int i4 = 112;
        while (i4 <= 123) {
            funcMenu.add(new EventAction(mid, i4));
            ++i4;
        }
        keyMenu.add(funcMenu);
        JMenu othersMenu = new JMenu(Messages.getString("EventPanel.OTHERS"));
        othersMenu.setIcon(keyGroupIcon);
        othersMenu.add(new EventAction(mid, 8));
        othersMenu.add(new EventAction(mid, 27));
        othersMenu.add(new EventAction(mid, 36));
        othersMenu.add(new EventAction(mid, 35));
        othersMenu.add(new EventAction(mid, 33));
        othersMenu.add(new EventAction(mid, 34));
        othersMenu.add(new EventAction(mid, 46));
        othersMenu.add(new EventAction(mid, 45));
        keyMenu.add(othersMenu);
        keyBt.setEventMenu(keyMenu);
        return keyBt;
    }

    private JToolBar makeInputToolBar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        EventAction keyBt = this.makeKeyboardAction(5);
        EventAction keyPressBt = this.makeKeyboardAction(9);
        EventAction keyUpBt = this.makeKeyboardAction(10);
        EventAction mouseBt = new EventAction(6);
        JMenu mouseMenu = new JMenu();
        ImageIcon mouseGroupIcon = LGM.getIconForKey("EventNode.GROUP6");
        int i = 0;
        while (i <= 11) {
            mouseMenu.add(new EventAction(6, i));
            ++i;
        }
        mouseMenu.insertSeparator(3);
        mouseMenu.insertSeparator(5);
        mouseMenu.insertSeparator(9);
        mouseMenu.insertSeparator(13);
        mouseMenu.addSeparator();
        i = 60;
        while (i <= 61) {
            mouseMenu.add(new EventAction(6, i));
            ++i;
        }
        mouseMenu.addSeparator();
        JMenu globalMenu = new JMenu(Messages.getString("EventPanel.GLOBAL_MOUSE"));
        globalMenu.setIcon(mouseGroupIcon);
        int i2 = 50;
        while (i2 <= 58) {
            globalMenu.add(new EventAction(6, i2));
            ++i2;
        }
        globalMenu.insertSeparator(3);
        globalMenu.insertSeparator(7);
        mouseMenu.add(globalMenu);
        mouseMenu.addSeparator();
        JMenu joy1Menu = new JMenu(Messages.getString("EventPanel.JOYSTICK_1"));
        joy1Menu.setIcon(mouseGroupIcon);
        int i3 = 16;
        while (i3 <= 28) {
            if (i3 != 20) {
                joy1Menu.add(new EventAction(6, i3));
            }
            ++i3;
        }
        joy1Menu.insertSeparator(4);
        mouseMenu.add(joy1Menu);
        JMenu joy2Menu = new JMenu(Messages.getString("EventPanel.JOYSTICK_2"));
        joy2Menu.setIcon(mouseGroupIcon);
        int i4 = 31;
        while (i4 <= 43) {
            if (i4 != 35) {
                joy2Menu.add(new EventAction(6, i4));
            }
            ++i4;
        }
        joy2Menu.insertSeparator(4);
        mouseMenu.add(joy2Menu);
        mouseBt.setEventMenu(mouseMenu);
        tb.add(keyBt);
        tb.add(keyPressBt);
        tb.add(keyUpBt);
        tb.add(mouseBt);
        return tb;
    }

    public void populate_collision_menu() {
        this.collisionMenu.removeAll();
        this.collisionBt.setEnabled(false);
        if (Prefs.groupKind) {
            int i = 0;
            while (i < LGM.root.getChildCount()) {
                ResNode group = (ResNode)LGM.root.getChildAt(i);
                if (group.kind == GmObject.class) {
                    this.populate_object_nodes(this.collisionMenu, group);
                }
                ++i;
            }
        } else {
            this.populate_object_nodes(this.collisionMenu, LGM.root);
        }
    }

    protected void populate_object_nodes(JMenu parent, ResNode group) {
        int i = 0;
        while (i < group.getChildCount()) {
            ResNode child = (ResNode)group.getChildAt(i);
            if (child.kind == GmObject.class) {
                if (child.status == 3) {
                    parent.add(new EventAction(child.getRes()));
                    this.collisionBt.setEnabled(true);
                } else if (child.status == 2) {
                    JMenu groupMenu = new JMenu(child.getUserObject().toString());
                    ImageIcon groupIcon = LGM.getIconForKey("EventNode.GROUP4");
                    groupMenu.setIcon(groupIcon);
                    if (child.getChildCount() > 0) {
                        this.populate_object_nodes(groupMenu, child);
                    } else {
                        groupMenu.add(new JMenuItem(Messages.getString("EventPanel.EMPTY_GROUP")));
                    }
                    parent.add(groupMenu);
                }
            }
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.linkSelect) {
            GmObject obj = (GmObject)Util.deRef(((ResourceMenu)e.getSource()).getSelected());
            if (obj != null) {
                ResNode node = obj.getNode();
                GmObjectFrame f = (GmObjectFrame)node.frame;
                this.linkedFrame = new WeakReference<GmObjectFrame>(f);
                f.toTop();
            } else {
                this.linkedFrame = null;
            }
            return;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("selectedFrame")) {
            JInternalFrame newFrame = (JInternalFrame)evt.getNewValue();
            JInternalFrame oldFrame = (JInternalFrame)evt.getOldValue();
            if (newFrame instanceof GmObjectFrame) {
                GmObjectFrame f = (GmObjectFrame)newFrame;
                this.linkedFrame = new WeakReference<GmObjectFrame>(f);
                this.linkSelect.setSelected(f.node.getRes());
            } else if (newFrame == null && !oldFrame.isVisible()) {
                this.linkSelect.setSelected(null);
            }
        }
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        this.populate_collision_menu();
    }

    public void reload() {
        LGM.mdi.addPropertyChangeListener("selectedFrame", this);
        LGM.root.updateSource.addListener(this);
        this.populate_collision_menu();
    }

    private class EventAction
    extends AbstractAction {
        private static final long serialVersionUID = -3612891952734251981L;
        private int mid = 0;
        private int sid = 0;
        private ResourceReference<GmObject> other;
        private JMenu subevtMenu = null;

        public EventAction(int id, int sid, ResourceReference<GmObject> other) {
            this.mid = id;
            this.sid = sid;
            this.other = other;
            this.putValue("SmallIcon", LGM.getIconForKey("EventNode.EVENT" + this.mid));
            this.putValue("SwingLargeIconKey", LGM.getIconForKey("EventNode.EVENT" + this.mid + "_32px"));
            this.putValue("Name", other == null ? Event.eventName(this.mid, sid) : other.get().getName());
        }

        public EventAction(int id) {
            this(id, 0, null);
            this.putValue("ShortDescription", Messages.getString("MainEvent.EVENT" + this.mid));
        }

        public EventAction(int id, int sid) {
            this(id, sid, null);
        }

        public EventAction(ResourceReference<GmObject> other) {
            this(4, 0, other);
        }

        public void setEventMenu(JMenu subevtMenu) {
            this.subevtMenu = subevtMenu;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.subevtMenu != null) {
                if (!(e.getSource() instanceof JComponent)) {
                    return;
                }
                JComponent src = (JComponent)e.getSource();
                JPopupMenu popup = this.subevtMenu.getPopupMenu();
                popup.show(src, src.getWidth(), 0);
            } else {
                GmObjectFrame f;
                GmObjectFrame gmObjectFrame = f = EventPanel.this.linkedFrame == null ? null : (GmObjectFrame)EventPanel.this.linkedFrame.get();
                if (f != null) {
                    f.functionEvent(EventPanel.this.function.getValue(), this.mid, this.sid, this.other, null);
                    f.toTop();
                    boolean ctrlDown = (e.getModifiers() & 2) != 0;
                    if (!EventPanel.this.stayOpen.isSelected() ^ ctrlDown) {
                        LGM.hideEventPanel();
                    }
                }
            }
        }
    }
}

