/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import org.lateralgm.components.CustomFileChooser;
import org.lateralgm.components.impl.CustomFileFilter;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.file.GmStreamDecoder;
import org.lateralgm.file.GmStreamEncoder;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.file.StreamDecoder;
import org.lateralgm.main.LGM;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Constants;
import org.lateralgm.resources.sub.Constant;
import org.lateralgm.subframes.ResourceFrame;

public class ConstantsFrame
extends ResourceFrame<Constants, Constants.PConstants> {
    private static final long serialVersionUID = 1L;
    public JToolBar toolbar;
    public JButton importBut;
    public JButton exportBut;
    public JTable constants;
    public ConstantsTableModel cModel;
    public JButton add;
    public JButton insert;
    public JButton delete;
    public JButton clear;
    public JButton up;
    public JButton down;
    public JButton sort;
    private CustomFileChooser constantsFc;

    public ConstantsFrame(Constants res) {
        this(res, (ResNode)null);
    }

    public void updateTitle() {
        String name = ((Constants)this.res).getName();
        if (this.res == LGM.currentFile.defaultConstants) {
            name = "All Configurations";
        }
        this.setTitle(String.valueOf(Messages.getString("ConstantsFrame.TITLE")) + " : " + name);
    }

    public ConstantsFrame(Constants res, ResNode node) {
        super(res, node);
        this.setDefaultCloseOperation(1);
        this.setTitle(Messages.getString("ConstantsFrame.TITLE"));
        JPanel content = new JPanel();
        GroupLayout layout = new GroupLayout(content);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        content.setLayout(layout);
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.add(this.save);
        this.toolbar.addSeparator();
        this.exportBut = new JButton(LGM.getIconForKey("ConstantsFrame.EXPORT"));
        this.exportBut.setToolTipText(Messages.getString("ConstantsFrame.EXPORT"));
        this.exportBut.addActionListener(this);
        this.toolbar.add(this.exportBut);
        this.importBut = new JButton(LGM.getIconForKey("ConstantsFrame.IMPORT"));
        this.importBut.setToolTipText(Messages.getString("ConstantsFrame.IMPORT"));
        this.importBut.addActionListener(this);
        this.toolbar.add(this.importBut);
        this.add((Component)this.toolbar, "North");
        this.add((Component)content, "Center");
        this.cModel = new ConstantsTableModel(res.constants);
        this.constants = new JTable(this.cModel);
        JScrollPane scroll = new JScrollPane(this.constants);
        this.constants.setSelectionMode(2);
        this.constants.getTableHeader().setReorderingAllowed(false);
        this.constants.setTransferHandler(null);
        this.constants.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.add = new JButton(Messages.getString("ConstantsFrame.ADD"));
        this.add.addActionListener(this);
        this.insert = new JButton(Messages.getString("ConstantsFrame.INSERT"));
        this.insert.addActionListener(this);
        this.delete = new JButton(Messages.getString("ConstantsFrame.DELETE"));
        this.delete.addActionListener(this);
        this.clear = new JButton(Messages.getString("ConstantsFrame.CLEAR"));
        this.clear.addActionListener(this);
        this.up = new JButton(Messages.getString("ConstantsFrame.UP"));
        this.up.addActionListener(this);
        this.down = new JButton(Messages.getString("ConstantsFrame.DOWN"));
        this.down.addActionListener(this);
        this.sort = new JButton(Messages.getString("ConstantsFrame.SORT"));
        this.sort.addActionListener(this);
        this.constantsFc = new CustomFileChooser("/org/lateralgm", "LAST_LGC_DIR");
        this.constantsFc.setFileFilter(new CustomFileFilter(Messages.getString("ConstantsFrame.LGC_FILES"), ".lgc"));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(scroll).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.add, -1, -1, Integer.MAX_VALUE).addComponent(this.insert, -1, -1, Integer.MAX_VALUE)).addGroup(layout.createParallelGroup().addComponent(this.delete, -1, -1, Integer.MAX_VALUE).addComponent(this.clear, -1, -1, Integer.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup().addComponent(this.up, -1, -1, Integer.MAX_VALUE).addComponent(this.down, -1, -1, Integer.MAX_VALUE)).addComponent(this.sort, -1, -1, Integer.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(scroll, -1, 300, Integer.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent(this.add).addComponent(this.delete).addComponent(this.up).addComponent(this.sort)).addGroup(layout.createParallelGroup().addComponent(this.insert).addComponent(this.clear).addComponent(this.down)));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.importBut) {
            this.importConstants();
            return;
        }
        if (e.getSource() == this.exportBut) {
            this.exportConstants();
            return;
        }
        if (e.getSource() == this.add) {
            if (this.constants.getCellEditor() != null) {
                this.constants.getCellEditor().stopCellEditing();
            }
            this.cModel.constants.add(new Constant());
            int row = this.cModel.constants.size() - 1;
            this.cModel.fireTableRowsInserted(row, row);
            this.constants.getSelectionModel().setSelectionInterval(row, row);
            return;
        }
        if (e.getSource() == this.insert) {
            if (this.constants.getSelectedRow() == -1) {
                return;
            }
            if (this.constants.getCellEditor() != null) {
                this.constants.getCellEditor().stopCellEditing();
            }
            this.cModel.constants.add(this.constants.getSelectedRow(), new Constant());
            this.cModel.fireTableRowsInserted(this.constants.getSelectedRow(), this.constants.getSelectedRow());
            this.constants.getSelectionModel().setSelectionInterval(0, this.constants.getSelectedRow() - 1);
            return;
        }
        if (e.getSource() == this.delete) {
            if (this.constants.getSelectedRow() == -1) {
                return;
            }
            int row = this.constants.getSelectedRow();
            this.cModel.constants.remove(row);
            this.cModel.fireTableRowsDeleted(row, row);
            if (this.cModel.constants.size() > 0) {
                this.constants.getSelectionModel().setSelectionInterval(0, Math.min(row, this.cModel.constants.size() - 1));
            }
            return;
        }
        if (e.getSource() == this.clear) {
            if (this.cModel.constants.size() == 0) {
                return;
            }
            int last = this.cModel.constants.size() - 1;
            this.cModel.constants.clear();
            this.cModel.fireTableRowsDeleted(0, last);
            return;
        }
        if (e.getSource() == this.up) {
            int row = this.constants.getSelectedRow();
            if (row <= 0) {
                return;
            }
            if (this.constants.getCellEditor() != null) {
                this.constants.getCellEditor().stopCellEditing();
            }
            Constant c = this.cModel.constants.get(row - 1);
            this.cModel.constants.set(row - 1, this.cModel.constants.get(row));
            this.cModel.constants.set(row, c);
            this.cModel.fireTableDataChanged();
            this.constants.getSelectionModel().setSelectionInterval(0, row - 1);
            return;
        }
        if (e.getSource() == this.down) {
            int row = this.constants.getSelectedRow();
            if (row == -1 || row >= this.cModel.constants.size() - 1) {
                return;
            }
            if (this.constants.getCellEditor() != null) {
                this.constants.getCellEditor().stopCellEditing();
            }
            Constant c = this.cModel.constants.get(row + 1);
            this.cModel.constants.set(row + 1, this.cModel.constants.get(row));
            this.cModel.constants.set(row, c);
            this.cModel.fireTableDataChanged();
            this.constants.getSelectionModel().setSelectionInterval(0, row + 1);
            return;
        }
        if (e.getSource() == this.sort) {
            if (this.constants.getCellEditor() != null) {
                this.constants.getCellEditor().stopCellEditing();
            }
            Collections.sort(this.cModel.constants);
            this.cModel.fireTableDataChanged();
            if (this.cModel.constants.size() > 0) {
                this.constants.getSelectionModel().setSelectionInterval(0, 0);
            }
            return;
        }
    }

    private void importConstants() {
        block18: {
            if (this.constantsFc.showOpenDialog(LGM.frame) == 0) {
                this.cModel.removeEmptyConstants();
                StreamDecoder in = null;
                try {
                    try {
                        File f = this.constantsFc.getSelectedFile();
                        if (f == null || !f.exists()) {
                            throw new Exception();
                        }
                        in = new GmStreamDecoder(f);
                        if (in.read3() != 4409164) {
                            throw new Exception();
                        }
                        int count = in.read2();
                        int i = 0;
                        while (i < count) {
                            Constant c = new Constant();
                            c.name = ((GmStreamDecoder)in).readStr1();
                            c.value = ((GmStreamDecoder)in).readStr1();
                            if (!this.cModel.constants.contains(c)) {
                                this.cModel.constants.add(c);
                            }
                            ++i;
                        }
                        this.cModel.fireTableDataChanged();
                        if (this.cModel.constants.size() > 0) {
                            this.constants.getSelectionModel().setSelectionInterval(0, 0);
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(LGM.frame, Messages.getString("ConstantsFrame.ERROR_IMPORTING_CONSTANTS"), Messages.getString("ConstantsFrame.TITLE_ERROR"), 0);
                        if (in == null) break block18;
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exportConstants() {
        while (this.constantsFc.showSaveDialog(LGM.frame) == 0) {
            File f = this.constantsFc.getSelectedFile();
            if (f == null) {
                return;
            }
            if (!f.getPath().endsWith(".lgc")) {
                f = new File(String.valueOf(f.getPath()) + ".lgc");
            }
            int result = 0;
            if (f.exists()) {
                result = JOptionPane.showConfirmDialog(LGM.frame, Messages.getString("ConstantsFrame.REPLACE_FILE"), Messages.getString("ConstantsFrame.TITLE_REPLACE_FILE"), 1);
            }
            if (result == 2) {
                return;
            }
            if (result == 1) continue;
            this.cModel.removeEmptyConstants();
            GmStreamEncoder out = null;
            try {
                try {
                    out = new GmStreamEncoder(f);
                    out.write(76);
                    out.write(71);
                    out.write(67);
                    out.write2(this.cModel.constants.size());
                    for (Constant c : this.cModel.constants) {
                        out.writeStr1(c.name);
                        out.writeStr1(c.value);
                    }
                    return;
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                    if (out == null) return;
                    try {
                        out.close();
                        return;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    if (out == null) return;
                    try {
                        out.close();
                        return;
                    }
                    catch (IOException ex2) {
                        ex2.printStackTrace();
                    }
                    return;
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void commitChanges() {
        this.cModel.removeEmptyConstants();
        ((Constants)this.res).constants = ProjectFile.copyConstants(this.cModel.constants);
    }

    public void setComponents(Constants c) {
        this.cModel = new ConstantsTableModel(c.constants);
        this.constants.setModel(this.cModel);
    }

    @Override
    public boolean resourceChanged() {
        this.commitChanges();
        return !((Constants)this.res).properties.equals(((Constants)this.resOriginal).properties) || !((Constants)this.res).constants.equals(((Constants)this.resOriginal).constants);
    }

    @Override
    public void revertResource() {
        ((Constants)this.resOriginal).copy((Constants)this.res);
        this.setComponents((Constants)this.res);
    }

    @Override
    public void updateResource(boolean commit) {
        super.updateResource(commit);
    }

    private class ConstantsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        List<Constant> constants;

        ConstantsTableModel(List<Constant> list) {
            this.constants = ProjectFile.copyConstants(list);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.constants.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Constant c = this.constants.get(rowIndex);
            return columnIndex == 0 ? c.name : c.value;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Constant c = this.constants.get(rowIndex);
            if (columnIndex == 0) {
                c.name = aValue.toString();
            } else {
                c.value = aValue.toString();
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public String getColumnName(int column) {
            String ind = column == 0 ? "NAME" : "VALUE";
            return Messages.getString("ConstantsFrame." + ind);
        }

        public void removeEmptyConstants() {
            int i = this.constants.size() - 1;
            while (i >= 0) {
                if (this.constants.get((int)i).name.equals("")) {
                    this.constants.remove(i);
                }
                --i;
            }
            this.fireTableDataChanged();
        }
    }
}

