/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.lateralgm.components.impl.NameDocument;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.main.LGM;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.GameSettings;

public class ConfigurationManager
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 683154513336137335L;
    JList<GameSettings> configList = null;
    private VectorListModel<GameSettings> vlm;
    private JButton deleteButton;
    private static ConfigurationManager INSTANCE = null;

    public static ConfigurationManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConfigurationManager();
            INSTANCE.setConfigList(LGM.currentFile.gameSettings);
        }
        return INSTANCE;
    }

    public ConfigurationManager() {
        super(LGM.frame);
        this.setResizable(false);
        this.setTitle(Messages.getString("ConfigurationManager.TITLE"));
        this.setIconImage(LGM.getIconForKey("ConfigurationManager.ICON").getImage());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        this.deleteButton = this.makeToolbarButton("DELETE");
        this.configList = new JList();
        toolbar.add(this.makeToolbarButton("ADD"));
        toolbar.add(this.makeToolbarButton("COPY"));
        toolbar.add(this.deleteButton);
        toolbar.addSeparator();
        toolbar.add(this.makeToolbarButton("EDIT_SETTINGS"));
        toolbar.add(this.makeToolbarButton("EDIT_CONSTANTS"));
        toolbar.addSeparator();
        toolbar.add(new JLabel(Messages.getString("ConfigurationManager.NAME")));
        final JTextField nameField = new JTextField();
        nameField.setDocument(new NameDocument());
        nameField.setColumns(10);
        nameField.setMaximumSize(nameField.getPreferredSize());
        nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateNameField(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateNameField(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateNameField(e);
            }

            public void updateNameField(DocumentEvent e) {
                GameSettings sel = ConfigurationManager.this.configList.getSelectedValue();
                if (sel == null) {
                    return;
                }
                sel.setName(nameField.getText());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).ConfigurationManager.this.configList.updateUI();
                    }
                });
                sel.constants.setName(nameField.getText());
                LGM.getConstantsFrame().updateTitle();
                LGM.getGameSettings().updateTitle();
            }
        });
        this.configList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                GameSettings sel = ConfigurationManager.this.configList.getSelectedValue();
                if (sel == null) {
                    return;
                }
                nameField.setText(sel.getName());
            }
        });
        toolbar.add(nameField);
        this.add((Component)toolbar, "North");
        JScrollPane scroll = new JScrollPane(this.configList);
        this.add((Component)scroll, "Center");
        this.pack();
        this.setSize(this.getWidth(), 320);
        this.setLocationRelativeTo(LGM.frame);
    }

    JButton makeToolbarButton(String key) {
        key = "ConfigurationManager." + key;
        JButton jb = new JButton();
        jb.setToolTipText(Messages.getString(key));
        jb.setIcon(LGM.getIconForKey(key));
        jb.setActionCommand(key);
        jb.addActionListener(this);
        return jb;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String cmd = ev.getActionCommand();
        VectorListModel model = (VectorListModel)this.configList.getModel();
        if (cmd.endsWith("ADD")) {
            GameSettings config = ProjectFile.createDefaultConfig();
            int id = 0;
            for (GameSettings cfg : LGM.currentFile.gameSettings) {
                if (!cfg.getName().startsWith("Configuration")) continue;
                ++id;
            }
            config.setName("Configuration" + id);
            model.addElement(config);
            this.configList.setSelectedValue(config, true);
            LGM.configsCombo.updateUI();
        } else if (cmd.endsWith("COPY")) {
            GameSettings sel = this.configList.getSelectedValue();
            if (sel == null) {
                return;
            }
            GameSettings config = (GameSettings)sel.clone();
            int id = 0;
            for (GameSettings cfg : LGM.currentFile.gameSettings) {
                if (!cfg.getName().startsWith("Configuration")) continue;
                ++id;
            }
            config.setName("Configuration" + id);
            model.addElement(config);
            this.configList.setSelectedValue(config, true);
            LGM.configsCombo.updateUI();
        } else if (cmd.endsWith("DELETE")) {
            List<GameSettings> selList = this.configList.getSelectedValuesList();
            if (selList.size() >= model.getSize()) {
                selList.remove(0);
            }
            model.removeAll(selList);
            if (LGM.configsCombo.getSelectedIndex() >= LGM.configsCombo.getItemCount() || LGM.configsCombo.getSelectedIndex() < 0) {
                LGM.configsCombo.setSelectedIndex(0);
            }
            LGM.configsCombo.updateUI();
        } else if (cmd.endsWith("EDIT_SETTINGS")) {
            GameSettings sel = this.configList.getSelectedValue();
            if (sel == null) {
                return;
            }
            LGM.showGameSettings(sel);
        } else if (cmd.endsWith("EDIT_CONSTANTS")) {
            GameSettings sel = this.configList.getSelectedValue();
            if (sel == null) {
                return;
            }
            sel.constants.setName(sel.getName());
            LGM.showConstantsFrame(sel.constants);
        }
    }

    public void setConfigList(Vector<GameSettings> gameSettings) {
        this.vlm = new VectorListModel<GameSettings>(LGM.currentFile.gameSettings);
        this.vlm.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent arg0) {
                ConfigurationManager.this.deleteButton.setEnabled(ConfigurationManager.this.vlm.getSize() > 1);
            }

            @Override
            public void intervalAdded(ListDataEvent arg0) {
                ConfigurationManager.this.deleteButton.setEnabled(ConfigurationManager.this.vlm.getSize() > 1);
            }

            @Override
            public void intervalRemoved(ListDataEvent arg0) {
                ConfigurationManager.this.deleteButton.setEnabled(ConfigurationManager.this.vlm.getSize() > 1);
            }
        });
        this.configList.setModel(this.vlm);
        this.deleteButton.setEnabled(this.vlm.getSize() > 1);
    }

    public class VectorListModel<T>
    extends AbstractListModel<T> {
        private static final long serialVersionUID = 8672982566605074780L;
        private Vector<T> vector = null;

        public VectorListModel(Vector<T> vec) {
            this.vector = vec;
        }

        public void add(int index, T element) {
            this.vector.add(index, element);
            super.fireIntervalAdded(this, index, index);
        }

        public void addElement(T element) {
            this.vector.addElement(element);
            super.fireIntervalAdded(this, this.vector.size() - 1, this.vector.size() - 1);
        }

        public boolean remove(T element) {
            int index = this.vector.indexOf(element);
            boolean ret = this.vector.remove(element);
            super.fireIntervalRemoved(this, index, index);
            return ret;
        }

        public boolean removeAll(List<T> elements) {
            boolean ret = this.vector.removeAll(elements);
            super.fireIntervalRemoved(this, 0, elements.size());
            return ret;
        }

        @Override
        public T getElementAt(int index) {
            return this.vector.get(index);
        }

        public T get(int index) {
            return this.vector.get(index);
        }

        public Enumeration<T> elements() {
            return this.vector.elements();
        }

        public Object[] toArray() {
            return this.vector.toArray();
        }

        public int size() {
            return this.vector.size();
        }

        public boolean isEmpty() {
            return this.vector.isEmpty();
        }

        @Override
        public int getSize() {
            return this.vector.size();
        }
    }
}

