/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.lateralgm.components.CodeTextArea;
import org.lateralgm.components.MarkerCache;
import org.lateralgm.components.impl.TextAreaFocusTraversalPolicy;
import org.lateralgm.components.mdi.RevertableMDIFrame;
import org.lateralgm.main.LGM;
import org.lateralgm.subframes.SubframeInformer;

public class CodeFrame
extends RevertableMDIFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public final CodeHolder codeHolder;
    public final JToolBar tool;
    public final CodeTextArea code;
    public final JPanel status;
    private final String titleFormat;
    private final JButton save;

    public CodeFrame(CodeHolder codeHolder, String titleFormat, Object titleArg) {
        super(MessageFormat.format(titleFormat, titleArg), true, true, true, true);
        this.setFrameIcon(LGM.getIconForKey("Resource.SCR"));
        this.codeHolder = codeHolder;
        this.titleFormat = titleFormat;
        this.setSize(700, 430);
        this.tool = new JToolBar();
        this.tool.setFloatable(false);
        this.tool.setAlignmentX(0.0f);
        this.save = new JButton(LGM.getIconForKey("ResourceFrame.SAVE"));
        this.save.addActionListener(this);
        this.tool.add(this.save);
        this.tool.addSeparator();
        this.code = new CodeTextArea(codeHolder.getCode(), MarkerCache.getMarker("gml"));
        this.code.addEditorButtons(this.tool);
        this.status = new JPanel(new FlowLayout());
        this.status.setLayout(new BoxLayout(this.status, 0));
        this.status.setMaximumSize(new Dimension(Integer.MAX_VALUE, 11));
        final JLabel caretPos = new JLabel(" INS | UTF-8 | " + (this.code.getCaretLine() + 1) + " : " + (this.code.getCaretColumn() + 1));
        this.status.add(caretPos);
        this.code.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                caretPos.setText(" INS | UTF-8 | " + (CodeFrame.this.code.getCaretLine() + 1) + ":" + (CodeFrame.this.code.getCaretColumn() + 1));
            }
        });
        this.add((Component)this.tool, "North");
        this.add((Component)this.code, "Center");
        this.add((Component)this.status, "South");
        this.setFocusTraversalPolicy(new TextAreaFocusTraversalPolicy(this.code.text));
        SubframeInformer.fireSubframeAppear(this, false);
    }

    public void setTitleFormatArg(Object titleArg) {
        this.setTitle(MessageFormat.format(this.titleFormat, titleArg));
    }

    public void commitChanges() {
        this.codeHolder.setCode(this.code.getTextCompat());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateResource(true);
        this.close();
    }

    @Override
    public String getConfirmationName() {
        return this.getTitle();
    }

    @Override
    public boolean resourceChanged() {
        return this.code.isChanged();
    }

    @Override
    public void revertResource() {
    }

    @Override
    public void updateResource(boolean commit) {
        this.commitChanges();
    }

    @Override
    public void setResourceChanged() {
    }

    public static interface CodeHolder {
        public String getCode();

        public void setCode(String var1);
    }
}

