/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.text.NumberFormatter;
import org.lateralgm.components.EffectsFrame;
import org.lateralgm.components.NumberField;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.components.visual.BackgroundPreview;
import org.lateralgm.file.FileChangeMonitor;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Background;
import org.lateralgm.subframes.InstantiableResourceFrame;
import org.lateralgm.ui.swing.util.SwingExecutor;
import org.lateralgm.util.PropertyMap;

public class BackgroundFrame
extends InstantiableResourceFrame<Background, Background.PBackground>
implements UpdateSource.UpdateListener,
EffectsFrame.EffectsFrameListener {
    private static final long serialVersionUID = 1L;
    public JButton load;
    public JLabel statusLabel;
    public JCheckBox transparent;
    public JButton edit;
    public JButton zoomIn;
    public JButton zoomOut;
    public JToggleButton zoomButton;
    public JCheckBox smooth;
    public JCheckBox preload;
    public JCheckBox tileset;
    public MouseAdapter mouseAdapter = null;
    public JPanel groupPanel;
    public NumberField tWidth;
    public NumberField tHeight;
    public NumberField hOffset;
    public NumberField vOffset;
    public NumberField hSep;
    public NumberField vSep;
    public JScrollPane previewScroll;
    public BackgroundPreview preview;
    public boolean imageChanged = false;
    private BackgroundEditor editor;
    private final BackgroundPropertyListener bpl = new BackgroundPropertyListener();

    public BackgroundFrame(Background res, ResNode node) {
        super(res, node);
        this.getRootPane().setDefaultButton(this.save);
        res.properties.getUpdateSource(Background.PBackground.USE_AS_TILESET).addListener(this.bpl);
        res.reference.updateSource.addListener(this);
        this.setLayout(new BorderLayout());
        JPanel previewPanel = new JPanel(new BorderLayout());
        this.preview = new BackgroundPreview(res);
        this.preview.setVerticalAlignment(1);
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                if (ev.getButton() == 1) {
                    BackgroundFrame.this.preview.setCursor(LGM.zoomInCursor);
                }
                if (ev.getButton() == 3) {
                    BackgroundFrame.this.preview.setCursor(LGM.zoomOutCursor);
                }
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (ev.getButton() == 1) {
                    BackgroundFrame.this.preview.zoomIn(ev.getPoint(), BackgroundFrame.this.previewScroll);
                }
                if (ev.getButton() == 3) {
                    BackgroundFrame.this.preview.zoomOut(ev.getPoint(), BackgroundFrame.this.previewScroll);
                }
                BackgroundFrame.this.preview.setCursor(LGM.zoomCursor);
            }
        };
        this.previewScroll = new JScrollPane(this.preview);
        previewPanel.add((Component)this.previewScroll, "Center");
        previewPanel.add((Component)this.makeToolBar(), "North");
        previewPanel.add((Component)this.makeStatusBar(), "South");
        JSplitPane orientationSplit = new JSplitPane(1, true);
        Util.orientSplit(orientationSplit, Prefs.rightOrientation, this.makeOptionsPanel(), previewPanel);
        this.add((Component)orientationSplit, "Center");
        this.updateStatusBar();
        this.updateScrollBars();
        this.pack();
        this.setSize(640, 462);
    }

    private JButton makeJButton(String key) {
        JButton but = new JButton(LGM.getIconForKey(key));
        but.setToolTipText(Messages.getString(key));
        but.addActionListener(this);
        but.setActionCommand(key);
        return but;
    }

    private JToolBar makeToolBar() {
        JToolBar tool = new JToolBar();
        tool.setFloatable(false);
        tool.setAlignmentX(0.0f);
        tool.add(this.makeJButton("BackgroundFrame.CREATE"));
        tool.add(this.makeJButton("BackgroundFrame.LOAD"));
        tool.add(this.makeJButton("BackgroundFrame.SAVE"));
        tool.add(this.makeJButton("BackgroundFrame.EDIT"));
        tool.add(this.makeJButton("BackgroundFrame.EFFECT"));
        tool.addSeparator();
        this.zoomButton = new JToggleButton(LGM.getIconForKey("BackgroundFrame.ZOOM"));
        this.zoomButton.setToolTipText(Messages.getString("BackgroundFrame.ZOOM"));
        this.zoomButton.addActionListener(this);
        this.zoomButton.setActionCommand("BackgroundFrame.ZOOM");
        tool.add(this.zoomButton);
        tool.add(this.makeJButton("BackgroundFrame.ZOOM_IN"));
        tool.add(this.makeJButton("BackgroundFrame.ZOOM_OUT"));
        return tool;
    }

    private JPanel makeStatusBar() {
        JPanel status = new JPanel();
        BoxLayout layout = new BoxLayout(status, 0);
        status.setLayout(layout);
        status.setMaximumSize(new Dimension(Integer.MAX_VALUE, 11));
        this.statusLabel = new JLabel();
        status.add(this.statusLabel);
        return status;
    }

    private JPanel makeOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        this.transparent = new JCheckBox(Messages.getString("BackgroundFrame.TRANSPARENT"));
        this.plf.make(this.transparent, Background.PBackground.TRANSPARENT);
        this.smooth = new JCheckBox(Messages.getString("BackgroundFrame.SMOOTH"));
        this.plf.make(this.smooth, Background.PBackground.SMOOTH_EDGES);
        this.preload = new JCheckBox(Messages.getString("BackgroundFrame.PRELOAD"));
        this.plf.make(this.preload, Background.PBackground.PRELOAD);
        this.tileset = new JCheckBox(Messages.getString("BackgroundFrame.USE_AS_TILESET"));
        this.plf.make(this.tileset, Background.PBackground.USE_AS_TILESET);
        this.groupPanel = new JPanel();
        GroupLayout pLayout = new GroupLayout(this.groupPanel);
        pLayout.setAutoCreateContainerGaps(true);
        this.groupPanel.setLayout(pLayout);
        String tileProps = Messages.getString("BackgroundFrame.TILE_PROPERTIES");
        this.groupPanel.setBorder(BorderFactory.createTitledBorder(tileProps));
        JLabel twLabel = new JLabel(Messages.getString("BackgroundFrame.TILE_WIDTH"));
        twLabel.setHorizontalAlignment(4);
        this.tWidth = new NumberField(0, Integer.MAX_VALUE);
        this.plf.make(this.tWidth, Background.PBackground.TILE_WIDTH);
        this.tWidth.setColumns(3);
        JLabel thLabel = new JLabel(Messages.getString("BackgroundFrame.TILE_HEIGHT"));
        thLabel.setHorizontalAlignment(4);
        this.tHeight = new NumberField(0, Integer.MAX_VALUE);
        this.plf.make(this.tHeight, Background.PBackground.TILE_HEIGHT);
        this.tHeight.setColumns(3);
        JLabel hoLabel = new JLabel(Messages.getString("BackgroundFrame.H_OFFSET"));
        hoLabel.setHorizontalAlignment(4);
        this.hOffset = new NumberField(0, Integer.MAX_VALUE);
        this.plf.make(this.hOffset, Background.PBackground.H_OFFSET);
        this.hOffset.setColumns(3);
        JLabel voLabel = new JLabel(Messages.getString("BackgroundFrame.V_OFFSET"));
        voLabel.setHorizontalAlignment(4);
        this.vOffset = new NumberField(0, Integer.MAX_VALUE);
        this.plf.make(this.vOffset, Background.PBackground.V_OFFSET);
        this.vOffset.setColumns(3);
        JLabel hsLabel = new JLabel(Messages.getString("BackgroundFrame.H_SEP"));
        hsLabel.setHorizontalAlignment(4);
        this.hSep = new NumberField(0, Integer.MAX_VALUE);
        this.plf.make(this.hSep, Background.PBackground.H_SEP);
        this.hSep.setColumns(3);
        JLabel vsLabel = new JLabel(Messages.getString("BackgroundFrame.V_SEP"));
        vsLabel.setHorizontalAlignment(4);
        this.vSep = new NumberField(0, Integer.MAX_VALUE);
        this.plf.make(this.vSep, Background.PBackground.V_SEP);
        this.vSep.setColumns(3);
        pLayout.setHorizontalGroup(pLayout.createSequentialGroup().addGroup(pLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(twLabel).addComponent(thLabel).addComponent(hoLabel).addComponent(voLabel).addComponent(hsLabel).addComponent(vsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pLayout.createParallelGroup().addComponent(this.tWidth, -2, -1, -1).addComponent(this.tHeight, -2, -1, -1).addComponent(this.hOffset, -2, -1, -1).addComponent(this.vOffset, -2, -1, -1).addComponent(this.hSep, -2, -1, -1).addComponent(this.vSep, -2, -1, -1)));
        pLayout.setVerticalGroup(pLayout.createSequentialGroup().addGroup(pLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(twLabel).addComponent(this.tWidth)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(thLabel).addComponent(this.tHeight)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(hoLabel).addComponent(this.hOffset)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(voLabel).addComponent(this.vOffset)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(hsLabel).addComponent(this.hSep)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(vsLabel).addComponent(this.vSep)));
        JLabel nameLabel = new JLabel(Messages.getString("SpriteFrame.NAME"));
        this.save.setText(Messages.getString("SpriteFrame.SAVE"));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(nameLabel).addComponent(this.name, -1, 120, Integer.MAX_VALUE)).addComponent(this.smooth).addComponent(this.preload).addComponent(this.transparent).addComponent(this.tileset).addComponent(this.groupPanel).addComponent(this.save, -1, -1, Integer.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(nameLabel).addComponent(this.name)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.smooth).addComponent(this.preload).addComponent(this.transparent).addComponent(this.tileset).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.groupPanel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 0, Integer.MAX_VALUE).addComponent(this.save));
        layout.setHonorsVisibility(this.groupPanel, false);
        this.groupPanel.setVisible(this.tileset.isSelected());
        return panel;
    }

    private void realizeScrollBarIncrement(JScrollPane scroll) {
        JScrollBar vertical = scroll.getVerticalScrollBar();
        JScrollBar horizontal = scroll.getHorizontalScrollBar();
        if (vertical != null) {
            vertical.setUnitIncrement((int)this.getZoom());
        }
        if (horizontal != null) {
            horizontal.setUnitIncrement((int)this.getZoom());
        }
    }

    private void updateScrollBars() {
        this.realizeScrollBarIncrement(this.previewScroll);
    }

    public double getZoom() {
        return this.preview.getZoom();
    }

    public void setZoom(double nzoom) {
        this.preview.setZoom(nzoom);
        this.updateStatusBar();
        this.updateScrollBars();
    }

    private void updateStatusBar() {
        String stat = " " + Messages.getString("BackgroundFrame.WIDTH") + ": " + ((Background)this.res).getWidth() + " | " + Messages.getString("BackgroundFrame.HEIGHT") + ": " + ((Background)this.res).getHeight() + " | " + Messages.getString("BackgroundFrame.MEMORY") + ": ";
        stat = ((Background)this.res).getBackgroundImage() != null ? String.valueOf(stat) + Util.formatDataSize(((Background)this.res).getSize()) : String.valueOf(stat) + Util.formatDataSize(0L);
        String zoom = new DecimalFormat("#,##0.##").format(this.getZoom() * 100.0);
        stat = String.valueOf(stat) + " | " + Messages.getString("BackgroundFrame.ZOOM") + ": " + zoom + "%";
        this.statusLabel.setText(stat);
    }

    @Override
    protected boolean areResourceFieldsEqual() {
        return !this.imageChanged;
    }

    @Override
    public void commitChanges() {
        ((Background)this.res).setName(this.name.getText());
    }

    @Override
    public void updateResource(boolean commit) {
        super.updateResource(commit);
        this.imageChanged = false;
        this.updateStatusBar();
        this.updateScrollBars();
    }

    public void handleToolBar(String cmd) {
        if (cmd.endsWith(".LOAD")) {
            BufferedImage img = Util.getValidImage();
            if (img != null) {
                ((Background)this.res).setBackgroundImage(img);
                this.imageChanged = true;
                this.cleanup();
            }
            return;
        }
        if (cmd.endsWith(".SAVE")) {
            BufferedImage img = ((Background)this.res).getBackgroundImage();
            Util.saveImage(img);
            return;
        }
        if (cmd.endsWith(".CREATE")) {
            this.createNewImage(true);
        } else {
            if (cmd.endsWith(".EDIT")) {
                try {
                    if (this.editor == null) {
                        new BackgroundEditor();
                    } else {
                        this.editor.start();
                    }
                }
                catch (IOException ex) {
                    LGM.showDefaultExceptionHandler(ex);
                }
                return;
            }
            if (cmd.endsWith(".EFFECT")) {
                ArrayList<BufferedImage> imgs = new ArrayList<BufferedImage>(1);
                imgs.add(((Background)this.res).getBackgroundImage());
                EffectsFrame ef = EffectsFrame.getInstance();
                ef.setEffectsListener(this, imgs);
                ef.setVisible(true);
            } else if (cmd.endsWith(".ZOOM")) {
                if (this.zoomButton.isSelected()) {
                    this.preview.setCursor(LGM.zoomCursor);
                    this.preview.addMouseListener(this.mouseAdapter);
                } else {
                    this.preview.removeMouseListener(this.mouseAdapter);
                    this.preview.setCursor(Cursor.getDefaultCursor());
                }
            } else {
                if (cmd.endsWith(".ZOOM_IN")) {
                    this.preview.zoomIn(this.previewScroll);
                    return;
                }
                if (cmd.endsWith(".ZOOM_OUT")) {
                    this.preview.zoomOut(this.previewScroll);
                    return;
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.handleToolBar(e.getActionCommand());
        super.actionPerformed(e);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension p = this.getContentPane().getSize();
        Dimension l = this.getContentPane().getMinimumSize();
        Dimension s = this.getSize();
        l.width += s.width - p.width;
        l.height += s.height - p.height;
        return l;
    }

    private BufferedImage createNewImage(boolean askforsize) {
        int width = 256;
        int height = 256;
        if (askforsize) {
            NumberFormatter nf = new NumberFormatter();
            nf.setMinimum(Integer.valueOf(1));
            JFormattedTextField wField = new JFormattedTextField(nf);
            wField.setValue(width);
            JFormattedTextField hField = new JFormattedTextField(nf);
            hField.setValue(height);
            JPanel myPanel = new JPanel();
            GridLayout layout = new GridLayout(0, 2, 0, 3);
            myPanel.setLayout(layout);
            myPanel.add(new JLabel(Messages.getString("BackgroundFrame.NEW_WIDTH")));
            myPanel.add(wField);
            myPanel.add(new JLabel(Messages.getString("BackgroundFrame.NEW_HEIGHT")));
            myPanel.add(hField);
            int result = JOptionPane.showConfirmDialog(LGM.frame, myPanel, Messages.getString("BackgroundFrame.NEW_TITLE"), 2, -1);
            if (result == 2) {
                return null;
            }
            width = (Integer)wField.getValue();
            height = (Integer)hField.getValue();
        }
        BufferedImage bi = new BufferedImage(width, height, 2);
        ((Background)this.res).setBackgroundImage(bi);
        this.imageChanged = true;
        return bi;
    }

    @Override
    public void dispose() {
        this.cleanup();
        super.dispose();
    }

    protected void cleanup() {
        if (this.editor != null) {
            this.editor.stop();
        }
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        this.updateStatusBar();
        this.updateScrollBars();
    }

    @Override
    public void applyEffects(List<BufferedImage> imgs) {
        ((Background)this.res).setBackgroundImage(imgs.get(0));
    }

    private class BackgroundEditor
    implements UpdateSource.UpdateListener {
        private FileChangeMonitor monitor;
        private File f;

        public BackgroundEditor() throws IOException {
            BackgroundFrame.this.editor = this;
            this.start();
        }

        public void start() throws IOException {
            BufferedImage bi;
            if (this.monitor != null) {
                this.monitor.stop();
            }
            if (this.f == null || !this.f.exists()) {
                this.f = File.createTempFile(((Background)BackgroundFrame.this.res).getName(), String.valueOf('.') + Prefs.externalBackgroundExtension, LGM.tempDir);
                this.f.deleteOnExit();
            }
            if ((bi = ((Background)BackgroundFrame.this.res).getBackgroundImage()) == null) {
                bi = BackgroundFrame.this.createNewImage(false);
            }
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileOutputStream out = new FileOutputStream(this.f);){
                ImageIO.write((RenderedImage)bi, Prefs.externalBackgroundExtension, out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.monitor = new FileChangeMonitor(this.f, (Executor)SwingExecutor.INSTANCE);
            this.monitor.updateSource.addListener(this);
            if (!Prefs.useExternalBackgroundEditor || Prefs.externalBackgroundEditorCommand == null) {
                Util.OpenDesktopEditor(this.monitor.file);
            } else {
                Runtime.getRuntime().exec(String.format(Prefs.externalBackgroundEditorCommand, this.monitor.file.getAbsolutePath()));
            }
        }

        public void stop() {
            this.monitor.stop();
            this.monitor.file.delete();
            BackgroundFrame.this.editor = null;
        }

        @Override
        public void updated(UpdateSource.UpdateEvent e) {
            if (!(e instanceof FileChangeMonitor.FileUpdateEvent)) {
                return;
            }
            switch (((FileChangeMonitor.FileUpdateEvent)e).flag) {
                case CHANGED: {
                    BufferedImage img;
                    try {
                        Throwable throwable = null;
                        Object var4_5 = null;
                        try (FileInputStream stream = new FileInputStream(this.monitor.file);){
                            img = ImageIO.read(stream);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException ioe) {
                        LGM.showDefaultExceptionHandler(ioe);
                        return;
                    }
                    ((Background)BackgroundFrame.this.res).setBackgroundImage(img);
                    BackgroundFrame.this.imageChanged = true;
                    break;
                }
                case DELETED: {
                    BackgroundFrame.this.editor = null;
                }
            }
        }
    }

    private class BackgroundPropertyListener
    extends PropertyMap.PropertyUpdateListener<Background.PBackground> {
        private BackgroundPropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<Background.PBackground> e) {
            BackgroundFrame.this.groupPanel.setVisible((Boolean)((Background)BackgroundFrame.this.res).get(Background.PBackground.USE_AS_TILESET));
        }
    }
}

