/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.lateralgm.components.CodeTextArea;
import org.lateralgm.components.ColorSelect;
import org.lateralgm.components.MarkerCache;
import org.lateralgm.components.ResourceMenu;
import org.lateralgm.components.impl.IndexButtonGroup;
import org.lateralgm.components.impl.TextAreaFocusTraversalPolicy;
import org.lateralgm.components.mdi.RevertableMDIFrame;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.library.LibAction;
import org.lateralgm.resources.library.LibArgument;
import org.lateralgm.resources.sub.Action;
import org.lateralgm.resources.sub.Argument;
import org.lateralgm.subframes.SubframeInformer;

public class ActionFrame
extends RevertableMDIFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private IndexButtonGroup applies;
    protected ResourceMenu<GmObject> appliesObject;
    private JPanel appliesPanel;
    private Action act;
    private ArgumentComponent[] argComp;
    private JCheckBox relativeBox;
    private JCheckBox notBox;
    private JButton save;
    private JButton discard;
    public JToolBar tool;
    public CodeTextArea code;
    public JPanel status;

    public ActionFrame(Action a) {
        this(a, a.getLibAction());
    }

    private ActionFrame(Action a, LibAction la) {
        super(la.description, false);
        ResourceReference<GmObject> at;
        this.setTitle(la.name.replace("_", " "));
        if (la.parent == null) {
            this.setTitle(Messages.getString("Action.UNKNOWN"));
        }
        if (la.actImage != null) {
            this.setFrameIcon(new ImageIcon(la.actImage.getScaledInstance(16, 16, 4)));
        }
        String s = (at = a.getAppliesTo()) == GmObject.OBJECT_SELF ? Messages.getString("ActionFrame.SELF") : Messages.getString("ActionFrame.OTHER");
        this.appliesObject = new ResourceMenu(GmObject.class, s, false, 100);
        this.appliesObject.setEnabled(GmObject.refAsInt(at) >= 0);
        this.appliesObject.setOpaque(false);
        this.appliesObject.setSelected(at);
        this.act = a;
        this.appliesPanel = new JPanel();
        this.appliesPanel.setOpaque(false);
        this.appliesPanel.setLayout(new GridBagLayout());
        this.applies = new IndexButtonGroup(3, true, false);
        JRadioButton button = new JRadioButton(Messages.getString("ActionFrame.SELF"));
        button.setOpaque(false);
        this.applies.add(button, -1);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.fill = 2;
        this.appliesPanel.add((Component)button, gbc);
        button = new JRadioButton(Messages.getString("ActionFrame.OTHER"));
        button.setOpaque(false);
        this.applies.add(button, -2);
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.fill = 2;
        this.appliesPanel.add((Component)button, gbc);
        button = new JRadioButton(Messages.getString("ActionFrame.OBJECT"));
        button.setHorizontalAlignment(2);
        button.setOpaque(false);
        button.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean sel = ((JRadioButton)e.getSource()).isSelected();
                ActionFrame.this.appliesObject.setEnabled(sel);
            }
        });
        this.applies.add(button, 0);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 2;
        this.appliesPanel.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 2, 0, 6);
        this.appliesPanel.add(this.appliesObject, gbc);
        this.applies.setValue(Math.min(GmObject.refAsInt(at), 0));
        if (la.interfaceKind == 5) {
            this.setClosable(true);
            this.setMaximizable(true);
            this.setResizable(true);
            this.setIconifiable(true);
            this.tool = new JToolBar();
            this.tool.setFloatable(false);
            this.tool.setAlignmentX(0.0f);
            this.save = new JButton(LGM.getIconForKey("ActionFrame.SAVE"));
            this.save.addActionListener(this);
            this.tool.add(this.save);
            this.tool.addSeparator();
            this.code = new CodeTextArea(a.getArguments().get(0).getVal(), MarkerCache.getMarker("gml"));
            this.code.addEditorButtons(this.tool);
            if (Prefs.enableDragAndDrop) {
                this.tool.addSeparator();
                this.tool.add(new JLabel(Messages.getString("ActionFrame.APPLIES")));
                this.tool.add(this.appliesPanel);
            }
            this.status = new JPanel(new FlowLayout());
            this.status.setLayout(new BoxLayout(this.status, 0));
            this.status.setMaximumSize(new Dimension(Integer.MAX_VALUE, 11));
            final JLabel caretPos = new JLabel(" INS | UTF-8 | " + (this.code.getCaretLine() + 1) + " : " + (this.code.getCaretColumn() + 1));
            this.status.add(caretPos);
            this.code.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    caretPos.setText(" INS | UTF-8 | " + (ActionFrame.this.code.getCaretLine() + 1) + ":" + (ActionFrame.this.code.getCaretColumn() + 1));
                }
            });
            this.add((Component)this.tool, "North");
            this.add((Component)this.code, "Center");
            this.add((Component)this.status, "South");
            this.setFocusTraversalPolicy(new TextAreaFocusTraversalPolicy(this.code.text));
            this.appliesPanel.setLayout(new BoxLayout(this.appliesPanel, 2));
            this.pack();
            if (!Prefs.enableDragAndDrop) {
                this.setSize(new Dimension(this.getWidth() + 300, this.getHeight() + 100));
            }
            this.repaint();
        } else {
            this.makeArgumentPane(a, la);
            this.pack();
            this.repaint();
        }
        SubframeInformer.fireSubframeAppear(this, false);
    }

    private void makeArgumentPane(Action a, LibAction la) {
        JLabel lab;
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pane = new JPanel();
        pane.setBorder(new EmptyBorder(6, 6, 0, 6));
        pane.setLayout(new BorderLayout());
        this.add(pane);
        if (la.actImage != null) {
            lab = new JLabel(new ImageIcon(la.actImage));
            lab.setBorder(new EmptyBorder(16, 16, 16, 20));
            pane.add((Component)lab, "Before");
        }
        String s = Messages.getString("ActionFrame.APPLIES");
        this.appliesPanel.setBorder(BorderFactory.createTitledBorder(s));
        pane.add(this.appliesPanel);
        if (!la.canApplyTo) {
            this.appliesPanel.setVisible(false);
        }
        List<Argument> args = a.getArguments();
        this.argComp = new ArgumentComponent[args.size()];
        if (args.size() > 0) {
            pane = new JPanel();
            pane.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(6, 8, 0, 8), BorderFactory.createTitledBorder("")));
            GroupLayout kvLayout = new GroupLayout(pane);
            GroupLayout.SequentialGroup hGroup = kvLayout.createSequentialGroup();
            GroupLayout.SequentialGroup vGroup = kvLayout.createSequentialGroup();
            GroupLayout.ParallelGroup keyGroup = kvLayout.createParallelGroup(GroupLayout.Alignment.TRAILING);
            GroupLayout.ParallelGroup valueGroup = kvLayout.createParallelGroup();
            hGroup.addGap(4);
            hGroup.addGroup(keyGroup);
            hGroup.addGap(6);
            hGroup.addGroup(valueGroup);
            hGroup.addGap(4);
            kvLayout.setHorizontalGroup(hGroup);
            kvLayout.setVerticalGroup(vGroup);
            pane.setLayout(kvLayout);
            this.add(pane);
            vGroup.addGap(4);
            int n = 0;
            while (n < args.size()) {
                GroupLayout.Alignment al;
                this.argComp[n] = new ArgumentComponent(args.get(n), a.getLibAction().libArguments[n]);
                if (la.parent == null) {
                    lab = new JLabel(Messages.format("ActionFrame.UNKNOWN", n));
                } else {
                    LibArgument larg = la.libArguments[n];
                    lab = new JLabel(larg.caption);
                }
                if (n == 0 && this.act.getLibAction().interfaceKind == 2) {
                    this.argComp[n].setEditor(new ArrowsEditor(this.argComp[n].getArgument().getVal()));
                    al = GroupLayout.Alignment.CENTER;
                } else {
                    Component c = this.argComp[n].getEditor();
                    c.setMaximumSize(new Dimension(240, 20));
                    c.setPreferredSize(new Dimension(200, 20));
                    c.setMinimumSize(new Dimension(160, 20));
                    al = GroupLayout.Alignment.BASELINE;
                }
                keyGroup.addComponent(lab);
                valueGroup.addComponent(this.argComp[n].getEditor());
                if (n > 0) {
                    vGroup.addGap(6);
                }
                GroupLayout.ParallelGroup argGroup = kvLayout.createParallelGroup(al);
                argGroup.addComponent(lab).addComponent(this.argComp[n].getEditor());
                vGroup.addGroup(argGroup);
                ++n;
            }
            vGroup.addGap(4);
        }
        pane = new JPanel();
        pane.setLayout(new FlowLayout(4));
        this.add(pane);
        if (la.allowRelative) {
            this.relativeBox = new JCheckBox(Messages.getString("ActionFrame.RELATIVE"));
            this.relativeBox.setSelected(this.act.isRelative());
            pane.add(this.relativeBox);
        }
        if (la.question) {
            this.notBox = new JCheckBox(Messages.getString("ActionFrame.NOT"));
            this.notBox.setSelected(this.act.isNot());
            pane.add(this.notBox);
        }
        pane = new JPanel();
        pane.setLayout(new GridLayout(1, 2, 8, 0));
        pane.setBorder(new EmptyBorder(0, 8, 8, 8));
        this.add(pane);
        s = Messages.getString("ActionFrame.SAVE");
        this.save = new JButton(s, LGM.getIconForKey("ActionFrame.SAVE"));
        this.save.addActionListener(this);
        this.getRootPane().setDefaultButton(this.save);
        pane.add(this.save);
        s = Messages.getString("ActionFrame.DISCARD");
        this.discard = new JButton(s, LGM.getIconForKey("ActionFrame.DISCARD"));
        this.discard.addActionListener(this);
        pane.add(this.discard);
    }

    public ResourceReference<GmObject> getApplies() {
        if (this.applies.getValue() >= 0) {
            ResourceReference<GmObject> sel = this.appliesObject.getSelected();
            if (sel != null) {
                return sel;
            }
            return this.act.getAppliesTo();
        }
        if (this.applies.getValue() == -1) {
            return GmObject.OBJECT_SELF;
        }
        if (this.applies.getValue() == -2) {
            return GmObject.OBJECT_OTHER;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.discard) {
            ArgumentComponent[] argumentComponentArray = this.argComp;
            int n = this.argComp.length;
            int n2 = 0;
            while (n2 < n) {
                ArgumentComponent a = argumentComponentArray[n2];
                a.discard();
                ++n2;
            }
            this.close();
        } else if (e.getSource() == this.save) {
            this.updateResource(true);
            this.close();
        }
    }

    public void commitChanges() {
        this.act.setAppliesTo(this.getApplies());
        if (this.relativeBox != null) {
            this.act.setRelative(this.relativeBox.isSelected());
        }
        if (this.notBox != null) {
            this.act.setNot(this.notBox.isSelected());
        }
        switch (this.act.getLibAction().interfaceKind) {
            case 5: {
                this.act.getArguments().get(0).setVal(this.code.getTextCompat());
                break;
            }
            default: {
                ArgumentComponent[] argumentComponentArray = this.argComp;
                int n = this.argComp.length;
                int n2 = 0;
                while (n2 < n) {
                    ArgumentComponent a = argumentComponentArray[n2];
                    a.commit();
                    ++n2;
                }
                break block0;
            }
        }
    }

    public Action getAction() {
        return this.act;
    }

    @Override
    public String getConfirmationName() {
        return this.getTitle();
    }

    @Override
    public boolean resourceChanged() {
        return this.act.getLibAction().interfaceKind == 5 && (this.code.isChanged() || !this.act.getAppliesTo().equals(this.getApplies()));
    }

    @Override
    public void revertResource() {
    }

    @Override
    public void updateResource(boolean commit) {
        this.commitChanges();
    }

    @Override
    public void setResourceChanged() {
    }

    public void focusArgumentComponent(int id) {
        ArgumentComponent comp = this.argComp[id];
        if (comp != null) {
            comp.editor.requestFocus();
        }
    }

    private class ArgumentComponent {
        private Argument arg;
        private Component editor;

        public ArgumentComponent(Argument arg, LibArgument libArg) {
            this.arg = arg;
            this.editor = this.makeEditor(libArg);
            this.discard();
        }

        public Argument getArgument() {
            return this.arg;
        }

        private JComponent makeEditor(LibArgument la) {
            switch (this.arg.kind) {
                case 3: {
                    String[] sab = new String[]{"false", "true"};
                    return new JComboBox<String>(sab);
                }
                case 4: {
                    if (la == null) {
                        return new JTextField(this.arg.getVal());
                    }
                    String[] sam = la.menu.split("\\|");
                    return new JComboBox<String>(sam);
                }
                case 13: {
                    return new ColorSelect(Util.convertGmColor(Integer.parseInt(this.arg.getVal())));
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: {
                    Class<? extends Resource<?, ?>> rk = Argument.getResourceKind(this.arg.kind);
                    String none = Messages.format("ArgumentComponent.NO_SELECTION", Resource.kindNames.get(rk));
                    return new ResourceMenu(rk, none, 120);
                }
            }
            return new JTextField(this.arg.getVal());
        }

        public Component getEditor() {
            return this.editor;
        }

        public void setEditor(Component editor) {
            this.editor = editor;
        }

        public void commit() {
            if (this.editor instanceof JTextField) {
                this.arg.setVal(((JTextField)this.editor).getText());
                return;
            }
            if (this.editor instanceof JComboBox) {
                this.arg.setVal(Integer.toString(((JComboBox)this.editor).getSelectedIndex()));
                return;
            }
            if (this.editor instanceof ColorSelect) {
                this.arg.setVal(Integer.toString(Util.getGmColor(((ColorSelect)this.editor).getSelectedColor())));
            }
            if (this.editor instanceof ArrowsEditor) {
                this.arg.setVal(((ArrowsEditor)this.editor).getStringValue());
            }
            if (this.editor instanceof ResourceMenu) {
                this.arg.setRes(((ResourceMenu)this.editor).getSelected());
                return;
            }
        }

        public void discard() {
            if (this.editor instanceof JTextField) {
                ((JTextField)this.editor).setText(this.arg.getVal());
            } else if (this.editor instanceof JComboBox) {
                ((JComboBox)this.editor).setSelectedIndex(Integer.parseInt(this.arg.getVal()));
            } else if (this.editor instanceof ColorSelect) {
                Color c = Util.convertGmColor(Integer.parseInt(this.arg.getVal()));
                ((ColorSelect)this.editor).setSelectedColor(c);
            } else if (this.editor instanceof ResourceMenu) {
                ((ResourceMenu)this.editor).setSelected(this.arg.getRes());
            }
        }
    }

    public class ArrowsEditor
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JToggleButton[] arrows;
        private final Dimension btnSize = new Dimension(32, 32);
        private final Dimension panelSize = new Dimension(96, 96);

        public ArrowsEditor(String val) {
            BufferedImage icons;
            this.setLayout(new GridLayout(3, 3));
            this.arrows = new JToggleButton[9];
            String location = "org/lateralgm/resources/library/default/arrows.png";
            URL url = LGM.class.getClassLoader().getResource(location);
            try {
                icons = ImageIO.read(url);
            }
            catch (IOException e) {
                icons = new BufferedImage(72, 72, 2);
            }
            int i = 0;
            while (i < 9) {
                this.arrows[i] = new JToggleButton();
                this.arrows[i].setIcon(new ImageIcon(icons.getSubimage(24 * (i % 3), 24 * (i / 3), 24, 24)));
                this.arrows[i].setMinimumSize(this.btnSize);
                this.arrows[i].setPreferredSize(this.btnSize);
                int p = (2 - i / 3) * 3 + i % 3;
                if (val.length() > p) {
                    this.arrows[i].setSelected(val.charAt(p) == '1');
                }
                this.add(this.arrows[i]);
                ++i;
            }
            this.setMaximumSize(this.panelSize);
            this.setPreferredSize(this.panelSize);
        }

        public String getStringValue() {
            char[] res = new char[9];
            int i = 0;
            while (i < 9) {
                res[i] = this.arrows[(2 - i / 3) * 3 + i % 3].isSelected() ? 49 : 48;
                ++i;
            }
            return new String(res);
        }
    }
}

