/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.resources.sub;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.EnumMap;
import java.util.Random;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.resources.Background;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Room;
import org.lateralgm.util.PropertyMap;

public class Tile
implements Room.Piece,
UpdateSource.UpdateListener,
PropertyMap.PropertyValidator<PTile> {
    private ResourceReference<?> background = null;
    public final PropertyMap<PTile> properties;
    private final ResourceReference<Room> room;
    private final TilePropertyListener tpl = new TilePropertyListener();
    private final UpdateSource.UpdateTrigger updateTrigger = new UpdateSource.UpdateTrigger();
    public final UpdateSource updateSource = new UpdateSource(this, this.updateTrigger);
    private static final EnumMap<PTile, Object> DEFS = PropertyMap.makeDefaultMap(PTile.class, 0, 0, 0, 0, 0, 0, 0, null, "tile", 0, false, 0xFFFFFFFFL, 255, 1.0, 1.0, 0.0, false);

    public Tile(Room r) {
        this.room = r.reference;
        this.properties = new PropertyMap<PTile>(PTile.class, this, DEFS);
        this.properties.put(PTile.NAME, (Object)("tile_" + String.format("%08X", new Random().nextInt())));
        this.properties.updateSource.addListener(this.tpl);
    }

    public Tile(Room r, int id) {
        this(r);
        this.properties.put(PTile.ID, (Object)id);
    }

    public Tile(Room r, ProjectFile f) {
        this(r, ++f.lastTileId);
    }

    protected void fireUpdate(UpdateSource.UpdateEvent e) {
        Room r;
        if (e == null) {
            e = this.updateTrigger.getEvent();
        }
        this.updateTrigger.fire(e);
        Room room = r = this.room == null ? null : this.room.get();
        if (r != null) {
            r.tileUpdated(e);
        }
    }

    public int getID() {
        return (Integer)this.properties.get(PTile.ID);
    }

    @Override
    public void setName(String name) {
        this.properties.put(PTile.NAME, (Object)name);
    }

    @Override
    public String getName() {
        return (String)this.properties.get(PTile.NAME);
    }

    public Point getBackgroundPosition() {
        int x = (Integer)this.properties.get(PTile.BG_X);
        int y = (Integer)this.properties.get(PTile.BG_Y);
        return new Point(x, y);
    }

    public void setBackgroundPosition(Point p) {
        this.properties.put(PTile.BG_X, (Object)p.x);
        this.properties.put(PTile.BG_Y, (Object)p.y);
        this.fireUpdate(null);
    }

    @Override
    public double getRotation() {
        return (Double)this.properties.get(PTile.ROTATION);
    }

    @Override
    public void setRotation(double degrees) {
        this.properties.put(PTile.ROTATION, (Object)degrees);
    }

    @Override
    public Point getPosition() {
        int x = (Integer)this.properties.get(PTile.ROOM_X);
        int y = (Integer)this.properties.get(PTile.ROOM_Y);
        return new Point(x, y);
    }

    @Override
    public void setPosition(Point p) {
        this.properties.put(PTile.ROOM_X, (Object)p.x);
        this.properties.put(PTile.ROOM_Y, (Object)p.y);
    }

    @Override
    public void setColor(Color color) {
        this.properties.put(PTile.COLOR, (Object)color);
    }

    @Override
    public int getAlpha() {
        return (Integer)this.properties.get(PTile.ALPHA);
    }

    @Override
    public void setAlpha(int alpha) {
        this.properties.put(PTile.ALPHA, (Object)alpha);
    }

    public Dimension getSize() {
        int w = (Integer)this.properties.get(PTile.WIDTH);
        int h = (Integer)this.properties.get(PTile.HEIGHT);
        return new Dimension(w, h);
    }

    @Override
    public void setSelected(boolean selected) {
        this.properties.put(PTile.SELECTED, (Object)selected);
    }

    @Override
    public boolean isSelected() {
        return (Boolean)this.properties.get(PTile.SELECTED);
    }

    public void setSize(Dimension s) {
        this.properties.put(PTile.WIDTH, (Object)s.width);
        this.properties.put(PTile.HEIGHT, (Object)s.height);
        this.fireUpdate(null);
    }

    @Override
    public void setScale(Point2D scale) {
        this.properties.put(PTile.SCALE_X, (Object)scale.getX());
        this.properties.put(PTile.SCALE_Y, (Object)scale.getY());
    }

    public void setColor(long color) {
        this.properties.put(PTile.COLOR, (Object)color);
    }

    @Override
    public Point2D getScale() {
        return new Point2D.Double((Double)this.properties.get(PTile.SCALE_X), (Double)this.properties.get(PTile.SCALE_Y));
    }

    public long getColor() {
        return (Long)this.properties.get(PTile.COLOR);
    }

    public int getDepth() {
        return (Integer)this.properties.get(PTile.DEPTH);
    }

    public void setDepth(int d) {
        this.properties.put(PTile.DEPTH, (Object)d);
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        this.fireUpdate(e);
    }

    @Override
    public boolean isLocked() {
        return (Boolean)this.properties.get(PTile.LOCKED);
    }

    @Override
    public void setLocked(boolean l) {
        this.properties.put(PTile.LOCKED, (Object)l);
    }

    @Override
    public Object validate(PTile k, Object v) {
        if (k == PTile.BACKGROUND) {
            ResourceReference r = (ResourceReference)v;
            if (r != null) {
                Object o = r.get();
                if (o == null) {
                    r = null;
                } else if (!(o instanceof Background)) {
                    throw new PropertyMap.PropertyValidationException();
                }
            }
            if (this.background != null) {
                this.background.updateSource.removeListener(this);
            }
            this.background = r;
            if (this.background != null) {
                this.background.updateSource.addListener(this);
            }
        }
        return v;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tile)) {
            return false;
        }
        Tile other = (Tile)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public static enum PTile {
        BG_X,
        BG_Y,
        ROOM_X,
        ROOM_Y,
        WIDTH,
        HEIGHT,
        DEPTH,
        BACKGROUND,
        NAME,
        ID,
        LOCKED,
        COLOR,
        ALPHA,
        SCALE_X,
        SCALE_Y,
        ROTATION,
        SELECTED;

    }

    private class TilePropertyListener
    extends PropertyMap.PropertyUpdateListener<PTile> {
        private TilePropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<PTile> e) {
            if (e.key == PTile.BACKGROUND) {
                Tile.this.fireUpdate(null);
            }
            if (e.key == PTile.SELECTED) {
                Tile.this.fireUpdate(null);
            }
        }
    }
}

