/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.resources.sub;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.EnumMap;
import java.util.Random;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Room;
import org.lateralgm.subframes.CodeFrame;
import org.lateralgm.util.PropertyMap;

public class Instance
implements Room.Piece,
UpdateSource.UpdateListener,
CodeFrame.CodeHolder,
PropertyMap.PropertyValidator<PInstance> {
    private ResourceReference<?> object = null;
    public final PropertyMap<PInstance> properties;
    private final ResourceReference<Room> room;
    private final InstancePropertyListener ipl = new InstancePropertyListener();
    private final UpdateSource.UpdateTrigger updateTrigger = new UpdateSource.UpdateTrigger();
    public final UpdateSource updateSource = new UpdateSource(this, this.updateTrigger);
    private static final EnumMap<PInstance, Object> DEFS = PropertyMap.makeDefaultMap(PInstance.class, 0, 0, null, "instance", 0, "", false, 1.0, 1.0, new Color(255, 255, 255), 0.0, false, 255);

    public Instance(Room r) {
        this.room = r.reference;
        this.properties = new PropertyMap<PInstance>(PInstance.class, this, DEFS);
        this.properties.put(PInstance.NAME, (Object)("inst_" + String.format("%08X", new Random().nextInt())));
        this.properties.updateSource.addListener(this.ipl);
    }

    protected void fireUpdate(UpdateSource.UpdateEvent e) {
        Room r;
        if (e == null) {
            e = this.updateTrigger.getEvent();
        }
        this.updateTrigger.fire(e);
        Room room = r = this.room == null ? null : this.room.get();
        if (r != null) {
            r.instanceUpdated(e);
        }
    }

    public int getID() {
        return (Integer)this.properties.get(PInstance.ID);
    }

    @Override
    public void setName(String name) {
        this.properties.put(PInstance.NAME, (Object)name);
    }

    @Override
    public String getName() {
        return (String)this.properties.get(PInstance.NAME);
    }

    @Override
    public Point getPosition() {
        return new Point((Integer)this.properties.get(PInstance.X), (Integer)this.properties.get(PInstance.Y));
    }

    @Override
    public int getAlpha() {
        return (Integer)this.properties.get(PInstance.ALPHA);
    }

    @Override
    public void setAlpha(int alpha) {
        this.properties.put(PInstance.ALPHA, (Object)alpha);
    }

    @Override
    public Point2D getScale() {
        return new Point2D.Double((Double)this.properties.get(PInstance.SCALE_X), (Double)this.properties.get(PInstance.SCALE_Y));
    }

    @Override
    public double getRotation() {
        return (Double)this.properties.get(PInstance.ROTATION);
    }

    public Color getColor() {
        return (Color)this.properties.get(PInstance.COLOR);
    }

    public Color getAWTColor() {
        return (Color)this.properties.get(PInstance.COLOR);
    }

    @Override
    public void setPosition(Point pos) {
        this.properties.put(PInstance.X, (Object)pos.x);
        this.properties.put(PInstance.Y, (Object)pos.y);
    }

    @Override
    public void setScale(Point2D scale) {
        this.properties.put(PInstance.SCALE_X, (Object)scale.getX());
        this.properties.put(PInstance.SCALE_Y, (Object)scale.getY());
    }

    @Override
    public void setRotation(double degrees) {
        this.properties.put(PInstance.ROTATION, (Object)degrees);
    }

    @Override
    public void setSelected(boolean selected) {
        this.properties.put(PInstance.SELECTED, (Object)selected);
    }

    @Override
    public boolean isSelected() {
        return (Boolean)this.properties.get(PInstance.SELECTED);
    }

    @Override
    public void setColor(Color color) {
        this.properties.put(PInstance.COLOR, (Object)color);
    }

    public String getCreationCode() {
        return (String)this.properties.get(PInstance.CREATION_CODE);
    }

    @Override
    public String getCode() {
        return this.getCreationCode();
    }

    public void setCreationCode(String creationCode) {
        this.properties.put(PInstance.CREATION_CODE, (Object)creationCode);
    }

    @Override
    public void setCode(String s) {
        this.setCreationCode(s);
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        this.fireUpdate(e);
    }

    @Override
    public boolean isLocked() {
        return (Boolean)this.properties.get(PInstance.LOCKED);
    }

    @Override
    public void setLocked(boolean l) {
        this.properties.put(PInstance.LOCKED, (Object)l);
    }

    @Override
    public Object validate(PInstance k, Object v) {
        if (k == PInstance.OBJECT) {
            ResourceReference r = (ResourceReference)v;
            if (r != null) {
                Object o = r.get();
                if (o == null) {
                    r = null;
                } else if (!(o instanceof GmObject)) {
                    throw new PropertyMap.PropertyValidationException();
                }
            }
            if (this.object != null) {
                this.object.updateSource.removeListener(this);
            }
            this.object = r;
            if (this.object != null) {
                this.object.updateSource.addListener(this);
            }
        }
        return v;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    private class InstancePropertyListener
    extends PropertyMap.PropertyUpdateListener<PInstance> {
        private InstancePropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<PInstance> e) {
            if (e.key == PInstance.OBJECT) {
                Instance.this.fireUpdate(null);
            }
            if (e.key == PInstance.NAME) {
                Instance.this.fireUpdate(null);
            }
            if (e.key == PInstance.SELECTED) {
                Instance.this.fireUpdate(null);
            }
            if (e.key == PInstance.SCALE_X) {
                Instance.this.fireUpdate(null);
            }
            if (e.key == PInstance.SCALE_Y) {
                Instance.this.fireUpdate(null);
            }
            if (e.key == PInstance.ROTATION) {
                Instance.this.fireUpdate(null);
            }
            if (e.key == PInstance.COLOR) {
                Instance.this.fireUpdate(null);
            }
            if (e.key == PInstance.ALPHA) {
                Instance.this.fireUpdate(null);
            }
        }
    }

    public static enum PInstance {
        X,
        Y,
        OBJECT,
        NAME,
        ID,
        CREATION_CODE,
        LOCKED,
        SCALE_X,
        SCALE_Y,
        COLOR,
        ROTATION,
        SELECTED,
        ALPHA;

    }
}

