/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.resources.sub;

import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.sub.Action;
import org.lateralgm.resources.sub.ActionContainer;

public class Event
extends ActionContainer
implements Comparable<Event>,
Util.InherentlyUnique<Event> {
    public static final byte EV_LEFT_BUTTON = 0;
    public static final byte EV_RIGHT_BUTTON = 1;
    public static final byte EV_MIDDLE_BUTTON = 2;
    public static final byte EV_NO_BUTTON = 3;
    public static final byte EV_LEFT_PRESS = 4;
    public static final byte EV_RIGHT_PRESS = 5;
    public static final byte EV_MIDDLE_PRESS = 6;
    public static final byte EV_LEFT_RELEASE = 7;
    public static final byte EV_RIGHT_RELEASE = 8;
    public static final byte EV_MIDDLE_RELEASE = 9;
    public static final byte EV_MOUSE_ENTER = 10;
    public static final byte EV_MOUSE_LEAVE = 11;
    public static final byte EV_MOUSE_WHEEL_UP = 60;
    public static final byte EV_MOUSE_WHEEL_DOWN = 61;
    public static final byte EV_GLOBAL_LEFT_BUTTON = 50;
    public static final byte EV_GLOBAL_RIGHT_BUTTON = 51;
    public static final byte EV_GLOBAL_MIDDLE_BUTTON = 52;
    public static final byte EV_GLOBAL_LEFT_PRESS = 53;
    public static final byte EV_GLOBAL_RIGHT_PRESS = 54;
    public static final byte EV_GLOBAL_MIDDLE_PRESS = 55;
    public static final byte EV_GLOBAL_LEFT_RELEASE = 56;
    public static final byte EV_GLOBAL_RIGHT_RELEASE = 57;
    public static final byte EV_GLOBAL_MIDDLE_RELEASE = 58;
    public static final byte EV_JOYSTICK1_LEFT = 16;
    public static final byte EV_JOYSTICK1_RIGHT = 17;
    public static final byte EV_JOYSTICK1_UP = 18;
    public static final byte EV_JOYSTICK1_DOWN = 19;
    public static final byte EV_JOYSTICK1_BUTTON1 = 21;
    public static final byte EV_JOYSTICK1_BUTTON2 = 22;
    public static final byte EV_JOYSTICK1_BUTTON3 = 23;
    public static final byte EV_JOYSTICK1_BUTTON4 = 24;
    public static final byte EV_JOYSTICK1_BUTTON5 = 25;
    public static final byte EV_JOYSTICK1_BUTTON6 = 26;
    public static final byte EV_JOYSTICK1_BUTTON7 = 27;
    public static final byte EV_JOYSTICK1_BUTTON8 = 28;
    public static final byte EV_JOYSTICK2_LEFT = 31;
    public static final byte EV_JOYSTICK2_RIGHT = 32;
    public static final byte EV_JOYSTICK2_UP = 33;
    public static final byte EV_JOYSTICK2_DOWN = 34;
    public static final byte EV_JOYSTICK2_BUTTON1 = 36;
    public static final byte EV_JOYSTICK2_BUTTON2 = 37;
    public static final byte EV_JOYSTICK2_BUTTON3 = 38;
    public static final byte EV_JOYSTICK2_BUTTON4 = 39;
    public static final byte EV_JOYSTICK2_BUTTON5 = 40;
    public static final byte EV_JOYSTICK2_BUTTON6 = 41;
    public static final byte EV_JOYSTICK2_BUTTON7 = 42;
    public static final byte EV_JOYSTICK2_BUTTON8 = 43;
    public static final byte EV_NO_KEY = 0;
    public static final byte EV_ANY_KEY = 1;
    public static final byte EV_ENTER_KEY = 13;
    public static final byte EV_DELETE_KEY = 46;
    public static final byte EV_INSERT_KEY = 45;
    public static final byte EV_OUTSIDE = 0;
    public static final byte EV_BOUNDARY = 1;
    public static final byte EV_GAME_START = 2;
    public static final byte EV_GAME_END = 3;
    public static final byte EV_ROOM_START = 4;
    public static final byte EV_ROOM_END = 5;
    public static final byte EV_NO_MORE_LIVES = 6;
    public static final byte EV_NO_MORE_HEALTH = 9;
    public static final byte EV_ANIMATION_END = 7;
    public static final byte EV_END_OF_PATH = 8;
    public static final byte EV_USER0 = 10;
    public static final byte EV_USER1 = 11;
    public static final byte EV_USER2 = 12;
    public static final byte EV_USER3 = 13;
    public static final byte EV_USER4 = 14;
    public static final byte EV_USER5 = 15;
    public static final byte EV_USER6 = 16;
    public static final byte EV_USER7 = 17;
    public static final byte EV_USER8 = 18;
    public static final byte EV_USER9 = 19;
    public static final byte EV_USER10 = 20;
    public static final byte EV_USER11 = 21;
    public static final byte EV_USER12 = 22;
    public static final byte EV_USER13 = 23;
    public static final byte EV_USER14 = 24;
    public static final byte EV_USER15 = 25;
    public static final byte EV_OUTSIDEVIEW0 = 40;
    public static final byte EV_OUTSIDEVIEW1 = 41;
    public static final byte EV_OUTSIDEVIEW2 = 42;
    public static final byte EV_OUTSIDEVIEW3 = 43;
    public static final byte EV_OUTSIDEVIEW4 = 44;
    public static final byte EV_OUTSIDEVIEW5 = 45;
    public static final byte EV_OUTSIDEVIEW6 = 46;
    public static final byte EV_OUTSIDEVIEW7 = 47;
    public static final byte EV_BOUNDARYVIEW0 = 50;
    public static final byte EV_BOUNDARYVIEW1 = 51;
    public static final byte EV_BOUNDARYVIEW2 = 52;
    public static final byte EV_BOUNDARYVIEW3 = 53;
    public static final byte EV_BOUNDARYVIEW4 = 54;
    public static final byte EV_BOUNDARYVIEW5 = 55;
    public static final byte EV_BOUNDARYVIEW6 = 56;
    public static final byte EV_BOUNDARYVIEW7 = 57;
    public static final byte EV_CLOSEWINDOW = 30;
    public static final byte EV_IMAGELOADED = 60;
    public static final byte EV_SOUNDLOADED = 61;
    public static final byte EV_HTTP = 62;
    public static final byte EV_DIALOG = 63;
    public static final byte EV_IAP = 66;
    public static final byte EV_CLOUD = 67;
    public static final byte EV_NETWORKING = 68;
    public static final byte EV_STEAM = 69;
    public static final byte EV_SOCIAL = 70;
    public static final byte EV_PUSHNOTIFICATION = 71;
    public static final byte EV_SAVELOAD = 72;
    public static final byte EV_AUDIORECORDING = 73;
    public static final byte EV_AUDIOPLAYBACK = 74;
    public static final byte EV_SYSTEM = 75;
    public static final byte EV_STEP_NORMAL = 0;
    public static final byte EV_STEP_BEGIN = 1;
    public static final byte EV_STEP_END = 2;
    public static final byte EV_ALARM0 = 0;
    public static final byte EV_ALARM1 = 1;
    public static final byte EV_ALARM2 = 2;
    public static final byte EV_ALARM3 = 3;
    public static final byte EV_ALARM4 = 4;
    public static final byte EV_ALARM5 = 5;
    public static final byte EV_ALARM6 = 6;
    public static final byte EV_ALARM7 = 7;
    public static final byte EV_ALARM8 = 8;
    public static final byte EV_ALARM9 = 9;
    public static final byte EV_ALARM10 = 10;
    public static final byte EV_ALARM11 = 11;
    public static final byte EV_DRAW_NORMAL = 0;
    public static final byte EV_DRAW_GUI = 64;
    public static final byte EV_DRAW_RESIZE = 65;
    public static final byte EV_DRAW_BEGIN = 72;
    public static final byte EV_DRAW_END = 73;
    public static final byte EV_DRAW_GUI_BEGIN = 74;
    public static final byte EV_DRAW_GUI_END = 75;
    public static final byte EV_DRAW_PRE = 76;
    public static final byte EV_DRAW_POST = 77;
    public int id = 0;
    public ResourceReference<GmObject> other = null;
    public int mainId = 0;
    public static final Map<Integer, Integer> KEYS;

    static {
        HashMap<Integer, Integer> keys = new HashMap<Integer, Integer>();
        keys.put(37, 37);
        keys.put(39, 39);
        keys.put(38, 38);
        keys.put(40, 40);
        keys.put(17, 17);
        keys.put(18, 18);
        keys.put(16, 16);
        keys.put(32, 32);
        keys.put(13, 13);
        int c = 96;
        while (c <= 105) {
            keys.put(c, c);
            ++c;
        }
        keys.put(111, 111);
        keys.put(106, 106);
        keys.put(109, 109);
        keys.put(107, 107);
        keys.put(110, 110);
        c = 48;
        while (c <= 57) {
            keys.put(c, c);
            ++c;
        }
        c = 65;
        while (c <= 90) {
            keys.put(c, c);
            ++c;
        }
        c = 112;
        while (c <= 123) {
            keys.put(c, c);
            ++c;
        }
        keys.put(8, 8);
        keys.put(27, 27);
        keys.put(36, 36);
        keys.put(35, 35);
        keys.put(33, 33);
        keys.put(34, 34);
        keys.put(46, 46);
        keys.put(45, 45);
        keys.put(0, 0);
        keys.put(1, 1);
        KEYS = Collections.unmodifiableMap(keys);
    }

    public Event() {
    }

    public Event(int mainId, int id) {
        this.mainId = mainId;
        this.id = id;
    }

    public Event(int mainId, ResourceReference<GmObject> other) {
        this.mainId = mainId;
        this.other = other;
    }

    public Event(int mainId, int id, ResourceReference<GmObject> other) {
        this.mainId = mainId;
        this.id = id;
        this.other = other;
    }

    public String toString() {
        switch (this.mainId) {
            case 4: {
                GmObject obj = Util.deRef(this.other);
                String name = obj == null ? "<undefined>" : obj.getName();
                return Messages.format("Event.EVENT4_X", name);
            }
        }
        return Event.eventName(this.mainId, this.id);
    }

    @Override
    public int compareTo(Event e) {
        if (e.mainId != this.mainId) {
            return e.mainId > this.mainId ? -1 : 1;
        }
        return e.id > this.id ? -1 : (e.id == this.id ? 0 : 1);
    }

    public boolean matchesType(Event e) {
        if (e.mainId != this.mainId) {
            return false;
        }
        if (this.mainId != 4) {
            return e.id == this.id;
        }
        return e.other == this.other;
    }

    public static String getGmKeyName(int keyCode) {
        switch (keyCode) {
            case 0: {
                return Messages.getString("Event.NO_KEY");
            }
            case 1: {
                return Messages.getString("Event.ANY_KEY");
            }
            case 13: {
                keyCode = 10;
                break;
            }
            case 46: {
                keyCode = 127;
                break;
            }
            case 45: {
                keyCode = 155;
                break;
            }
        }
        return KeyEvent.getKeyText(keyCode);
    }

    public static String eventName(int mainId, int eventId) {
        switch (mainId) {
            case 2: 
            case 11: {
                return Messages.format("Event.EVENT" + mainId + "_X", eventId);
            }
            case 6: {
                if (eventId <= 9 || eventId >= 50 && eventId <= 58) {
                    int b;
                    boolean g;
                    int i = eventId % 10;
                    boolean bl = g = eventId >= 50;
                    if (g || i < 3) {
                        b = i % 3;
                    } else if (i > 3) {
                        b = --i % 3;
                    } else {
                        b = -1;
                        i = 0;
                    }
                    return Messages.format("Event.EVENT6_BUTTON", b, i / 3, g ? 1 : 0);
                }
                if (eventId >= 16 && eventId <= 28 || eventId >= 31 && eventId <= 43) {
                    int j = eventId < 31 ? 1 : 2;
                    int i = eventId - (j == 1 ? 16 : 31);
                    return Messages.format("Event.EVENT6_JOYSTICK", j, i < 4 ? i : 4, i - 4);
                }
                return Messages.getString("Event.EVENT" + mainId + "_" + eventId);
            }
            case 5: 
            case 9: 
            case 10: {
                return Messages.format("Event.EVENT" + mainId + "_X", Event.getGmKeyName(eventId));
            }
            case 7: {
                if (eventId >= 10 && eventId <= 25) {
                    return Messages.format("Event.EVENT" + mainId + "_X", eventId - 10);
                }
                if (eventId >= 40 && eventId <= 47) {
                    return Messages.format("Event.EVENT" + mainId + "_40X", eventId - 40);
                }
                if (eventId >= 50 && eventId <= 57) {
                    return Messages.format("Event.EVENT" + mainId + "_50X", eventId - 50);
                }
                return Messages.getString("Event.EVENT" + mainId + "_" + eventId);
            }
        }
        return Messages.getString("Event.EVENT" + mainId + "_" + eventId);
    }

    public Event copy() {
        Event ev = new Event();
        ev.mainId = this.mainId;
        ev.id = this.id;
        ev.other = this.other;
        for (Action act : this.actions) {
            ev.actions.add(act.copy());
        }
        return ev;
    }

    @Override
    public boolean isEqual(Event evt) {
        if (this == evt) {
            return true;
        }
        if (evt == null || this.id != evt.id || this.mainId != evt.mainId) {
            return false;
        }
        if (!Util.areInherentlyUniquesEqual(this.actions, evt.actions)) {
            return false;
        }
        if (this.other == null) {
            return evt.other == null;
        }
        return this.other.equals(evt.other);
    }
}

