/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.resources.sub;

import java.util.EnumMap;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.resources.Font;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.util.PropertyMap;

public class CharacterRange
implements UpdateSource.UpdateListener,
PropertyMap.PropertyValidator<PCharacterRange> {
    private static final EnumMap<PCharacterRange, Object> DEFS = PropertyMap.makeDefaultMap(PCharacterRange.class, 32, 127);
    public final PropertyMap<PCharacterRange> properties;
    private final ResourceReference<Font> font;
    private final RangePropertyListener rpl = new RangePropertyListener();
    private final UpdateSource.UpdateTrigger updateTrigger = new UpdateSource.UpdateTrigger();
    public final UpdateSource updateSource = new UpdateSource(this, this.updateTrigger);

    public CharacterRange(Font fnt) {
        this.font = fnt.reference;
        this.properties = new PropertyMap<PCharacterRange>(PCharacterRange.class, this, DEFS);
        this.properties.updateSource.addListener(this.rpl);
    }

    public CharacterRange(Font fnt, int min, int max) {
        this(fnt);
        this.properties.put(PCharacterRange.RANGE_MIN, (Object)min);
        this.properties.put(PCharacterRange.RANGE_MAX, (Object)max);
    }

    public void fireUpdate(UpdateSource.UpdateEvent e) {
        Font f;
        if (e == null) {
            e = this.updateTrigger.getEvent();
        }
        this.updateTrigger.fire(e);
        Font font = f = this.font == null ? null : this.font.get();
        if (f != null) {
            f.rangeUpdated(e);
        }
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        this.fireUpdate(e);
    }

    @Override
    public Object validate(PCharacterRange k, Object v) {
        switch (k) {
            case RANGE_MIN: {
                int min = (Integer)v;
                if (min < 0) {
                    min = 0;
                }
                if (min > (Integer)this.properties.get(PCharacterRange.RANGE_MAX)) {
                    this.properties.put(PCharacterRange.RANGE_MAX, (Object)min);
                }
                if (min == (Integer)v) break;
                return min;
            }
            case RANGE_MAX: {
                int max = (Integer)v;
                if (max < 0) {
                    max = 0;
                }
                if (max < (Integer)this.properties.get(PCharacterRange.RANGE_MIN)) {
                    this.properties.put(PCharacterRange.RANGE_MIN, (Object)max);
                }
                if (max == (Integer)v) break;
                return max;
            }
        }
        return v;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CharacterRange)) {
            return false;
        }
        CharacterRange other = (CharacterRange)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public static enum PCharacterRange {
        RANGE_MIN,
        RANGE_MAX;

    }

    private class RangePropertyListener
    extends PropertyMap.PropertyUpdateListener<PCharacterRange> {
        private RangePropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<PCharacterRange> e) {
            CharacterRange.this.fireUpdate(null);
        }
    }
}

