/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.resources.sub;

import org.lateralgm.main.UpdateSource;
import org.lateralgm.resources.Background;
import org.lateralgm.resources.Font;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.Path;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.Script;
import org.lateralgm.resources.Sound;
import org.lateralgm.resources.Sprite;
import org.lateralgm.resources.Timeline;
import org.lateralgm.resources.library.LibArgument;

public class Argument {
    public static final byte ARG_EXPRESSION = 0;
    public static final byte ARG_STRING = 1;
    public static final byte ARG_BOTH = 2;
    public static final byte ARG_BOOLEAN = 3;
    public static final byte ARG_MENU = 4;
    public static final byte ARG_COLOR = 13;
    @Deprecated
    public static final byte ARG_FONTSTRING = 15;
    public static final byte ARG_SPRITE = 5;
    public static final byte ARG_SOUND = 6;
    public static final byte ARG_BACKGROUND = 7;
    public static final byte ARG_PATH = 8;
    public static final byte ARG_SCRIPT = 9;
    public static final byte ARG_GMOBJECT = 10;
    public static final byte ARG_ROOM = 11;
    public static final byte ARG_FONT = 12;
    public static final byte ARG_TIMELINE = 14;
    public byte kind;
    private String val;
    private ResourceReference<? extends Resource<?, ?>> res;
    private final UpdateSource.UpdateTrigger updateTrigger = new UpdateSource.UpdateTrigger();
    public final UpdateSource updateSource = new UpdateSource(this, this.updateTrigger);

    public Argument(byte kind, String val, ResourceReference<? extends Resource<?, ?>> res) {
        this.kind = kind;
        this.val = val;
        this.res = res;
    }

    public Argument(byte kind) {
        this(kind, new String(), null);
    }

    public static Class<? extends Resource<?, ?>> getResourceKind(byte argumentKind) {
        switch (argumentKind) {
            case 5: {
                return Sprite.class;
            }
            case 6: {
                return Sound.class;
            }
            case 7: {
                return Background.class;
            }
            case 8: {
                return Path.class;
            }
            case 9: {
                return Script.class;
            }
            case 10: {
                return GmObject.class;
            }
            case 11: {
                return Room.class;
            }
            case 12: {
                return Font.class;
            }
            case 14: {
                return Timeline.class;
            }
        }
        return null;
    }

    public String toString(LibArgument la) {
        Class<? extends Resource<?, ?>> rk = Argument.getResourceKind(this.kind);
        switch (this.kind) {
            case 3: {
                return Boolean.toString(!this.val.equals("0"));
            }
            case 4: {
                String[] sam = la.menu.split("\\|");
                try {
                    return sam[Integer.parseInt(this.val)];
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                return this.val;
            }
            case 13: {
                try {
                    return String.format("%06X", Integer.parseInt(this.val));
                }
                catch (NumberFormatException numberFormatException) {
                    return this.val;
                }
            }
        }
        if (rk == null) {
            return this.val;
        }
        Resource<?, ?> resource = this.res == null ? null : this.res.get();
        return resource == null ? "<none>" : resource.getName();
    }

    protected void fireStateChanged() {
        this.updateTrigger.fire();
    }

    public String getVal() {
        return this.val;
    }

    public void setVal(String val) {
        this.val = val;
        this.fireStateChanged();
    }

    public ResourceReference<? extends Resource<?, ?>> getRes() {
        return this.res;
    }

    public void setRes(ResourceReference<? extends Resource<?, ?>> res) {
        this.res = res;
        this.fireStateChanged();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.kind;
        result = 31 * result + (this.res == null ? 0 : this.res.hashCode());
        result = 31 * result + (this.val == null ? 0 : this.val.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Argument)) {
            return false;
        }
        Argument other = (Argument)obj;
        if (this.kind != other.kind) {
            return false;
        }
        if (this.res == null ? other.res != null : !this.res.equals(other.res)) {
            return false;
        }
        return !(this.val == null ? other.val != null : !this.val.equals(other.val));
    }
}

