/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.resources.sub;

import java.util.AbstractList;
import java.util.List;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.library.LibAction;
import org.lateralgm.resources.library.LibArgument;
import org.lateralgm.resources.sub.Argument;

public class Action
implements UpdateSource.UpdateListener,
Util.InherentlyUnique<Action> {
    public static final byte ACT_NORMAL = 0;
    public static final byte ACT_BEGIN = 1;
    public static final byte ACT_END = 2;
    public static final byte ACT_ELSE = 3;
    public static final byte ACT_EXIT = 4;
    public static final byte ACT_REPEAT = 5;
    public static final byte ACT_VARIABLE = 6;
    public static final byte ACT_CODE = 7;
    public static final byte ACT_PLACEHOLDER = 8;
    public static final byte ACT_SEPARATOR = 9;
    public static final byte ACT_LABEL = 10;
    public static final byte EXEC_NONE = 0;
    public static final byte EXEC_FUNCTION = 1;
    public static final byte EXEC_CODE = 2;
    private LibAction libAction;
    private boolean relative = false;
    private boolean not = false;
    private ResourceReference<GmObject> appliesTo = GmObject.OBJECT_SELF;
    private ArgumentList arguments;
    private final UpdateSource.UpdateTrigger updateTrigger = new UpdateSource.UpdateTrigger();
    public final UpdateSource updateSource = new UpdateSource(this, this.updateTrigger);

    public Action(LibAction la, Argument[] args) {
        this.libAction = la;
        if (la == null) {
            return;
        }
        if (args == null) {
            args = new Argument[la.libArguments.length];
            int i = 0;
            while (i < args.length) {
                LibArgument arg = la.libArguments[i];
                args[i] = new Argument(arg.kind, arg.defaultVal, null);
                ++i;
            }
        }
        this.arguments = new ArgumentList(args);
    }

    public Action(LibAction la) {
        this(la, null);
    }

    public Action copy() {
        Argument[] args = this.arguments.toArray(new Argument[this.arguments.size()]);
        int l = 0;
        while (l < args.length) {
            if (args[l] != null) {
                args[l] = new Argument(args[l].kind, args[l].getVal(), args[l].getRes());
            }
            ++l;
        }
        Action act = new Action(this.libAction, args);
        act.relative = this.relative;
        act.not = this.not;
        act.appliesTo = this.appliesTo;
        return act;
    }

    protected void fireUpdate() {
        this.updateTrigger.fire();
    }

    public LibAction getLibAction() {
        return this.libAction;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public void setRelative(boolean relative) {
        this.relative = relative;
        this.fireUpdate();
    }

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean not) {
        this.not = not;
        this.fireUpdate();
    }

    public ResourceReference<GmObject> getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(ResourceReference<GmObject> appliesTo) {
        this.appliesTo = appliesTo;
        this.fireUpdate();
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public void setArguments(Argument[] arguments) {
        this.arguments = new ArgumentList(arguments);
        this.fireUpdate();
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        this.fireUpdate();
    }

    @Override
    public boolean isEqual(Action other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.appliesTo == null ? other.appliesTo != null : !this.appliesTo.equals(other.appliesTo)) {
            return false;
        }
        if (this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments)) {
            return false;
        }
        if (this.libAction == null ? other.libAction != null : !this.libAction.equals(other.libAction)) {
            return false;
        }
        return this.not == other.not && this.relative == other.relative;
    }

    public class ArgumentList
    extends AbstractList<Argument> {
        private final Argument[] args;

        public ArgumentList(Argument[] args) {
            this.args = args;
            Argument[] argumentArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Argument a = argumentArray[n2];
                if (a != null) {
                    a.updateSource.addListener(Action.this);
                }
                ++n2;
            }
        }

        @Override
        public Argument get(int index) {
            return this.args[index];
        }

        @Override
        public Argument set(int index, Argument element) {
            Argument oa = this.args[index];
            oa.updateSource.addListener(Action.this);
            this.args[index] = element;
            element.updateSource.addListener(Action.this);
            Action.this.fireUpdate();
            return oa;
        }

        @Override
        public int size() {
            return this.args.length;
        }
    }
}

