/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.resources.library;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import org.lateralgm.file.GmStreamDecoder;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.library.LibAction;
import org.lateralgm.resources.library.LibArgument;
import org.lateralgm.resources.library.LibFormatException;
import org.lateralgm.resources.library.Library;

public final class LibManager {
    public static ArrayList<Library> libs = new ArrayList();
    public static LibAction codeAction;
    public static final String[] EXTS;

    static {
        EXTS = new String[]{".lib", ".lgl"};
    }

    private LibManager() {
    }

    public static LibAction getLibAction(int libraryId, int libActionId) {
        for (Library l : libs) {
            LibAction act;
            if (l.id != libraryId || (act = l.getLibAction(libActionId)) == null) continue;
            return act;
        }
        return null;
    }

    public static void autoLoad() {
        File dir = new File(Prefs.actionLibraryPath);
        if (!dir.exists()) {
            if (LGM.workDir == null) {
                return;
            }
            dir = new File(LGM.workDir, Prefs.actionLibraryPath);
            if (!dir.exists()) {
                dir = LGM.workDir;
            }
        }
        codeAction = null;
        LibManager.autoLoad(dir);
        File userLibF = new File(Prefs.userLibraryPath);
        if (userLibF.exists()) {
            LibManager.autoLoad(userLibF);
        }
        if (codeAction == null) {
            codeAction = LibManager.makeCodeAction();
        }
    }

    public static void autoLoad(File loc) {
        TreeMap<String, InputStream> map = LibManager.getLibs(loc);
        if (map != null) {
            LibManager.loadLibMap(map, loc);
        }
    }

    public static TreeMap<String, InputStream> getLibs(File loc) {
        if (loc.exists()) {
            try {
                if (loc.isDirectory()) {
                    return LibManager.getDirLibs(loc);
                }
                if (!LibManager.passFilter(loc.getName())) {
                    return LibManager.getZipLibs(new ZipFile(loc));
                }
                TreeMap<String, InputStream> map = new TreeMap<String, InputStream>();
                map.put(loc.getName(), new FileInputStream(loc));
                return map;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static TreeMap<String, InputStream> getZipLibs(ZipFile zip) throws IOException {
        TreeMap<String, InputStream> map = new TreeMap<String, InputStream>();
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry ent = entries.nextElement();
            String en = ent.getName();
            if (!LibManager.passFilter(en)) continue;
            map.put(en.substring(en.lastIndexOf(47) + 1), zip.getInputStream(ent));
        }
        return map;
    }

    public static TreeMap<String, InputStream> getDirLibs(File dir) throws IOException {
        File[] fl;
        TreeMap<String, InputStream> map = new TreeMap<String, InputStream>();
        File[] fileArray = fl = dir.listFiles();
        int n = fl.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String en = f.getName();
            if (LibManager.passFilter(en)) {
                map.put(en, new FileInputStream(f));
            }
            ++n2;
        }
        return map;
    }

    private static boolean passFilter(String fn) {
        String[] stringArray = EXTS;
        int n = EXTS.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (fn.endsWith(ext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void loadLibMap(Map<String, InputStream> libs, File path) {
        ArrayList<String> exceptions = new ArrayList<String>();
        if (libs.size() > 0) {
            System.out.println(Messages.format("LibManager.LOADINGN", path.getPath()));
        }
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, InputStream> ent : libs.entrySet()) {
            String fn = ent.getKey();
            try {
                LibManager.loadFile(new GmStreamDecoder(ent.getValue()), fn);
                if (buffer.length() + fn.length() > 60) {
                    System.out.println(buffer);
                    buffer.delete(0, buffer.length() - 1);
                }
                buffer.append(fn).append(' ');
            }
            catch (LibFormatException ex) {
                exceptions.add(String.valueOf(fn) + ": " + ex.getMessage());
            }
        }
        System.out.println(buffer);
        for (String s : exceptions) {
            System.out.println(s);
        }
    }

    public static Library loadFile(String filename) throws LibFormatException {
        try {
            return LibManager.loadFile(new GmStreamDecoder(filename), filename);
        }
        catch (FileNotFoundException e) {
            throw new LibFormatException(Messages.format("LibManager.ERROR_NOTFOUND", filename));
        }
    }

    public static Library loadFile(GmStreamDecoder in, String filename) throws LibFormatException {
        Library lib = null;
        try {
            try {
                int header = in.read3();
                if (header == 0x4C474C) {
                    lib = LibManager.loadLgl(in);
                } else if (header == 500 || header == 520) {
                    lib = LibManager.loadLib(in);
                } else {
                    throw new LibFormatException(Messages.format("LibManager.ERROR_INVALIDFILE", filename));
                }
                libs.add(lib);
            }
            catch (IOException ex) {
                throw new LibFormatException(Messages.format("LibManager.ERROR_READING", filename, ex.getMessage()));
            }
            catch (LibFormatException ex) {
                throw new LibFormatException(String.format(ex.getMessage(), filename));
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                String msg = Messages.getString("LibManager.ERROR_CLOSEFAILED");
                throw new LibFormatException(msg);
            }
        }
        return lib;
    }

    public static Library loadLib(GmStreamDecoder in) throws LibFormatException, IOException {
        if (in.read() != 0) {
            throw new LibFormatException(Messages.format("LibManager.ERROR_INVALIDFILE", "%s"));
        }
        Library lib = new Library();
        lib.tabCaption = in.readStr();
        lib.id = in.read4();
        in.skip(in.read4());
        in.skip(4L);
        in.skip(8L);
        in.skip(in.read4());
        in.skip(in.read4());
        lib.advanced = in.readBool();
        in.skip(4L);
        int acts = in.read4();
        int j = 0;
        while (j < acts) {
            int ver = in.read4();
            if (ver != 500 && ver != 520) {
                throw new LibFormatException(Messages.format("LibManager.ERROR_INVALIDACTION", j, "%s", ver));
            }
            LibAction act = lib.addLibAction();
            act.parent = lib;
            act.name = in.readStr();
            act.id = in.read4();
            byte[] data = new byte[in.read4()];
            in.read(data);
            act.actImage = Util.getTransparentImage(ImageIO.read(new ByteArrayInputStream(data))).getSubimage(0, 0, 24, 24);
            act.hidden = in.readBool();
            act.advanced = in.readBool();
            if (ver == 520) {
                act.registeredOnly = in.readBool();
            }
            act.description = in.readStr();
            act.listText = in.readStr();
            act.hintText = in.readStr();
            act.actionKind = (byte)in.read4();
            act.interfaceKind = (byte)in.read4();
            act.question = in.readBool();
            act.canApplyTo = in.readBool();
            act.allowRelative = in.readBool();
            act.libArguments = new LibArgument[in.read4()];
            int args = in.read4();
            int k = 0;
            while (k < args) {
                if (k < act.libArguments.length) {
                    LibArgument arg = new LibArgument();
                    arg.caption = in.readStr();
                    arg.kind = (byte)in.read4();
                    arg.defaultVal = in.readStr();
                    arg.menu = in.readStr();
                    act.libArguments[k] = arg;
                } else {
                    in.skip(in.read4());
                    in.skip(4L);
                    in.skip(in.read4());
                    in.skip(in.read4());
                }
                ++k;
            }
            act.execType = (byte)in.read4();
            if (act.execType == 1) {
                act.execInfo = in.readStr();
            } else {
                in.skip(in.read4());
            }
            if (act.execType == 2) {
                act.execInfo = in.readStr();
            } else {
                in.skip(in.read4());
            }
            ++j;
        }
        return lib;
    }

    public static Library loadLgl(GmStreamDecoder in) throws LibFormatException, IOException {
        if (in.read2() != 160) {
            String invalidFile = Messages.getString("LibManager.ERROR_INVALIDFILE");
            throw new LibFormatException(invalidFile);
        }
        Library lib = new Library();
        lib.id = in.read3();
        lib.tabCaption = in.readStr1();
        in.skip(in.read());
        in.skip(4L);
        in.skip(8L);
        in.skip(in.read4());
        in.skip(in.read4());
        int acts = in.read();
        lib.advanced = GmStreamDecoder.mask(acts, 128);
        acts &= 0x7F;
        int j = 0;
        while (j < acts) {
            if (in.read2() != 160) {
                throw new LibFormatException(Messages.format("LibManager.ERROR_INVALIDACTION", j, "%s", 160));
            }
            LibAction act = lib.addLibAction();
            act.parent = lib;
            act.id = in.read2();
            act.name = in.readStr1();
            act.description = in.readStr1();
            act.listText = in.readStr1();
            act.hintText = in.readStr1();
            int tags = in.read();
            act.hidden = GmStreamDecoder.mask(tags, 128);
            act.advanced = GmStreamDecoder.mask(tags, 64);
            act.registeredOnly = GmStreamDecoder.mask(tags, 32);
            act.question = GmStreamDecoder.mask(tags, 16);
            act.canApplyTo = GmStreamDecoder.mask(tags, 8);
            act.allowRelative = GmStreamDecoder.mask(tags, 4);
            act.execType = (byte)(tags & 3);
            act.execInfo = in.readStr();
            tags = in.read();
            act.actionKind = (byte)(tags >> 4);
            act.interfaceKind = (byte)(tags & 0xF);
            act.libArguments = new LibArgument[in.read()];
            int k = 0;
            while (k < act.libArguments.length) {
                LibArgument arg = new LibArgument();
                arg.caption = in.readStr1();
                arg.kind = (byte)in.read();
                arg.defaultVal = in.readStr1();
                arg.menu = in.readStr1();
                act.libArguments[k] = arg;
                ++k;
            }
            if (act.actionKind == 7 && act.execType == 2 && act.interfaceKind == 5) {
                codeAction = act;
            }
            ++j;
        }
        BufferedImage icons = ImageIO.read(in.getInputStream());
        int i = 0;
        int cc = icons.getWidth() / 24;
        for (LibAction a : lib.libActions) {
            if (a.actionKind >= 8) continue;
            a.actImage = icons.getSubimage(24 * (i % cc), 24 * (i / cc), 24, 24);
            ++i;
        }
        return lib;
    }

    private static LibAction makeCodeAction() {
        LibAction act = new LibAction();
        act.name = "Code";
        act.description = "Execute a piece of code";
        act.listText = "Execute a piece of code";
        act.hintText = "Execute code:##@0";
        act.canApplyTo = true;
        act.execType = (byte)2;
        act.actionKind = (byte)7;
        act.interfaceKind = (byte)5;
        act.libArguments = new LibArgument[1];
        act.libArguments[0] = new LibArgument();
        act.libArguments[0].kind = 1;
        return act;
    }
}

