/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.resources;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import javax.imageio.ImageIO;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.util.PropertyMap;

public class Sprite
extends InstantiableResource<Sprite, PSprite>
implements Resource.Viewable {
    public final ImageList subImages = new ImageList();
    private static final EnumMap<PSprite, Object> DEFS = PropertyMap.makeDefaultMap(PSprite.class, new Object[]{false, MaskShape.RECTANGLE, 0, false, false, true, 0, 0, BBMode.AUTO, 0, 31, 0, 31, false, false, false});
    private SoftReference<BufferedImage> imageCache = null;
    private final SpritePropertyListener spl = new SpritePropertyListener();

    public Sprite() {
        this((ResourceReference<Sprite>)null);
    }

    public Sprite(ResourceReference<Sprite> r) {
        super(r);
        this.properties.updateSource.addListener(this.spl);
    }

    @Override
    public Sprite makeInstance(ResourceReference<Sprite> r) {
        return new Sprite(r);
    }

    public BufferedImage addSubImage() {
        int w = this.subImages.getWidth();
        int h = this.subImages.getHeight();
        if (w == 0 || h == 0) {
            w = 32;
            h = 32;
        }
        BufferedImage sub = new BufferedImage(w, h, 5);
        Graphics g = sub.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        return sub;
    }

    public BufferedImage addSubImage(byte[] imagedata) {
        BufferedImage result = null;
        try {
            ByteArrayInputStream imagestr = new ByteArrayInputStream(imagedata);
            result = ImageIO.read(imagestr);
            this.subImages.add(result);
        }
        catch (IOException ex) {
            System.err.println(Messages.format("Sprite.ERROR_SUBIMAGE", this.subImages.size(), this.getId()));
        }
        return result;
    }

    private void updateBoundingBox() {
        BBMode mode = (BBMode)((Object)this.get(PSprite.BB_MODE));
        if (mode == null) {
            return;
        }
        switch (mode) {
            case AUTO: {
                Rectangle r = Sprite.getOverallBounds(this.subImages, (Boolean)this.get(PSprite.TRANSPARENT), (Integer)this.get(PSprite.ALPHA_TOLERANCE));
                this.put(PSprite.BB_LEFT, r.x);
                this.put(PSprite.BB_RIGHT, r.x + r.width);
                this.put(PSprite.BB_TOP, r.y);
                this.put(PSprite.BB_BOTTOM, r.y + r.height);
                break;
            }
            case FULL: {
                this.put(PSprite.BB_LEFT, 0);
                this.put(PSprite.BB_RIGHT, this.subImages.getWidth() - 1);
                this.put(PSprite.BB_TOP, 0);
                this.put(PSprite.BB_BOTTOM, this.subImages.getHeight() - 1);
                break;
            }
        }
    }

    public int getWidth() {
        return this.subImages.getWidth();
    }

    public int getHeight() {
        return this.subImages.getHeight();
    }

    public static Rectangle getOverallBounds(ImageList l, boolean transPixel, int tolerance) {
        Rectangle r = new Rectangle();
        for (BufferedImage bi : l) {
            Sprite.getCropBounds(bi, r, transPixel, tolerance);
        }
        if (r.width > 0 && r.height > 0) {
            --r.width;
            --r.height;
        }
        return r;
    }

    public static void getCropBounds(BufferedImage img, Rectangle u, boolean transPixel, int tolerance) {
        if (transPixel) {
            Sprite.getCropBoundsPixel(img, u);
        } else {
            Sprite.getCropBoundsAlpha(img, u, tolerance);
        }
    }

    public static void getCropBoundsAlpha(BufferedImage img, Rectangle u, int tolerance) {
        int width = img.getWidth();
        int height = img.getHeight();
        boolean unz = u.width > 0 && u.height > 0;
        int uy2 = unz ? u.y + u.height - 1 : -1;
        int y2 = height - 1;
        block0: while (y2 > uy2) {
            int i = 0;
            while (i < width) {
                if ((img.getRGB(i, y2) >> 24 & 0xFF) > tolerance) break block0;
                ++i;
            }
            --y2;
        }
        int ux2 = unz ? u.x + u.width - 1 : -1;
        int x2 = width - 1;
        block2: while (x2 > ux2) {
            int j = 0;
            while (j <= y2) {
                if ((img.getRGB(x2, j) >> 24 & 0xFF) > tolerance) break block2;
                ++j;
            }
            --x2;
        }
        int uy1 = unz ? u.y : y2;
        int y1 = 0;
        block4: while (y1 < uy1) {
            int i = 0;
            while (i <= x2) {
                if ((img.getRGB(i, y1) >> 24 & 0xFF) > tolerance) break block4;
                ++i;
            }
            ++y1;
        }
        int ux1 = unz ? u.x : x2;
        int x1 = 0;
        block6: while (x1 < ux1) {
            int j = y1;
            while (j <= y2) {
                if ((img.getRGB(x1, j) >> 24 & 0xFF) > tolerance) break block6;
                ++j;
            }
            ++x1;
        }
        u.x = x1;
        u.y = y1;
        u.width = 1 + x2 - x1;
        u.height = 1 + y2 - y1;
    }

    public static void getCropBoundsPixel(BufferedImage img, Rectangle u) {
        int transparent = img.getRGB(0, img.getHeight() - 1);
        int width = img.getWidth();
        int height = img.getHeight();
        boolean unz = u.width > 0 && u.height > 0;
        int uy2 = unz ? u.y + u.height - 1 : -1;
        int y2 = height - 1;
        block0: while (y2 > uy2) {
            int i = 0;
            while (i < width) {
                if (img.getRGB(i, y2) != transparent) break block0;
                ++i;
            }
            --y2;
        }
        int ux2 = unz ? u.x + u.width - 1 : -1;
        int x2 = width - 1;
        block2: while (x2 > ux2) {
            int j = 0;
            while (j <= y2) {
                if (img.getRGB(x2, j) != transparent) break block2;
                ++j;
            }
            --x2;
        }
        int uy1 = unz ? u.y : y2;
        int y1 = 0;
        block4: while (y1 < uy1) {
            int i = 0;
            while (i <= x2) {
                if (img.getRGB(i, y1) != transparent) break block4;
                ++i;
            }
            ++y1;
        }
        int ux1 = unz ? u.x : x2;
        int x1 = 0;
        block6: while (x1 < ux1) {
            int j = y1;
            while (j <= y2) {
                if (img.getRGB(x1, j) != transparent) break block6;
                ++j;
            }
            ++x1;
        }
        u.x = x1;
        u.y = y1;
        u.width = 1 + x2 - x1;
        u.height = 1 + y2 - y1;
    }

    @Override
    public BufferedImage getDisplayImage() {
        BufferedImage bi;
        if (this.imageCache != null && (bi = this.imageCache.get()) != null) {
            return bi;
        }
        if (this.subImages.size() < 1) {
            return null;
        }
        bi = (BufferedImage)this.subImages.get(0);
        if (((Boolean)this.get(PSprite.TRANSPARENT)).booleanValue()) {
            bi = Util.getTransparentImage(bi);
        }
        this.imageCache = new SoftReference<BufferedImage>(bi);
        return bi;
    }

    @Override
    protected void postCopy(Sprite dest) {
        super.postCopy(dest);
        int j = 0;
        while (j < this.subImages.size()) {
            dest.subImages.add(Util.cloneImage((BufferedImage)this.subImages.get(j)));
            ++j;
        }
    }

    @Override
    protected void fireUpdate() {
        if (this.imageCache != null) {
            this.imageCache.clear();
        }
        this.updateBoundingBox();
        super.fireUpdate();
    }

    @Override
    protected PropertyMap<PSprite> makePropertyMap() {
        boolean defTransparency = (Boolean)DEFS.get((Object)PSprite.TRANSPARENT);
        defTransparency = LGM.currentFile.format != null && LGM.currentFile.format.getOwner() == "GM" ? LGM.currentFile.format.getVersion() <= 600 : false;
        DEFS.put(PSprite.TRANSPARENT, (Object)defTransparency);
        return new PropertyMap<PSprite>(PSprite.class, this, DEFS);
    }

    public static enum BBMode {
        AUTO,
        FULL,
        MANUAL;

    }

    public static enum Effects {
        INVERT,
        FLIP,
        ROTATE;

    }

    public final class ImageList
    extends ArrayList<BufferedImage> {
        private static final long serialVersionUID = 1L;

        private ImageList() {
        }

        public long getSize() {
            long count = 0L;
            int i = 0;
            while (i < this.size()) {
                count += this.getSize(i);
                ++i;
            }
            return count;
        }

        public long getSize(int index) {
            return ((BufferedImage)this.get(index)).getWidth() * ((BufferedImage)this.get(index)).getHeight() * 4;
        }

        public int getWidth() {
            if (this.size() > 0) {
                return ((BufferedImage)this.get(0)).getWidth();
            }
            return 0;
        }

        public int getHeight() {
            if (this.size() > 0) {
                return ((BufferedImage)this.get(0)).getHeight();
            }
            return 0;
        }

        @Override
        public boolean add(BufferedImage e) {
            super.add(e);
            Sprite.this.fireUpdate();
            return true;
        }

        @Override
        public void add(int index, BufferedImage element) {
            super.add(index, element);
            Sprite.this.fireUpdate();
        }

        @Override
        public boolean addAll(Collection<? extends BufferedImage> c) {
            boolean u = super.addAll(c);
            if (u) {
                Sprite.this.fireUpdate();
            }
            return u;
        }

        @Override
        public boolean addAll(int index, Collection<? extends BufferedImage> c) {
            boolean u = super.addAll(index, c);
            if (u) {
                Sprite.this.fireUpdate();
            }
            return u;
        }

        public boolean replace(BufferedImage obi, BufferedImage nbi) {
            int i = this.indexOf(obi);
            if (i < 0) {
                return false;
            }
            this.set(i, nbi);
            return true;
        }

        @Override
        public void clear() {
            super.clear();
            Sprite.this.fireUpdate();
        }

        @Override
        public BufferedImage remove(int index) {
            BufferedImage i = (BufferedImage)super.remove(index);
            Sprite.this.fireUpdate();
            return i;
        }

        @Override
        public boolean remove(Object o) {
            boolean u = super.remove(o);
            if (u) {
                Sprite.this.fireUpdate();
            }
            return u;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean u = super.removeAll(c);
            if (u) {
                Sprite.this.fireUpdate();
            }
            return u;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
            Sprite.this.fireUpdate();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean u = super.retainAll(c);
            if (u) {
                Sprite.this.fireUpdate();
            }
            return u;
        }

        @Override
        public BufferedImage set(int index, BufferedImage element) {
            BufferedImage i = super.set(index, element);
            Sprite.this.fireUpdate();
            return i;
        }
    }

    public static enum MaskShape {
        PRECISE,
        RECTANGLE,
        DISK,
        DIAMOND,
        POLYGON;

    }

    public static enum PSprite {
        TRANSPARENT,
        SHAPE,
        ALPHA_TOLERANCE,
        SEPARATE_MASK,
        SMOOTH_EDGES,
        PRELOAD,
        ORIGIN_X,
        ORIGIN_Y,
        BB_MODE,
        BB_LEFT,
        BB_RIGHT,
        BB_TOP,
        BB_BOTTOM,
        TILE_HORIZONTALLY,
        TILE_VERTICALLY,
        FOR3D;

    }

    private class SpritePropertyListener
    extends PropertyMap.PropertyUpdateListener<PSprite> {
        private SpritePropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<PSprite> e) {
            switch ((PSprite)((Object)e.key)) {
                case TRANSPARENT: {
                    Sprite.this.fireUpdate();
                    break;
                }
                case ALPHA_TOLERANCE: 
                case BB_MODE: {
                    Sprite.this.updateBoundingBox();
                    break;
                }
            }
        }
    }
}

