/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.resources;

import java.util.EnumMap;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.util.PropertyMap;

public class Sound
extends InstantiableResource<Sound, PSound> {
    public byte[] data = new byte[0];
    private static final EnumMap<PSound, Object> DEFS = PropertyMap.makeDefaultMap(PSound.class, new Object[]{SoundKind.NORMAL, "", "", false, false, false, false, false, 1.0, 0.0, true, 192, 44100, SoundType.MONO, 16, false, false, false});

    public Sound() {
        this((ResourceReference<Sound>)null);
    }

    public Sound(ResourceReference<Sound> r) {
        super(r);
    }

    @Override
    public Sound makeInstance(ResourceReference<Sound> r) {
        return new Sound(r);
    }

    public int getEffects() {
        int effects = 0;
        int n = 1;
        PSound[] pSoundArray = ProjectFile.SOUND_FX_FLAGS;
        int n2 = ProjectFile.SOUND_FX_FLAGS.length;
        int n3 = 0;
        while (n3 < n2) {
            PSound k = pSoundArray[n3];
            if (((Boolean)this.get(k)).booleanValue()) {
                effects |= n;
            }
            n <<= 1;
            ++n3;
        }
        return effects;
    }

    public void setEffects(int effects) {
        PSound[] pSoundArray = ProjectFile.SOUND_FX_FLAGS;
        int n = ProjectFile.SOUND_FX_FLAGS.length;
        int n2 = 0;
        while (n2 < n) {
            PSound k = pSoundArray[n2];
            this.put(k, (effects & 1) != 0);
            effects >>= 1;
            ++n2;
        }
    }

    @Override
    protected void postCopy(Sound dest) {
        super.postCopy(dest);
        dest.data = new byte[this.data.length];
        System.arraycopy(this.data, 0, dest.data, 0, this.data.length);
    }

    @Override
    protected PropertyMap<PSound> makePropertyMap() {
        return new PropertyMap<PSound>(PSound.class, this, DEFS);
    }

    public static enum PSound {
        KIND,
        FILE_TYPE,
        FILE_NAME,
        CHORUS,
        ECHO,
        FLANGER,
        GARGLE,
        REVERB,
        VOLUME,
        PAN,
        PRELOAD,
        BIT_RATE,
        SAMPLE_RATE,
        TYPE,
        BIT_DEPTH,
        COMPRESSED,
        STREAMED,
        DECOMPRESS_ON_LOAD;

    }

    public static enum SoundKind {
        NORMAL,
        BACKGROUND,
        SPATIAL,
        MULTIMEDIA;

    }

    public static enum SoundType {
        MONO,
        STEREO,
        THREED;

    }
}

