/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.resources;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.lateralgm.main.LGM;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.sub.BackgroundDef;
import org.lateralgm.resources.sub.Instance;
import org.lateralgm.resources.sub.Tile;
import org.lateralgm.resources.sub.View;
import org.lateralgm.subframes.CodeFrame;
import org.lateralgm.util.ActiveArrayList;
import org.lateralgm.util.PropertyMap;

public class Room
extends InstantiableResource<Room, PRoom>
implements CodeFrame.CodeHolder {
    public static final int TAB_OBJECTS = 0;
    public static final int TAB_SETTINGS = 1;
    public static final int TAB_TILES = 2;
    public static final int TAB_BACKGROUNDS = 3;
    public static final int TAB_VIEWS = 4;
    public final List<BackgroundDef> backgroundDefs;
    public final List<View> views;
    public final ActiveArrayList<Instance> instances = new ActiveArrayList();
    public final ActiveArrayList<Tile> tiles = new ActiveArrayList();
    private final UpdateSource.UpdateTrigger instanceUpdateTrigger = new UpdateSource.UpdateTrigger();
    public final UpdateSource instanceUpdateSource = new UpdateSource(this, this.instanceUpdateTrigger);
    private final UpdateSource.UpdateTrigger tileUpdateTrigger = new UpdateSource.UpdateTrigger();
    public final UpdateSource tileUpdateSource = new UpdateSource(this, this.tileUpdateTrigger);
    private static final EnumMap<PRoom, Object> DEFS = PropertyMap.makeDefaultMap(PRoom.class, "", 640, 480, 16, 16, false, 30, false, Color.LIGHT_GRAY, true, "", true, 1024, 640, true, true, true, true, true, false, false, false, 0, 0, 0, false, true, false, 0, 0, 640, 480, 0.0, 10.0, 0.1);

    public Room() {
        this((ResourceReference<Room>)null);
    }

    public Room(ResourceReference<Room> r) {
        super(r);
        BackgroundDef[] b = new BackgroundDef[8];
        int j = 0;
        while (j < b.length) {
            b[j] = new BackgroundDef();
            ++j;
        }
        this.backgroundDefs = Collections.unmodifiableList(Arrays.asList(b));
        View[] v = new View[8];
        int j2 = 0;
        while (j2 < v.length) {
            v[j2] = new View();
            ++j2;
        }
        this.views = Collections.unmodifiableList(Arrays.asList(v));
    }

    @Override
    public Room makeInstance(ResourceReference<Room> r) {
        return new Room(r);
    }

    public Instance addInstance() {
        Instance inst = new Instance(this);
        inst.properties.put(Instance.PInstance.ID, (Object)(++LGM.currentFile.lastInstanceId));
        this.instances.add(inst);
        return inst;
    }

    public int getWidth() {
        return (Integer)this.properties.get(PRoom.WIDTH);
    }

    public int getHeight() {
        return (Integer)this.properties.get(PRoom.HEIGHT);
    }

    @Override
    public String getCode() {
        return (String)this.properties.get(PRoom.CREATION_CODE);
    }

    @Override
    public void setCode(String s) {
        this.properties.put(PRoom.CREATION_CODE, (Object)s);
    }

    @Override
    protected void postCopy(Room dest) {
        super.postCopy(dest);
        for (Instance inst : this.instances) {
            Instance inst2 = dest.addInstance();
            inst2.properties.putAll((Map<Instance.PInstance, Object>)inst.properties);
        }
        for (Tile tile : this.tiles) {
            Tile tile2 = new Tile(this);
            tile2.properties.putAll((Map<Tile.PTile, Object>)tile.properties);
            dest.tiles.add(tile2);
        }
        int s = this.views.size();
        int i = 0;
        while (i < s) {
            View view = this.views.get(i);
            View view2 = dest.views.get(i);
            view2.properties.putAll((Map<View.PView, Object>)view.properties);
            ++i;
        }
        s = this.backgroundDefs.size();
        i = 0;
        while (i < s) {
            BackgroundDef back = this.backgroundDefs.get(i);
            BackgroundDef back2 = dest.backgroundDefs.get(i);
            back2.properties.putAll((Map<BackgroundDef.PBackgroundDef, Object>)back.properties);
            ++i;
        }
    }

    @Override
    protected PropertyMap<PRoom> makePropertyMap() {
        return new PropertyMap<PRoom>(PRoom.class, this, DEFS);
    }

    public void instanceUpdated(UpdateSource.UpdateEvent e) {
        this.instanceUpdateTrigger.fire(new UpdateSource.UpdateEvent(this.instanceUpdateSource, e));
    }

    public void tileUpdated(UpdateSource.UpdateEvent e) {
        this.tileUpdateTrigger.fire(new UpdateSource.UpdateEvent(this.tileUpdateSource, e));
    }

    public static enum PRoom {
        CAPTION,
        WIDTH,
        HEIGHT,
        SNAP_X,
        SNAP_Y,
        ISOMETRIC,
        SPEED,
        PERSISTENT,
        BACKGROUND_COLOR,
        DRAW_BACKGROUND_COLOR,
        CREATION_CODE,
        REMEMBER_WINDOW_SIZE,
        EDITOR_WIDTH,
        EDITOR_HEIGHT,
        SHOW_GRID,
        SHOW_OBJECTS,
        SHOW_TILES,
        SHOW_BACKGROUNDS,
        SHOW_FOREGROUNDS,
        SHOW_VIEWS,
        DELETE_UNDERLYING_OBJECTS,
        DELETE_UNDERLYING_TILES,
        CURRENT_TAB,
        SCROLL_BAR_X,
        SCROLL_BAR_Y,
        VIEWS_ENABLED,
        VIEWS_CLEAR,
        PHYSICS_WORLD,
        PHYSICS_TOP,
        PHYSICS_LEFT,
        PHYSICS_RIGHT,
        PHYSICS_BOTTOM,
        PHYSICS_GRAVITY_X,
        PHYSICS_GRAVITY_Y,
        PHYSICS_PIXTOMETERS;

    }

    public static interface Piece {
        public boolean isLocked();

        public void setLocked(boolean var1);

        public void setName(String var1);

        public String getName();

        public void setPosition(Point var1);

        public void setScale(Point2D var1);

        public Point2D getScale();

        public double getRotation();

        public void setRotation(double var1);

        public void setAlpha(int var1);

        public void setColor(Color var1);

        public int getAlpha();

        public void setSelected(boolean var1);

        public boolean isSelected();

        public Point getPosition();
    }
}

