/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.resources;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Background;
import org.lateralgm.resources.Constants;
import org.lateralgm.resources.Extension;
import org.lateralgm.resources.ExtensionPackages;
import org.lateralgm.resources.Font;
import org.lateralgm.resources.GameInformation;
import org.lateralgm.resources.GameSettings;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.Include;
import org.lateralgm.resources.Path;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.Script;
import org.lateralgm.resources.Shader;
import org.lateralgm.resources.Sound;
import org.lateralgm.resources.Sprite;
import org.lateralgm.resources.Timeline;
import org.lateralgm.util.PropertyMap;

public abstract class Resource<R extends Resource<R, P>, P extends Enum<P>>
implements PropertyMap.PropertyValidator<P> {
    public static final Map<String, Class<? extends Resource<?, ?>>> kindsByName3 = new LinkedHashMap();
    public static final Map<Class<? extends Resource<?, ?>>, String> kindNames = new LinkedHashMap();
    public static final Map<Class<? extends Resource<?, ?>>, String> kindNamesPlural = new LinkedHashMap();
    public static final List<Class<? extends Resource<?, ?>>> kinds = new ArrayList();
    public static final boolean hasNode = true;
    protected ResNode node;
    protected String name = "";
    public final ResourceReference<R> reference;
    public final PropertyMap<P> properties = this.makePropertyMap();

    static {
        Class[] ca = new Class[]{Sprite.class, Sound.class, Background.class, Path.class, Script.class, Shader.class, Font.class, Timeline.class, GmObject.class, Room.class, Include.class, Extension.class, Constants.class, GameInformation.class, GameSettings.class, ExtensionPackages.class};
        String[] chr3 = new String[]{"SPR", "SND", "BKG", "PTH", "SCR", "SHR", "FNT", "TML", "OBJ", "RMM", "INC", "EXT", "CST", "GMI", "GMS", "PKG"};
        int leng = chr3.length;
        int i = 0;
        while (i < leng) {
            kindsByName3.put(chr3[i], ca[i]);
            ++i;
        }
        i = 0;
        while (i < leng) {
            Resource.addKind(chr3[i], ca[i]);
            ++i;
        }
    }

    private static void addKind(String str3, Class<?> clz) {
        String name = Messages.getString("LGM." + str3);
        String plural = Messages.getString("LGM.PL_" + str3);
        Resource.addKind(clz, str3, name, plural);
    }

    public static void addKind(Class<? extends Resource<?, ?>> kind, String name3, String name, String plural) {
        kinds.add(kind);
        kindsByName3.put(name3, kind);
        kindNames.put(kind, name);
        kindNamesPlural.put(kind, plural);
    }

    public Resource() {
        this(null);
    }

    public Resource(ResourceReference<R> r) {
        this.reference = r == null ? new ResourceReference<Resource>(this) : r;
    }

    protected void fireUpdate() {
        this.reference.updateTrigger.fire();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireUpdate();
    }

    public ResNode getNode() {
        return this.node;
    }

    public void setNode(ResNode node) {
        this.node = node;
    }

    public final void updateReference() {
        this.reference.set(this);
    }

    public final void copy(R dest) {
        ((Resource)dest).properties.putAll((Map<P, Object>)this.properties);
        this.postCopy(dest);
    }

    public final R clone() {
        R dest = this.makeInstance(this.reference);
        ((Resource)dest).properties.putAll((Map<P, Object>)this.properties);
        ((Resource)dest).node = this.node;
        ((Resource)dest).setName(this.getName());
        this.postCopy(dest);
        return dest;
    }

    public abstract R makeInstance(ResourceReference<R> var1);

    public void dispose() {
        this.reference.set(null);
    }

    public void put(P key, Object value) {
        this.properties.put(key, value);
    }

    public <V> V get(P key) {
        return this.properties.get(key);
    }

    protected abstract PropertyMap<P> makePropertyMap();

    protected abstract void postCopy(R var1);

    @Override
    public Object validate(P k, Object v) {
        return v;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        if (!this.name.equals(other.name) || this.reference != other.reference) {
            return false;
        }
        return this.properties.equals(other.properties);
    }

    public String toString() {
        return this.name;
    }

    public static interface Viewable {
        public BufferedImage getDisplayImage();
    }
}

