/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.resources;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Sprite;
import org.lateralgm.resources.sub.Event;
import org.lateralgm.resources.sub.MainEvent;
import org.lateralgm.resources.sub.ShapePoint;
import org.lateralgm.util.ActiveArrayList;
import org.lateralgm.util.PropertyMap;

public class GmObject
extends InstantiableResource<GmObject, PGmObject>
implements Resource.Viewable,
UpdateSource.UpdateListener {
    public static final ResourceReference<GmObject> OBJECT_SELF = new ResourceReference<Object>(null);
    public static final ResourceReference<GmObject> OBJECT_OTHER = new ResourceReference<Object>(null);
    private final ObjectPropertyListener opl = new ObjectPropertyListener();
    private ResourceReference<?> sprite = null;
    public final List<MainEvent> mainEvents;
    public final ActiveArrayList<ShapePoint> shapePoints = new ActiveArrayList();
    private static final EnumMap<PGmObject, Object> DEFS = PropertyMap.makeDefaultMap(PGmObject.class, new Object[]{null, false, true, 0, false, null, null, false, false, PhysicsShape.CIRCLE, 0.5, 0.1, 0, 0.1, 0.1, 0.2, true, false});

    public static int refAsInt(ResourceReference<GmObject> ref) {
        if (ref == OBJECT_SELF) {
            return -1;
        }
        if (ref == OBJECT_OTHER) {
            return -2;
        }
        GmObject obj = Util.deRef(ref);
        return obj == null ? -100 : obj.getId();
    }

    public GmObject() {
        this((ResourceReference<GmObject>)null);
    }

    public GmObject(ResourceReference<GmObject> r) {
        super(r);
        MainEvent[] e = new MainEvent[12];
        int j = 0;
        while (j < 12) {
            e[j] = new MainEvent();
            ++j;
        }
        this.mainEvents = Collections.unmodifiableList(Arrays.asList(e));
        this.properties.updateSource.addListener(this.opl);
    }

    @Override
    public GmObject makeInstance(ResourceReference<GmObject> r) {
        return new GmObject(r);
    }

    @Override
    protected void postCopy(GmObject dest) {
        super.postCopy(dest);
        int i = 0;
        while (i < 12) {
            MainEvent mev = this.mainEvents.get(i);
            MainEvent mev2 = dest.mainEvents.get(i);
            for (Event ev : mev.events) {
                mev2.events.add(ev.copy());
            }
            ++i;
        }
        for (ShapePoint point : this.shapePoints) {
            ShapePoint point2 = new ShapePoint(point.getX(), point.getY());
            dest.shapePoints.add(point2);
        }
    }

    @Override
    public BufferedImage getDisplayImage() {
        ResourceReference r = (ResourceReference)this.get(PGmObject.SPRITE);
        Sprite s = (Sprite)Util.deRef(r);
        return s == null ? null : s.getDisplayImage();
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        this.reference.updateTrigger.fire(e);
    }

    @Override
    protected PropertyMap<PGmObject> makePropertyMap() {
        return new PropertyMap<PGmObject>(PGmObject.class, this, DEFS);
    }

    private boolean isValidParent(GmObject p) {
        if (p == this) {
            return false;
        }
        if (p == null) {
            return true;
        }
        HashSet<GmObject> traversed = new HashSet<GmObject>();
        traversed.add(p);
        do {
            ResourceReference r;
            if ((p = (GmObject)Util.deRef(r = (ResourceReference)p.get(PGmObject.PARENT))) != null) continue;
            return true;
        } while (p != this && traversed.add(p));
        return false;
    }

    @Override
    public Object validate(PGmObject k, Object v) {
        switch (k) {
            case SPRITE: {
                ResourceReference r = (ResourceReference)v;
                if (r != null) {
                    Object o = r.get();
                    if (o == null) {
                        r = null;
                    } else if (!(o instanceof Sprite)) {
                        throw new PropertyMap.PropertyValidationException();
                    }
                }
                if (this.sprite != null) {
                    this.sprite.updateSource.removeListener(this);
                }
                this.sprite = r;
                if (this.sprite == null) break;
                this.sprite.updateSource.addListener(this);
                break;
            }
            case PARENT: {
                GmObject p;
                if (v == null || this.isValidParent(p = (GmObject)((ResourceReference)v).get())) break;
                throw new ParentLoopException();
            }
        }
        return v;
    }

    private class ObjectPropertyListener
    extends PropertyMap.PropertyUpdateListener<PGmObject> {
        private ObjectPropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<PGmObject> e) {
            if (e.key == PGmObject.SPRITE) {
                GmObject.this.fireUpdate();
            }
        }
    }

    public static enum PGmObject {
        SPRITE,
        SOLID,
        VISIBLE,
        DEPTH,
        PERSISTENT,
        PARENT,
        MASK,
        PHYSICS_OBJECT,
        PHYSICS_SENSOR,
        PHYSICS_SHAPE,
        PHYSICS_DENSITY,
        PHYSICS_RESTITUTION,
        PHYSICS_GROUP,
        PHYSICS_DAMPING_LINEAR,
        PHYSICS_DAMPING_ANGULAR,
        PHYSICS_FRICTION,
        PHYSICS_AWAKE,
        PHYSICS_KINEMATIC;

    }

    public static class ParentLoopException
    extends PropertyMap.PropertyValidationException {
        private static final long serialVersionUID = 1L;
    }

    public static enum PhysicsShape {
        CIRCLE,
        BOX,
        SHAPE;

    }
}

