/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.resources;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.EnumMap;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.file.iconio.ICOFile;
import org.lateralgm.main.LGM;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Constants;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.util.PropertyMap;

public class GameSettings
extends Resource<GameSettings, PGameSettings> {
    public static ICOFile DEFAULT_ICON = null;
    public Constants constants = new Constants();
    private static final EnumMap<PGameSettings, Object> DEFS;

    static {
        try {
            String loc = "org/lateralgm/file/default.ico";
            File file = new File(loc);
            InputStream filein = !file.exists() ? LGM.class.getClassLoader().getResourceAsStream(loc) : new FileInputStream(file);
            DEFAULT_ICON = new ICOFile(filein);
        }
        catch (Exception ex) {
            System.err.println(Messages.getString("GmFile.NOICON"));
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
        DEFS = PropertyMap.makeDefaultMap(PGameSettings.class, new Object[]{-1, new byte[16], false, false, false, false, true, -1, false, false, Color.BLACK, false, ColorDepth.NO_CHANGE, Resolution.NO_CHANGE, Frequency.NO_CHANGE, false, false, true, true, true, true, false, false, true, Priority.NORMAL, true, ProgressBar.DEFAULT, null, null, false, null, false, 255, true, true, false, false, false, true, "", "100", ProjectFile.longTimeToGmTime(System.currentTimeMillis()), "", IncludeFolder.MAIN, false, false, 1, 0, 0, 0, "", "", "", "", DEFAULT_ICON, true, true, false, false, 0, 0, 0, false, false, false});
    }

    @Override
    public GameSettings makeInstance(ResourceReference<GameSettings> ref) {
        return new GameSettings();
    }

    @Override
    protected PropertyMap<PGameSettings> makePropertyMap() {
        return new PropertyMap<PGameSettings>(PGameSettings.class, this, DEFS);
    }

    @Override
    protected void postCopy(GameSettings dest) {
    }

    @Override
    public Object validate(PGameSettings k, Object v) {
        return v;
    }

    @Override
    public void put(PGameSettings key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public <V> V get(PGameSettings key) {
        return this.properties.get(key);
    }

    public Double getLastChanged() {
        return (Double)this.properties.get(PGameSettings.LAST_CHANGED);
    }

    public static enum ColorDepth {
        NO_CHANGE,
        BIT_16,
        BIT_32;

    }

    public static enum Frequency {
        NO_CHANGE,
        FREQ_60,
        FREQ_70,
        FREQ_85,
        FREQ_100,
        FREQ_120;

    }

    public static enum IncludeFolder {
        MAIN,
        TEMP;

    }

    public static enum PGameSettings {
        GAME_ID,
        GAME_GUID,
        START_FULLSCREEN,
        INTERPOLATE,
        FORCE_SOFTWARE_VERTEX_PROCESSING,
        DONT_DRAW_BORDER,
        DISPLAY_CURSOR,
        SCALING,
        ALLOW_WINDOW_RESIZE,
        ALWAYS_ON_TOP,
        COLOR_OUTSIDE_ROOM,
        SET_RESOLUTION,
        COLOR_DEPTH,
        RESOLUTION,
        FREQUENCY,
        DONT_SHOW_BUTTONS,
        USE_SYNCHRONIZATION,
        DISABLE_SCREENSAVERS,
        LET_F4_SWITCH_FULLSCREEN,
        LET_F1_SHOW_GAME_INFO,
        LET_ESC_END_GAME,
        LET_F5_SAVE_F6_LOAD,
        LET_F9_SCREENSHOT,
        TREAT_CLOSE_AS_ESCAPE,
        GAME_PRIORITY,
        FREEZE_ON_LOSE_FOCUS,
        LOAD_BAR_MODE,
        FRONT_LOAD_BAR,
        BACK_LOAD_BAR,
        SHOW_CUSTOM_LOAD_IMAGE,
        LOADING_IMAGE,
        IMAGE_PARTIALLY_TRANSPARENTY,
        LOAD_IMAGE_ALPHA,
        SCALE_PROGRESS_BAR,
        DISPLAY_ERRORS,
        WRITE_TO_LOG,
        ABORT_ON_ERROR,
        TREAT_UNINIT_AS_0,
        ERROR_ON_ARGS,
        AUTHOR,
        VERSION,
        LAST_CHANGED,
        INFORMATION,
        INCLUDE_FOLDER,
        OVERWRITE_EXISTING,
        REMOVE_AT_GAME_END,
        VERSION_MAJOR,
        VERSION_MINOR,
        VERSION_RELEASE,
        VERSION_BUILD,
        COMPANY,
        PRODUCT,
        COPYRIGHT,
        DESCRIPTION,
        GAME_ICON,
        USE_NEW_AUDIO,
        SHORT_CIRCUIT_EVAL,
        USE_FAST_COLLISION,
        FAST_COLLISION_COMPAT,
        WINDOWS_STEAM_ID,
        MAC_STEAM_ID,
        LINUX_STEAM_ID,
        WINDOWS_STEAM_ENABLE,
        MAC_STEAM_ENABLE,
        LINUX_STEAM_ENABLE;

    }

    public static enum Priority {
        NORMAL,
        HIGH,
        HIGHEST;

    }

    public static enum ProgressBar {
        NONE,
        DEFAULT,
        CUSTOM;

    }

    public static enum Resolution {
        NO_CHANGE,
        RES_320X240,
        RES_640X480,
        RES_800X600,
        RES_1024X768,
        RES_1280X1024,
        RES_1600X1200;

    }
}

