/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.resources;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import org.lateralgm.main.LGM;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.sub.CharacterRange;
import org.lateralgm.resources.sub.GlyphMetric;
import org.lateralgm.util.ActiveArrayList;
import org.lateralgm.util.PropertyMap;

public class Font
extends InstantiableResource<Font, PFont> {
    private static final EnumMap<PFont, Object> DEFS = PropertyMap.makeDefaultMap(PFont.class, "Arial", 12, false, false, 3, 0);
    public final ActiveArrayList<CharacterRange> characterRanges = new ActiveArrayList();
    public final ActiveArrayList<GlyphMetric> glyphMetrics = new ActiveArrayList();
    private final UpdateSource.UpdateTrigger rangeUpdateTrigger = new UpdateSource.UpdateTrigger();
    public final UpdateSource rangeUpdateSource = new UpdateSource(this, this.rangeUpdateTrigger);

    public Font() {
        this((ResourceReference<Font>)null);
    }

    public Font(ResourceReference<Font> r) {
        super(r);
    }

    @Override
    public Font makeInstance(ResourceReference<Font> r) {
        return new Font(r);
    }

    public GlyphMetric addGlyph() {
        GlyphMetric gm = new GlyphMetric();
        this.glyphMetrics.add(gm);
        return gm;
    }

    public CharacterRange addRange() {
        CharacterRange cr = new CharacterRange(this);
        this.characterRanges.add(cr);
        return cr;
    }

    public CharacterRange addRange(int min, int max) {
        if (min < 0 || min > max) {
            throw new IllegalArgumentException();
        }
        CharacterRange cr = new CharacterRange(this, min, max);
        this.characterRanges.add(cr);
        return cr;
    }

    public void addRangesFromString(String s) {
        HashSet<Integer> unique = new HashSet<Integer>();
        int mincp = Integer.MAX_VALUE;
        int maxcp = 0;
        int i = 0;
        while (i < s.length()) {
            int cp = s.codePointAt(i);
            if (cp < mincp) {
                mincp = cp;
            }
            if (cp > maxcp) {
                maxcp = cp;
            }
            unique.add(cp);
            i += Character.charCount(cp);
        }
        CharacterRange cr = null;
        int i2 = mincp;
        while (i2 <= maxcp) {
            if (unique.contains(i2)) {
                if (cr == null) {
                    cr = this.addRange(i2, i2);
                } else {
                    cr.properties.put(CharacterRange.PCharacterRange.RANGE_MAX, (Object)i2);
                }
            } else {
                cr = null;
            }
            ++i2;
        }
    }

    public void addRangesFromFile(File f) {
        try {
            this.addRangesFromString(new String(Files.readAllBytes(f.toPath()), "UTF-8"));
        }
        catch (IOException e) {
            LGM.showDefaultExceptionHandler(e);
        }
    }

    public static int makeStyle(boolean bold, boolean italic) {
        return (italic ? 2 : 0) | (bold ? 1 : 0);
    }

    public java.awt.Font getAWTFont(int resolution) {
        int s = (Integer)this.get(PFont.SIZE);
        String fn = (String)this.get(PFont.FONT_NAME);
        boolean b = (Boolean)this.get(PFont.BOLD);
        boolean i = (Boolean)this.get(PFont.ITALIC);
        int fontSize = (int)Math.round((double)(s * resolution) / 72.0);
        return new java.awt.Font(fn, Font.makeStyle(b, i), fontSize);
    }

    public java.awt.Font getAWTFont() {
        return this.getAWTFont(96);
    }

    @Override
    protected PropertyMap<PFont> makePropertyMap() {
        return new PropertyMap<PFont>(PFont.class, this, DEFS);
    }

    @Override
    protected void postCopy(Font dest) {
        super.postCopy(dest);
        dest.characterRanges.clear();
        for (CharacterRange cr : this.characterRanges) {
            CharacterRange r2 = dest.addRange();
            r2.properties.putAll((Map<CharacterRange.PCharacterRange, Object>)cr.properties);
        }
        dest.glyphMetrics.clear();
        for (GlyphMetric gm : this.glyphMetrics) {
            GlyphMetric g2 = dest.addGlyph();
            g2.properties.putAll((Map<GlyphMetric.PGlyphMetric, Object>)gm.properties);
        }
    }

    public void rangeUpdated(UpdateSource.UpdateEvent e) {
        this.rangeUpdateTrigger.fire(new UpdateSource.UpdateEvent(this.rangeUpdateSource, e));
    }

    public static enum PFont {
        FONT_NAME,
        SIZE,
        BOLD,
        ITALIC,
        ANTIALIAS,
        CHARSET;

    }
}

