/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.resources;

import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.EnumMap;
import org.lateralgm.main.Util;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.util.PropertyMap;

public class Background
extends InstantiableResource<Background, PBackground>
implements Resource.Viewable {
    private BufferedImage backgroundImage = null;
    private SoftReference<BufferedImage> imageCache = null;
    private final BackgroundPropertyListener bpl = new BackgroundPropertyListener();
    private static final EnumMap<PBackground, Object> DEFS = PropertyMap.makeDefaultMap(PBackground.class, false, false, false, false, 16, 16, 0, 0, 0, 0, false, false, false);

    public Background() {
        this((ResourceReference<Background>)null);
    }

    public Background(ResourceReference<Background> r) {
        super(r);
        this.properties.updateSource.addListener(this.bpl);
    }

    @Override
    public Background makeInstance(ResourceReference<Background> r) {
        return new Background(r);
    }

    @Override
    public BufferedImage getDisplayImage() {
        BufferedImage bi;
        if (this.backgroundImage == null) {
            return null;
        }
        if (this.imageCache != null && (bi = this.imageCache.get()) != null) {
            return bi;
        }
        bi = this.backgroundImage;
        if (((Boolean)this.get(PBackground.TRANSPARENT)).booleanValue()) {
            bi = Util.getTransparentImage(bi);
        }
        this.imageCache = new SoftReference<BufferedImage>(bi);
        return bi;
    }

    @Override
    protected void postCopy(Background dest) {
        super.postCopy(dest);
        dest.backgroundImage = Util.cloneImage(this.backgroundImage);
    }

    @Override
    protected void fireUpdate() {
        if (this.imageCache != null) {
            this.imageCache.clear();
        }
        super.fireUpdate();
    }

    public BufferedImage getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(BufferedImage backgroundImage) {
        this.backgroundImage = backgroundImage;
        this.fireUpdate();
    }

    public long getSize() {
        if (this.backgroundImage != null) {
            return this.getWidth() * this.getHeight() * 4;
        }
        return 0L;
    }

    public int getWidth() {
        return this.backgroundImage == null ? 0 : this.backgroundImage.getWidth();
    }

    public int getHeight() {
        return this.backgroundImage == null ? 0 : this.backgroundImage.getHeight();
    }

    @Override
    protected PropertyMap<PBackground> makePropertyMap() {
        return new PropertyMap<PBackground>(PBackground.class, this, DEFS);
    }

    private class BackgroundPropertyListener
    extends PropertyMap.PropertyUpdateListener<PBackground> {
        private BackgroundPropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<PBackground> e) {
            switch ((PBackground)((Object)e.key)) {
                case TRANSPARENT: {
                    Background.this.fireUpdate();
                    break;
                }
            }
        }
    }

    public static enum PBackground {
        TRANSPARENT,
        SMOOTH_EDGES,
        PRELOAD,
        USE_AS_TILESET,
        TILE_WIDTH,
        TILE_HEIGHT,
        H_OFFSET,
        V_OFFSET,
        H_SEP,
        V_SEP,
        TILE_HORIZONTALLY,
        TILE_VERTICALLY,
        FOR3D;

    }
}

