/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.messages;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.KeyStroke;

public final class Messages {
    private static final String LANGUAGE_BUNDLE_NAME = "org.lateralgm.messages.messages";
    private static final String INPUT_BUNDLE_NAME = "org.lateralgm.messages.keyboard";
    private static ResourceBundle LANGUAGE_BUNDLE = null;
    private static ResourceBundle KEYBOARD_BUNDLE = null;

    static {
        Messages.updateLangPack();
    }

    private Messages() {
    }

    public static void updateLangPack() {
        LANGUAGE_BUNDLE = ResourceBundle.getBundle(LANGUAGE_BUNDLE_NAME);
        KEYBOARD_BUNDLE = ResourceBundle.getBundle(INPUT_BUNDLE_NAME);
    }

    public static String getString(String key) {
        try {
            return LANGUAGE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static void translate(String[] keys) {
        int i = 0;
        while (i < keys.length) {
            keys[i] = Messages.getString(keys[i]);
            ++i;
        }
    }

    public static String getKeyboardString(String key) {
        try {
            return KEYBOARD_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static KeyStroke getKeyboardStroke(String key) {
        String keyString = Messages.getKeyboardString(key);
        return KeyStroke.getKeyStroke(keyString);
    }

    public static String format(String key, Object ... arguments) {
        try {
            String p = LANGUAGE_BUNDLE.getString(key);
            return MessageFormat.format(p, arguments);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }
}

