/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.bmp.BMPImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import org.lateralgm.components.CustomFileChooser;
import org.lateralgm.components.impl.CustomFileFilter;
import org.lateralgm.components.visual.FileChooserImagePreview;
import org.lateralgm.file.ApngIO;
import org.lateralgm.file.iconio.BitmapDescriptor;
import org.lateralgm.file.iconio.ICOFile;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class Util {
    private static final InvokeOnceRunnable IOR = new InvokeOnceRunnable();
    public static CustomFileChooser imageReadFc = null;
    public static CustomFileChooser imageWriteFc = null;

    private Util() {
    }

    public static DataFlavor createJVMLocalDataFlavor(Class<?> dataClass) throws ClassNotFoundException {
        return new DataFlavor("application/x-java-jvm-local-objectref;class=" + dataClass.getName());
    }

    public static DataFlavor createJVMLocalDataFlavor(String className) throws ClassNotFoundException {
        return new DataFlavor("application/x-java-jvm-local-objectref;class=" + className);
    }

    public static void setComponentTreeEnabled(JComponent comp, boolean enabled) {
        comp.setIgnoreRepaint(true);
        comp.setEnabled(enabled);
        Component[] componentArray = comp.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component child = componentArray[n2];
            child.setEnabled(enabled);
            ++n2;
        }
        comp.setIgnoreRepaint(false);
        comp.repaint();
    }

    public static JPanel makeLabelPane(String name) {
        JPanel lp = new JPanel(new GridLayout(0, 3, 0, 0));
        MatteBorder mb = BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(184, 184, 184));
        TitledBorder tb = BorderFactory.createTitledBorder(mb, name);
        lp.setBorder(tb);
        return lp;
    }

    public static BufferedImage paintBackground(int width, int height, Color background, Color foreground) {
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        BufferedImage dest = new BufferedImage(width, height, 1);
        int row = 0;
        while (row < height) {
            int col = 0;
            while (col < width) {
                if ((row + col) % 2 == 0) {
                    dest.setRGB(col, row, foreground.getRGB());
                } else {
                    dest.setRGB(col, row, background.getRGB());
                }
                ++col;
            }
            ++row;
        }
        return dest;
    }

    public static BufferedImage paintBackground(int width, int height) {
        return Util.paintBackground(width, height, new Color(Prefs.imagePreviewBackgroundColor), new Color(Prefs.imagePreviewForegroundColor));
    }

    public static BufferedImage paintBackgroundScaled(int width, int height, int TILE, Color background, Color foreground) {
        BufferedImage dest = new BufferedImage(width, height, 1);
        Graphics2D g = dest.createGraphics();
        g.setClip(0, 0, width, height);
        g.setColor(background);
        g.fillRect(0, 0, width, height);
        g.setColor(foreground);
        int w = width / TILE + 1;
        int h = height / TILE + 1;
        int row = 0;
        while (row < h) {
            int col = 0;
            while (col < w) {
                if ((row + col) % 2 == 0) {
                    g.fillRect(col * TILE, row * TILE, TILE, TILE);
                }
                ++col;
            }
            ++row;
        }
        g.dispose();
        return dest;
    }

    public static BufferedImage paintBackgroundScaled(int width, int height, int TILE) {
        return Util.paintBackgroundScaled(width, height, TILE, new Color(Prefs.imagePreviewBackgroundColor), new Color(Prefs.imagePreviewForegroundColor));
    }

    public static OutputStream openURIOutputStream(URI uri) throws NullPointerException, IOException {
        if (uri == null) {
            throw new NullPointerException();
        }
        File file = null;
        try {
            file = new File(uri);
        }
        catch (IllegalArgumentException e) {
            URLConnection uc = uri.toURL().openConnection();
            uc.setDoOutput(true);
            return uc.getOutputStream();
        }
        return new FileOutputStream(file);
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] readFully(File file) throws FileNotFoundException, IOException {
        byte[] fileData = new byte[(int)file.length()];
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                try (DataInputStream dis = new DataInputStream(fis);){
                    dis.readFully(fileData);
                }
                if (fis == null) return fileData;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return fileData;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static ByteArrayOutputStream readFully(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int numRead = 0;
        while ((numRead = in.read(buffer)) >= 0) {
            baos.write(buffer, 0, numRead);
        }
        return baos;
    }

    public static byte[] readFully(String path) throws FileNotFoundException, IOException {
        return Util.readFully(new File(path));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeFully(File file, byte[] data) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileOutputStream fos = new FileOutputStream(file);
            try {
                try (BufferedOutputStream bos = new BufferedOutputStream(fos);){
                    bos.write(data);
                }
                if (fos == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            fos.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void writeFully(String path, byte[] data) throws FileNotFoundException, IOException {
        Util.writeFully(new File(path), data);
    }

    public static Rectangle stringToRectangle(String s, Rectangle defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        String[] sa = s.split(" +");
        if (sa.length != 4) {
            return defaultValue;
        }
        int[] ia = new int[4];
        int i = 0;
        while (i < 4) {
            try {
                ia[i] = Integer.parseInt(sa[i]);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
            ++i;
        }
        return new Rectangle(ia[0], ia[1], ia[2], ia[3]);
    }

    public static String rectangleToString(Rectangle r) {
        return String.format("%d %d %d %d", r.x, r.y, r.width, r.height);
    }

    public static String formatDataSize(long bytes) {
        if (bytes <= 0L) {
            return "0 B";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digits = (int)(Math.log(bytes) / Math.log(1024.0));
        return String.valueOf(new DecimalFormat("#,##0.##").format((double)bytes / Math.pow(1024.0, digits))) + " " + units[digits];
    }

    public static String formatDataSizeAlt(long bytes) {
        if (bytes <= 0L) {
            return "0 B";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digits = (int)(Math.log(bytes) / Math.log(1000.0));
        return String.valueOf(new DecimalFormat("#,##0.##").format((double)bytes / Math.pow(1000.0, digits))) + " " + units[digits];
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static BufferedImage getTransparentImage(BufferedImage i) {
        if (i == null) {
            return null;
        }
        final int t = i.getRGB(0, i.getHeight() - 1) & 0xFFFFFF;
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public int filterRGB(int x, int y, int rgb) {
                if ((rgb & 0xFFFFFF) == t) {
                    return t;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(i.getSource(), filter);
        return Util.toBufferedImage(Toolkit.getDefaultToolkit().createImage(ip));
    }

    private static void createImageReadChooser() {
        int n;
        int n2;
        String[] stringArray;
        imageReadFc = new CustomFileChooser("/org/lateralgm", "LAST_IMAGE_DIR");
        imageReadFc.setAccessory(new FileChooserImagePreview(imageReadFc));
        String[] readexts = new String[]{"apng", "gif"};
        if (LGM.javaVersion >= 10600) {
            String ext;
            String[] internalexts = ImageIO.getReaderFileSuffixes();
            ArrayList<String> extensions = new ArrayList<String>();
            stringArray = readexts;
            n2 = readexts.length;
            n = 0;
            while (n < n2) {
                ext = stringArray[n];
                extensions.add(ext);
                ++n;
            }
            stringArray = internalexts;
            n2 = internalexts.length;
            n = 0;
            while (n < n2) {
                ext = stringArray[n];
                if (!extensions.contains(ext)) {
                    extensions.add(ext);
                }
                ++n;
            }
            readexts = extensions.toArray(new String[extensions.size()]);
        }
        int i = 0;
        while (i < readexts.length) {
            readexts[i] = "." + readexts[i];
            ++i;
        }
        String allSpiImages = Messages.getString("Util.ALL_SPI_IMAGES");
        CustomFileFilter allSpiFilter = new CustomFileFilter(allSpiImages, readexts);
        imageReadFc.addChoosableFileFilter(allSpiFilter);
        stringArray = readexts;
        n2 = readexts.length;
        n = 0;
        while (n < n2) {
            String element = stringArray[n];
            imageReadFc.addChoosableFileFilter(new CustomFileFilter(Messages.format("Util.FILES", element), element));
            ++n;
        }
        imageReadFc.setFileFilter(allSpiFilter);
    }

    private static void createImageWriteChooser() {
        int n;
        int n2;
        String[] stringArray;
        imageWriteFc = new CustomFileChooser("/org/lateralgm", "LAST_IMAGE_DIR");
        String[] writeexts = new String[]{"apng"};
        if (LGM.javaVersion >= 10600) {
            String ext;
            String[] internalexts = ImageIO.getWriterFileSuffixes();
            ArrayList<String> extensions = new ArrayList<String>();
            stringArray = writeexts;
            n2 = writeexts.length;
            n = 0;
            while (n < n2) {
                ext = stringArray[n];
                extensions.add(ext);
                ++n;
            }
            stringArray = internalexts;
            n2 = internalexts.length;
            n = 0;
            while (n < n2) {
                ext = stringArray[n];
                if (!extensions.contains(ext)) {
                    extensions.add(ext);
                }
                ++n;
            }
            writeexts = extensions.toArray(new String[extensions.size()]);
        }
        int i = 0;
        while (i < writeexts.length) {
            writeexts[i] = "." + writeexts[i];
            ++i;
        }
        String allSpiImages = Messages.getString("Util.ALL_SPI_IMAGES");
        CustomFileFilter allSpiFilter = new CustomFileFilter(allSpiImages, writeexts);
        imageWriteFc.addChoosableFileFilter(allSpiFilter);
        stringArray = writeexts;
        n2 = writeexts.length;
        n = 0;
        while (n < n2) {
            String element = stringArray[n];
            imageWriteFc.addChoosableFileFilter(new CustomFileFilter(Messages.format("Util.FILES", element), element));
            ++n;
        }
        imageWriteFc.setFileFilter(allSpiFilter);
    }

    public static File chooseImageFile() {
        if (imageReadFc == null) {
            Util.createImageReadChooser();
        }
        imageReadFc.setMultiSelectionEnabled(false);
        if (imageReadFc.showOpenDialog(LGM.frame) == 0) {
            return imageReadFc.getSelectedFile();
        }
        return null;
    }

    public static File[] chooseImageFiles() {
        if (imageReadFc == null) {
            Util.createImageReadChooser();
        }
        imageReadFc.setMultiSelectionEnabled(true);
        if (imageReadFc.showOpenDialog(LGM.frame) == 0) {
            return imageReadFc.getSelectedFiles();
        }
        return null;
    }

    public static File getSelectedFileWithExtension(JFileChooser c) {
        File file = c.getSelectedFile();
        if (c.getFileFilter() instanceof CustomFileFilter) {
            String[] exts = ((CustomFileFilter)c.getFileFilter()).getExtensions();
            String nameLower = file.getName().toLowerCase();
            String[] stringArray = exts;
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (ext.startsWith(".")) {
                    ext = ext.substring(1);
                }
                if (nameLower.endsWith(String.valueOf('.') + ext.toLowerCase())) {
                    return file;
                }
                ++n2;
            }
            file = new File(String.valueOf(file.toString()) + (exts[0].startsWith(".") ? "" : ".") + exts[0]);
        }
        return file;
    }

    private static String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf + 1);
    }

    public static String fileNameWithoutExtension(String fileName) {
        int indexOf = fileName.indexOf(46);
        if (indexOf > 0) {
            return fileName.substring(0, indexOf);
        }
        return fileName;
    }

    public static void writeImageQualityPrompt(BufferedImage img, String ext, File f) throws FileNotFoundException, IOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(ext);
        ImageWriter writer = iter.next();
        BMPImageWriteParam iwp = (BMPImageWriteParam)writer.getDefaultWriteParam();
        if (iwp.canWriteCompressed()) {
            iwp.setCompressionMode(2);
            String[] stringArray = iwp.getCompressionTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                System.out.println(str);
                ++n2;
            }
            if (ext.equals("jpg") || ext.equals("jpeg")) {
                iwp.setCompressionQuality(1.0f);
            } else if (ext.equals("bmp")) {
                iwp.setCompressionType("BI_RLE4");
            }
        }
        FileImageOutputStream output = new FileImageOutputStream(f);
        writer.setOutput(output);
        IIOImage image = new IIOImage(img, null, null);
        writer.write(null, image, iwp);
        writer.dispose();
        output.close();
    }

    public static BufferedImage convertImage(BufferedImage img, int format, Color col) {
        BufferedImage bi = new BufferedImage(img.getWidth(), img.getHeight(), format);
        Graphics gd = bi.getGraphics();
        if (col != null) {
            gd.setColor(col);
            gd.fillRect(0, 0, img.getWidth(), img.getHeight());
        }
        gd.drawImage(img, 0, 0, img.getWidth(), img.getHeight(), null);
        gd.dispose();
        return bi;
    }

    public static BufferedImage convertImage(BufferedImage img, int format) {
        return Util.convertImage(img, format, null);
    }

    public static BufferedImage clearBackground(BufferedImage img, Color col) {
        return Util.convertImage(img, 2, col);
    }

    public static BufferedImage makeOpaque(BufferedImage img, Color col) {
        return Util.convertImage(img, 13, col);
    }

    public static void saveImages(ArrayList<BufferedImage> imgs) {
        if (imgs == null || imgs.size() <= 0) {
            JOptionPane.showMessageDialog(LGM.frame, Messages.getString("Util.NO_IMAGE_MESSAGE"), Messages.getString("Util.NO_IMAGE_TITLE"), 2);
            return;
        }
        if (imageWriteFc == null) {
            Util.createImageWriteChooser();
        }
        imageWriteFc.setMultiSelectionEnabled(false);
        if (imageWriteFc.showSaveDialog(LGM.frame) == 0) {
            try {
                File f = Util.getSelectedFileWithExtension(imageWriteFc);
                String ext = Util.getFileExtension(f);
                if (ext.equals("apng")) {
                    FileOutputStream os = new FileOutputStream(f);
                    ApngIO.imagesToApng(imgs, os);
                    os.close();
                } else if (!ImageIO.write((RenderedImage)imgs.get(0), ext, f)) {
                    BufferedImage bi = Util.makeOpaque(imgs.get(0), Color.white);
                    ImageIO.write((RenderedImage)bi, ext, f);
                }
            }
            catch (IOException e) {
                LGM.showDefaultExceptionHandler(e);
            }
        }
    }

    public static void saveImage(BufferedImage img) {
        if (img == null) {
            JOptionPane.showMessageDialog(LGM.frame, Messages.getString("Util.NO_IMAGE_MESSAGE"), Messages.getString("Util.NO_IMAGE_TITLE"), 2);
            return;
        }
        if (imageWriteFc == null) {
            Util.createImageWriteChooser();
        }
        imageWriteFc.setMultiSelectionEnabled(false);
        if (imageWriteFc.showSaveDialog(LGM.frame) == 0) {
            try {
                File f = Util.getSelectedFileWithExtension(imageWriteFc);
                String ext = Util.getFileExtension(f);
                if (ext.equals("apng")) {
                    ArrayList<BufferedImage> imgs = new ArrayList<BufferedImage>(1);
                    imgs.add(img);
                    FileOutputStream os = new FileOutputStream(f);
                    ApngIO.imagesToApng(imgs, os);
                    os.close();
                } else if (!ImageIO.write((RenderedImage)img, ext, f)) {
                    BufferedImage bi = Util.makeOpaque(img, Color.white);
                    ImageIO.write((RenderedImage)bi, ext, f);
                }
            }
            catch (IOException e) {
                LGM.showDefaultExceptionHandler(e);
            }
        }
    }

    public static String getPOSIXPath(String path) {
        return path.replace("\\", "/");
    }

    private static ArrayList<BufferedImage> readGIF(File gif) throws IOException {
        IIOMetadataNode screenDescriptor;
        IIOMetadataNode globalRoot;
        NodeList globalScreenDescriptor;
        ArrayList<BufferedImage> frames = new ArrayList<BufferedImage>(0);
        ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
        reader.setInput(ImageIO.createImageInputStream(gif));
        int width = -1;
        int height = -1;
        IIOMetadata metadata = reader.getStreamMetadata();
        if (metadata != null && (globalScreenDescriptor = (globalRoot = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName())).getElementsByTagName("LogicalScreenDescriptor")) != null && globalScreenDescriptor.getLength() > 0 && (screenDescriptor = (IIOMetadataNode)globalScreenDescriptor.item(0)) != null) {
            width = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenWidth"));
            height = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenHeight"));
        }
        BufferedImage master = null;
        Graphics masterGraphics = null;
        int frameIndex = 0;
        while (true) {
            BufferedImage image;
            try {
                image = reader.read(frameIndex);
            }
            catch (IndexOutOfBoundsException io) {
                break;
            }
            if (width == -1 || height == -1) {
                width = image.getWidth();
                height = image.getHeight();
            }
            IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(frameIndex).getAsTree("javax_imageio_gif_image_1.0");
            IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
            String disposal = gce.getAttribute("disposalMethod");
            int x = 0;
            int y = 0;
            if (master == null) {
                master = new BufferedImage(width, height, 2);
                masterGraphics = master.createGraphics();
                ((Graphics2D)masterGraphics).setBackground(new Color(0, 0, 0, 0));
            } else {
                NodeList children = root.getChildNodes();
                int nodeIndex = 0;
                while (nodeIndex < children.getLength()) {
                    Node nodeItem = children.item(nodeIndex);
                    if (nodeItem.getNodeName().equals("ImageDescriptor")) {
                        NamedNodeMap map = nodeItem.getAttributes();
                        x = Integer.valueOf(map.getNamedItem("imageLeftPosition").getNodeValue());
                        y = Integer.valueOf(map.getNamedItem("imageTopPosition").getNodeValue());
                    }
                    ++nodeIndex;
                }
            }
            masterGraphics.drawImage(image, x, y, null);
            BufferedImage copy = new BufferedImage(master.getColorModel(), master.copyData(null), master.isAlphaPremultiplied(), null);
            frames.add(copy);
            if (disposal.equals("restoreToPrevious")) {
                BufferedImage from = null;
                int i = frameIndex - 1;
                while (i >= 0) {
                    if (frameIndex == 0) {
                        from = frames.get(i);
                        break;
                    }
                    --i;
                }
                master = new BufferedImage(from.getColorModel(), from.copyData(null), from.isAlphaPremultiplied(), null);
                masterGraphics = master.createGraphics();
                ((Graphics2D)masterGraphics).setBackground(new Color(0, 0, 0, 0));
            } else if (disposal.equals("restoreToBackgroundColor")) {
                masterGraphics.clearRect(x, y, image.getWidth(), image.getHeight());
            }
            ++frameIndex;
        }
        masterGraphics.dispose();
        reader.dispose();
        return frames;
    }

    public static BufferedImage getValidImage() {
        File f = Util.chooseImageFile();
        if (f == null || !f.exists()) {
            return null;
        }
        try {
            if (f.getName().endsWith(".gif")) {
                return Util.readGIF(f).get(0);
            }
            if (f.getName().endsWith(".apng")) {
                FileInputStream is = new FileInputStream(f);
                ArrayList<BufferedImage> imgs = ApngIO.apngToBufferedImages(is);
                is.close();
                return (BufferedImage)imgs.get(0);
            }
            return ImageIO.read(f);
        }
        catch (IOException e) {
            LGM.showDefaultExceptionHandler(e);
            return null;
        }
    }

    public static BufferedImage[] getValidImages() {
        File[] f = Util.chooseImageFiles();
        if (f == null) {
            return null;
        }
        try {
            ArrayList<BufferedImage> subframes = new ArrayList<BufferedImage>(0);
            int i = 0;
            while (i < f.length) {
                if (f[i].exists()) {
                    if (f[i].getName().endsWith(".gif")) {
                        subframes.addAll(Util.readGIF(f[i]));
                    } else if (f[i].getName().endsWith(".apng")) {
                        FileInputStream is = new FileInputStream(f[i]);
                        subframes.addAll(ApngIO.apngToBufferedImages(is));
                        is.close();
                    } else {
                        if (f[i].getName().endsWith(".ico")) {
                            List<BufferedImage> imgs = new ICOFile(Util.readFully(f[i])).getImages();
                            return imgs.toArray(new BufferedImage[imgs.size()]);
                        }
                        subframes.add(ImageIO.read(f[i]));
                    }
                }
                ++i;
            }
            return subframes.toArray(new BufferedImage[0]);
        }
        catch (Exception e) {
            LGM.showDefaultExceptionHandler(e);
            return null;
        }
    }

    public static BufferedImage[] getValidImages(ImageInputStream in) throws IOException, IllegalArgumentException {
        Iterator<ImageReader> it = ImageIO.getImageReaders(in);
        ImageReader reader = it.next();
        reader.setInput(in);
        int count = reader.getNumImages(true);
        BufferedImage[] img = new BufferedImage[count];
        int i = 0;
        while (i < count) {
            img[i] = reader.read(i);
            ++i;
        }
        return img;
    }

    public static BufferedImage cloneImage(BufferedImage bi) {
        if (bi == null) {
            return null;
        }
        WritableRaster or = bi.getRaster();
        WritableRaster nr = or.createCompatibleWritableRaster();
        nr.setRect(or);
        return new BufferedImage(bi.getColorModel(), nr, bi.isAlphaPremultiplied(), null);
    }

    public static Color convertGmColor(int col) {
        return new Color(col & 0xFF, (col & 0xFF00) >> 8, (col & 0xFF0000) >> 16);
    }

    public static Color convertGmColorWithAlpha(int col) {
        return new Color(col & 0xFF, (col & 0xFF00) >> 8, (col & 0xFF0000) >> 16, (col & 0xFF000000) >>> 24);
    }

    public static Color convertInstanceColorWithAlpha(int col) {
        return new Color((col & 0xFF0000) >> 16, (col & 0xFF00) >> 8, col & 0xFF, (col & 0xFF000000) >>> 24);
    }

    public static Color HSL2RGB(float h, float s, float l, int a) {
        float b_;
        float g_;
        float r_;
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float h_ = h / 60.0f;
        float h_mod2 = h_;
        if (h_mod2 >= 4.0f) {
            h_mod2 -= 4.0f;
        } else if (h_mod2 >= 2.0f) {
            h_mod2 -= 2.0f;
        }
        float x = c * (1.0f - Math.abs(h_mod2 - 1.0f));
        if (h_ < 1.0f) {
            r_ = c;
            g_ = x;
            b_ = 0.0f;
        } else if (h_ < 2.0f) {
            r_ = x;
            g_ = c;
            b_ = 0.0f;
        } else if (h_ < 3.0f) {
            r_ = 0.0f;
            g_ = c;
            b_ = x;
        } else if (h_ < 4.0f) {
            r_ = 0.0f;
            g_ = x;
            b_ = c;
        } else if (h_ < 5.0f) {
            r_ = x;
            g_ = 0.0f;
            b_ = c;
        } else {
            r_ = c;
            g_ = 0.0f;
            b_ = x;
        }
        float m = l - 0.5f * c;
        int r = (int)((r_ + m) * 255.0f + 0.5f);
        int g = (int)((g_ + m) * 255.0f + 0.5f);
        int b = (int)((b_ + m) * 255.0f + 0.5f);
        return new Color(r, g, b, a);
    }

    public static void RGB2HSL(int red, int green, int blue, float[] hslvals) {
        float r = (float)red / 255.0f;
        float g = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        float max = Math.max(Math.max(r, g), b);
        float min = Math.min(Math.min(r, g), b);
        float c = max - min;
        float h_ = 0.0f;
        if (c == 0.0f) {
            h_ = 0.0f;
        } else if (max == r) {
            h_ = (g - b) / c;
            if (h_ < 0.0f) {
                h_ += 6.0f;
            }
        } else if (max == g) {
            h_ = (b - r) / c + 2.0f;
        } else if (max == b) {
            h_ = (r - g) / c + 4.0f;
        }
        float h = 60.0f * h_;
        float l = (max + min) * 0.5f;
        float s = c == 0.0f ? 0.0f : c / (1.0f - Math.abs(2.0f * l - 1.0f));
        hslvals[0] = h;
        hslvals[1] = s;
        hslvals[2] = l;
    }

    public static int getGmColor(Color col) {
        return col.getRed() | col.getGreen() << 8 | col.getBlue() << 16;
    }

    public static int getGmColorWithAlpha(Color col) {
        return col.getRed() | col.getGreen() << 8 | col.getBlue() << 16 | col.getAlpha() << 24;
    }

    public static int getGmColorWithAlpha(Color col, int alpha) {
        return col.getRed() | col.getGreen() << 8 | col.getBlue() << 16 | alpha << 24;
    }

    public static String getHTMLColor(int col, boolean hasTransparency) {
        if (hasTransparency) {
            return String.format("rgba(%d,%d,%d,%d)", col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF, col >> 24 & 0xFF);
        }
        return String.format("rgb(%d,%d,%d)", col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF);
    }

    public static String getHTMLColor(Color col, boolean hastransparency) {
        if (hastransparency) {
            return String.format("rgba(%d,%d,%d,%d)", col.getRed(), col.getGreen(), col.getBlue(), col.getAlpha());
        }
        return String.format("rgb(%d,%d,%d)", col.getRed(), col.getGreen(), col.getBlue());
    }

    public static String formatColortoHex(Color col, boolean includeAlpha) {
        if (includeAlpha) {
            return String.format("%02X%02X%02X%02X", col.getRed(), col.getGreen(), col.getBlue(), col.getAlpha());
        }
        return String.format("%02X%02X%02X", col.getRed(), col.getGreen(), col.getBlue());
    }

    public static String formatColortoHex(Color col) {
        return String.format("%02X%02X%02X%02X", col.getRed(), col.getGreen(), col.getBlue(), col.getAlpha());
    }

    public static long getInstanceColorWithAlpha(Color col, int alpha) {
        return (long)(alpha << 24 | col.getRed() << 16 | col.getGreen() << 8 | col.getBlue()) & 0xFFFFFFFFL;
    }

    public static Component addDim(Container container, Component comp, int width, int height) {
        comp.setPreferredSize(new Dimension(width, height));
        return container.add(comp);
    }

    public static JPanel makeRadioPanel(String paneTitle, int width, int height) {
        JPanel panel = Util.makeTitledPanel(paneTitle, width, height);
        panel.setLayout(new BoxLayout(panel, 1));
        return panel;
    }

    public static JPanel makeTitledPanel(String paneTitle, int width, int height) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(paneTitle));
        Dimension newSize = new Dimension(width, height);
        panel.setPreferredSize(newSize);
        panel.setMaximumSize(newSize);
        panel.setMinimumSize(newSize);
        return panel;
    }

    public static <R extends Resource<R, ?>> R deRef(ResourceReference<R> ref) {
        return ref == null ? null : (R)ref.get();
    }

    public static <V extends InherentlyUnique<V>> boolean areInherentlyUniquesEqual(List<V> a, List<V> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        ListIterator<V> e1 = a.listIterator();
        ListIterator<V> e2 = b.listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            InherentlyUnique o1 = (InherentlyUnique)e1.next();
            InherentlyUnique o2 = (InherentlyUnique)e2.next();
            if (!(o1 == null ? o2 != null : !o1.isEqual(o2))) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    public static int gcd(int a, int b) {
        while (b != 0) {
            int c = a % b;
            a = b;
            b = c;
        }
        return a;
    }

    public static int negDiv(int a, int b) {
        return a >= 0 ? a / b : ~(~a / b);
    }

    public static void invokeOnceLater(Runnable r) {
        IOR.add(r);
    }

    public static void fixIcon(ICOFile ico, int ver) {
        if (ver < 800) {
            byte[] weights = new byte[ico.getImageCount()];
            int i = 0;
            for (BitmapDescriptor bmd : ico.getDescriptors()) {
                int width = bmd.getWidth();
                if (width == 32) {
                    int n = i;
                    weights[n] = (byte)(weights[n] + 3);
                } else if (width == 16) {
                    int n = i;
                    weights[n] = (byte)(weights[n] + 1);
                } else {
                    int n = i;
                    weights[n] = (byte)(weights[n] - 9);
                }
                int bpp = bmd.getBPP();
                if (bpp == 32) {
                    int n = i;
                    weights[n] = (byte)(weights[n] + 3);
                }
                if (bpp == 24) {
                    int n = i;
                    weights[n] = (byte)(weights[n] + 2);
                }
                if (bpp == 8) {
                    int n = i;
                    weights[n] = (byte)(weights[n] + 1);
                } else if (bpp <= 0) {
                    int n = i;
                    weights[n] = (byte)(weights[n] - 9);
                }
                ++i;
            }
            int maxind = 0;
            byte maxweight = 0;
            i = 0;
            while (i < weights.length) {
                if (weights[i] > maxweight) {
                    maxweight = weights[i];
                    maxind = i;
                }
                ++i;
            }
            BitmapDescriptor bmd = ico.getDescriptor(maxind);
            ico.getDescriptors().clear();
            ico.getDescriptors().add(bmd);
        }
    }

    public static void OpenDesktopEditor(File file) {
        try {
            Desktop.getDesktop().edit(file);
        }
        catch (UnsupportedOperationException e) {
            JOptionPane.showMessageDialog(LGM.frame, Messages.getString("ExternalEditorDialog.NOT_SUPPORTED_MESSAGE"), Messages.getString("ExternalEditorDialog.NOT_SUPPORTED_TITLE"), 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(LGM.frame, Messages.getString("ExternalEditorDialog.FAILED_MESSAGE"), Messages.getString("ExternalEditorDialog.FAILED_TITLE"), 0);
        }
    }

    public static boolean stringEndsWith(String str, String suffix) {
        if (suffix == null || str == null) {
            return false;
        }
        return str.endsWith(suffix);
    }

    public static void orientSplit(JSplitPane orientationSplit, boolean reverse, Component left, Component right) {
        orientationSplit.setLeftComponent(reverse ? right : left);
        orientationSplit.setRightComponent(reverse ? left : right);
        if (reverse) {
            orientationSplit.setResizeWeight(1.0 - orientationSplit.getResizeWeight());
        }
    }

    public static boolean directoryDelete(File f) {
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File c = fileArray[n2];
                if (!Util.directoryDelete(c)) {
                    return false;
                }
                ++n2;
            }
        }
        return f.delete();
    }

    public static interface InherentlyUnique<E extends InherentlyUnique<E>> {
        public boolean isEqual(E var1);
    }

    private static class InvokeOnceRunnable
    implements Runnable {
        private final ArrayList<Runnable> queue = new ArrayList();
        private boolean inDispatcher = false;

        private InvokeOnceRunnable() {
        }

        public synchronized void add(Runnable r) {
            if (this.queue.contains(r)) {
                return;
            }
            this.queue.add(r);
            if (!this.inDispatcher) {
                SwingUtilities.invokeLater(this);
                this.inDispatcher = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable[] q;
            InvokeOnceRunnable invokeOnceRunnable = this;
            synchronized (invokeOnceRunnable) {
                this.inDispatcher = false;
                q = new Runnable[this.queue.size()];
                q = this.queue.toArray(q);
                this.queue.clear();
            }
            Runnable[] runnableArray = q;
            int n = q.length;
            int n2 = 0;
            while (n2 < n) {
                Runnable r = runnableArray[n2];
                r.run();
                ++n2;
            }
        }
    }
}

