/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.main;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.lateralgm.util.SetTraverser;

public class UpdateSource {
    public final Object owner;
    private WeakHashMap<UpdateListener, WeakReference<UpdateListener>> weakReferences;
    private final HardListenerTraverser hardTraverser;
    private final WeakListenerTraverser weakTraverser;

    public UpdateSource(Object owner, UpdateTrigger t) {
        t.setSource(this);
        this.owner = owner;
        this.hardTraverser = new HardListenerTraverser();
        this.weakTraverser = new WeakListenerTraverser();
    }

    public void addListener(UpdateListener l, boolean weak) {
        if (weak) {
            if (this.weakReferences == null) {
                this.weakReferences = new WeakHashMap();
            } else if (this.weakReferences.containsKey(l)) {
                return;
            }
            WeakReference<UpdateListener> r = new WeakReference<UpdateListener>(l);
            this.weakReferences.put(l, r);
            this.weakTraverser.add(r);
        } else {
            this.hardTraverser.add(l);
        }
    }

    public void addListener(UpdateListener l) {
        this.addListener(l, true);
    }

    public void removeListener(UpdateListener l) {
        WeakReference<UpdateListener> r;
        if (this.weakReferences != null && (r = this.weakReferences.remove(l)) != null) {
            this.weakTraverser.remove(r);
        }
        this.hardTraverser.remove(l);
    }

    private void fireUpdate(UpdateEvent e) {
        this.weakTraverser.traverse(e);
        this.hardTraverser.traverse(e);
    }

    private class HardListenerTraverser
    extends SetTraverser<UpdateListener, UpdateEvent> {
        private HardListenerTraverser() {
        }

        @Override
        protected void visit(UpdateListener l, UpdateEvent e) {
            l.updated(e);
        }
    }

    public static class UpdateEvent {
        public final UpdateSource source;
        public final UpdateEvent cause;

        public UpdateEvent(UpdateSource s) {
            this(s, null);
        }

        public UpdateEvent(UpdateSource s, UpdateEvent e) {
            this.source = s;
            this.cause = e;
        }
    }

    public static interface UpdateListener {
        public void updated(UpdateEvent var1);
    }

    public static class UpdateTrigger {
        private UpdateSource source;
        private UpdateEvent event;

        private void setSource(UpdateSource s) {
            if (this.source != null) {
                throw new IllegalStateException();
            }
            this.source = s;
        }

        public void fire() {
            if (this.event == null) {
                this.event = new UpdateEvent(this.source);
            }
            this.source.fireUpdate(this.event);
        }

        public void fire(UpdateEvent e) {
            this.source.fireUpdate(e);
        }

        public UpdateEvent getEvent() {
            if (this.event == null) {
                this.event = new UpdateEvent(this.source);
            }
            return this.event;
        }
    }

    private class WeakListenerTraverser
    extends SetTraverser<WeakReference<UpdateListener>, UpdateEvent> {
        private WeakListenerTraverser() {
        }

        @Override
        protected void visit(WeakReference<UpdateListener> r, UpdateEvent e) {
            UpdateListener l = (UpdateListener)r.get();
            if (l == null) {
                this.remove(r);
            } else {
                l.updated(e);
            }
        }
    }
}

