/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lateralgm.components.CodeTextArea;
import org.lateralgm.components.CustomJToolBar;
import org.lateralgm.components.HintTextField;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.Script;
import org.lateralgm.resources.Shader;
import org.lateralgm.resources.Timeline;
import org.lateralgm.resources.sub.Action;
import org.lateralgm.resources.sub.Argument;
import org.lateralgm.resources.sub.Event;
import org.lateralgm.resources.sub.Instance;
import org.lateralgm.resources.sub.MainEvent;
import org.lateralgm.resources.sub.Moment;
import org.lateralgm.subframes.ActionFrame;
import org.lateralgm.subframes.CodeFrame;
import org.lateralgm.subframes.GmObjectFrame;
import org.lateralgm.subframes.ResourceFrame;
import org.lateralgm.subframes.RoomFrame;
import org.lateralgm.subframes.ScriptFrame;
import org.lateralgm.subframes.ShaderFrame;
import org.lateralgm.subframes.TimelineFrame;

public class Search {
    static JTextField filterText;
    private static JCheckBox matchCaseCB;
    private static JCheckBox regexCB;
    static JCheckBox wholeWordCB;
    static JCheckBox pruneResultsCB;
    private static JButton closeButton;
    private static final Pattern NEWLINE;

    static {
        NEWLINE = Pattern.compile("\r\n|\r|\n");
    }

    private Search() {
    }

    private static boolean expressionMatch(String token, String expression, boolean matchCase, boolean wholeWord) {
        if (!matchCase) {
            token = token.toLowerCase();
            expression = expression.toLowerCase();
        }
        if (wholeWord) {
            return token.equals(expression);
        }
        return token.contains(expression);
    }

    public static DefaultMutableTreeNode applyFilterRecursion(Vector<ResNode> children, boolean filter, String expression, boolean matchCase, boolean wholeWord) {
        if (children == null) {
            return null;
        }
        DefaultMutableTreeNode firstResult = null;
        for (ResNode child : children) {
            boolean match = Search.expressionMatch(child.toString(), expression, matchCase, wholeWord);
            if (firstResult == null && match) {
                firstResult = child;
            }
            DefaultMutableTreeNode childResult = Search.applyFilterRecursion(child.getChildren(), filter, expression, matchCase, wholeWord);
            if (firstResult == null && childResult != null) {
                firstResult = childResult;
            }
            if (childResult != null || match) {
                child.setVisible(true);
                continue;
            }
            child.setVisible(false);
        }
        return firstResult;
    }

    public static boolean applyFilter(Vector<ResNode> children, boolean filter, String expression, boolean matchCase, boolean wholeWord, boolean selectFirst) {
        if (children == null) {
            return false;
        }
        DefaultMutableTreeNode firstResult = Search.applyFilterRecursion(children, filter, expression, matchCase, wholeWord);
        if (firstResult != null && selectFirst) {
            LGM.tree.setSelectionPath(new TreePath(firstResult.getPath()));
            LGM.tree.updateUI();
            return true;
        }
        LGM.tree.updateUI();
        return false;
    }

    public static boolean searchFilter(ResNode child, String expression, boolean matchCase, boolean wholeWord, boolean backwards) {
        DefaultMutableTreeNode firstResult = null;
        while (child != null) {
            child = backwards ? (ResNode)child.getPreviousNode() : (ResNode)child.getNextNode();
            if (child == null) break;
            boolean match = Search.expressionMatch(child.toString(), expression, matchCase, wholeWord);
            if (firstResult != null || !match) continue;
            firstResult = child;
            break;
        }
        if (firstResult != null) {
            LGM.tree.setSelectionPath(new TreePath(firstResult.getPath()));
            LGM.tree.updateUI();
            return true;
        }
        return false;
    }

    private static String formatMatchCountText(String pretext, int matches) {
        boolean enablehtml = Prefs.highlightMatchCountBackground || Prefs.highlightMatchCountForeground;
        String text = String.valueOf(enablehtml ? "<html>" : "") + pretext + " " + (enablehtml ? "<font" : "");
        if (Prefs.highlightMatchCountBackground) {
            text = String.valueOf(text) + " bgcolor='" + Util.getHTMLColor(Prefs.matchCountBackgroundColor, false) + "'";
        }
        if (Prefs.highlightMatchCountForeground) {
            text = String.valueOf(text) + " color='" + Util.getHTMLColor(Prefs.matchCountForegroundColor, false) + "'";
        }
        text = String.valueOf(text) + (enablehtml ? ">" : "") + "(" + matches + " " + Messages.getString("TreeFilter.MATCHES") + ")" + (enablehtml ? "</font></html>" : "");
        return text;
    }

    static List<LineMatch> getMatchingLines(String code, Pattern content) {
        ArrayList<LineMatch> res = new ArrayList<LineMatch>();
        Matcher m = content.matcher(code);
        Matcher nl = NEWLINE.matcher(code);
        int lineNum = 0;
        int lineAt = 0;
        int lastEnd = -1;
        LineMatch lastMatch = null;
        while (m.find()) {
            nl.region(lineAt, m.start());
            int firstSkippedLineAt = lineAt;
            if (nl.find()) {
                firstSkippedLineAt = nl.start();
                lineAt = nl.end();
                ++lineNum;
                while (nl.find()) {
                    ++lineNum;
                    lineAt = nl.end();
                }
            }
            if (lastMatch != null) {
                if (lineNum == lastMatch.lineNum) {
                    lastMatch.matchedText.add(new MatchBlock(code.substring(lastEnd, m.start()), false));
                    lastMatch.matchedText.add(new MatchBlock(code.substring(m.start(), m.end()), true));
                } else {
                    lastMatch.matchedText.add(new MatchBlock(code.substring(lastEnd, firstSkippedLineAt), false));
                }
            }
            if (lastMatch == null || lineNum != lastMatch.lineNum) {
                lastMatch = new LineMatch();
                lastMatch.lineNum = lineNum;
                if (m.start() > lineAt) {
                    lastMatch.matchedText.add(new MatchBlock(code.substring(lineAt, m.start()), false));
                }
                lastMatch.matchedText.add(new MatchBlock(code.substring(m.start(), m.end()), true));
                res.add(lastMatch);
            }
            lastEnd = m.end();
        }
        if (lastMatch != null) {
            nl.region(lastEnd, code.length());
            int indTo = nl.find() ? nl.start() : code.length();
            lastMatch.matchedText.add(new MatchBlock(code.substring(lastEnd, indTo), false));
        }
        return res;
    }

    public static void buildSearchHierarchy(ResNode resNode, SearchResultNode resultRoot) {
        DefaultMutableTreeNode searchNode = (DefaultMutableTreeNode)LGM.searchTree.getModel().getRoot();
        if (resNode == null) {
            searchNode.add(resultRoot);
            return;
        }
        TreeNode[] paths = resNode.getPath();
        int n = 1;
        while (n < paths.length - 1) {
            ResNode pathNode = (ResNode)paths[n];
            boolean found = false;
            int y = 0;
            while (y < searchNode.getChildCount()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)searchNode.getChildAt(y);
                if (childNode.getUserObject() == pathNode.getUserObject()) {
                    searchNode = childNode;
                    found = true;
                    break;
                }
                ++y;
            }
            if (!found) {
                SearchResultNode newSearchNode = new SearchResultNode(pathNode.getUserObject());
                newSearchNode.status = pathNode.status;
                searchNode.add(newSearchNode);
                searchNode = newSearchNode;
            }
            if (pathNode == resNode.getParent()) {
                searchNode.insert(resultRoot, searchNode.getChildCount() + resNode.getDepth());
            }
            ++n;
        }
    }

    public static ArrayList<SearchResultNode> searchInAction(Action act, Pattern pattern) {
        ArrayList<SearchResultNode> resultNodes = new ArrayList<SearchResultNode>();
        List<Argument> args = act.getArguments();
        int i = 0;
        while (i < args.size()) {
            Argument arg = args.get(i);
            Resource<?, ?> ares = Util.deRef(arg.getRes());
            String code = ares == null ? arg.getVal() : ares.getName();
            List<LineMatch> matches = Search.getMatchingLines(code, pattern);
            for (LineMatch match : matches) {
                if (match.matchedText.size() <= 0) continue;
                String text = match.toHighlightableString();
                SearchResultNode resultNode = null;
                if (act.getLibAction().actionKind != 7) {
                    boolean enablehtml = Prefs.highlightResultMatchBackground || Prefs.highlightResultMatchForeground;
                    text = String.valueOf(enablehtml ? "<html>" : "") + Integer.toString(i) + text.substring(text.indexOf(":"), text.length());
                    resultNode = new SearchResultNode(text);
                    resultNode.data = new Object[]{i};
                } else {
                    resultNode = new SearchResultNode(text);
                    resultNode.data = new Object[]{match.lineNum};
                }
                resultNode.setIcon(LGM.getIconForKey("TreeFilter.RESULT"));
                resultNode.status = (byte)4;
                resultNodes.add(resultNode);
            }
            ++i;
        }
        return resultNodes;
    }

    public static void searchInResourcesRecursion(DefaultMutableTreeNode node, Pattern pattern) {
        int numChildren = node.getChildCount();
        int i = 0;
        while (i < numChildren) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child instanceof ResNode) {
                ResNode resNode = (ResNode)child;
                if (resNode.status != 3) {
                    Search.searchInResourcesRecursion(child, pattern);
                } else {
                    SearchResultNode resultRoot = null;
                    ResourceReference<Resource<?, ?>> ref = resNode.getRes();
                    if (ref != null) {
                        InstantiableResource res;
                        Resource<Object, Object> resderef = ref.get();
                        if (resNode.frame != null) {
                            resNode.frame.commitChanges();
                            resderef = resNode.frame.res;
                        }
                        if (resNode.kind == Script.class) {
                            res = (Script)resderef;
                            String code = ((Script)res).getCode();
                            List<LineMatch> matches = Search.getMatchingLines(code, pattern);
                            if (matches.size() > 0) {
                                resultRoot = new SearchResultNode(Search.formatMatchCountText(res.getName(), matches.size()));
                                resultRoot.ref = ((Script)res).reference;
                                resultRoot.status = (byte)3;
                                resultRoot.setIcon(res.getNode().getIcon());
                                for (LineMatch match : matches) {
                                    if (match.matchedText.size() <= 0) continue;
                                    String text = match.toHighlightableString();
                                    SearchResultNode resultNode2 = new SearchResultNode(text);
                                    resultNode2.setIcon(LGM.getIconForKey("TreeFilter.RESULT"));
                                    resultNode2.status = (byte)4;
                                    resultNode2.data = new Object[]{match.lineNum};
                                    resultRoot.add(resultNode2);
                                }
                            }
                        } else if (resNode.kind == Shader.class) {
                            res = (Shader)resderef;
                            String vcode = ((Shader)res).getVertexCode();
                            String fcode = ((Shader)res).getFragmentCode();
                            List<LineMatch> vertexmatches = Search.getMatchingLines(vcode, pattern);
                            List<LineMatch> fragmentmatches = Search.getMatchingLines(fcode, pattern);
                            if (vertexmatches.size() + fragmentmatches.size() > 0) {
                                String text;
                                resultRoot = new SearchResultNode(Search.formatMatchCountText(res.getName(), vertexmatches.size() + fragmentmatches.size()));
                                resultRoot.ref = ((Shader)res).reference;
                                resultRoot.status = (byte)3;
                                resultRoot.setIcon(res.getNode().getIcon());
                                SearchResultNode resultGroupNode = new SearchResultNode(Search.formatMatchCountText(String.valueOf(Messages.getString("TreeFilter.VERTEX_CODE")) + ":", vertexmatches.size()));
                                resultGroupNode.status = (byte)8;
                                resultRoot.add(resultGroupNode);
                                for (LineMatch match : vertexmatches) {
                                    if (match.matchedText.size() <= 0) continue;
                                    text = match.toHighlightableString();
                                    SearchResultNode searchResultNode = new SearchResultNode(text);
                                    searchResultNode.setIcon(LGM.getIconForKey("TreeFilter.RESULT"));
                                    searchResultNode.status = (byte)4;
                                    searchResultNode.data = new Object[]{match.lineNum};
                                    resultGroupNode.add(searchResultNode);
                                }
                                resultGroupNode = new SearchResultNode(Search.formatMatchCountText(String.valueOf(Messages.getString("TreeFilter.FRAGMENT_CODE")) + ":", fragmentmatches.size()));
                                resultGroupNode.status = (byte)9;
                                resultRoot.add(resultGroupNode);
                                for (LineMatch match : fragmentmatches) {
                                    if (match.matchedText.size() <= 0) continue;
                                    text = match.toHighlightableString();
                                    SearchResultNode searchResultNode = new SearchResultNode(text);
                                    searchResultNode.setIcon(LGM.getIconForKey("TreeFilter.RESULT"));
                                    searchResultNode.status = (byte)4;
                                    searchResultNode.data = new Object[]{match.lineNum};
                                    resultGroupNode.add(searchResultNode);
                                }
                            }
                        } else if (resNode.kind == GmObject.class) {
                            res = (GmObject)resderef;
                            ArrayList<SearchResultNode> meNodes = new ArrayList<SearchResultNode>();
                            int matchCount = 0;
                            for (MainEvent me : ((GmObject)res).mainEvents) {
                                ArrayList<SearchResultNode> evNodes = new ArrayList<SearchResultNode>();
                                int meMatches = 0;
                                int n = 0;
                                for (Event ev : me.events) {
                                    n = ev.mainId;
                                    ArrayList<SearchResultNode> arrayList = new ArrayList<SearchResultNode>();
                                    int evMatches = 0;
                                    List actions = ev.actions;
                                    int ii = 0;
                                    while (ii < actions.size()) {
                                        Action act = (Action)actions.get(ii);
                                        ArrayList<SearchResultNode> resultNodes = Search.searchInAction(act, pattern);
                                        evMatches += resultNodes.size();
                                        if (resultNodes.size() > 0) {
                                            SearchResultNode actRoot = new SearchResultNode(Search.formatMatchCountText(act.getLibAction().name.replace("_", " "), resultNodes.size()));
                                            actRoot.status = (byte)10;
                                            actRoot.data = new Object[]{ii};
                                            actRoot.setIcon(new ImageIcon(act.getLibAction().actImage.getScaledInstance(16, 16, 0)));
                                            for (SearchResultNode actn : resultNodes) {
                                                actRoot.add(actn);
                                            }
                                            arrayList.add(actRoot);
                                        }
                                        ++ii;
                                    }
                                    meMatches += evMatches;
                                    if (arrayList.size() <= 0) continue;
                                    SearchResultNode evRoot = new SearchResultNode(Search.formatMatchCountText(ev.toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;"), evMatches));
                                    evRoot.status = (byte)6;
                                    evRoot.setIcon(LGM.getIconForKey("EventNode.EVENT" + ev.mainId));
                                    evRoot.data = new Object[]{ev.mainId, ev.id};
                                    for (SearchResultNode resn2 : arrayList) {
                                        evRoot.add(resn2);
                                    }
                                    evNodes.add(evRoot);
                                }
                                matchCount += meMatches;
                                if (evNodes.size() <= 0) continue;
                                if (evNodes.size() > 1) {
                                    SearchResultNode meRoot = new SearchResultNode(Search.formatMatchCountText(Messages.getString("MainEvent.EVENT" + n), meMatches));
                                    meRoot.status = (byte)5;
                                    meRoot.setIcon(LGM.getIconForKey("EventNode.GROUP" + n));
                                    for (SearchResultNode searchResultNode : evNodes) {
                                        meRoot.add(searchResultNode);
                                    }
                                    meNodes.add(meRoot);
                                    continue;
                                }
                                for (SearchResultNode resn4 : evNodes) {
                                    meNodes.add(resn4);
                                }
                            }
                            if (meNodes.size() > 0) {
                                resultRoot = new SearchResultNode(Search.formatMatchCountText(res.getName(), matchCount));
                                resultRoot.ref = ((GmObject)res).reference;
                                resultRoot.status = (byte)3;
                                resultRoot.setIcon(res.getNode().getIcon());
                            }
                            for (SearchResultNode resn : meNodes) {
                                resultRoot.add(resn);
                            }
                        } else if (resNode.kind == Timeline.class) {
                            res = (Timeline)resderef;
                            ArrayList<SearchResultNode> momentNodes = new ArrayList<SearchResultNode>();
                            int matchCount = 0;
                            for (Moment mom : ((Timeline)res).moments) {
                                ArrayList<SearchResultNode> actionNodes = new ArrayList<SearchResultNode>();
                                int momentMatches = 0;
                                List list = mom.actions;
                                int ii = 0;
                                while (ii < list.size()) {
                                    Action action = (Action)list.get(ii);
                                    ArrayList<SearchResultNode> arrayList = Search.searchInAction(action, pattern);
                                    momentMatches += arrayList.size();
                                    if (arrayList.size() > 0) {
                                        SearchResultNode actRoot = new SearchResultNode(Search.formatMatchCountText(action.getLibAction().name.replace("_", " "), arrayList.size()));
                                        actRoot.status = (byte)10;
                                        actRoot.data = new Object[]{ii};
                                        actRoot.setIcon(new ImageIcon(action.getLibAction().actImage.getScaledInstance(16, 16, 0)));
                                        for (SearchResultNode actn : arrayList) {
                                            actRoot.add(actn);
                                        }
                                        actionNodes.add(actRoot);
                                    }
                                    ++ii;
                                }
                                matchCount += momentMatches;
                                if (actionNodes.size() <= 0) continue;
                                SearchResultNode momentRoot = new SearchResultNode(Search.formatMatchCountText(mom.toString(), momentMatches));
                                momentRoot.status = (byte)7;
                                momentRoot.data = new Object[]{mom.stepNo};
                                momentRoot.setIcon(null);
                                for (SearchResultNode searchResultNode : actionNodes) {
                                    momentRoot.add(searchResultNode);
                                }
                                momentNodes.add(momentRoot);
                            }
                            if (momentNodes.size() > 0) {
                                resultRoot = new SearchResultNode(Search.formatMatchCountText(res.getName(), matchCount));
                                resultRoot.ref = ((Timeline)res).reference;
                                resultRoot.status = (byte)3;
                                resultRoot.setIcon(res.getNode().getIcon());
                            }
                            for (SearchResultNode momn : momentNodes) {
                                resultRoot.add(momn);
                            }
                        } else if (resNode.kind == Room.class) {
                            res = (Room)resderef;
                            ArrayList<SearchResultNode> resultNodes = new ArrayList<SearchResultNode>();
                            int matchCount = 0;
                            String code = ((Room)res).getCode();
                            List<LineMatch> matches = Search.getMatchingLines(code, pattern);
                            matchCount += matches.size();
                            ArrayList<SearchResultNode> codeNodes = new ArrayList<SearchResultNode>();
                            for (LineMatch match : matches) {
                                if (match.matchedText.size() <= 0) continue;
                                String text = match.toHighlightableString();
                                SearchResultNode searchResultNode = new SearchResultNode(text);
                                searchResultNode.setIcon(LGM.getIconForKey("TreeFilter.RESULT"));
                                searchResultNode.status = (byte)4;
                                searchResultNode.data = new Object[]{match.lineNum};
                                codeNodes.add(searchResultNode);
                            }
                            if (codeNodes.size() > 0) {
                                SearchResultNode resultNode3 = new SearchResultNode(Search.formatMatchCountText(Messages.getString("TreeFilter.CREATION_CODE"), matches.size()));
                                resultNode3.setIcon(null);
                                resultNode3.status = (byte)11;
                                resultNodes.add(resultNode3);
                                for (SearchResultNode searchResultNode : codeNodes) {
                                    resultNode3.add(searchResultNode);
                                }
                            }
                            for (Instance inst : ((Room)res).instances) {
                                code = inst.getCode();
                                matches = Search.getMatchingLines(code, pattern);
                                matchCount += matches.size();
                                codeNodes = new ArrayList();
                                for (LineMatch match : matches) {
                                    if (match.matchedText.size() <= 0) continue;
                                    String string = match.toHighlightableString();
                                    SearchResultNode resultNode4 = new SearchResultNode(string);
                                    resultNode4.setIcon(LGM.getIconForKey("TreeFilter.RESULT"));
                                    resultNode4.data = new Object[]{match.lineNum};
                                    resultNode4.status = (byte)4;
                                    codeNodes.add(resultNode4);
                                }
                                if (codeNodes.size() <= 0) continue;
                                SearchResultNode resultNode5 = new SearchResultNode(Search.formatMatchCountText(String.valueOf(Messages.getString("TreeFilter.INSTANCE")) + " " + inst.getID(), matches.size()));
                                Object r = ((ResourceReference)inst.properties.get(Instance.PInstance.OBJECT)).get();
                                resultNode5.setIcon(r == null ? null : ((Resource)r).getNode().getIcon());
                                resultNode5.status = (byte)12;
                                resultNode5.data = new Object[]{inst.getID()};
                                resultNodes.add(resultNode5);
                                for (SearchResultNode searchResultNode : codeNodes) {
                                    resultNode5.add(searchResultNode);
                                }
                            }
                            if (resultNodes.size() > 0) {
                                resultRoot = new SearchResultNode(Search.formatMatchCountText(res.getName(), matchCount));
                                resultRoot.ref = ((Room)res).reference;
                                resultRoot.status = (byte)3;
                                resultRoot.setIcon(res.getNode().getIcon());
                            }
                            for (SearchResultNode resultNode6 : resultNodes) {
                                resultRoot.add(resultNode6);
                            }
                        }
                        if (resultRoot != null) {
                            TreeNode[] paths = resNode.getPath();
                            DefaultMutableTreeNode searchNode = (DefaultMutableTreeNode)LGM.searchTree.getModel().getRoot();
                            int n = 1;
                            while (n < paths.length - 1) {
                                ResNode pathNode = (ResNode)paths[n];
                                boolean found = false;
                                int y = 0;
                                while (y < searchNode.getChildCount()) {
                                    DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)searchNode.getChildAt(y);
                                    if (childNode.getUserObject() == pathNode.getUserObject()) {
                                        searchNode = childNode;
                                        found = true;
                                        break;
                                    }
                                    ++y;
                                }
                                if (!found) {
                                    SearchResultNode newSearchNode = new SearchResultNode(pathNode.getUserObject());
                                    newSearchNode.status = pathNode.status;
                                    searchNode.add(newSearchNode);
                                    searchNode = newSearchNode;
                                }
                                if (pathNode == resNode.getParent()) {
                                    searchNode.add(resultRoot);
                                }
                                ++n;
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    public static void searchInResources(DefaultMutableTreeNode node, String expression, boolean regex, boolean matchCase, boolean wholeWord) {
        DefaultMutableTreeNode searchRoot = (DefaultMutableTreeNode)LGM.searchTree.getModel().getRoot();
        searchRoot.removeAllChildren();
        Pattern pattern = Pattern.compile(wholeWord ? "\\b" + Pattern.quote(expression) + "\\b" : (regex ? expression : Pattern.quote(expression)), matchCase ? 0 : 2);
        Search.searchInResourcesRecursion(node, pattern);
        ((DefaultTreeModel)LGM.searchTree.getModel()).reload();
    }

    private static JDialog createFilterSettingsDialog() {
        String title = Messages.getString("TreeFilter.TITLE");
        final JDialog filterSettings = new JDialog(LGM.frame, title, false);
        filterSettings.setIconImage(LGM.getIconForKey("TreeFilter.ICON").getImage());
        filterSettings.setResizable(false);
        wholeWordCB = new JCheckBox(Messages.getString("TreeFilter.WHOLEWORD"));
        wholeWordCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InvisibleTreeModel ml = (InvisibleTreeModel)LGM.tree.getModel();
                Search.applyFilter(LGM.root.getChildren(), ml.isActivatedFilter(), filterText.getText(), matchCaseCB.isSelected(), wholeWordCB.isSelected(), false);
            }
        });
        regexCB = new JCheckBox(Messages.getString("TreeFilter.REGEX"));
        regexCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InvisibleTreeModel ml = (InvisibleTreeModel)LGM.tree.getModel();
                Search.applyFilter(LGM.root.getChildren(), ml.isActivatedFilter(), filterText.getText(), matchCaseCB.isSelected(), wholeWordCB.isSelected(), false);
            }
        });
        matchCaseCB = new JCheckBox(Messages.getString("TreeFilter.MATCHCASE"));
        matchCaseCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InvisibleTreeModel ml = (InvisibleTreeModel)LGM.tree.getModel();
                Search.applyFilter(LGM.root.getChildren(), ml.isActivatedFilter(), filterText.getText(), matchCaseCB.isSelected(), wholeWordCB.isSelected(), false);
            }
        });
        pruneResultsCB = new JCheckBox(Messages.getString("TreeFilter.PRUNERESULTS"));
        pruneResultsCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InvisibleTreeModel ml = (InvisibleTreeModel)LGM.tree.getModel();
                ml.activateFilter(pruneResultsCB.isSelected());
                Search.applyFilter(LGM.root.getChildren(), ml.isActivatedFilter(), filterText.getText(), false, wholeWordCB.isSelected(), false);
            }
        });
        closeButton = new JButton(Messages.getString("TreeFilter.CLOSE"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                filterSettings.setVisible(false);
            }
        });
        filterSettings.getRootPane().setDefaultButton(closeButton);
        JPanel panel = new JPanel();
        GroupLayout gl = new GroupLayout(panel);
        gl.setAutoCreateGaps(true);
        gl.setAutoCreateContainerGaps(true);
        panel.setLayout(gl);
        filterSettings.getContentPane().setLayout(new GridBagLayout());
        filterSettings.add(panel);
        gl.setHorizontalGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup().addComponent(wholeWordCB).addComponent(matchCaseCB)).addGroup(gl.createParallelGroup().addComponent(regexCB).addComponent(pruneResultsCB))).addComponent(closeButton));
        gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addComponent(wholeWordCB).addComponent(matchCaseCB)).addGroup(gl.createSequentialGroup().addComponent(regexCB).addComponent(pruneResultsCB))).addComponent(closeButton));
        filterSettings.pack();
        filterSettings.setLocationRelativeTo(LGM.frame);
        return filterSettings;
    }

    public static JToolBar createSearchToolbar() {
        CustomJToolBar toolbar = new CustomJToolBar();
        final JDialog filterSettingsDialog = Search.createFilterSettingsDialog();
        filterText = new HintTextField(Messages.getString("TreeFilter.SEARCHFOR"), true);
        JButton prevButton = new JButton(LGM.getIconForKey("TreeFilter.PREV"));
        prevButton.setToolTipText(Messages.getString("TreeFilter.PREV"));
        prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Search.searchFilter((ResNode)LGM.tree.getLastSelectedPathComponent(), filterText.getText(), matchCaseCB.isSelected(), wholeWordCB.isSelected(), true);
            }
        });
        JButton nextButton = new JButton(LGM.getIconForKey("TreeFilter.NEXT"));
        nextButton.setToolTipText(Messages.getString("TreeFilter.NEXT"));
        nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Search.searchFilter((ResNode)LGM.tree.getLastSelectedPathComponent(), filterText.getText(), matchCaseCB.isSelected(), wholeWordCB.isSelected(), false);
            }
        });
        JButton searchInButton = new JButton(LGM.getIconForKey("TreeFilter.SEARCHIN"));
        searchInButton.setToolTipText(Messages.getString("TreeFilter.SEARCHIN"));
        searchInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (filterText.getText().length() <= 0) {
                    return;
                }
                InvisibleTreeModel ml = (InvisibleTreeModel)LGM.tree.getModel();
                Search.searchInResources((DefaultMutableTreeNode)ml.getRoot(), filterText.getText(), regexCB.isSelected(), matchCaseCB.isSelected(), wholeWordCB.isSelected());
                LGM.setSelectedTab(LGM.treeTabs, Messages.getString("TreeFilter.TAB_SEARCHRESULTS"));
            }
        });
        JButton setButton = new JButton(LGM.getIconForKey("TreeFilter.SET"));
        setButton.setToolTipText(Messages.getString("TreeFilter.SET"));
        setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                filterSettingsDialog.setVisible(true);
            }
        });
        filterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                InvisibleTreeModel ml = (InvisibleTreeModel)LGM.tree.getModel();
                if (ml.isActivatedFilter()) {
                    Search.applyFilter(LGM.root.getChildren(), ml.isActivatedFilter(), filterText.getText(), false, wholeWordCB.isSelected(), true);
                } else {
                    Search.searchFilter(LGM.root, filterText.getText(), matchCaseCB.isSelected(), wholeWordCB.isSelected(), false);
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                InvisibleTreeModel ml = (InvisibleTreeModel)LGM.tree.getModel();
                if (ml.isActivatedFilter()) {
                    Search.applyFilter(LGM.root.getChildren(), ml.isActivatedFilter(), filterText.getText(), false, wholeWordCB.isSelected(), true);
                } else {
                    Search.searchFilter(LGM.root, filterText.getText(), matchCaseCB.isSelected(), wholeWordCB.isSelected(), false);
                }
            }
        });
        filterText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (filterText.getText().length() <= 0) {
                    return;
                }
                InvisibleTreeModel ml = (InvisibleTreeModel)LGM.tree.getModel();
                Search.searchInResources((DefaultMutableTreeNode)ml.getRoot(), filterText.getText(), regexCB.isSelected(), matchCaseCB.isSelected(), wholeWordCB.isSelected());
                LGM.setSelectedTab(LGM.treeTabs, Messages.getString("TreeFilter.TAB_SEARCHRESULTS"));
            }
        });
        GroupLayout filterLayout = new GroupLayout(toolbar);
        filterLayout.setHorizontalGroup(filterLayout.createSequentialGroup().addComponent(filterText).addComponent(prevButton).addComponent(nextButton).addComponent(searchInButton).addComponent(setButton));
        filterLayout.setVerticalGroup(filterLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(filterText, -2, -2, -2).addComponent(prevButton).addComponent(nextButton).addComponent(searchInButton).addComponent(setButton));
        toolbar.setLayout(filterLayout);
        toolbar.setFloatable(true);
        toolbar.setVisible(Prefs.showTreeFilter);
        return toolbar;
    }

    public static JTree createSearchTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        final JTree tree = new JTree(root);
        final JPopupMenu searchMenu = new JPopupMenu();
        JMenuItem expandAllItem = new JMenuItem(Messages.getString("TreeFilter.EXPANDALL"));
        expandAllItem.setIcon(LGM.getIconForKey("TreeFilter.EXPANDALL"));
        expandAllItem.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("TreeFilter.EXPANDALL")));
        expandAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int i = 0;
                while (i < tree.getRowCount()) {
                    tree.expandRow(i);
                    ++i;
                }
            }
        });
        searchMenu.add(expandAllItem);
        JMenuItem collapseAllItem = new JMenuItem(Messages.getString("TreeFilter.COLLAPSEALL"));
        collapseAllItem.setIcon(LGM.getIconForKey("TreeFilter.COLLAPSEALL"));
        collapseAllItem.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("TreeFilter.COLLAPSEALL")));
        collapseAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ((DefaultTreeModel)tree.getModel()).reload();
            }
        });
        searchMenu.add(collapseAllItem);
        searchMenu.addSeparator();
        AbstractAction treeCopyAction = new AbstractAction("COPY"){
            private static final long serialVersionUID = 2505969552404421504L;

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object obj = ev.getSource();
                if (obj == null) {
                    return;
                }
                JTree tree = null;
                tree = !(obj instanceof JTree) ? LGM.searchTree : (JTree)obj;
                String text = "";
                int[] rows = tree.getSelectionRows();
                Arrays.sort(rows);
                int i = 0;
                while (i < rows.length) {
                    TreePath path = tree.getPathForRow(rows[i]);
                    text = String.valueOf(text) + (i > 0 ? "\n" : "") + path.getLastPathComponent().toString().replaceAll("\\<[^>]*>", "");
                    ++i;
                }
                StringSelection selection = new StringSelection(text);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }
        };
        JMenuItem copyItem = new JMenuItem();
        copyItem.setAction(treeCopyAction);
        copyItem.setText(Messages.getString("TreeFilter.COPY"));
        copyItem.setIcon(LGM.getIconForKey("TreeFilter.COPY"));
        copyItem.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("TreeFilter.COPY")));
        tree.getActionMap().put("COPY", treeCopyAction);
        tree.getInputMap().put(copyItem.getAccelerator(), "COPY");
        tree.getActionMap().put("COPY", treeCopyAction);
        tree.getInputMap().put(copyItem.getAccelerator(), "COPY");
        searchMenu.add(copyItem);
        searchMenu.addSeparator();
        JMenuItem selectAllItem = new JMenuItem(Messages.getString("TreeFilter.SELECTALL"));
        selectAllItem.setIcon(LGM.getIconForKey("TreeFilter.SELECTALL"));
        selectAllItem.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("TreeFilter.SELECTALL")));
        selectAllItem.addActionListener(new ActionListener(){

            public void selectAllChildren(JTree tree2, DefaultMutableTreeNode node) {
                Enumeration<TreeNode> children = node.children();
                DefaultMutableTreeNode it = null;
                while (children.hasMoreElements()) {
                    it = (DefaultMutableTreeNode)children.nextElement();
                    tree2.addSelectionPath(new TreePath(it.getPath()));
                    if (!tree2.isExpanded(new TreePath(it.getPath()))) continue;
                    this.selectAllChildren(tree2, it);
                }
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                this.selectAllChildren(tree, (DefaultMutableTreeNode)tree.getModel().getRoot());
            }
        });
        searchMenu.add(selectAllItem);
        tree.setToggleClickCount(0);
        tree.setCellRenderer(new SearchResultsRenderer());
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.getSelectionModel().setSelectionMode(4);
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                TreePath path = tree.getPathForLocation(me.getX(), me.getY());
                boolean inpath = false;
                if (path != null) {
                    TreePath[] paths = tree.getSelectionPaths();
                    if (paths != null) {
                        int i = 0;
                        while (i < paths.length) {
                            if (paths[i].equals(path)) {
                                inpath = true;
                            }
                            ++i;
                        }
                    }
                    if (me.getButton() == 1 && inpath) {
                        tree.setSelectionPath(path);
                    }
                }
                if (me.getButton() == 3 && me.getClickCount() == 1) {
                    if (!inpath && path != null) {
                        tree.setSelectionPath(path);
                    }
                    searchMenu.show((Component)me.getSource(), me.getX(), me.getY());
                    return;
                }
                if (path == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node == null) {
                    return;
                }
                if (me.getButton() == 1 && me.getClickCount() >= 2 && (me.getClickCount() & 1) == 0) {
                    if (node instanceof SearchResultNode) {
                        SearchResultNode srn = (SearchResultNode)node;
                        if (srn.status >= 3) {
                            srn.openFrame();
                            return;
                        }
                        if (tree.isExpanded(path)) {
                            tree.collapsePath(path);
                        } else {
                            tree.expandPath(path);
                        }
                    } else if (tree.isExpanded(path)) {
                        tree.collapsePath(path);
                    } else {
                        tree.expandPath(path);
                    }
                }
            }
        });
        return tree;
    }

    public static class InvisibleTreeModel
    extends DefaultTreeModel {
        private static final long serialVersionUID = -7759731037386264163L;
        protected boolean filterIsActive;

        public InvisibleTreeModel(TreeNode root) {
            this(root, false);
        }

        public InvisibleTreeModel(TreeNode root, boolean asksAllowsChildren) {
            this(root, false, false);
        }

        public InvisibleTreeModel(TreeNode root, boolean asksAllowsChildren, boolean filterIsActive) {
            super(root, asksAllowsChildren);
            this.filterIsActive = filterIsActive;
        }

        public void activateFilter(boolean newValue) {
            this.filterIsActive = newValue;
        }

        public boolean isActivatedFilter() {
            return this.filterIsActive;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (this.filterIsActive && parent instanceof ResNode) {
                return ((ResNode)parent).getChildAt(index, this.filterIsActive);
            }
            return ((TreeNode)parent).getChildAt(index);
        }

        @Override
        public int getChildCount(Object parent) {
            if (this.filterIsActive && parent instanceof ResNode) {
                return ((ResNode)parent).getChildCount(this.filterIsActive);
            }
            return ((TreeNode)parent).getChildCount();
        }
    }

    public static class LineMatch {
        public int lineNum;
        public List<MatchBlock> matchedText = new ArrayList<MatchBlock>();

        public String toHighlightableString() {
            boolean enablehtml = Prefs.highlightResultMatchBackground || Prefs.highlightResultMatchForeground;
            String text = String.valueOf(enablehtml ? "<html>" : "") + this.lineNum + ": ";
            for (MatchBlock block : this.matchedText) {
                if (block.highlighted && enablehtml) {
                    text = String.valueOf(text) + "<span";
                    if (Prefs.highlightResultMatchBackground) {
                        text = String.valueOf(text) + " bgcolor='" + Util.getHTMLColor(Prefs.resultMatchBackgroundColor, false) + "'";
                    }
                    if (Prefs.highlightResultMatchForeground) {
                        text = String.valueOf(text) + " color='" + Util.getHTMLColor(Prefs.resultMatchForegroundColor, false) + "'";
                    }
                    text = String.valueOf(text) + ">";
                }
                text = String.valueOf(text) + block.content;
                if (!block.highlighted || !enablehtml) continue;
                text = String.valueOf(text) + "</span>";
            }
            if (enablehtml) {
                text = String.valueOf(text) + "</html>";
            }
            return text;
        }
    }

    public static class MatchBlock {
        public String content;
        public boolean highlighted;

        MatchBlock(String content, boolean highlighted) {
            this.content = content;
            this.highlighted = highlighted;
        }
    }

    static class SearchResultNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -8827316922729826331L;
        public static final byte STATUS_RESULT = 4;
        public static final byte STATUS_MAIN_EVENT = 5;
        public static final byte STATUS_EVENT = 6;
        public static final byte STATUS_MOMENT = 7;
        public static final byte STATUS_VERTEX_CODE = 8;
        public static final byte STATUS_FRAGMENT_CODE = 9;
        public static final byte STATUS_ACTION = 10;
        public static final byte STATUS_ROOM_CREATION = 11;
        public static final byte STATUS_INSTANCE_CREATION = 12;
        public byte status;
        ResourceReference<?> ref;
        private Icon icon = null;
        Object[] data;
        Object[] parentdata;

        public SearchResultNode() {
        }

        public SearchResultNode(Object text) {
            super(text);
        }

        public void setIcon(Icon ico) {
            this.icon = ico;
        }

        public ResourceReference<?> getRef() {
            SearchResultNode par = (SearchResultNode)this.getParent();
            ResourceReference<?> ret = par.ref;
            while (ret == null) {
                par = (SearchResultNode)par.getParent();
                ret = par.ref;
            }
            return ret;
        }

        public void threadCaretUpdate(final CodeTextArea code, int row, int col) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    code.setCaretPosition((Integer)SearchResultNode.this.data[0], 0);
                    code.text.centerCaret();
                    code.repaint();
                }
            });
        }

        public void openFrame() {
            ResNode node;
            Object res;
            if (this.status >= 4) {
                DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)this.getParent();
                if (node2 instanceof SearchResultNode) {
                    ResourceFrame<?, ?> frame;
                    ResNode resNode;
                    Object res2;
                    SearchResultNode parNode = (SearchResultNode)node2;
                    parNode.openFrame();
                    ResourceReference<?> parentRef = this.getRef();
                    if (parentRef != null && (res2 = parentRef.get()) != null && (resNode = ((Resource)res2).getNode()) != null && (frame = resNode.frame) != null) {
                        if (resNode.kind == GmObject.class) {
                            GmObjectFrame objframe = (GmObjectFrame)frame;
                            if (this.status == 6) {
                                objframe.setSelectedEvent((Integer)this.data[0], (Integer)this.data[1]);
                            } else if (this.status == 10) {
                                objframe.actions.setSelectedIndex((Integer)this.data[0]);
                                Action act = (Action)objframe.actions.getSelectedValue();
                                if (act != null) {
                                    ActionFrame af = (ActionFrame)objframe.actions.openActionFrame(objframe, act);
                                    this.parentdata = new Object[]{af};
                                }
                            } else if (this.status == 4 && parNode.status == 10) {
                                ActionFrame af = (ActionFrame)parNode.parentdata[0];
                                Action act = af.getAction();
                                if (act.getLibAction().actionKind != 7) {
                                    af.focusArgumentComponent((Integer)this.data[0]);
                                } else if ((Integer)this.data[0] < af.code.getLineCount()) {
                                    this.threadCaretUpdate(af.code, (Integer)this.data[0], 0);
                                }
                            }
                        } else if (resNode.kind == Timeline.class) {
                            TimelineFrame tmlframe = (TimelineFrame)frame;
                            if (this.status == 7) {
                                tmlframe.setSelectedMoment((Integer)this.data[0]);
                            } else if (this.status == 10) {
                                tmlframe.actions.setSelectedIndex((Integer)this.data[0]);
                                Action act = (Action)tmlframe.actions.getSelectedValue();
                                if (act != null) {
                                    ActionFrame af = (ActionFrame)tmlframe.actions.openActionFrame(tmlframe, act);
                                    this.parentdata = new Object[]{af};
                                }
                            } else if (this.status == 4 && parNode.status == 10) {
                                ActionFrame af = (ActionFrame)parNode.parentdata[0];
                                Action act = af.getAction();
                                if (act.getLibAction().actionKind != 7) {
                                    af.focusArgumentComponent((Integer)this.data[0]);
                                } else if ((Integer)this.data[0] < af.code.getLineCount()) {
                                    this.threadCaretUpdate(af.code, (Integer)this.data[0], 0);
                                }
                            }
                        } else if (resNode.kind == Room.class) {
                            RoomFrame roomframe = (RoomFrame)frame;
                            if (this.status == 12) {
                                roomframe.tabs.setSelectedIndex(0);
                                this.parentdata = new Object[]{roomframe.openInstanceCodeFrame((Integer)this.data[0], true)};
                            } else if (this.status == 11) {
                                roomframe.tabs.setSelectedIndex(1);
                                this.parentdata = new Object[]{roomframe.openRoomCreationCode()};
                            } else if (this.status == 4 && (parNode.status == 12 || parNode.status == 11)) {
                                CodeFrame cf = (CodeFrame)parNode.parentdata[0];
                                if ((Integer)this.data[0] < cf.code.getLineCount()) {
                                    this.threadCaretUpdate(cf.code, (Integer)this.data[0], 0);
                                }
                            }
                        } else if (resNode.kind == Script.class) {
                            ScriptFrame scrframe = (ScriptFrame)frame;
                            if (this.status == 4 && (Integer)this.data[0] < scrframe.code.text.getLineCount()) {
                                this.threadCaretUpdate(scrframe.code, (Integer)this.data[0], 0);
                            }
                        } else if (resNode.kind == Shader.class) {
                            ShaderFrame shrframe = (ShaderFrame)frame;
                            if (this.status == 8) {
                                shrframe.editors.setSelectedIndex(0);
                            } else if (this.status == 9) {
                                shrframe.editors.setSelectedIndex(1);
                            } else if (this.status == 4) {
                                if (parNode.status == 8) {
                                    shrframe.vcode.requestFocusInWindow();
                                    if ((Integer)this.data[0] < shrframe.vcode.text.getLineCount()) {
                                        this.threadCaretUpdate(shrframe.vcode, (Integer)this.data[0], 0);
                                    }
                                } else if (parNode.status == 9) {
                                    shrframe.fcode.requestFocusInWindow();
                                    if ((Integer)this.data[0] < shrframe.fcode.text.getLineCount()) {
                                        this.threadCaretUpdate(shrframe.fcode, (Integer)this.data[0], 0);
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (this.status == 3 && this.ref != null && (res = this.ref.get()) != null && (node = ((Resource)res).getNode()) != null) {
                node.openFrame();
            }
        }
    }

    public static class SearchResultsRenderer
    extends DefaultTreeCellRenderer {
        SearchResultNode last;
        private Color nonSelectColor;
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof SearchResultNode) {
                this.last = (SearchResultNode)value;
            }
            this.setTextNonSelectionColor(this.nonSelectColor);
            Component com = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof SearchResultNode && com instanceof JLabel) {
                SearchResultNode rn = (SearchResultNode)value;
                JLabel label = (JLabel)com;
                if (rn.status == 1) {
                    label.setText("<html><b>" + label.getText() + "</b></html>");
                }
            }
            return com;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.nonSelectColor = this.getTextNonSelectionColor();
        }

        @Override
        public Icon getLeafIcon() {
            Icon icon;
            if (this.last != null && (icon = this.last.icon) != null) {
                return icon;
            }
            return null;
        }

        @Override
        public Icon getClosedIcon() {
            if (this.last != null) {
                if (this.last.status == 1 || this.last.status == 2) {
                    return LGM.getIconForKey("GmTreeGraphics.GROUP");
                }
                Icon icon = this.last.icon;
                if (icon != null) {
                    return icon;
                }
            }
            return null;
        }

        @Override
        public Icon getOpenIcon() {
            if (this.last != null) {
                if (this.last.status == 1 || this.last.status == 2) {
                    return LGM.getIconForKey("GmTreeGraphics.GROUP_OPEN");
                }
                Icon icon = this.last.icon;
                if (icon != null) {
                    return icon;
                }
            }
            return null;
        }
    }
}

