/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.main;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import org.lateralgm.main.Util;
import org.lateralgm.resources.Resource;

public final class Prefs {
    private static String BUNDLE_NAME = "org.lateralgm.main.preferences";
    private static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
    private static final Preferences PREFS = Preferences.userRoot().node("/org/lateralgm");
    public static String iconPack;
    public static String iconPath;
    public static String swingTheme;
    public static String swingThemePath;
    public static String documentationURI;
    public static String websiteURI;
    public static String communityURI;
    public static String issueURI;
    public static Locale locale;
    public static boolean showTreeFilter;
    public static boolean extraNodes;
    public static boolean restrictHierarchy;
    public static boolean renamableRoots;
    public static boolean groupKind;
    public static boolean iconizeGroup;
    public static Map<Class<? extends Resource<?, ?>>, String> prefixes;
    public static Font codeFont;
    public static int tabSize;
    public static int eventKeyInputAddKey;
    public static boolean boldPrimaryNodes;
    public static boolean rightOrientation;
    public static boolean enableDragAndDrop;
    public static boolean expandEventTree;
    public static String actionLibraryPath;
    public static String userLibraryPath;
    public static int actionToolTipColumns;
    public static int actionToolTipLines;
    public static int backupCopies;
    public static int backupMinutes;
    public static boolean backupSave;
    public static boolean backupAuto;
    public static boolean backupExit;
    public static boolean useExternalBackgroundEditor;
    public static String externalBackgroundEditorCommand;
    public static String externalBackgroundExtension;
    public static boolean useExternalSpriteEditor;
    public static String externalSpriteEditorCommand;
    public static String externalSpriteExtension;
    public static boolean useExternalScriptEditor;
    public static String externalScriptEditorCommand;
    public static String externalScriptExtension;
    public static boolean useExternalSoundEditor;
    public static String externalSoundEditorCommand;
    public static int undoHistorySize;
    public static int viewInsideColor;
    public static int viewOutsideColor;
    public static boolean useFilledRectangleForViews;
    public static boolean useInvertedColorForViews;
    public static int selectionInsideColor;
    public static int selectionOutsideColor;
    public static boolean useFilledRectangleForSelection;
    public static boolean useInvertedColorForSelection;
    public static int multipleSelectionInsideColor;
    public static int multipleSelectionOutsideColor;
    public static boolean useFilledRectangleForMultipleSelection;
    public static boolean useInvertedColorForMultipleSelection;
    public static int imagePreviewForegroundColor;
    public static int imagePreviewBackgroundColor;
    public static boolean highlightMatchCountBackground;
    public static boolean highlightMatchCountForeground;
    public static int matchCountBackgroundColor;
    public static int matchCountForegroundColor;
    public static boolean highlightResultMatchBackground;
    public static boolean highlightResultMatchForeground;
    public static int resultMatchBackgroundColor;
    public static int resultMatchForegroundColor;
    public static String antialiasControlFont;
    public static String openGLAcceleration;
    public static String direct3DAcceleration;
    public static boolean decorateWindowBorders;

    static {
        Prefs.loadPrefs();
        eventKeyInputAddKey = 92;
    }

    private Prefs() {
    }

    public static String getString(String key, String def) {
        String r;
        try {
            r = RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            r = def == null ? String.valueOf('!') + key + '!' : def;
        }
        return PREFS.get(key, r);
    }

    public static int getInt(String key, int def) {
        try {
            return Integer.parseInt(Prefs.getString(key, null));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static boolean getBoolean(String key, boolean def) {
        String ret = Prefs.getString(key, null).trim().toLowerCase();
        if (ret.startsWith("true")) {
            return true;
        }
        if (ret.startsWith("false")) {
            return false;
        }
        return def;
    }

    public static void loadPrefs() {
        if (new File("preferences.properties").exists()) {
            BUNDLE_NAME = "preferences.properties";
            RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
        }
        showTreeFilter = Prefs.getBoolean("showTreeFilter", true);
        extraNodes = Prefs.getBoolean("extraNodes", true);
        restrictHierarchy = Prefs.getBoolean("restrictHierarchy", true);
        renamableRoots = Prefs.getBoolean("renamableRoots", false);
        swingTheme = Prefs.getString("swingTheme", "Native");
        swingThemePath = Prefs.getString("swingThemePath", "");
        iconPack = Prefs.getString("iconPack", "Standard");
        iconPath = Prefs.getString("iconPath", "/icons/");
        groupKind = Prefs.getBoolean("groupKind", true);
        iconizeGroup = Prefs.getBoolean("iconizeGroup", false);
        String fontName = Prefs.getString("codeFontName", "Monospaced");
        codeFont = new Font(fontName, 0, Prefs.getInt("codeFontSize", 12));
        tabSize = Prefs.getInt("tabSize", 4);
        String d = "OBJ>obj_\tSPR>spr_\tSND>snd_\tRMM>rm_\t BKG>bkg_  PTH>path_\tSCR>scr_  SHR>shr_\t FNT>font_\tTML>time_";
        Prefs.createPrefixes(Prefs.getString("prefixes", d));
        String localeTag = Prefs.getString("localeTag", Locale.getDefault().toLanguageTag());
        locale = Locale.forLanguageTag(localeTag);
        documentationURI = Prefs.getString("documentationURI", "http://enigma-dev.org/docs/Wiki/Main_Page");
        websiteURI = Prefs.getString("websiteURI", "http://github.com/IsmAvatar/LateralGM");
        communityURI = Prefs.getString("communityURI", "http://enigma-dev.org/forums");
        issueURI = Prefs.getString("issueURI", "http://github.com/IsmAvatar/LateralGM/issues");
        enableDragAndDrop = Prefs.getBoolean("enableDragAndDrop", true);
        expandEventTree = Prefs.getBoolean("expandEventTree", true);
        rightOrientation = Prefs.getBoolean("rightOrientation", false);
        boldPrimaryNodes = Prefs.getBoolean("boldPrimaryNodes", true);
        actionLibraryPath = Prefs.getString("actionLibraryPath", "org/lateralgm/resources/library/default");
        userLibraryPath = Prefs.getString("userLibraryPath", "./lib");
        imagePreviewBackgroundColor = Prefs.getInt("imagePreviewBackgroundColor", new Color(224, 224, 224).getRGB());
        imagePreviewForegroundColor = Prefs.getInt("imagePreviewForegroundColor", new Color(172, 172, 172).getRGB());
        highlightMatchCountBackground = Prefs.getBoolean("highlightMatchCountBackground", false);
        highlightMatchCountForeground = Prefs.getBoolean("highlightMatchCountForeground", true);
        matchCountBackgroundColor = Prefs.getInt("matchCountBackgroundColor", Color.BLACK.getRGB());
        matchCountForegroundColor = Prefs.getInt("matchCountForegroundColor", Color.BLUE.getRGB());
        highlightResultMatchBackground = Prefs.getBoolean("highlightResultMatchBackground", true);
        highlightResultMatchForeground = Prefs.getBoolean("highlightResultMatchForeground", false);
        resultMatchBackgroundColor = Prefs.getInt("resultMatchBackgroundColor", Color.PINK.getRGB());
        resultMatchForegroundColor = Prefs.getInt("resultMatchForegroundColor", Color.WHITE.getRGB());
        antialiasControlFont = Prefs.getString("antialiasControlFont", "default");
        direct3DAcceleration = Prefs.getString("direct3DAcceleration", "off");
        openGLAcceleration = Prefs.getString("openGLAcceleration", "off");
        decorateWindowBorders = Prefs.getBoolean("decorateWindowBorders", false);
        eventKeyInputAddKey = 92;
        actionToolTipColumns = Prefs.getInt("actionToolTipColumns", 30);
        actionToolTipLines = Prefs.getInt("actionToolTipLines", 10);
        backupSave = Prefs.getBoolean("backupSave", true);
        backupExit = Prefs.getBoolean("backupExit", true);
        backupAuto = Prefs.getBoolean("backupAuto", false);
        backupCopies = Prefs.getInt("backupCopies", 5);
        backupMinutes = Prefs.getInt("backupMinutes", 5);
        externalSpriteExtension = Prefs.getString("externalSpriteExtension", "png");
        externalBackgroundExtension = Prefs.getString("externalBackgroundExtension", "png");
        externalScriptExtension = Prefs.getString("externalScriptExtension", "gml");
        String str = Prefs.getString("externalBackgroundEditorCommand", "null");
        useExternalBackgroundEditor = !str.isEmpty() && !str.toLowerCase().equals("null");
        externalBackgroundEditorCommand = str.toLowerCase().equals("system") ? null : str;
        str = Prefs.getString("externalSpriteEditorCommand", "null");
        useExternalSpriteEditor = !str.isEmpty() && !str.toLowerCase().equals("null");
        externalSpriteEditorCommand = str.toLowerCase().equals("system") ? null : str;
        str = Prefs.getString("externalScriptEditorCommand", "null");
        useExternalScriptEditor = !str.isEmpty() && !str.toLowerCase().equals("null");
        externalScriptEditorCommand = str.toLowerCase().equals("system") ? null : str;
        str = Prefs.getString("externalSoundEditorCommand", "null");
        useExternalSoundEditor = !str.isEmpty() && !str.toLowerCase().equals("null");
        externalSoundEditorCommand = str.toLowerCase().equals("system") ? null : str;
        undoHistorySize = Prefs.getInt("undoHistorySize", 100);
        viewInsideColor = Prefs.getInt("viewInsideColor", Util.getGmColorWithAlpha(Color.WHITE));
        viewOutsideColor = Prefs.getInt("viewOutsideColor", Util.getGmColorWithAlpha(Color.BLACK));
        useFilledRectangleForViews = Prefs.getBoolean("filledRectangleForViews", false);
        useInvertedColorForViews = Prefs.getBoolean("invertedColorForViews", false);
        selectionInsideColor = Prefs.getInt("selectionInsideColor", Util.getGmColorWithAlpha(Color.WHITE));
        selectionOutsideColor = Prefs.getInt("selectionOutsideColor", Util.getGmColorWithAlpha(Color.BLACK));
        useFilledRectangleForSelection = Prefs.getBoolean("filledRectangleForSelection", false);
        useInvertedColorForSelection = Prefs.getBoolean("invertedColorForSelection", false);
        multipleSelectionInsideColor = Prefs.getInt("multipleSelectionInsideColor", Util.getGmColorWithAlpha(Color.BLUE, 50));
        multipleSelectionOutsideColor = Prefs.getInt("multipleSelectionOutsideColor", Util.getGmColorWithAlpha(Color.BLUE, 50));
        useFilledRectangleForMultipleSelection = Prefs.getBoolean("filledRectangleForMultipleSelection", true);
        useInvertedColorForMultipleSelection = Prefs.getBoolean("invertedColorForMultipleSelection", false);
    }

    public static void createPrefixes(String pref) {
        String[] p = pref.split("\\t+");
        prefixes = new HashMap();
        int i = 0;
        while (i < p.length) {
            String[] kv = p[i].split(">", 2);
            try {
                Class<? extends Resource<?, ?>> k = Resource.kindsByName3.get(kv[0]);
                if (k != null) {
                    prefixes.put(k, kv[1]);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }
}

