/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.main;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.lateralgm.components.ColorSelect;
import org.lateralgm.components.NumberField;
import org.lateralgm.joshedit.TokenMarker;
import org.lateralgm.joshedit.lexers.GLESTokenMarker;
import org.lateralgm.joshedit.lexers.GLSLTokenMarker;
import org.lateralgm.joshedit.lexers.GMLTokenMarker;
import org.lateralgm.joshedit.lexers.HLSLTokenMarker;
import org.lateralgm.joshedit.preferences.HighlightPreferences;
import org.lateralgm.joshedit.preferences.KeybindingsPanel;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Listener;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.PrefsStore;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Background;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.Script;
import org.lateralgm.resources.Sprite;

public class PreferencesFrame
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static PreferencesFrame instance = null;
    protected JPanel cardPane;
    protected JTree tree;
    protected JLabel applyChangesLabel;
    private Timer blinkTimer;
    public static final List<PreferencesGroup> groups = new ArrayList<PreferencesGroup>();

    static {
        groups.add(new GeneralGroup());
        groups.add(new AppearanceGroup());
        groups.add(new ExternalGroup());
        groups.add(new MediaGroup());
        groups.add(new RoomEditorGroup());
    }

    public PreferencesFrame() {
        super(LGM.frame);
        instance = this;
        this.setDefaultCloseOperation(1);
        this.setTitle(Messages.getString("PreferencesFrame.TITLE"));
        this.setIconImage(LGM.getIconForKey("Toolbar.PREFERENCES").getImage());
        this.setResizable(true);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this.cardPane = new JPanel(new CardLayout());
        for (PreferencesGroup group : groups) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(group.name);
            root.add(node);
            this.cardPane.add((Component)group.makePanel(), Integer.toString(node.hashCode()));
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(Messages.getString("PreferencesFrame.TAB_CODE_EDITOR"));
        DefaultMutableTreeNode cnode = new DefaultMutableTreeNode(Messages.getString("PreferencesFrame.TAB_CODE_EDITOR_KEYBINDINGS"));
        node.add(cnode);
        cnode = new DefaultMutableTreeNode(Messages.getString("PreferencesFrame.TAB_CODE_EDITOR_SYNTAX_HIGHLIGHTING"));
        node.add(cnode);
        this.cardPane.add((Component)new KeybindingsPanel(), Messages.getString("PreferencesFrame.TAB_CODE_EDITOR_KEYBINDINGS"));
        this.cardPane.add((Component)new HighlightPreferences(new TokenMarker.LanguageDescription[][]{GMLTokenMarker.getLanguageDescriptions(), GLSLTokenMarker.getLanguageDescriptions(), GLESTokenMarker.getLanguageDescriptions(), HLSLTokenMarker.getLanguageDescriptions()}, Preferences.userRoot().node("org/lateralgm/joshedit")), Messages.getString("PreferencesFrame.TAB_CODE_EDITOR_SYNTAX_HIGHLIGHTING"));
        this.tree = new JTree(new DefaultTreeModel(root));
        this.tree.setEditable(false);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        this.tree.setCellRenderer(renderer);
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PreferencesFrame.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                CardLayout cl = (CardLayout)PreferencesFrame.this.cardPane.getLayout();
                String nodeInfo = node.getUserObject().toString();
                cl.show(PreferencesFrame.this.cardPane, nodeInfo);
                nodeInfo = Integer.toString(node.hashCode());
                cl.show(PreferencesFrame.this.cardPane, nodeInfo);
            }
        });
        JScrollPane scroll = new JScrollPane(this.tree);
        scroll.setPreferredSize(new Dimension(160, 0));
        JSplitPane split = new JSplitPane(1, true, scroll, this.cardPane);
        this.add(split);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(4));
        String key = "PreferencesFrame.APPLY_CHANGES";
        JButton applyBut = new JButton(Messages.getString(key));
        applyBut.addActionListener(this);
        applyBut.setActionCommand(key);
        key = "PreferencesFrame.RESET_DEFAULTS";
        JButton resetDefaultsBut = new JButton(Messages.getString(key));
        resetDefaultsBut.addActionListener(this);
        resetDefaultsBut.setActionCommand(key);
        key = "PreferencesFrame.CLOSE";
        JButton closeBut = new JButton(Messages.getString(key));
        closeBut.addActionListener(this);
        closeBut.setActionCommand(key);
        this.getRootPane().setDefaultButton(closeBut);
        this.applyChangesLabel = new JLabel(Messages.getString("PreferencesFrame.APPLY_NOTICE"));
        this.applyChangesLabel.setIcon(LGM.getIconForKey("PreferencesFrame.APPLY_NOTICE"));
        this.applyChangesLabel.setVisible(false);
        p.add(this.applyChangesLabel);
        p.add(applyBut);
        p.add(resetDefaultsBut);
        p.add(closeBut);
        this.add((Component)p, "South");
        this.pack();
        this.setLocationRelativeTo(LGM.frame);
    }

    private void savePreferences() {
        for (PreferencesGroup group : groups) {
            group.save();
        }
    }

    private void resetDefaults() {
        PrefsStore.resetToDefaults();
        Prefs.loadPrefs();
        for (PreferencesGroup group : groups) {
            group.load();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            for (PreferencesGroup group : groups) {
                group.load();
            }
        }
        super.setVisible(visible);
    }

    private void startBlink() {
        this.applyChangesLabel.setVisible(true);
        if (this.blinkTimer == null) {
            this.blinkTimer = new Timer(300, new ActionListener(){
                int count = 0;
                Icon icon;
                {
                    this.icon = PreferencesFrame.this.applyChangesLabel.getIcon();
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.count % 2 > 0) {
                        PreferencesFrame.this.applyChangesLabel.setIcon(this.icon);
                    } else {
                        PreferencesFrame.this.applyChangesLabel.setIcon(null);
                    }
                    ++this.count;
                    if (this.count > 7) {
                        this.count = 0;
                        PreferencesFrame.this.blinkTimer.stop();
                    }
                }
            });
        }
        this.blinkTimer.start();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String com = ev.getActionCommand();
        if (com.equals("PreferencesFrame.APPLY_CHANGES")) {
            this.savePreferences();
            this.startBlink();
        } else if (com.equals("PreferencesFrame.RESET_DEFAULTS")) {
            this.resetDefaults();
            this.startBlink();
        } else if (com.equals("PreferencesFrame.CLOSE")) {
            this.setVisible(false);
        }
    }

    private static class AppearanceGroup
    extends PreferencesGroup {
        JComboBox<String> themeCombo;
        JComboBox<String> iconCombo;
        JTextField iconPath;
        JTextField themePath;
        private ColorSelect imagePreviewBackgroundColor;
        private ColorSelect imagePreviewForegroundColor;
        private ColorSelect matchCountBackgroundColor;
        private ColorSelect matchCountForegroundColor;
        private ColorSelect resultMatchBackgroundColor;
        private ColorSelect resultMatchForegroundColor;
        private JCheckBox matchCountBackgroundCheckBox;
        private JCheckBox matchCountForegroundCheckBox;
        private JCheckBox resultMatchBackgroundCheckBox;
        private JCheckBox resultMatchForegroundCheckBox;
        private JComboBox<String> direct3DCombo;
        private JComboBox<String> openGLCombo;
        private JComboBox<String> antialiasCombo;
        private JCheckBox decorateWindowBordersCheckBox;

        protected AppearanceGroup() {
            super(Messages.getString("PreferencesFrame.TAB_APPEARANCE"));
        }

        @Override
        public JPanel makePanel() {
            JPanel panel = new JPanel();
            String[] systemItems = new String[]{"default", "off", "on"};
            String[] systemItemsLocalized = new String[]{Messages.getString("PreferencesFrame.SYSTEM_PROPERTY_DEFAULT"), Messages.getString("PreferencesFrame.SYSTEM_PROPERTY_OFF"), Messages.getString("PreferencesFrame.SYSTEM_PROPERTY_ON")};
            this.decorateWindowBordersCheckBox = new JCheckBox(Messages.getString("PreferencesFrame.DECORATE_WINDOW_BORDERS"));
            JLabel themeLabel = new JLabel(Messages.getString("PreferencesFrame.THEME"));
            Vector<String> themeComboItems = new Vector<String>();
            themeComboItems.add("Swing");
            themeComboItems.add("Native");
            UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
            int i = 0;
            while (i < lnfs.length) {
                themeComboItems.add(lnfs[i].getName());
                ++i;
            }
            themeComboItems.add("Custom");
            DefaultComboBoxModel model = new DefaultComboBoxModel(themeComboItems);
            this.themeCombo = new JComboBox(model);
            JLabel iconLabel = new JLabel(Messages.getString("PreferencesFrame.ICONS"));
            String[] iconItems = new String[]{"Calico", "Contrast", "Custom"};
            this.iconCombo = new JComboBox<String>(iconItems);
            JLabel antialiasLabel = new JLabel(Messages.getString("PreferencesFrame.ANTIALIASING"));
            String[] antialiasItems = new String[]{"default", "off", "on", "gasp", "lcd_hrgb", "lcd_hbgr", "lcd_vrgb", "lcd_vbgr"};
            String[] antialiasItemsLocalized = new String[]{Messages.getString("PreferencesFrame.SYSTEM_PROPERTY_DEFAULT"), Messages.getString("PreferencesFrame.SYSTEM_PROPERTY_OFF"), Messages.getString("PreferencesFrame.SYSTEM_PROPERTY_ON"), Messages.getString("PreferencesFrame.SYSTEM_PROPERTY_GASP"), Messages.getString("PreferencesFrame.SYSTEM_PROPERTY_LCD_HBGR"), Messages.getString("PreferencesFrame.SYSTEM_PROPERTY_LCD_HRGB"), Messages.getString("PreferencesFrame.SYSTEM_PROPERTY_LCD_VBGR"), Messages.getString("PreferencesFrame.SYSTEM_PROPERTY_LCD_VRGB")};
            this.antialiasCombo = new JComboBox<String>(antialiasItems);
            JLabel iconPathLabel = new JLabel(Messages.getString("PreferencesFrame.ICONS_PATH"));
            this.iconPath = new JTextField();
            JLabel themePathLabel = new JLabel(Messages.getString("PreferencesFrame.THEME_PATH"));
            this.themePath = new JTextField();
            JPanel imagePreviewPanel = new JPanel();
            GroupLayout imagePreviewLayout = new GroupLayout(imagePreviewPanel);
            imagePreviewLayout.setAutoCreateGaps(true);
            imagePreviewLayout.setAutoCreateContainerGaps(true);
            imagePreviewPanel.setLayout(imagePreviewLayout);
            imagePreviewPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PreferencesFrame.IMAGE_PREVIEW")));
            JLabel imagePreviewBackgroundLabel = new JLabel(Messages.getString("PreferencesFrame.IMAGE_PREVIEW_BACKGROUND_COLOR"));
            this.imagePreviewBackgroundColor = new ColorSelect();
            JLabel imagePreviewForegroundLabel = new JLabel(Messages.getString("PreferencesFrame.IMAGE_PREVIEW_FOREGROUND_COLOR"));
            this.imagePreviewForegroundColor = new ColorSelect();
            imagePreviewLayout.setHorizontalGroup(imagePreviewLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addGroup(imagePreviewLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(imagePreviewBackgroundLabel).addComponent(imagePreviewForegroundLabel)).addGroup(imagePreviewLayout.createParallelGroup().addComponent(this.imagePreviewBackgroundColor).addComponent(this.imagePreviewForegroundColor)));
            imagePreviewLayout.setVerticalGroup(imagePreviewLayout.createSequentialGroup().addGroup(imagePreviewLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(imagePreviewBackgroundLabel).addComponent(this.imagePreviewBackgroundColor)).addGroup(imagePreviewLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(imagePreviewForegroundLabel).addComponent(this.imagePreviewForegroundColor)));
            JPanel hardwareAccelerationPanel = new JPanel();
            GroupLayout hardwareAccelerationLayout = new GroupLayout(hardwareAccelerationPanel);
            hardwareAccelerationLayout.setAutoCreateGaps(true);
            hardwareAccelerationLayout.setAutoCreateContainerGaps(true);
            hardwareAccelerationPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PreferencesFrame.HARDWARE_ACCELERATION")));
            JLabel direct3DLabel = new JLabel(Messages.getString("PreferencesFrame.DIRECT3D"));
            this.direct3DCombo = new JComboBox<String>(systemItems);
            JLabel openGLLabel = new JLabel(Messages.getString("PreferencesFrame.OPENGL"));
            this.openGLCombo = new JComboBox<String>(systemItems);
            hardwareAccelerationLayout.setHorizontalGroup(hardwareAccelerationLayout.createParallelGroup().addGroup(hardwareAccelerationLayout.createSequentialGroup().addGroup(hardwareAccelerationLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(direct3DLabel).addComponent(openGLLabel)).addGroup(hardwareAccelerationLayout.createParallelGroup().addComponent(this.direct3DCombo, -2, -1, -2).addComponent(this.openGLCombo, -2, -1, -2))));
            hardwareAccelerationLayout.setVerticalGroup(hardwareAccelerationLayout.createSequentialGroup().addGroup(hardwareAccelerationLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(direct3DLabel).addComponent(this.direct3DCombo)).addGroup(hardwareAccelerationLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(openGLLabel).addComponent(this.openGLCombo)));
            hardwareAccelerationPanel.setLayout(hardwareAccelerationLayout);
            JPanel searchResultsPanel = new JPanel();
            GroupLayout searchResultsLayout = new GroupLayout(searchResultsPanel);
            searchResultsLayout.setAutoCreateGaps(true);
            searchResultsLayout.setAutoCreateContainerGaps(true);
            searchResultsPanel.setLayout(searchResultsLayout);
            searchResultsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PreferencesFrame.SEARCH_RESULTS")));
            JLabel matchCountLable = new JLabel(Messages.getString("PreferencesFrame.MATCH_COUNT"));
            this.matchCountBackgroundCheckBox = new JCheckBox(Messages.getString("PreferencesFrame.MATCH_COUNT_BACKGROUND_COLOR"));
            this.matchCountBackgroundColor = new ColorSelect();
            this.matchCountForegroundCheckBox = new JCheckBox(Messages.getString("PreferencesFrame.MATCH_COUNT_FOREGROUND_COLOR"));
            this.matchCountForegroundColor = new ColorSelect();
            JLabel resultMatchLabel = new JLabel(Messages.getString("PreferencesFrame.RESULT_MATCH"));
            this.resultMatchBackgroundCheckBox = new JCheckBox(Messages.getString("PreferencesFrame.RESULT_MATCH_BACKGROUND_COLOR"));
            this.resultMatchBackgroundColor = new ColorSelect();
            this.resultMatchForegroundCheckBox = new JCheckBox(Messages.getString("PreferencesFrame.RESULT_MATCH_FOREGROUND_COLOR"));
            this.resultMatchForegroundColor = new ColorSelect();
            searchResultsLayout.setHorizontalGroup(searchResultsLayout.createParallelGroup().addComponent(matchCountLable).addGroup(searchResultsLayout.createSequentialGroup().addGroup(searchResultsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.matchCountBackgroundCheckBox).addComponent(this.matchCountForegroundCheckBox)).addGroup(searchResultsLayout.createParallelGroup().addComponent(this.matchCountBackgroundColor, -2, -2, -2).addComponent(this.matchCountForegroundColor, -2, -2, -2))).addComponent(resultMatchLabel).addGroup(searchResultsLayout.createSequentialGroup().addGroup(searchResultsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resultMatchBackgroundCheckBox).addComponent(this.resultMatchForegroundCheckBox)).addGroup(searchResultsLayout.createParallelGroup().addComponent(this.resultMatchBackgroundColor, -2, -2, -2).addComponent(this.resultMatchForegroundColor, -2, -2, -2))));
            searchResultsLayout.setVerticalGroup(searchResultsLayout.createSequentialGroup().addComponent(matchCountLable).addGroup(searchResultsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.matchCountBackgroundCheckBox).addComponent(this.matchCountBackgroundColor)).addGroup(searchResultsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.matchCountForegroundCheckBox).addComponent(this.matchCountForegroundColor)).addComponent(resultMatchLabel).addGroup(searchResultsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resultMatchBackgroundCheckBox).addComponent(this.resultMatchBackgroundColor)).addGroup(searchResultsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resultMatchForegroundCheckBox).addComponent(this.resultMatchForegroundColor)));
            GroupLayout gl = new GroupLayout(panel);
            gl.setAutoCreateGaps(true);
            gl.setAutoCreateContainerGaps(true);
            panel.setLayout(gl);
            gl.setHorizontalGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(themeLabel).addComponent(themePathLabel).addComponent(iconPathLabel)).addGroup(gl.createParallelGroup().addComponent(this.themePath).addComponent(this.iconPath).addGroup(gl.createSequentialGroup().addComponent(this.themeCombo, -2, -1, -2).addComponent(iconLabel).addComponent(this.iconCombo, -2, -1, -2).addComponent(antialiasLabel).addComponent(this.antialiasCombo, -2, -1, -2).addComponent(this.decorateWindowBordersCheckBox)))).addGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup().addComponent(imagePreviewPanel).addComponent(searchResultsPanel)).addComponent(hardwareAccelerationPanel)));
            gl.linkSize(0, imagePreviewPanel, searchResultsPanel);
            gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(themeLabel).addComponent(this.themeCombo, -2, -1, -2).addComponent(iconLabel).addComponent(this.iconCombo, -2, -1, -2).addComponent(antialiasLabel).addComponent(this.antialiasCombo, -2, -1, -2).addComponent(this.decorateWindowBordersCheckBox)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(themePathLabel).addComponent(this.themePath)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(iconPathLabel).addComponent(this.iconPath)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(imagePreviewPanel).addComponent(hardwareAccelerationPanel)).addComponent(searchResultsPanel));
            gl.linkSize(1, imagePreviewPanel, hardwareAccelerationPanel);
            return panel;
        }

        @Override
        public void load() {
            this.iconPath.setText(Prefs.iconPath);
            this.themePath.setText(Prefs.swingThemePath);
            this.themeCombo.setSelectedItem(LGM.themename);
            this.iconCombo.setSelectedItem(LGM.iconspack);
            this.antialiasCombo.setSelectedItem(Prefs.antialiasControlFont);
            this.imagePreviewBackgroundColor.setSelectedColor(new Color(Prefs.imagePreviewBackgroundColor));
            this.imagePreviewForegroundColor.setSelectedColor(new Color(Prefs.imagePreviewForegroundColor));
            this.direct3DCombo.setSelectedItem(Prefs.direct3DAcceleration);
            this.openGLCombo.setSelectedItem(Prefs.openGLAcceleration);
            this.decorateWindowBordersCheckBox.setSelected(Prefs.decorateWindowBorders);
            this.matchCountBackgroundCheckBox.setSelected(Prefs.highlightMatchCountBackground);
            this.matchCountForegroundCheckBox.setSelected(Prefs.highlightMatchCountForeground);
            this.resultMatchBackgroundCheckBox.setSelected(Prefs.highlightResultMatchBackground);
            this.resultMatchForegroundCheckBox.setSelected(Prefs.highlightResultMatchForeground);
            this.matchCountBackgroundColor.setSelectedColor(new Color(Prefs.matchCountBackgroundColor));
            this.matchCountForegroundColor.setSelectedColor(new Color(Prefs.matchCountForegroundColor));
            this.resultMatchBackgroundColor.setSelectedColor(new Color(Prefs.resultMatchBackgroundColor));
            this.resultMatchForegroundColor.setSelectedColor(new Color(Prefs.resultMatchForegroundColor));
        }

        @Override
        public void save() {
            LGM.iconspack = (String)this.iconCombo.getSelectedItem();
            PrefsStore.setIconPack(LGM.iconspack);
            PrefsStore.setIconPath(this.iconPath.getText());
            PrefsStore.setSwingThemePath(this.themePath.getText());
            PrefsStore.setSwingTheme((String)this.themeCombo.getSelectedItem());
            PrefsStore.setDecorateWindowBorders(this.decorateWindowBordersCheckBox.isSelected());
            PrefsStore.setAntialiasControlFont(this.antialiasCombo.getSelectedItem().toString());
            PrefsStore.setDirect3DAcceleration(this.direct3DCombo.getSelectedItem().toString());
            PrefsStore.setOpenGLAcceleration(this.openGLCombo.getSelectedItem().toString());
            PrefsStore.setImagePreviewBackgroundColor(this.imagePreviewBackgroundColor.getSelectedColor().getRGB());
            PrefsStore.setImagePreviewForegroundColor(this.imagePreviewForegroundColor.getSelectedColor().getRGB());
            PrefsStore.setHighlightMatchCountBackground(this.matchCountBackgroundCheckBox.isSelected());
            PrefsStore.setHighlightMatchCountForeground(this.matchCountForegroundCheckBox.isSelected());
            PrefsStore.setMatchCountBackgroundColor(this.matchCountBackgroundColor.getSelectedColor().getRGB());
            PrefsStore.setMatchCountForegroundColor(this.matchCountForegroundColor.getSelectedColor().getRGB());
            PrefsStore.setHighlightResultMatchBackground(this.resultMatchBackgroundCheckBox.isSelected());
            PrefsStore.setHighlightResultMatchForeground(this.resultMatchForegroundCheckBox.isSelected());
            PrefsStore.setResultMatchBackgroundColor(this.resultMatchBackgroundColor.getSelectedColor().getRGB());
            PrefsStore.setResultMatchForegroundColor(this.resultMatchForegroundColor.getSelectedColor().getRGB());
            LGM.setLookAndFeel((String)this.themeCombo.getSelectedItem());
            LGM.updateLookAndFeel();
            LGM.reloadIcons();
            LGM.applyPreferences();
            instance.requestFocus();
        }
    }

    private static class ExternalGroup
    extends PreferencesGroup {
        JTextField soundEditorPath;
        JTextField backgroundEditorPath;
        JTextField spriteEditorPath;
        JTextField codeEditorPath;

        protected ExternalGroup() {
            super(Messages.getString("PreferencesFrame.TAB_EXTERNAL_EDITOR"));
        }

        private JButton makeEditorBrowseButton(final JTextField textField) {
            JButton button = new JButton(Messages.getString("PreferencesFrame.BROWSE"));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = new JFileChooser();
                    fc.setFileSelectionMode(0);
                    fc.setMultiSelectionEnabled(false);
                    if (fc.showOpenDialog(instance) != 0) {
                        return;
                    }
                    File file = fc.getSelectedFile();
                    if (file != null) {
                        String commandText = String.valueOf('\"') + file.getAbsolutePath() + "\" %s";
                        if (System.getProperty("os.name").equalsIgnoreCase("windows")) {
                            textField.setText("cmd /c " + commandText);
                        } else {
                            textField.setText(commandText);
                        }
                    }
                }
            });
            return button;
        }

        @Override
        public JPanel makePanel() {
            JPanel p = new JPanel();
            JLabel codeEditorLabel = new JLabel(Messages.getString("PreferencesFrame.CODE_EDITOR"));
            this.codeEditorPath = new JTextField();
            JButton codeEditorBrowse = this.makeEditorBrowseButton(this.codeEditorPath);
            JLabel spriteEditorLabel = new JLabel(Messages.getString("PreferencesFrame.SPRITE_EDITOR"));
            this.spriteEditorPath = new JTextField();
            JButton spriteEditorBrowse = this.makeEditorBrowseButton(this.spriteEditorPath);
            JLabel backgroundEditorLabel = new JLabel(Messages.getString("PreferencesFrame.BACKGROUND_EDITOR"));
            this.backgroundEditorPath = new JTextField();
            JButton backgroundEditorBrowse = this.makeEditorBrowseButton(this.backgroundEditorPath);
            JLabel soundEditorLabel = new JLabel(Messages.getString("PreferencesFrame.SOUND_EDITOR"));
            this.soundEditorPath = new JTextField();
            JButton soundEditorBrowse = this.makeEditorBrowseButton(this.soundEditorPath);
            GroupLayout gl = new GroupLayout(p);
            gl.setAutoCreateGaps(true);
            gl.setAutoCreateContainerGaps(true);
            p.setLayout(gl);
            gl.setHorizontalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(spriteEditorLabel).addComponent(soundEditorLabel).addComponent(backgroundEditorLabel).addComponent(codeEditorLabel)).addGroup(gl.createParallelGroup().addComponent(this.spriteEditorPath).addComponent(this.soundEditorPath).addComponent(this.backgroundEditorPath).addComponent(this.codeEditorPath)).addGroup(gl.createParallelGroup().addComponent(spriteEditorBrowse).addComponent(soundEditorBrowse).addComponent(backgroundEditorBrowse).addComponent(codeEditorBrowse)));
            gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(spriteEditorLabel).addComponent(this.spriteEditorPath).addComponent(spriteEditorBrowse)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(soundEditorLabel).addComponent(this.soundEditorPath).addComponent(soundEditorBrowse)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(backgroundEditorLabel).addComponent(this.backgroundEditorPath).addComponent(backgroundEditorBrowse)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(codeEditorLabel).addComponent(this.codeEditorPath).addComponent(codeEditorBrowse)));
            return p;
        }

        @Override
        public void load() {
            this.codeEditorPath.setText(Prefs.externalScriptEditorCommand);
            this.spriteEditorPath.setText(Prefs.externalSpriteEditorCommand);
            this.backgroundEditorPath.setText(Prefs.externalBackgroundEditorCommand);
            this.soundEditorPath.setText(Prefs.externalSoundEditorCommand);
        }

        @Override
        public void save() {
            PrefsStore.setBackgroundEditorCommand(this.backgroundEditorPath.getText());
            PrefsStore.setSpriteEditorCommand(this.spriteEditorPath.getText());
            PrefsStore.setSoundEditorCommand(this.soundEditorPath.getText());
            PrefsStore.setScriptEditorCommand(this.codeEditorPath.getText());
        }
    }

    private static class GeneralGroup
    extends PreferencesGroup {
        JCheckBox dndEnable;
        JCheckBox expandEventsEnable;
        JCheckBox restrictTreeEnable;
        JCheckBox extraNodesEnable;
        JCheckBox showTreeFilter;
        JCheckBox rightOrientation;
        JCheckBox backupSave;
        JCheckBox backupExit;
        JCheckBox backupAuto;
        JComboBox<LocaleItem> localeCombo;
        JTextField documentationURI;
        JTextField websiteURI;
        JTextField communityURI;
        JTextField issueURI;
        JTextField actionsPath;
        JSpinner backupCopies;
        JSpinner backupMinutes;

        protected GeneralGroup() {
            super(Messages.getString("PreferencesFrame.TAB_GENERAL"));
        }

        private JButton getURIBrowseButton(final JTextField textField) {
            JButton button = new JButton(Messages.getString("PreferencesFrame.BROWSE"));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = new JFileChooser();
                    fc.setFileSelectionMode(2);
                    if (fc.showOpenDialog(instance) != 0) {
                        return;
                    }
                    File file = fc.getSelectedFile();
                    if (file != null) {
                        textField.setText(file.toURI().toString());
                    }
                }
            });
            return button;
        }

        @Override
        public JPanel makePanel() {
            JPanel p = new JPanel();
            this.dndEnable = new JCheckBox(Messages.getString("PreferencesFrame.ENABLE_DND"));
            this.expandEventsEnable = new JCheckBox(Messages.getString("PreferencesFrame.ENABLE_EXPAND_EVENTS"));
            this.restrictTreeEnable = new JCheckBox(Messages.getString("PreferencesFrame.ENABLE_TREE_RESTRICT"));
            this.extraNodesEnable = new JCheckBox(Messages.getString("PreferencesFrame.ENABLE_EXTRA_NODES"));
            this.showTreeFilter = new JCheckBox(Messages.getString("PreferencesFrame.SHOW_TREE_FILTER"));
            this.rightOrientation = new JCheckBox(Messages.getString("PreferencesFrame.RIGHT_ORIENTATION"));
            JLabel documentationLabel = new JLabel(Messages.getString("PreferencesFrame.DOCUMENTATION_URI"));
            this.documentationURI = new JTextField();
            JButton documentationBrowse = this.getURIBrowseButton(this.documentationURI);
            JLabel websiteLabel = new JLabel(Messages.getString("PreferencesFrame.WEBSITE_URI"));
            this.websiteURI = new JTextField();
            JButton websiteBrowse = this.getURIBrowseButton(this.websiteURI);
            JLabel communityLabel = new JLabel(Messages.getString("PreferencesFrame.COMMUNITY_URI"));
            this.communityURI = new JTextField();
            JButton communityBrowse = this.getURIBrowseButton(this.communityURI);
            JLabel issueLabel = new JLabel(Messages.getString("PreferencesFrame.ISSUE_URI"));
            this.issueURI = new JTextField();
            JButton issueBrowse = this.getURIBrowseButton(this.issueURI);
            this.actionsPath = new JTextField();
            this.actionsPath.setText(Prefs.userLibraryPath);
            JPanel backupsPanel = new JPanel();
            backupsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PreferencesFrame.BACKUPS")));
            this.backupSave = new JCheckBox(Messages.getString("PreferencesFrame.BACKUP_SAVE"), Prefs.backupSave);
            this.backupSave.setToolTipText(Messages.getString("PreferencesFrame.BACKUP_SAVE_TOOLTIP"));
            this.backupAuto = new JCheckBox(Messages.getString("PreferencesFrame.BACKUP_AUTO"), Prefs.backupAuto);
            this.backupAuto.setToolTipText(Messages.getString("PreferencesFrame.BACKUP_AUTO_TOOLTIP"));
            this.backupExit = new JCheckBox(Messages.getString("PreferencesFrame.BACKUP_EXIT"), Prefs.backupExit);
            JLabel backupCopiesLabel = new JLabel(Messages.getString("PreferencesFrame.BACKUP_COPIES"));
            this.backupCopies = new JSpinner(new SpinnerNumberModel(Prefs.backupCopies, 1, 9, 1));
            JLabel backupMinutesLabel = new JLabel(Messages.getString("PreferencesFrame.BACKUP_MINUTES"));
            this.backupMinutes = new JSpinner(new SpinnerNumberModel(Prefs.backupMinutes, 1, 60, 1));
            this.backupSave.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    GeneralGroup.this.backupCopies.setEnabled(GeneralGroup.this.backupSave.isSelected());
                }
            });
            this.backupAuto.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    GeneralGroup.this.backupMinutes.setEnabled(GeneralGroup.this.backupAuto.isSelected());
                }
            });
            GroupLayout backupsLayout = new GroupLayout(backupsPanel);
            backupsLayout.setAutoCreateGaps(true);
            backupsLayout.setAutoCreateContainerGaps(true);
            backupsPanel.setLayout(backupsLayout);
            backupsLayout.setHorizontalGroup(backupsLayout.createSequentialGroup().addGroup(backupsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(backupCopiesLabel).addComponent(backupMinutesLabel)).addGroup(backupsLayout.createParallelGroup().addComponent(this.backupCopies).addComponent(this.backupMinutes)).addGroup(backupsLayout.createParallelGroup().addComponent(this.backupSave).addComponent(this.backupAuto)));
            backupsLayout.setVerticalGroup(backupsLayout.createSequentialGroup().addGroup(backupsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(backupCopiesLabel).addComponent(this.backupCopies).addComponent(this.backupSave)).addGroup(backupsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(backupMinutesLabel).addComponent(this.backupMinutes).addComponent(this.backupAuto)));
            JLabel localeLabel = new JLabel(Messages.getString("PreferencesFrame.LOCALE"));
            JLabel localeWarningLabel = new JLabel(Messages.getString("PreferencesFrame.LOCALE_WARNING"));
            Locale[] locales = Locale.getAvailableLocales();
            Arrays.sort(locales, new Comparator<Locale>(){

                @Override
                public int compare(Locale o1, Locale o2) {
                    return o1.getDisplayName().compareTo(o2.getDisplayName());
                }
            });
            this.localeCombo = new JComboBox();
            int i = 0;
            while (i < locales.length) {
                Locale locale = locales[i];
                if (!locale.equals(Locale.ROOT)) {
                    this.localeCombo.addItem(new LocaleItem(locale));
                }
                ++i;
            }
            GroupLayout gl = new GroupLayout(p);
            gl.setAutoCreateGaps(true);
            gl.setAutoCreateContainerGaps(true);
            p.setLayout(gl);
            gl.setHorizontalGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(localeLabel).addComponent(documentationLabel).addComponent(websiteLabel).addComponent(communityLabel).addComponent(issueLabel)).addGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addComponent(this.localeCombo, -2, -1, -2).addComponent(localeWarningLabel)).addGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup().addComponent(this.documentationURI).addComponent(this.websiteURI).addComponent(this.communityURI).addComponent(this.issueURI)).addGroup(gl.createParallelGroup().addComponent(documentationBrowse).addComponent(websiteBrowse).addComponent(communityBrowse).addComponent(issueBrowse))))).addGroup(gl.createSequentialGroup().addComponent(backupsPanel, -1, -1, -2).addGroup(gl.createParallelGroup().addComponent(this.dndEnable).addComponent(this.expandEventsEnable).addComponent(this.rightOrientation).addComponent(this.showTreeFilter))));
            gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(localeLabel).addComponent(this.localeCombo, -2, -1, -2).addComponent(localeWarningLabel)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(documentationLabel).addComponent(this.documentationURI).addComponent(documentationBrowse)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(websiteLabel).addComponent(this.websiteURI).addComponent(websiteBrowse)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(communityLabel).addComponent(this.communityURI).addComponent(communityBrowse)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(issueLabel).addComponent(this.issueURI).addComponent(issueBrowse)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(backupsPanel).addGroup(gl.createSequentialGroup().addComponent(this.dndEnable).addComponent(this.expandEventsEnable).addComponent(this.rightOrientation).addComponent(this.showTreeFilter))));
            return p;
        }

        @Override
        public void load() {
            Locale currentLocale = Prefs.locale == null ? Locale.getDefault() : Prefs.locale;
            LocaleItem selectedLocale = new LocaleItem(currentLocale);
            this.localeCombo.setSelectedItem(selectedLocale);
            this.dndEnable.setSelected(Prefs.enableDragAndDrop);
            this.expandEventsEnable.setSelected(Prefs.expandEventTree);
            this.restrictTreeEnable.setSelected(Prefs.restrictHierarchy);
            this.extraNodesEnable.setSelected(Prefs.extraNodes);
            this.showTreeFilter.setSelected(Prefs.showTreeFilter);
            this.rightOrientation.setSelected(Prefs.rightOrientation);
            this.documentationURI.setText(Prefs.documentationURI);
            this.websiteURI.setText(Prefs.websiteURI);
            this.communityURI.setText(Prefs.communityURI);
            this.issueURI.setText(Prefs.issueURI);
            this.backupSave.setSelected(Prefs.backupSave);
            this.backupAuto.setSelected(Prefs.backupAuto);
            this.backupExit.setSelected(Prefs.backupExit);
            this.backupCopies.setEnabled(this.backupSave.isSelected());
            this.backupMinutes.setEnabled(this.backupAuto.isSelected());
            this.backupCopies.setValue(Prefs.backupCopies);
            this.backupMinutes.setValue(Prefs.backupMinutes);
        }

        @Override
        public void save() {
            LGM.filterPanel.setVisible(this.showTreeFilter.isSelected());
            LocaleItem selectedLocale = (LocaleItem)this.localeCombo.getSelectedItem();
            PrefsStore.setLocale(selectedLocale.locale);
            PrefsStore.setIconPack(LGM.iconspack);
            PrefsStore.setDNDEnabled(this.dndEnable.isSelected());
            PrefsStore.setExpandEventTree(this.expandEventsEnable.isSelected());
            PrefsStore.setExtraNodes(this.extraNodesEnable.isSelected());
            PrefsStore.setShowTreeFilter(this.showTreeFilter.isSelected());
            PrefsStore.setRightOrientation(this.rightOrientation.isSelected());
            PrefsStore.setUserLibraryPath(this.actionsPath.getText());
            PrefsStore.setDocumentationURI(this.documentationURI.getText());
            PrefsStore.setWebsiteURI(this.websiteURI.getText());
            PrefsStore.setCommunityURI(this.communityURI.getText());
            PrefsStore.setIssueURI(this.issueURI.getText());
            PrefsStore.setBackupSave(this.backupSave.isSelected());
            PrefsStore.setBackupAuto(this.backupAuto.isSelected());
            PrefsStore.setBackupExit(this.backupExit.isSelected());
            PrefsStore.setBackupCopies((Integer)this.backupCopies.getValue());
            PrefsStore.setBackupMinutes((Integer)this.backupMinutes.getValue());
            Listener.getInstance().updateBackupTimer();
        }

        private static class LocaleItem {
            public final Locale locale;

            public LocaleItem(Locale locale) {
                this.locale = locale;
            }

            public String toString() {
                return this.locale.getDisplayName();
            }

            public boolean equals(Object object) {
                if (object instanceof LocaleItem) {
                    return ((LocaleItem)object).locale.equals(this.locale);
                }
                return false;
            }
        }
    }

    private static class MediaGroup
    extends PreferencesGroup {
        JTextField backgroundExtension;
        JTextField spriteExtension;
        JTextField scriptExtension;
        private PrefixList prefixList;

        protected MediaGroup() {
            super(Messages.getString("PreferencesFrame.TAB_MEDIA_PREFIX"));
        }

        @Override
        public JPanel makePanel() {
            JPanel p = new JPanel();
            this.prefixList = new PrefixList();
            this.prefixList.setSize(new Dimension(100, 100));
            JScrollPane prefixScroll = new JScrollPane(this.prefixList);
            prefixScroll.setBorder(BorderFactory.createTitledBorder(Messages.getString("PreferencesFrame.PREFIXES")));
            JLabel backgroundExtensionLabel = new JLabel(Messages.format("PreferencesFrame.EXTENSION_FORMAT", Resource.kindNames.get(Background.class)));
            this.backgroundExtension = new JTextField();
            JLabel spriteExtensionLabel = new JLabel(Messages.format("PreferencesFrame.EXTENSION_FORMAT", Resource.kindNames.get(Sprite.class)));
            this.spriteExtension = new JTextField();
            JLabel scriptExtensionLabel = new JLabel(Messages.format("PreferencesFrame.EXTENSION_FORMAT", Resource.kindNames.get(Script.class)));
            this.scriptExtension = new JTextField();
            JPanel extensionsPanel = new JPanel();
            extensionsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PreferencesFrame.EXTENSIONS")));
            GroupLayout el = new GroupLayout(extensionsPanel);
            el.setAutoCreateGaps(true);
            el.setAutoCreateContainerGaps(true);
            extensionsPanel.setLayout(el);
            el.setHorizontalGroup(el.createSequentialGroup().addGroup(el.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(backgroundExtensionLabel).addComponent(spriteExtensionLabel).addComponent(scriptExtensionLabel)).addGroup(el.createParallelGroup().addComponent(this.backgroundExtension).addComponent(this.spriteExtension).addComponent(this.scriptExtension)));
            el.setVerticalGroup(el.createSequentialGroup().addGroup(el.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(backgroundExtensionLabel).addComponent(this.backgroundExtension)).addGroup(el.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(spriteExtensionLabel).addComponent(this.spriteExtension)).addGroup(el.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(scriptExtensionLabel).addComponent(this.scriptExtension)));
            GroupLayout gl = new GroupLayout(p);
            gl.setAutoCreateGaps(true);
            gl.setAutoCreateContainerGaps(true);
            p.setLayout(gl);
            gl.setHorizontalGroup(gl.createSequentialGroup().addComponent(prefixScroll).addComponent(extensionsPanel));
            gl.setVerticalGroup(gl.createParallelGroup().addComponent(prefixScroll, -1, -1, -2).addComponent(extensionsPanel));
            return p;
        }

        @Override
        public void load() {
            this.prefixList.load();
            this.backgroundExtension.setText(Prefs.externalBackgroundExtension);
            this.spriteExtension.setText(Prefs.externalSpriteExtension);
            this.scriptExtension.setText(Prefs.externalScriptExtension);
        }

        @Override
        public void save() {
            PrefsStore.setPrefixes(this.prefixList.getSerializedPrefixes());
            PrefsStore.setSpriteExt(this.spriteExtension.getText());
            PrefsStore.setBackgroundExt(this.backgroundExtension.getText());
            PrefsStore.setScriptExt(this.scriptExtension.getText());
        }

        protected class PrefixList
        extends JPanel {
            private static final long serialVersionUID = 5270374014574194314L;
            private Map<Class<? extends Resource<?, ?>>, JTextField> prefixMap = new HashMap();

            public PrefixList() {
                GroupLayout gl = new GroupLayout(this);
                gl.setAutoCreateGaps(true);
                gl.setAutoCreateContainerGaps(true);
                GroupLayout.ParallelGroup labelGroup = gl.createParallelGroup(GroupLayout.Alignment.TRAILING);
                GroupLayout.ParallelGroup textfieldGroup = gl.createParallelGroup();
                GroupLayout.SequentialGroup verticalGroup = gl.createSequentialGroup();
                for (Map.Entry<Class<Resource<?, ?>>, String> ent : Resource.kindNames.entrySet()) {
                    if (!InstantiableResource.class.isAssignableFrom(ent.getKey())) continue;
                    JLabel label = new JLabel(Messages.format("PreferencesFrame.PREFIX_FORMAT", ent.getValue()));
                    JTextField textfield = new JTextField(Prefs.prefixes.get(ent.getKey()));
                    this.prefixMap.put(ent.getKey(), textfield);
                    GroupLayout.ParallelGroup vg = gl.createParallelGroup(GroupLayout.Alignment.BASELINE);
                    labelGroup.addComponent(label);
                    textfieldGroup.addComponent(textfield);
                    vg.addComponent(label);
                    vg.addComponent(textfield);
                    verticalGroup.addGroup(vg);
                }
                gl.setHorizontalGroup(gl.createSequentialGroup().addGroup(labelGroup).addGroup(textfieldGroup));
                gl.setVerticalGroup(verticalGroup);
                this.setLayout(gl);
            }

            public void load() {
                for (Map.Entry<Class<Resource<?, ?>>, JTextField> entry : this.prefixMap.entrySet()) {
                    entry.getValue().setText(Prefs.prefixes.get(entry.getKey()));
                }
            }

            public String getSerializedPrefixes() {
                String ret = "";
                for (Map.Entry<String, Class<Resource<?, ?>>> ent : Resource.kindsByName3.entrySet()) {
                    if (!InstantiableResource.class.isAssignableFrom(ent.getValue())) continue;
                    ret = String.valueOf(ret) + ent.getKey() + ">" + this.prefixMap.get(ent.getValue()).getText() + "\t";
                }
                return ret;
            }
        }
    }

    public static abstract class PreferencesGroup {
        public final String name;

        protected PreferencesGroup(String name) {
            this.name = name;
        }

        public abstract JPanel makePanel();

        public abstract void load();

        public abstract void save();
    }

    private static class RoomEditorGroup
    extends PreferencesGroup {
        NumberField undoHistorySize;
        JCheckBox useFilledRectangleForViews;
        JCheckBox useInvertedColorForViews;
        JCheckBox useFilledRectangleForSelection;
        JCheckBox useInvertedColorForSelection;
        JCheckBox useFilledRectangleForMultipleSelection;
        JCheckBox useInvertedColorForMultipleSelection;
        ColorSelect viewInsideColor;
        ColorSelect viewOutsideColor;
        ColorSelect selectionInsideColor;
        ColorSelect selectionOutsideColor;
        ColorSelect multipleSelectionInsideColor;
        ColorSelect multipleSelectionOutsideColor;

        protected RoomEditorGroup() {
            super(Messages.getString("PreferencesFrame.TAB_ROOM_EDITOR"));
        }

        @Override
        public JPanel makePanel() {
            JPanel roomEditorPanel = new JPanel();
            JLabel undoHistorySizeLabel = new JLabel(Messages.getString("PreferencesFrame.UNDO_HISTORY_SIZE"));
            this.undoHistorySize = new NumberField(-1, 999999);
            JPanel viewsPanel = new JPanel();
            GroupLayout viewsLayout = new GroupLayout(viewsPanel);
            viewsLayout.setAutoCreateGaps(true);
            viewsLayout.setAutoCreateContainerGaps(true);
            viewsPanel.setLayout(viewsLayout);
            String title = Messages.getString("PreferencesFrame.VIEWS_TITLE");
            viewsPanel.setBorder(BorderFactory.createTitledBorder(title));
            this.useFilledRectangleForViews = new JCheckBox(Messages.getString("PreferencesFrame.FILLED_RECTANGLE"));
            this.useInvertedColorForViews = new JCheckBox(Messages.getString("PreferencesFrame.INVERTED_COLOR"));
            JLabel insideColorLabel = new JLabel(Messages.getString("PreferencesFrame.INSIDE_COLOR"));
            this.viewInsideColor = new ColorSelect();
            JLabel outsideColorLabel = new JLabel(Messages.getString("PreferencesFrame.OUTSIDE_COLOR"));
            this.viewOutsideColor = new ColorSelect();
            viewsLayout.setHorizontalGroup(viewsLayout.createParallelGroup().addGroup(viewsLayout.createSequentialGroup().addComponent(this.useFilledRectangleForViews)).addGroup(viewsLayout.createSequentialGroup().addGroup(viewsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.useInvertedColorForViews).addComponent(insideColorLabel).addComponent(outsideColorLabel)).addGroup(viewsLayout.createParallelGroup().addComponent(this.viewInsideColor).addComponent(this.viewOutsideColor))));
            viewsLayout.setVerticalGroup(viewsLayout.createSequentialGroup().addComponent(this.useFilledRectangleForViews).addComponent(this.useInvertedColorForViews).addGap(10).addGroup(viewsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(insideColorLabel).addComponent(this.viewInsideColor)).addGroup(viewsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(outsideColorLabel).addComponent(this.viewOutsideColor)));
            JPanel selectionPanel = new JPanel();
            GroupLayout selectionLayout = new GroupLayout(selectionPanel);
            selectionLayout.setAutoCreateGaps(true);
            selectionLayout.setAutoCreateContainerGaps(true);
            selectionPanel.setLayout(selectionLayout);
            String selectionTitle = Messages.getString("PreferencesFrame.SELECTION");
            selectionPanel.setBorder(BorderFactory.createTitledBorder(selectionTitle));
            this.useFilledRectangleForSelection = new JCheckBox(Messages.getString("PreferencesFrame.FILLED_RECTANGLE"));
            this.useInvertedColorForSelection = new JCheckBox(Messages.getString("PreferencesFrame.INVERTED_COLOR"));
            JLabel insideColorLabelForSelection = new JLabel(Messages.getString("PreferencesFrame.INSIDE_COLOR"));
            this.selectionInsideColor = new ColorSelect();
            JLabel outsideColorLabelForSelection = new JLabel(Messages.getString("PreferencesFrame.OUTSIDE_COLOR"));
            this.selectionOutsideColor = new ColorSelect();
            selectionLayout.setHorizontalGroup(selectionLayout.createParallelGroup().addGroup(selectionLayout.createSequentialGroup().addComponent(this.useFilledRectangleForSelection)).addGroup(selectionLayout.createSequentialGroup().addGroup(selectionLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.useInvertedColorForSelection).addComponent(insideColorLabelForSelection).addComponent(outsideColorLabelForSelection)).addGroup(selectionLayout.createParallelGroup().addComponent(this.selectionInsideColor).addComponent(this.selectionOutsideColor))));
            selectionLayout.setVerticalGroup(selectionLayout.createSequentialGroup().addComponent(this.useFilledRectangleForSelection).addComponent(this.useInvertedColorForSelection).addGap(10).addGroup(selectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(insideColorLabelForSelection).addComponent(this.selectionInsideColor)).addGroup(selectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(outsideColorLabelForSelection).addComponent(this.selectionOutsideColor)));
            JPanel multipleSelectionPanel = new JPanel();
            GroupLayout multipleSelectionLayout = new GroupLayout(multipleSelectionPanel);
            multipleSelectionLayout.setAutoCreateGaps(true);
            multipleSelectionLayout.setAutoCreateContainerGaps(true);
            multipleSelectionPanel.setLayout(multipleSelectionLayout);
            String multipleSelectionTitle = Messages.getString("PreferencesFrame.MULTIPLE_SELECTION");
            multipleSelectionPanel.setBorder(BorderFactory.createTitledBorder(multipleSelectionTitle));
            this.useFilledRectangleForMultipleSelection = new JCheckBox(Messages.getString("PreferencesFrame.FILLED_RECTANGLE"));
            this.useInvertedColorForMultipleSelection = new JCheckBox(Messages.getString("PreferencesFrame.INVERTED_COLOR"));
            JLabel insideColorLabelForMultipleSelection = new JLabel(Messages.getString("PreferencesFrame.INSIDE_COLOR"));
            this.multipleSelectionInsideColor = new ColorSelect();
            JLabel outsideColorLabelForMultipleSelection = new JLabel(Messages.getString("PreferencesFrame.OUTSIDE_COLOR"));
            this.multipleSelectionOutsideColor = new ColorSelect();
            multipleSelectionLayout.setHorizontalGroup(multipleSelectionLayout.createParallelGroup().addGroup(multipleSelectionLayout.createSequentialGroup().addComponent(this.useFilledRectangleForMultipleSelection)).addGroup(multipleSelectionLayout.createSequentialGroup().addGroup(multipleSelectionLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.useInvertedColorForMultipleSelection).addComponent(insideColorLabelForMultipleSelection).addComponent(outsideColorLabelForMultipleSelection)).addGroup(multipleSelectionLayout.createParallelGroup().addComponent(this.multipleSelectionInsideColor).addComponent(this.multipleSelectionOutsideColor))));
            multipleSelectionLayout.setVerticalGroup(multipleSelectionLayout.createSequentialGroup().addComponent(this.useFilledRectangleForMultipleSelection).addComponent(this.useInvertedColorForMultipleSelection).addGap(10).addGroup(multipleSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(insideColorLabelForMultipleSelection).addComponent(this.multipleSelectionInsideColor)).addGroup(multipleSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(outsideColorLabelForMultipleSelection).addComponent(this.multipleSelectionOutsideColor)));
            GroupLayout gl = new GroupLayout(roomEditorPanel);
            gl.setAutoCreateGaps(true);
            gl.setAutoCreateContainerGaps(true);
            roomEditorPanel.setLayout(gl);
            gl.setHorizontalGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addComponent(undoHistorySizeLabel).addComponent(this.undoHistorySize, -2, -2, -2)).addGroup(gl.createSequentialGroup().addComponent(selectionPanel, -2, -2, -2).addComponent(multipleSelectionPanel, -2, -2, -2)).addComponent(viewsPanel, -2, -2, -2));
            gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(undoHistorySizeLabel).addComponent(this.undoHistorySize)).addGroup(gl.createParallelGroup().addComponent(selectionPanel).addComponent(multipleSelectionPanel)).addComponent(viewsPanel));
            return roomEditorPanel;
        }

        @Override
        public void load() {
            this.undoHistorySize.setValue(Prefs.undoHistorySize);
            this.useFilledRectangleForViews.setSelected(Prefs.useFilledRectangleForViews);
            this.useInvertedColorForViews.setSelected(Prefs.useInvertedColorForViews);
            this.viewInsideColor.setSelectedColor(Util.convertGmColorWithAlpha(Prefs.viewInsideColor));
            this.viewInsideColor.setSelectedColor(Util.convertGmColorWithAlpha(Prefs.viewOutsideColor));
            this.useFilledRectangleForSelection.setSelected(Prefs.useFilledRectangleForSelection);
            this.useInvertedColorForSelection.setSelected(Prefs.useInvertedColorForSelection);
            this.selectionInsideColor.setSelectedColor(Util.convertGmColorWithAlpha(Prefs.selectionInsideColor));
            this.selectionOutsideColor.setSelectedColor(Util.convertGmColorWithAlpha(Prefs.selectionOutsideColor));
            this.useFilledRectangleForMultipleSelection.setSelected(Prefs.useFilledRectangleForMultipleSelection);
            this.useInvertedColorForMultipleSelection.setSelected(Prefs.useInvertedColorForMultipleSelection);
            this.multipleSelectionInsideColor.setSelectedColor(Util.convertGmColorWithAlpha(Prefs.multipleSelectionInsideColor));
            this.multipleSelectionOutsideColor.setSelectedColor(Util.convertGmColorWithAlpha(Prefs.multipleSelectionOutsideColor));
        }

        @Override
        public void save() {
            PrefsStore.setUndoHistorySize(this.undoHistorySize.getIntValue());
            PrefsStore.setFilledRectangleForViews(this.useFilledRectangleForViews.isSelected());
            PrefsStore.setInvertedColorForViews(this.useInvertedColorForViews.isSelected());
            PrefsStore.setViewInsideColor(Util.getGmColorWithAlpha(this.viewInsideColor.getSelectedColor()));
            PrefsStore.setViewOutsideColor(Util.getGmColorWithAlpha(this.viewOutsideColor.getSelectedColor()));
            PrefsStore.setFilledRectangleForSelection(this.useFilledRectangleForSelection.isSelected());
            PrefsStore.setInvertedColorForSelection(this.useInvertedColorForSelection.isSelected());
            PrefsStore.setSelectionInsideColor(Util.getGmColorWithAlpha(this.selectionInsideColor.getSelectedColor()));
            PrefsStore.setSelectionOutsideColor(Util.getGmColorWithAlpha(this.selectionOutsideColor.getSelectedColor()));
            PrefsStore.setFilledRectangleForMultipleSelection(this.useFilledRectangleForMultipleSelection.isSelected());
            PrefsStore.setInvertedColorForMultipleSelection(this.useInvertedColorForMultipleSelection.isSelected());
            PrefsStore.setMultipleSelectionInsideColor(Util.getGmColorWithAlpha(this.multipleSelectionInsideColor.getSelectedColor()));
            PrefsStore.setMultipleSelectionOutsideColor(Util.getGmColorWithAlpha(this.multipleSelectionOutsideColor.getSelectedColor()));
        }
    }
}

