/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.main;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.lateralgm.main.LGM;
import org.lateralgm.messages.Messages;

public class OutputManager {
    public static JTabbedPane outputTabs;
    private static JTextPane logPane;
    private static JTable messageTable;
    private static final SimpleAttributeSet ORANGE;
    private static final SimpleAttributeSet RED;

    static {
        ORANGE = new SimpleAttributeSet();
        RED = new SimpleAttributeSet();
        StyleConstants.setForeground(ORANGE, new Color(255, 128, 0));
        StyleConstants.setForeground(RED, Color.RED);
    }

    private static JMenuItem makeContextButton(Action a) {
        String key = "OutputManager." + a.getValue("Name");
        JMenuItem b = new JMenuItem();
        b.setIcon(LGM.getIconForKey(key));
        b.setText(Messages.getString(key));
        b.setRequestFocusEnabled(false);
        b.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString(key)));
        b.addActionListener(a);
        return b;
    }

    public static void initialize() {
        logPane = new JTextPane();
        logPane.setText(String.valueOf(Messages.getString("OutputManager.SESSIONSTARTED")) + ": " + new Date().toString());
        logPane.setEditable(false);
        logPane.getCaret().setVisible(true);
        logPane.setCaretPosition(0);
        logPane.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                logPane.getCaret().setVisible(true);
            }
        });
        AbstractAction aCopy = new AbstractAction("COPY"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                logPane.copy();
            }
        };
        AbstractAction aSelAll = new AbstractAction("SELALL"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                logPane.selectAll();
            }
        };
        JPopupMenu popup = new JPopupMenu();
        popup.add(OutputManager.makeContextButton(aCopy));
        popup.addSeparator();
        popup.add(OutputManager.makeContextButton(aSelAll));
        logPane.setComponentPopupMenu(popup);
        JScrollPane logScroll = new JScrollPane(logPane);
        outputTabs = new JTabbedPane();
        outputTabs.addTab("Log", logScroll);
        DefaultTableModel model = new DefaultTableModel(){
            private static final long serialVersionUID = -6256028089398003469L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model.addColumn("Type");
        model.addColumn("Origin");
        model.addColumn("Description");
        Object[] data = new Object[]{LGM.getIconForKey("OutputManager.NOTICE"), "obj_0", "Lorem ipsum dollor sit amet..."};
        model.addRow(data);
        Object[] data2 = new Object[]{LGM.getIconForKey("OutputManager.WARNING"), "obj_0", "Lorem ipsum dollor sit amet..."};
        model.addRow(data2);
        Object[] data3 = new Object[]{LGM.getIconForKey("OutputManager.ERROR"), "obj_0", "Lorem ipsum dollor sit amet..."};
        model.addRow(data3);
        messageTable = new JTable(model){
            private static final long serialVersionUID = -1963784072451574899L;

            @Override
            public Class<?> getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }
        };
        outputTabs.addTab("Messages", new JScrollPane(messageTable));
        messageTable.setRowHeight(24);
        messageTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        messageTable.getColumnModel().getColumn(1).setPreferredWidth(150);
        messageTable.getColumnModel().getColumn(2).setPreferredWidth(800);
        outputTabs.setPreferredSize(new Dimension(100, 250));
    }

    public static void append(String text) {
        if (logPane == null) {
            return;
        }
        StyledDocument doc = logPane.getStyledDocument();
        SimpleAttributeSet style = null;
        String lower = text.toLowerCase();
        if (lower.startsWith("warning:")) {
            style = ORANGE;
            OutputManager.postWarning(text);
        }
        if (lower.startsWith("error:")) {
            style = RED;
            OutputManager.postError(text);
        }
        try {
            doc.insertString(doc.getLength(), text, style);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        logPane.setCaretPosition(doc.getLength());
    }

    public static void postWarning(String text) {
        Object[] data = new Object[]{LGM.getIconForKey("OutputManager.WARNING"), "obj_0", text};
        DefaultTableModel model = (DefaultTableModel)messageTable.getModel();
        model.addRow(data);
    }

    public static void postError(String text) {
        Object[] data = new Object[]{LGM.getIconForKey("OutputManager.ERROR"), "obj_0", text};
        DefaultTableModel model = (DefaultTableModel)messageTable.getModel();
        model.addRow(data);
    }

    public void clearLog() {
        logPane.setText(null);
    }

    public static void setVisible(boolean visible) {
        outputTabs.setVisible(visible);
    }
}

