/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.main;

import java.awt.Desktop;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lateralgm.components.AboutBox;
import org.lateralgm.components.PackageResourcesDialog;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.file.ResourceList;
import org.lateralgm.main.FileChooser;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.PrefsStore;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.sub.Instance;
import org.lateralgm.subframes.ConfigurationManager;

public class Listener
extends TransferHandler
implements ActionListener,
CellEditorListener {
    private static final long serialVersionUID = 1L;
    MListener mListener = new MListener();
    public FileChooser fc = new FileChooser();
    private final Timer backupTimer = new Timer(0, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Prefs.backupAuto) {
                return;
            }
            Listener.this.fc.save(LGM.currentFile.uri, LGM.currentFile.format);
        }
    });

    public void updateBackupTimer() {
        if (Prefs.backupAuto) {
            int delay = (int)TimeUnit.MINUTES.toMillis(Prefs.backupMinutes);
            this.backupTimer.setCoalesce(true);
            this.backupTimer.setDelay(delay);
            this.backupTimer.setInitialDelay(delay);
            if (this.backupTimer.isRunning()) {
                this.backupTimer.restart();
            } else {
                this.backupTimer.start();
            }
        } else if (this.backupTimer.isRunning()) {
            this.backupTimer.stop();
        }
    }

    private Listener() {
    }

    public static Listener getInstance() {
        return LazyHolder.INSTANCE;
    }

    public static void addResource(JTree tree, Class<?> r) {
        Listener.addResource(tree, r, null, null);
    }

    public static void addResource(JTree tree, Class<?> r, Resource<?, ?> res) {
        Listener.addResource(tree, r, res, null);
    }

    public static void addResource(JTree tree, Class<?> r, ResNode parent) {
        Listener.addResource(tree, r, null, parent);
    }

    protected static void addResource(JTree tree, Class<?> r, Resource<?, ?> res, ResNode parent) {
        if (parent == null) {
            for (ResNode rn : LGM.root.getChildren()) {
                if (rn.status != 1 || r != rn.kind) continue;
                parent = rn;
                break;
            }
            if (parent == null) {
                return;
            }
        }
        Listener.putNode(tree, parent, parent, r, parent.getChildCount(), res);
    }

    public static void insertResource(JTree tree, Class<?> r) {
        Listener.insertResource(tree, r, null, (ResNode)tree.getLastSelectedPathComponent(), 0);
    }

    public static void insertResource(JTree tree, Class<?> r, Resource<?, ?> res) {
        Listener.insertResource(tree, r, res, (ResNode)tree.getLastSelectedPathComponent(), 0);
    }

    public static void insertResource(JTree tree, Class<?> r, ResNode node) {
        Listener.insertResource(tree, r, null, node, 0);
    }

    protected static void insertResource(JTree tree, Class<?> r, Resource<?, ?> res, ResNode node, int offset) {
        ResNode parent;
        if (node == null) {
            Listener.addResource(tree, r, res, node);
        }
        if ((parent = (ResNode)node.getParent()) == null) {
            Listener.addResource(tree, r, res, node);
        }
        if (parent.isRoot()) {
            Listener.addResource(tree, r, res, node);
            return;
        }
        int pos = parent.getIndex(node) + offset;
        Listener.putNode(tree, node, parent, r, pos, res);
    }

    public static void putNode(JTree tree, ResNode node, ResNode parent, Class<?> r, int pos, Resource<?, ?> res) {
        if (r == null) {
            String msg = Messages.getString("Listener.INPUT_GROUPNAME");
            String name = JOptionPane.showInputDialog(LGM.frame, msg, Messages.getString("Listener.DEFAULT_GROUPNAME"));
            if (name == null || name.isEmpty()) {
                return;
            }
            ResNode g = new ResNode(name, 2, parent.kind);
            parent.insert(g, pos);
            tree.expandPath(new TreePath(parent.getPath()));
            tree.setSelectionPath(new TreePath(g.getPath()));
            tree.updateUI();
            LGM.setWindowModified(true);
            return;
        }
        if (node.kind != r) {
            parent = Listener.getPrimaryParent(r);
            pos = parent.getChildCount();
        }
        Resource<?, ?> resource = res == null ? ((ProjectFile.ResourceHolder)LGM.currentFile.resMap.get(parent.kind)).getResource() : res;
        ResNode g = new ResNode(resource.getName(), 3, parent.kind, resource.reference);
        parent.insert(g, pos);
        tree.expandPath(new TreePath(parent.getPath()));
        tree.setSelectionPath(new TreePath(g.getPath()));
        tree.updateUI();
        LGM.setWindowModified(true);
        g.openFrame(true);
    }

    /*
     * WARNING - void declaration
     */
    protected static int deleteResources(Object[] resources, JTree tree) {
        void var4_5;
        HashSet rs = new HashSet();
        int last = -1;
        boolean bl = false;
        while (var4_5 < resources.length) {
            ResNode node = (ResNode)resources[var4_5];
            if (node != null) {
                if (node.status == 3) {
                    Resource<?, ?> res;
                    if (node.frame != null) {
                        node.frame.dispose();
                    }
                    if ((res = Util.deRef(node.getRes())) != null) {
                        rs.add(res);
                        ((ResourceList)LGM.currentFile.resMap.get(node.kind)).remove(res);
                    }
                    last = tree.getRowForPath(new TreePath(node));
                } else if (node.status == 2) {
                    if (node.getChildren() != null) {
                        Listener.deleteResources(node.getChildren().toArray(), tree);
                    }
                    node.removeFromParent();
                    last = tree.getRowForPath(new TreePath(node));
                }
            }
            ++var4_5;
        }
        for (Resource resource : rs) {
            resource.dispose();
        }
        LGM.setWindowModified(true);
        return last;
    }

    protected static void deleteSelectedResources(JTree tree) {
        String msg = Messages.getString("Listener.CONFIRM_DELETERESOURCE");
        if (JOptionPane.showConfirmDialog(LGM.frame, msg, Messages.getString("Listener.CONFIRM_DELETERESOURCE_TITLE"), 0) == 0) {
            TreePath[] selections = tree.getSelectionPaths();
            int row = -1;
            Object[] resources = new Object[selections.length];
            int i = 0;
            while (i < selections.length) {
                resources[i] = selections[i].getLastPathComponent();
                ++i;
            }
            row = Listener.deleteResources(resources, tree);
            if (row != -1) {
                tree.setSelectionPath(tree.getNextMatch("", row, Position.Bias.Forward));
            }
            tree.updateUI();
        }
    }

    public TreeNode findNode(DefaultMutableTreeNode parent, String name, boolean recursive) {
        Enumeration<TreeNode> enumeration = recursive ? parent.preorderEnumeration() : parent.children();
        while (enumeration.hasMoreElements()) {
            TreeNode child = enumeration.nextElement();
            if (!child.toString().equals(name)) continue;
            return child;
        }
        return null;
    }

    private static String getResourceName(Object res) {
        if (res instanceof InstantiableResource) {
            return ((InstantiableResource)res).getName();
        }
        if (res instanceof Instance) {
            return ((Instance)res).getName();
        }
        if (res == null) {
            return null;
        }
        return res.toString();
    }

    private static void setResourceName(Object res, String name) {
        if (res instanceof InstantiableResource) {
            ((InstantiableResource)res).setName(name);
        } else if (res instanceof Instance) {
            ((Instance)res).setName(name);
        }
    }

    private static String getKindName(Object res) {
        if (res instanceof InstantiableResource) {
            return Resource.kindNames.get(res.getClass());
        }
        if (res instanceof Instance) {
            return Messages.getString("LGM.INSTANCE");
        }
        if (res == null) {
            return null;
        }
        return res.getClass().getName();
    }

    private static int checkNameInteractive(Map<String, Object> map, Object dup) {
        String renameTitle;
        String rename;
        String newName;
        boolean validAndUnique = true;
        String dupName = Listener.getResourceName(dup);
        String dupKindName = Listener.getKindName(dup);
        Object orig = map.get(dupName);
        int result = 1;
        if (orig != null) {
            String duplicateTitle;
            String origName = Listener.getResourceName(orig);
            String origKindName = Listener.getKindName(orig);
            String duplicate = Messages.format("Listener.CHECKNAMES_DUPLICATE", dupKindName, dupName, origKindName, origName);
            result = JOptionPane.showConfirmDialog(LGM.frame, duplicate, duplicateTitle = Messages.getString("Listener.CHECKNAMES_DUPLICATE_TITLE"), 1);
            if (result == 2) {
                return -1;
            }
            validAndUnique = false;
        }
        if (result == 1) {
            boolean valid;
            boolean bl = valid = dupName == null ? false : dupName.matches("^(?!.*__.*)([\\p{Alpha}])[\\p{Alpha}0-9_]*$");
            if (!valid) {
                String invalidTitle;
                String invalid = Messages.format("Listener.CHECKNAMES_INVALID", dupKindName, dupName);
                result = JOptionPane.showConfirmDialog(LGM.frame, invalid, invalidTitle = Messages.getString("Listener.CHECKNAMES_INVALID_TITLE"), 1);
                if (result == 2) {
                    return -1;
                }
                validAndUnique = false;
            }
        }
        if (result == 0 && (newName = JOptionPane.showInputDialog(LGM.frame, rename = Messages.format("Listener.CHECKNAMES_RENAME", dupKindName, dupName), renameTitle = Messages.getString("Listener.CHECKNAMES_RENAME_TITLE"), -1)) != null) {
            dupName = newName;
            Listener.setResourceName(dup, dupName);
        }
        map.put(dupName, dup);
        return validAndUnique ? 0 : 1;
    }

    private static void checkNamesInteractive() {
        int result;
        Iterator iter = LGM.currentFile.resMap.values().iterator();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int invalidCount = 0;
        while (iter.hasNext()) {
            ProjectFile.ResourceHolder rh = (ProjectFile.ResourceHolder)iter.next();
            if (!(rh instanceof ResourceList)) continue;
            ResourceList rl = (ResourceList)rh;
            Iterator iterator = rl.iterator();
            while (iterator.hasNext()) {
                InstantiableResource dup = (InstantiableResource)iterator.next();
                result = Listener.checkNameInteractive(map, dup);
                if (result == -1) {
                    return;
                }
                invalidCount += result;
            }
        }
        for (Room r : LGM.currentFile.resMap.getList(Room.class)) {
            for (Instance j : r.instances) {
                result = Listener.checkNameInteractive(map, j);
                if (result == -1) {
                    return;
                }
                invalidCount += result;
            }
        }
        if (invalidCount == 0) {
            String unique = Messages.getString("Listener.CHECKNAMES_OK");
            String uniqueTitle = Messages.getString("Listener.CHECKNAMES_OK_TITLE");
            JOptionPane.showMessageDialog(LGM.frame, unique, uniqueTitle, 1);
        }
    }

    public static void checkIdsInteractive(boolean promptOk) {
        if (LGM.currentFile.checkIds()) {
            if (JOptionPane.showConfirmDialog(LGM.frame, Messages.getString("Listener.CHECKIDS_DEFRAG"), Messages.getString("Listener.CHECKIDS_DEFRAG_TITLE"), 0) == 0) {
                LGM.currentFile.defragIds();
            }
        } else if (promptOk && JOptionPane.showConfirmDialog(LGM.frame, Messages.getString("Listener.CHECKIDS_OK"), Messages.getString("Listener.CHECKIDS_OK_TITLE"), 0) == 0) {
            LGM.currentFile.defragIds();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String[] args;
        String com;
        JTree tree = LGM.tree;
        TreePath treepath = tree.getSelectionPath();
        ResNode node = null;
        if (treepath != null) {
            node = (ResNode)treepath.getLastPathComponent();
        }
        if ((com = (args = e.getActionCommand().split(" "))[0]).endsWith(".NEW")) {
            String title = Messages.getString("Listener.CONFIRM_NEW_TITLE");
            String message = Messages.getString("Listener.CONFIRM_NEW");
            int opt = JOptionPane.showConfirmDialog(LGM.frame, message, title, 0);
            if (opt == 0) {
                this.fc.newFile();
            }
            return;
        }
        if (com.endsWith(".OPEN")) {
            try {
                this.fc.open(args.length > 1 ? new URI(args[1]) : null);
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
            return;
        }
        if (com.endsWith(".CLEARRECENT")) {
            PrefsStore.clearRecentFiles();
            return;
        }
        if (com.endsWith(".OPENRECENT")) {
            try {
                this.fc.open(new File(new URI(args[1])));
            }
            catch (URISyntaxException e1) {
                LGM.showDefaultExceptionHandler(e1);
            }
            return;
        }
        if (com.endsWith(".SAVE")) {
            this.fc.save(LGM.currentFile.uri, LGM.currentFile.format);
            return;
        }
        if (com.endsWith(".EXPLORELATERALGM")) {
            String userDir = System.getProperty("user.dir");
            if (userDir == null) {
                return;
            }
            Desktop dt = Desktop.getDesktop();
            try {
                dt.open(new File(userDir));
            }
            catch (IOException e1) {
                LGM.showDefaultExceptionHandler(e1);
            }
        } else if (com.endsWith(".EXPLOREPROJECT")) {
            String userDir = LGM.currentFile.getDirectory();
            if (userDir == null) {
                return;
            }
            Desktop dt = Desktop.getDesktop();
            File f = new File(userDir);
            if (!f.exists()) {
                f = new File(System.getProperty("user.dir"));
            }
            try {
                dt.open(f);
            }
            catch (IOException e1) {
                LGM.showDefaultExceptionHandler(e1);
            }
        } else {
            if (com.endsWith(".PREFERENCES")) {
                LGM.showPreferences();
                return;
            }
            if (com.endsWith(".CST")) {
                LGM.showConstantsFrame(LGM.currentFile.defaultConstants);
                return;
            }
            if (com.endsWith(".GMI")) {
                LGM.showGameInformation();
                return;
            }
            if (com.endsWith(".GMS")) {
                LGM.showGameSettings(LGM.getSelectedConfig());
                return;
            }
            if (com.endsWith(".PKG")) {
                LGM.showExtensionPackages();
                return;
            }
            if (com.endsWith(".SAVEAS")) {
                this.fc.saveNewFile();
                return;
            }
            if (com.endsWith(".EVENT_BUTTON")) {
                Object o = e.getSource();
                if (o instanceof JToggleButton) {
                    LGM.toggleEventPanel();
                }
                return;
            }
            if (com.endsWith(".EXIT")) {
                LGM.onMainFrameClosed();
                return;
            }
            if (com.contains(".INSERT_") || com.contains(".ADD_")) {
                if (com.endsWith("GROUP")) {
                    if (com.contains(".INSERT_")) {
                        Listener.insertResource(tree, null);
                    } else {
                        Listener.addResource(tree, null);
                    }
                    return;
                }
                throw new UnsupportedOperationException(com);
            }
            if (com.endsWith(".RENAME")) {
                if (tree.getCellEditor().isCellEditable(null)) {
                    tree.startEditingAtPath(tree.getLeadSelectionPath());
                }
                return;
            }
            if (com.endsWith(".DELETE")) {
                Listener.deleteSelectedResources(tree);
                return;
            }
            if (com.endsWith(".PACKAGE")) {
                PackageResourcesDialog.getInstance().setVisible(true);
            } else if (com.endsWith(".CHECKNAMES")) {
                Listener.checkNamesInteractive();
            } else if (com.endsWith(".CHECKIDS")) {
                Listener.checkIdsInteractive(true);
            } else {
                if (com.endsWith(".EXPAND")) {
                    int m = 0;
                    while (m < tree.getRowCount()) {
                        tree.expandRow(m);
                        ++m;
                    }
                    return;
                }
                if (com.endsWith(".COLLAPSE")) {
                    int m = tree.getRowCount() - 1;
                    while (m >= 0) {
                        tree.collapseRow(m);
                        --m;
                    }
                    return;
                }
                if (com.endsWith(".SORT")) {
                    if (node == null) {
                        return;
                    }
                    Listener.sortNodeChildrenAlphabetically(node, false);
                    LGM.tree.expandPath(new TreePath(node.getPath()));
                    LGM.tree.updateUI();
                    return;
                }
                if (com.endsWith(".DOCUMENTATION") || com.endsWith(".WEBSITE") || com.endsWith(".COMMUNITY") || com.endsWith(".ISSUE")) {
                    String uri = Prefs.documentationURI;
                    if (com.endsWith(".WEBSITE")) {
                        uri = Prefs.websiteURI;
                    } else if (com.endsWith(".COMMUNITY")) {
                        uri = Prefs.communityURI;
                    } else if (com.endsWith(".ISSUE")) {
                        uri = Prefs.issueURI;
                    }
                    try {
                        Desktop.getDesktop().browse(new URI(uri));
                    }
                    catch (URISyntaxException e1) {
                        JOptionPane.showMessageDialog(LGM.frame, Messages.format("HelpDialog.MALFORMED_MESSAGE", uri), Messages.getString("HelpDialog.MALFORMED_TITLE"), 0);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(LGM.frame, Messages.format("HelpDialog.UNAVAILABLE_MESSAGE", uri), Messages.getString("HelpDialog.UNAVAILABLE_TITLE"), 1);
                    }
                    return;
                }
                if (com.endsWith(".CONFIG_MANAGE")) {
                    ConfigurationManager.getInstance().setVisible(true);
                    return;
                }
                if (com.endsWith(".ABOUT")) {
                    new AboutBox(LGM.frame).setVisible(true);
                    return;
                }
                if (com.endsWith(".DUPLICATE")) {
                    if (node == null) {
                        return;
                    }
                    if (!node.isInstantiable()) {
                        return;
                    }
                    ResourceList rl = (ResourceList)LGM.currentFile.resMap.get(node.kind);
                    if (node.frame != null) {
                        node.frame.commitChanges();
                    }
                    Object resource = rl.duplicate(node.getRes().get());
                    Listener.insertResource(tree, node.kind, resource, node, 1);
                    return;
                }
                if (com.endsWith(".PROPERTIES")) {
                    if (node == null) {
                        return;
                    }
                    if (node.status == 3) {
                        node.openFrame();
                    }
                    return;
                }
                if (com.endsWith(".FIND")) {
                    String name = JOptionPane.showInputDialog(LGM.frame, Messages.getString("FindResourceDialog.MESSAGE"), Messages.getString("FindResourceDialog.TITLE"), -1);
                    if (name != null) {
                        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
                        ResNode resn = (ResNode)this.findNode(root, name, true);
                        if (resn != null) {
                            tree.expandPath(new TreePath(resn.getPath()));
                            tree.setSelectionPath(new TreePath(resn.getPath()));
                            tree.updateUI();
                            if (resn.status == 3) {
                                resn.openFrame();
                            }
                        } else {
                            JOptionPane.showMessageDialog(LGM.frame, "Resource not found: " + name);
                        }
                    }
                    return;
                }
            }
        }
    }

    public static ResNode getPrimaryParent(Class<?> kind) {
        int i = 0;
        while (i < LGM.root.getChildCount()) {
            if (((ResNode)LGM.root.getChildAt((int)i)).kind == kind) {
                return (ResNode)LGM.root.getChildAt(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        ResNode n = (ResNode)((JTree)c).getLastSelectedPathComponent();
        if (n.status == 1) {
            return null;
        }
        if (!n.isInstantiable()) {
            return null;
        }
        return n;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    public boolean canImportNode(ResNode dragNode, ResNode dropNode) {
        if (dragNode == dropNode) {
            return false;
        }
        return !Prefs.groupKind || dropNode.kind == dragNode.kind;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDataFlavorSupported(ResNode.DATA_FLAVOR)) {
            return false;
        }
        DataFlavor[] dataFlavorArray = support.getDataFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor f = dataFlavorArray[n2];
            if (f != ResNode.DATA_FLAVOR) {
                return false;
            }
            ++n2;
        }
        TreePath drop = ((JTree.DropLocation)support.getDropLocation()).getPath();
        if (drop == null) {
            return false;
        }
        ResNode dropNode = (ResNode)drop.getLastPathComponent();
        if (dropNode.status == 3) {
            return false;
        }
        TreePath[] paths = ((JTree)support.getComponent()).getSelectionPaths();
        int i = 0;
        while (i < paths.length) {
            ResNode dragNode = (ResNode)paths[i].getLastPathComponent();
            if (!this.canImportNode(dragNode, dropNode)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        JTree.DropLocation drop = (JTree.DropLocation)support.getDropLocation();
        ResNode dropNode = (ResNode)drop.getPath().getLastPathComponent();
        TreePath[] paths = ((JTree)support.getComponent()).getSelectionPaths();
        DefaultTreeModel model = (DefaultTreeModel)((JTree)support.getComponent()).getModel();
        int ancestors = 0;
        ArrayList<ResNode> nodes = new ArrayList<ResNode>(paths.length);
        TreePath[] treePathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            ResNode dragNode = (ResNode)treePath.getLastPathComponent();
            if (dropNode == dragNode.getParent()) {
                ++ancestors;
            }
            nodes.add(dragNode);
            model.removeNodeFromParent(dragNode);
            ++n2;
        }
        int dropIndex = drop.getChildIndex();
        if (dropIndex == -1) {
            dropIndex = dropNode.getChildCount();
        } else if (dropIndex > dropNode.getChildCount() - ancestors && (dropIndex -= ancestors) < 0) {
            dropIndex = 0;
        }
        for (ResNode dragNode : nodes) {
            dropNode.insert(dragNode, dropIndex++);
        }
        LGM.tree.expandPath(new TreePath(dropNode.getPath()));
        LGM.tree.updateUI();
        return true;
    }

    public static void sortNodeChildrenAlphabetically(TreeNode node, boolean recursive) {
        DefaultMutableTreeNode defaultNode = (DefaultMutableTreeNode)node;
        ArrayList<? extends TreeNode> children = Collections.list(node.children());
        Comparator<TreeNode> comp = new Comparator<TreeNode>(){

            @Override
            public int compare(TreeNode o1, TreeNode o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };
        Collections.sort(children, comp);
        defaultNode.removeAllChildren();
        for (TreeNode treeNode : children) {
            defaultNode.add((DefaultMutableTreeNode)treeNode);
            if (!recursive || treeNode.getChildCount() <= 0) continue;
            Listener.sortNodeChildrenAlphabetically(treeNode, recursive);
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        ResNode node = (ResNode)LGM.tree.getLastSelectedPathComponent();
        if (node.status == 3 && node.isEditable()) {
            String txt = ((String)node.getUserObject()).replaceAll("\\W", "").replaceAll("^([0-9]+)", "");
            Resource<?, ?> r = Util.deRef(node.getRes());
            if (r != null) {
                r.setName(txt);
            }
        }
    }

    /* synthetic */ Listener(Listener listener) {
        this();
    }

    private static final class LazyHolder {
        public static final Listener INSTANCE = new Listener(null);

        private LazyHolder() {
        }
    }

    private static class MListener
    extends MouseAdapter {
        private MListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ResNode node;
            if (e.getSource() != LGM.tree) {
                return;
            }
            TreePath path = LGM.tree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            TreePath[] paths = LGM.tree.getSelectionPaths();
            boolean inpath = false;
            if (paths != null) {
                int i = 0;
                while (i < paths.length) {
                    if (paths[i].equals(path)) {
                        inpath = true;
                    }
                    ++i;
                }
            }
            if (e.getButton() == 1 && inpath) {
                LGM.tree.setSelectionPath(path);
            }
            if ((node = (ResNode)path.getLastPathComponent()) == null) {
                return;
            }
            if (e.getButton() == 3 && e.getClickCount() == 1) {
                if (!inpath) {
                    LGM.tree.setSelectionPath(path);
                }
                node.showMenu(e);
                return;
            }
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                if (node.status != 3) {
                    return;
                }
                node.openFrame();
                return;
            }
        }
    }

    public static class NodeMenuListener
    implements ActionListener {
        ResNode node;

        public NodeMenuListener(ResNode node) {
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTree tree = LGM.tree;
            String com = e.getActionCommand();
            if (com.endsWith("PROPERTIES")) {
                if (this.node.status == 3) {
                    this.node.openFrame();
                }
                return;
            }
            if (com.endsWith("SORT")) {
                Listener.sortNodeChildrenAlphabetically(this.node, false);
                LGM.tree.expandPath(new TreePath(this.node.getPath()));
                LGM.tree.updateUI();
                return;
            }
            if (com.endsWith("DELETE")) {
                Listener.deleteSelectedResources(tree);
                return;
            }
            if (com.endsWith("RENAME")) {
                if (tree.getCellEditor().isCellEditable(null)) {
                    tree.startEditingAtPath(tree.getLeadSelectionPath());
                }
                return;
            }
            if (com.endsWith("CREATE_RESOURCE")) {
                Listener.addResource(tree, this.node.kind, this.node);
                return;
            }
            if (com.endsWith("CREATE_GROUP")) {
                Listener.addResource(tree, null, this.node);
                return;
            }
            if (com.endsWith("INSERT_RESOURCE")) {
                Listener.insertResource(tree, this.node.kind, this.node);
                return;
            }
            if (com.endsWith("INSERT_GROUP")) {
                Listener.insertResource(tree, null, this.node);
                return;
            }
            if (com.endsWith("DUPLICATE_RESOURCE")) {
                ResourceList rl = (ResourceList)LGM.currentFile.resMap.get(this.node.kind);
                if (this.node.frame != null) {
                    this.node.frame.commitChanges();
                }
                Object resource = rl.duplicate(this.node.getRes().get());
                Listener.insertResource(tree, this.node.kind, resource, this.node, 1);
                return;
            }
        }
    }

    public static class ResourceAdder
    implements ActionListener {
        public boolean insert;
        public Class<?> k;

        public ResourceAdder(boolean insert, Class<?> k) {
            this.insert = insert;
            this.k = k;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.insert) {
                Listener.insertResource(LGM.tree, this.k);
            } else {
                Listener.addResource(LGM.tree, this.k);
            }
        }
    }
}

