/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.main;

import com.sun.imageio.plugins.wbmp.WBMPImageReaderSpi;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.imageio.spi.IIORegistry;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lateralgm.components.ErrorDialog;
import org.lateralgm.components.GmMenuBar;
import org.lateralgm.components.GmTreeGraphics;
import org.lateralgm.components.impl.CustomFileFilter;
import org.lateralgm.components.impl.FramePrefsHandler;
import org.lateralgm.components.impl.GmTreeEditor;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.components.mdi.MDIPane;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.file.iconio.ICOFile;
import org.lateralgm.file.iconio.ICOImageReaderSPI;
import org.lateralgm.file.iconio.WBMPImageReaderSpiFix;
import org.lateralgm.main.FileChooser;
import org.lateralgm.main.Listener;
import org.lateralgm.main.OutputManager;
import org.lateralgm.main.PreferencesFrame;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.PrefsStore;
import org.lateralgm.main.Search;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Constants;
import org.lateralgm.resources.GameInformation;
import org.lateralgm.resources.GameSettings;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.library.LibManager;
import org.lateralgm.subframes.ConfigurationManager;
import org.lateralgm.subframes.ConstantsFrame;
import org.lateralgm.subframes.EventPanel;
import org.lateralgm.subframes.ExtensionPackagesFrame;
import org.lateralgm.subframes.GameInformationFrame;
import org.lateralgm.subframes.GameSettingFrame;
import org.lateralgm.subframes.ResourceFrame;

public final class LGM {
    public static final String version = "1.8.229";
    public static final ArrayList<URLClassLoader> classLoaders = new ArrayList();
    public static boolean LOADING_PROJECT = false;
    private static JDialog progressDialog = null;
    private static JProgressBar progressDialogBar = null;
    private static String progressTitle;
    public static String iconspath;
    public static String iconspack;
    public static String themename;
    private static boolean themechanged;
    private static boolean windowModified;
    public static int javaVersion;
    public static File tempDir;
    public static File workDir;
    public static JFrame frame;
    public static JPanel contents;
    public static JToolBar tool;
    public static JToolBar filterPanel;
    public static JTree tree;
    public static JTree searchTree;
    public static ResNode root;
    public static ProjectFile currentFile;
    public static MDIPane mdi;
    private static ConstantsFrame constantsFrame;
    private static GameInformationFrame gameInfo;
    private static GameSettingFrame gameSet;
    private static ExtensionPackagesFrame extSet;
    private static EventPanel eventSelect;
    private static JDialog eventDialog;
    private static AbstractButton eventButton;
    public static PreferencesFrame prefFrame;
    public static Cursor zoomCursor;
    public static Cursor zoomInCursor;
    public static Cursor zoomOutCursor;
    public static GmMenuBar menuBar;
    public static JComboBox<GameSettings> configsCombo;
    private static final HashMap<String, ImageIcon> iconCache;
    private static Properties iconProps;
    protected static ArrayList<ReloadListener> reloadListeners;
    static JTabbedPane treeTabs;

    static {
        iconspath = "org/lateralgm/icons/";
        iconspack = "Calico";
        themename = "Swing";
        themechanged = false;
        windowModified = false;
        String jv = System.getProperty("java.version");
        Scanner s = new Scanner(jv);
        s.useDelimiter("[\\._-]");
        int major = s.hasNextInt() ? s.nextInt() * 10000 : 0;
        int minor = s.hasNextInt() ? s.nextInt() * 100 : 0;
        int patch = s.hasNextInt() ? s.nextInt() : 0;
        javaVersion = major + minor + patch;
        s.close();
        IIORegistry reg = IIORegistry.getDefaultInstance();
        reg.registerServiceProvider(new ICOImageReaderSPI());
        reg.deregisterServiceProvider(reg.getServiceProviderByClass(WBMPImageReaderSpi.class));
        reg.registerServiceProvider(new WBMPImageReaderSpiFix());
        try {
            workDir = new File(LGM.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception e) {
            System.err.println(Messages.format("LGM.NO_WORKDIR", e.getClass(), e.getLocalizedMessage()));
        }
        tempDir = new File(System.getProperty("java.io.tmpdir"), "lgm");
        if (!tempDir.exists()) {
            tempDir.mkdir();
            if (javaVersion >= 10600) {
                tempDir.setReadable(true, false);
                tempDir.setWritable(true, false);
            }
        }
        currentFile = new ProjectFile();
        iconCache = new HashMap();
        iconProps = null;
        reloadListeners = new ArrayList();
    }

    private LGM() {
    }

    public static JDialog getProgressDialog() {
        if (progressDialog == null) {
            progressDialog = new JDialog((Frame)frame, true);
            progressDialogBar = new JProgressBar(0, 100);
            progressDialogBar.setStringPainted(true);
            progressDialog.add("Center", progressDialogBar);
            progressDialog.setDefaultCloseOperation(0);
            progressDialog.pack();
            progressDialog.setLocationRelativeTo(frame);
            progressDialog.setResizable(false);
        }
        return progressDialog;
    }

    public static void showProgressDialog() {
        LGM.getProgressDialog();
        progressDialogBar.setValue(0);
        progressDialogBar.setMinimum(0);
        progressDialogBar.setMaximum(100);
        progressDialogBar.setIndeterminate(true);
        progressDialog.setTitle("");
        progressDialog.setVisible(true);
    }

    public static void setProgressDialogVisible(boolean visible) {
        if (visible) {
            LGM.showProgressDialog();
        } else {
            progressDialog.setVisible(false);
        }
    }

    public static void setProgressTitle(String title) {
        progressTitle = title;
    }

    public static void initProgressDialog(int min, int max, String title) {
        progressDialogBar.setMinimum(min);
        progressDialogBar.setMaximum(max);
        progressDialogBar.setIndeterminate(false);
        progressTitle = title;
    }

    public static void setProgress(int value, String message) {
        progressDialog.setTitle(String.valueOf(progressTitle) + " - " + message);
        progressDialogBar.setValue(value);
    }

    private static void createMouseCursors() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image cimg = LGM.getIconForKey("CursorDisplay.ZOOM").getImage();
        BufferedImage img = new BufferedImage(32, 32, 2);
        Graphics2D g = img.createGraphics();
        g.drawImage(cimg, 0, 0, null);
        g.dispose();
        zoomCursor = toolkit.createCustomCursor(img, new Point(0, 0), "Zoom");
        cimg = LGM.getIconForKey("CursorDisplay.ZOOM_IN").getImage();
        img = new BufferedImage(32, 32, 2);
        g = img.createGraphics();
        g.drawImage(cimg, 0, 0, null);
        g.dispose();
        zoomInCursor = toolkit.createCustomCursor(img, new Point(0, 0), "ZoomIn");
        cimg = LGM.getIconForKey("CursorDisplay.ZOOM_OUT").getImage();
        img = new BufferedImage(32, 32, 2);
        g = img.createGraphics();
        g.drawImage(cimg, 0, 0, null);
        g.dispose();
        zoomOutCursor = toolkit.createCustomCursor(img, new Point(0, 0), "ZoomOut");
    }

    public static void setLookAndFeel(String LOOKANDFEEL) {
        if (LOOKANDFEEL.equals(themename) && !LOOKANDFEEL.equals("Custom")) {
            themechanged = false;
            return;
        }
        themechanged = true;
        themename = LOOKANDFEEL;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (workDir != null) {
            File[] ps;
            File dir = new File(workDir, "lookandfeels");
            if (!dir.exists()) {
                dir = new File(workDir.getParent(), "lookandfeels");
            }
            if ((ps = dir.listFiles(new CustomFileFilter(null, ".jar"))) != null) {
                File[] fileArray = ps;
                int n = ps.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.exists()) {
                        try {
                            urls.add(f.toURI().toURL());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
            }
        }
        URLClassLoader lafClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
        UIManager.put("ClassLoader", lafClassLoader);
        String lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
        if (LOOKANDFEEL != null) {
            if (LOOKANDFEEL.equals("Swing")) {
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
                lookAndFeel = "javax.swing.plaf.metal.MetalLookAndFeel";
                MetalLookAndFeel.setCurrentTheme(new OceanTheme());
            } else if (LOOKANDFEEL.equals("Native")) {
                lookAndFeel = UIManager.getSystemLookAndFeelClassName();
            } else if (LOOKANDFEEL.equals("Nimbus")) {
                lookAndFeel = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
            } else if (LOOKANDFEEL.equals("Windows")) {
                lookAndFeel = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            } else if (LOOKANDFEEL.equals("Windows Classic")) {
                lookAndFeel = "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel";
                UIManager.put("InternalFrame.titleButtonWidth", 22);
                UIManager.put("InternalFrame.titleButtonHeight", 22);
            } else if (LOOKANDFEEL.equals("CDE/Motif")) {
                lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            } else if (LOOKANDFEEL.equals("Metal")) {
                lookAndFeel = "javax.swing.plaf.metal.MetalLookAndFeel";
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            } else if (LOOKANDFEEL.equals("Ocean")) {
                lookAndFeel = "javax.swing.plaf.metal.MetalLookAndFeel";
                MetalLookAndFeel.setCurrentTheme(new OceanTheme());
            } else if (LOOKANDFEEL.equals("GTK+")) {
                lookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            } else if (LOOKANDFEEL.equals("Custom")) {
                lookAndFeel = Prefs.swingThemePath;
            } else {
                boolean foundMatch = false;
                UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
                int i = 0;
                while (i < lnfs.length) {
                    if (LOOKANDFEEL.equals(lnfs[i].getName())) {
                        lookAndFeel = lnfs[i].getClassName();
                        foundMatch = true;
                        break;
                    }
                    ++i;
                }
                if (!foundMatch) {
                    System.err.println("Unexpected value of LOOKANDFEEL specified: " + LOOKANDFEEL);
                    lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
                }
            }
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(lafClassLoader);
                    UIManager.setLookAndFeel(lookAndFeel);
                }
                catch (Exception e) {
                    LGM.showDefaultExceptionHandler(e);
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    public static void updateLookAndFeel() {
        Window[] windows;
        if (!themechanged) {
            return;
        }
        Window[] windowArray = windows = Window.getWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            Window window = windowArray[n2];
            SwingUtilities.updateComponentTreeUI(window);
            ++n2;
        }
    }

    public static ConstantsFrame getConstantsFrame() {
        return constantsFrame;
    }

    public static GameInformationFrame getGameInfo() {
        return gameInfo;
    }

    public static GameSettingFrame getGameSettings() {
        return gameSet;
    }

    public static ExtensionPackagesFrame getExtensionPackages() {
        return extSet;
    }

    public static void showConstantsFrame(final Constants cnsts) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (constantsFrame.res != cnsts && constantsFrame.resOriginal != cnsts) {
                    constantsFrame.res = cnsts;
                    constantsFrame.resOriginal = (Constants)cnsts.clone();
                    constantsFrame.revertResource();
                }
                constantsFrame.updateTitle();
                LGM.getConstantsFrame().setVisible(true);
                LGM.getConstantsFrame().toTop();
            }
        };
        constantsFrame.doDefaultCloseAction(run);
    }

    public static void showGameInformation() {
        LGM.getGameInfo().setVisible(true);
        LGM.getGameInfo().toTop();
    }

    public static void showGameSettings(final GameSettings set) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (gameSet.res != set && gameSet.resOriginal != set) {
                    gameSet.res = set;
                    gameSet.resOriginal = (GameSettings)set.clone();
                    gameSet.revertResource();
                }
                gameSet.updateTitle();
                LGM.getGameSettings().setVisible(true);
                LGM.getGameSettings().toTop();
            }
        };
        gameSet.doDefaultCloseAction(run);
    }

    public static void showExtensionPackages() {
        LGM.getExtensionPackages().setVisible(true);
        LGM.getExtensionPackages().toTop();
    }

    private static ImageIcon loadIcon(String filename) {
        String location = null;
        URL url = null;
        if (Prefs.iconPack.equals("Custom")) {
            String custompath = String.valueOf(Prefs.iconPath) + filename;
            if (new File(custompath).exists()) {
                location = custompath;
            } else {
                String fallback = String.valueOf(iconspath) + "Calico/" + filename;
                url = LGM.class.getClassLoader().getResource(fallback);
            }
        } else {
            String jarpath = String.valueOf(iconspath) + iconspack + '/' + filename;
            url = LGM.class.getClassLoader().getResource(jarpath);
        }
        if (location != null) {
            return new ImageIcon(location);
        }
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    public static ImageIcon findIcon(String filename) {
        ImageIcon ico = iconCache.get(filename);
        if (ico != null) {
            return ico;
        }
        ico = LGM.loadIcon(filename);
        if (ico != null) {
            iconCache.put(filename, ico);
        }
        return ico;
    }

    public static void reloadIcons() {
        Window[] windows;
        for (Map.Entry<String, ImageIcon> ico : iconCache.entrySet()) {
            ico.getValue().getImage().flush();
            ImageIcon fresh = LGM.loadIcon(ico.getKey());
            ico.getValue().setImage(fresh.getImage());
        }
        Window[] windowArray = windows = Window.getWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            Window window = windowArray[n2];
            window.repaint();
            ++n2;
        }
    }

    public static ImageIcon getIconForKey(String key) {
        String filename;
        if (iconProps == null) {
            iconProps = new Properties();
            InputStream is = LGM.class.getClassLoader().getResourceAsStream("org/lateralgm/main/icons.properties");
            try {
                if (is == null) {
                    throw new IOException();
                }
                iconProps.load(is);
            }
            catch (IOException e) {
                System.err.println("Unable to read icons.properties");
            }
        }
        if (!(filename = iconProps.getProperty(key, "")).isEmpty()) {
            return LGM.findIcon(filename);
        }
        return null;
    }

    public static JButton makeButton(String key) {
        JButton but = new JButton();
        LGM.makeButton(but, key);
        return but;
    }

    public static AbstractButton makeButton(AbstractButton but, String key) {
        ImageIcon ico = LGM.getIconForKey(key);
        if (ico != null) {
            but.setIcon(ico);
        } else {
            but.setIcon(GmTreeGraphics.getBlankIcon());
        }
        but.setActionCommand(key);
        but.setToolTipText(Messages.getString(key));
        but.addActionListener(Listener.getInstance());
        return but;
    }

    private static JToolBar createToolBar() {
        tool = new JToolBar();
        tool.setFloatable(true);
        tool.add(LGM.makeButton("Toolbar.NEW"));
        tool.add(LGM.makeButton("Toolbar.OPEN"));
        tool.add(LGM.makeButton("Toolbar.SAVE"));
        tool.add(LGM.makeButton("Toolbar.SAVEAS"));
        tool.addSeparator();
        for (Class<? extends Resource<?, ?>> clazz : Resource.kinds) {
            if (!InstantiableResource.class.isAssignableFrom(clazz)) continue;
            Icon ico = ResNode.ICON.get(clazz);
            if (ico == null) {
                ico = GmTreeGraphics.getBlankIcon();
            }
            JButton but = new JButton(ico);
            but.setToolTipText(Messages.format("Toolbar.ADD", Resource.kindNames.get(clazz)));
            but.addActionListener(new Listener.ResourceAdder(false, clazz));
            tool.add(but);
        }
        tool.addSeparator();
        tool.add(LGM.makeButton("Toolbar.CST"));
        tool.add(LGM.makeButton("Toolbar.GMI"));
        tool.add(LGM.makeButton("Toolbar.PKG"));
        tool.addSeparator();
        tool.add(new JLabel(Messages.getString("Toolbar.CONFIGURATION")));
        configsCombo = new JComboBox();
        configsCombo.setModel(new DefaultComboBoxModel<GameSettings>(LGM.currentFile.gameSettings));
        configsCombo.setMaximumSize(configsCombo.getPreferredSize());
        tool.add(configsCombo);
        tool.add(LGM.makeButton("Toolbar.CONFIG_MANAGE"));
        tool.addSeparator();
        tool.add(LGM.makeButton("Toolbar.GMS"));
        tool.addSeparator();
        tool.add(LGM.makeButton("Toolbar.PREFERENCES"));
        tool.add(LGM.makeButton("Toolbar.DOCUMENTATION"));
        tool.add(Box.createHorizontalGlue());
        eventButton = LGM.makeButton(new JToggleButton(), "Toolbar.EVENT_BUTTON");
        tool.add(eventButton);
        return tool;
    }

    private static JTree createTree() {
        return LGM.createTree(LGM.newRoot());
    }

    private static JTree createTree(ResNode newroot) {
        Search.InvisibleTreeModel ml = new Search.InvisibleTreeModel(newroot);
        ml.activateFilter(false);
        tree = new JTree(ml);
        GmTreeGraphics renderer = new GmTreeGraphics();
        GmTreeEditor editor = new GmTreeEditor(tree, renderer);
        editor.addCellEditorListener(Listener.getInstance());
        tree.setEditable(true);
        tree.addMouseListener(Listener.getInstance().mListener);
        if (javaVersion >= 10600) {
            tree.setTransferHandler(Listener.getInstance());
            tree.setDragEnabled(true);
            tree.setDropMode(DropMode.ON_OR_INSERT);
        }
        tree.setCellRenderer(renderer);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setCellEditor(editor);
        tree.getSelectionModel().setSelectionMode(4);
        InputMap im = tree.getInputMap();
        KeyStroke[] keyStrokeArray = im.allKeys();
        int n = keyStrokeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyStroke s = keyStrokeArray[n2];
            Object o = im.get(s);
            if (o.equals("cut") || o.equals("copy") || o.equals("paste")) {
                im.put(s, "none");
            }
            ++n2;
        }
        return tree;
    }

    public static ResNode newRoot() {
        root = new ResNode("Root", 0, null, null);
        return root;
    }

    private static JComponent createMDI() {
        mdi = new MDIPane();
        JScrollPane scroll = new JScrollPane(mdi);
        mdi.setScrollPane(scroll);
        scroll.setHorizontalScrollBarPolicy(30);
        scroll.setVerticalScrollBarPolicy(20);
        mdi.setBackground(Color.GRAY);
        return scroll;
    }

    public static void loadPlugins() {
        File[] ps;
        if (workDir == null) {
            return;
        }
        File dir = new File(workDir.getParent(), "plugins");
        if (!dir.exists()) {
            dir = new File(workDir.getParent(), "Plugins");
        }
        if ((ps = dir.listFiles(new CustomFileFilter(null, ".jar"))) == null) {
            return;
        }
        File[] fileArray = ps;
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.exists()) {
                try {
                    String pluginEntry = "LGM-Plugin";
                    JarFile jar = new JarFile(f);
                    Manifest mf = jar.getManifest();
                    jar.close();
                    String clastr = mf.getMainAttributes().getValue(pluginEntry);
                    if (clastr == null) {
                        throw new Exception(Messages.format("LGM.PLUGIN_MISSING_ENTRY", pluginEntry));
                    }
                    URLClassLoader ucl = new URLClassLoader(new URL[]{f.toURI().toURL()});
                    ucl.loadClass(clastr).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    classLoaders.add(ucl);
                }
                catch (Exception e) {
                    String msgInd = "LGM.PLUGIN_LOAD_ERROR";
                    LGM.showDefaultExceptionHandler(new Exception(Messages.format(msgInd, f.getName()), e));
                }
            }
            ++n2;
        }
    }

    public static void populateTree() {
        for (Class<Resource<?, ?>> k : Resource.kinds) {
            boolean hasNode = true;
            Enumeration<TreeNode> children = root.depthFirstEnumeration();
            while (children.hasMoreElements()) {
                ResNode it = (ResNode)children.nextElement();
                if (it.kind != k) continue;
                hasNode = false;
                break;
            }
            if (!hasNode) continue;
            try {
                hasNode = k.getField("hasNode").getBoolean(hasNode);
            }
            catch (IllegalArgumentException e) {
                LGM.showDefaultExceptionHandler(e);
            }
            catch (NoSuchFieldException e) {
                LGM.showDefaultExceptionHandler(e);
            }
            catch (SecurityException e) {
                LGM.showDefaultExceptionHandler(e);
            }
            catch (IllegalAccessException e) {
                LGM.showDefaultExceptionHandler(e);
            }
            if (!hasNode) continue;
            String name = Resource.kindNamesPlural.get(k);
            byte status = InstantiableResource.class.isAssignableFrom(k) ? (byte)1 : 3;
            root.addChild(name, status, k);
        }
        tree.setSelectionPath(new TreePath(root).pathByAddingChild(root.getChildAt(0)));
    }

    public static void commitAll() {
        Enumeration<TreeNode> nodes = root.preorderEnumeration();
        while (nodes.hasMoreElements()) {
            ResNode node = (ResNode)nodes.nextElement();
            if (node.frame == null) continue;
            node.frame.commitChanges();
        }
        LGM.getExtensionPackages().commitChanges();
        LGM.getConstantsFrame().commitChanges();
        LGM.getGameInfo().commitChanges();
        LGM.getGameSettings().commitChanges();
    }

    public static void reload(boolean newRoot) {
        mdi.closeAll();
        LGM.setWindowModified(false);
        Search.InvisibleTreeModel ml = new Search.InvisibleTreeModel(root);
        tree.setModel(ml);
        ml.activateFilter(Search.pruneResultsCB.isSelected());
        if (ml.isActivatedFilter()) {
            Search.applyFilter(root.getChildren(), ml.isActivatedFilter(), Search.filterText.getText(), false, Search.wholeWordCB.isSelected(), true);
        }
        tree.setSelectionRow(0);
        DefaultMutableTreeNode searchRoot = (DefaultMutableTreeNode)searchTree.getModel().getRoot();
        searchRoot.removeAllChildren();
        ((DefaultTreeModel)searchTree.getModel()).reload();
        eventSelect.reload();
        ConfigurationManager.getInstance().setConfigList(LGM.currentFile.gameSettings);
        configsCombo.setModel(new DefaultComboBoxModel<GameSettings>(LGM.currentFile.gameSettings));
        LGM.constantsFrame.res = LGM.currentFile.defaultConstants;
        LGM.constantsFrame.resOriginal = (Constants)LGM.currentFile.defaultConstants.clone();
        constantsFrame.revertResource();
        constantsFrame.setVisible(false);
        LGM.gameInfo.res = LGM.currentFile.gameInfo;
        LGM.gameInfo.resOriginal = (GameInformation)LGM.currentFile.gameInfo.clone();
        gameInfo.revertResource();
        gameInfo.setVisible(false);
        LGM.gameSet.res = LGM.currentFile.gameSettings.firstElement();
        LGM.gameSet.resOriginal = (GameSettings)LGM.currentFile.gameSettings.firstElement().clone();
        gameSet.revertResource();
        gameSet.setVisible(false);
        LGM.fireReloadPerformed(newRoot);
    }

    public static void addReloadListener(ReloadListener l) {
        reloadListeners.add(l);
    }

    public static void removeReloadListener(ReloadListener l) {
        reloadListeners.remove(l);
    }

    protected static void fireReloadPerformed(boolean newRoot) {
        for (ReloadListener rl : reloadListeners) {
            rl.reloadPerformed(newRoot);
        }
        LOADING_PROJECT = false;
    }

    public static void addPluginResource(PluginResource pr) {
        String p;
        ImageIcon i = pr.getIcon();
        if (i != null) {
            ResNode.ICON.put(pr.getKind(), i);
        }
        if ((p = pr.getPrefix()) != null) {
            Prefs.prefixes.put(pr.getKind(), p);
        }
        Resource.addKind(pr.getKind(), pr.getName3(), pr.getName(), pr.getPlural());
        LGM.currentFile.resMap.put(pr.getKind(), pr.getResourceHolder());
        ResourceFrame.factories.put(pr.getKind(), pr.getResourceFrameFactory());
    }

    public static void applyPreferences() {
        if (javaVersion >= 10700 && Prefs.locale != null) {
            Locale.setDefault(Prefs.locale);
        }
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        if (Prefs.direct3DAcceleration.equals("off")) {
            System.setProperty("sun.java2d.d3d", "false");
            System.setProperty("sun.java2d.ddscale", "false");
        } else if (Prefs.direct3DAcceleration.equals("on")) {
            System.setProperty("sun.java2d.d3d", "true");
            System.setProperty("sun.java2d.ddscale", "true");
        }
        if (Prefs.openGLAcceleration.equals("off")) {
            System.setProperty("sun.java2d.opengl", "false");
        } else if (Prefs.openGLAcceleration.equals("on")) {
            System.setProperty("sun.java2d.opengl", "true");
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                System.setProperty("sun.java2d.noddraw", "true");
                System.setProperty("sun.java2d.opengl.fbobject", "false");
            }
        }
        if (!Prefs.antialiasControlFont.equals("default")) {
            System.setProperty("awt.useSystemAAFontSettings", Prefs.antialiasControlFont);
            if (Prefs.antialiasControlFont.equals("off")) {
                System.setProperty("swing.aatext", "false");
            } else {
                System.setProperty("swing.aatext", "true");
            }
        }
        JFrame.setDefaultLookAndFeelDecorated(Prefs.decorateWindowBorders);
        JDialog.setDefaultLookAndFeelDecorated(Prefs.decorateWindowBorders);
        Window[] windows = Window.getWindows();
        LookAndFeel laf = UIManager.getLookAndFeel();
        Window[] windowArray = windows;
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            Dialog decdialog;
            boolean decorate;
            Window window = windowArray[n2];
            final boolean visible = window.isVisible();
            boolean bl = decorate = Prefs.decorateWindowBorders && laf.getSupportsWindowDecorations();
            if (window instanceof Frame) {
                final Frame decframe = (Frame)window;
                if (decorate != decframe.isUndecorated()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            decframe.dispose();
                            decframe.setShape(null);
                            decframe.setUndecorated(decorate);
                            if (decframe instanceof RootPaneContainer) {
                                ((RootPaneContainer)((Object)decframe)).getRootPane().setWindowDecorationStyle(decorate ? 1 : 0);
                            }
                            decframe.setVisible(visible);
                        }
                    });
                }
            } else if (window instanceof Dialog && decorate != (decdialog = (Dialog)window).isUndecorated()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        decdialog.dispose();
                        decdialog.setShape(null);
                        decdialog.setUndecorated(decorate);
                        if (decdialog instanceof RootPaneContainer) {
                            ((RootPaneContainer)((Object)decdialog)).getRootPane().setWindowDecorationStyle(decorate ? 2 : 0);
                        }
                        decdialog.setVisible(visible);
                    }
                });
            }
            ++n2;
        }
    }

    private static void createAndShowGUI(String[] args) {
        LGM.applyPreferences();
        iconspack = Prefs.iconPack;
        LGM.setLookAndFeel(Prefs.swingTheme);
        themechanged = false;
        SplashProgress splashProgress = new SplashProgress();
        splashProgress.start();
        frame = new JFrame(Messages.format("LGM.TITLE", Messages.getString("LGM.NEWGAME")));
        splashProgress.progress(10, Messages.getString("LGM.SPLASH_LANG"));
        Messages.updateLangPack();
        splashProgress.progress(15, Messages.getString("LGM.SPLASH_CURSOR"));
        LGM.createMouseCursors();
        splashProgress.progress(20, Messages.getString("LGM.SPLASH_LIBS"));
        LibManager.autoLoad();
        splashProgress.progress(30, Messages.getString("LGM.SPLASH_TOOLS"));
        JToolBar toolbar = LGM.createToolBar();
        tree = LGM.createTree();
        searchTree = Search.createSearchTree();
        treeTabs = new JTabbedPane();
        treeTabs.addTab(Messages.getString("TreeFilter.TAB_RESOURCES"), new JScrollPane(tree));
        treeTabs.addTab(Messages.getString("TreeFilter.TAB_SEARCHRESULTS"), new JScrollPane(searchTree));
        contents = new JPanel(new BorderLayout());
        contents.add("Center", LGM.createMDI());
        eventSelect = new EventPanel();
        filterPanel = Search.createSearchToolbar();
        JPanel hierarchyPanel = new JPanel();
        hierarchyPanel.setLayout(new BorderLayout(0, 0));
        hierarchyPanel.add((Component)filterPanel, "North");
        hierarchyPanel.add((Component)treeTabs, "Center");
        hierarchyPanel.setPreferredSize(new Dimension(320, 320));
        splashProgress.progress(40, Messages.getString("LGM.SPLASH_THREAD"));
        constantsFrame = new ConstantsFrame(LGM.currentFile.defaultConstants);
        mdi.add(constantsFrame);
        gameInfo = new GameInformationFrame(LGM.currentFile.gameInfo);
        mdi.add(gameInfo);
        gameSet = new GameSettingFrame(LGM.currentFile.gameSettings.firstElement());
        mdi.add(gameSet);
        extSet = new ExtensionPackagesFrame(LGM.currentFile.extPackages);
        mdi.add(extSet);
        splashProgress.progress(50, Messages.getString("LGM.SPLASH_MENU"));
        menuBar = new GmMenuBar();
        frame.setJMenuBar(menuBar);
        splashProgress.progress(60, Messages.getString("LGM.SPLASH_UI"));
        JPanel f = new JPanel(new BorderLayout());
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent winEvt) {
                LGM.onMainFrameClosed();
            }
        });
        JSplitPane verSplit = new JSplitPane(0, true, contents, OutputManager.outputTabs);
        JSplitPane horSplit = new JSplitPane(1, true);
        Util.orientSplit(horSplit, Prefs.rightOrientation, hierarchyPanel, verSplit);
        f.add(horSplit);
        frame.setContentPane(f);
        frame.setTransferHandler(new FileChooser.LGMDropHandler(Listener.getInstance().fc));
        f.add("North", toolbar);
        f.setOpaque(true);
        splashProgress.progress(65, Messages.getString("LGM.SPLASH_LOGO"));
        try {
            ICOFile icoFile = new ICOFile(LGM.class.getClassLoader().getResource("org/lateralgm/main/lgm-logo.ico"));
            frame.setIconImages(icoFile.getImages());
        }
        catch (Exception e) {
            LGM.showDefaultExceptionHandler(e);
        }
        if (new File("lookandfeels/lgmbackground.png").exists()) {
            LGM.applyBackground("lookandfeels/lgmbackground.png");
        } else {
            LGM.applyBackground("org/lateralgm/main/lgmbackground.png");
        }
        splashProgress.progress(70, Messages.getString("LGM.SPLASH_TREE"));
        LGM.populateTree();
        splashProgress.progress(80, Messages.getString("LGM.SPLASH_PLUGINS"));
        LOADING_PROJECT = true;
        LGM.loadPlugins();
        splashProgress.complete();
        new FramePrefsHandler(frame);
        frame.setVisible(true);
        if (args.length > 0 && args[0].length() > 0) {
            Listener.getInstance().fc.open(new File(args[0]));
        } else {
            LOADING_PROJECT = false;
        }
        Listener.getInstance().updateBackupTimer();
    }

    public static void main(final String[] args) {
        LGM.setDefaultExceptionHandler();
        System.out.format("Java Version: %d (%s)\n", javaVersion, System.getProperty("java.version"));
        if (javaVersion < 10700) {
            System.out.println("Some program functionality will be limited due to your outdated Java version");
        }
        PrefsStore.patchRecentFiles();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LGM.createAndShowGUI(args);
            }
        });
    }

    public static int getTabIndex(JTabbedPane tabs, String title) {
        int i = 0;
        while (i < tabs.getTabCount()) {
            if (tabs.getTitleAt(i).equals(title)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void setSelectedTab(JTabbedPane tabs, String title) {
        if (tabs.getTitleAt(tabs.getSelectedIndex()).equals(title)) {
            return;
        }
        int index = LGM.getTabIndex(tabs, title);
        if (index == -1) {
            return;
        }
        tabs.setSelectedIndex(index);
    }

    public static boolean isWindowModified() {
        JInternalFrame[] jInternalFrameArray = mdi.getAllFrames();
        int n = jInternalFrameArray.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame f = jInternalFrameArray[n2];
            if (f instanceof ResourceFrame && f.isVisible() && ((ResourceFrame)f).resourceChanged()) {
                return true;
            }
            ++n2;
        }
        return windowModified;
    }

    public static void setWindowModified(boolean modified) {
        windowModified = modified;
    }

    public static void onMainFrameClosed() {
        int result = 2;
        try {
            if (!LGM.isWindowModified()) {
                System.exit(0);
            }
            result = JOptionPane.showConfirmDialog(frame, Messages.getString("LGM.KEEPCHANGES"), Messages.getString("LGM.KEEPCHANGES_TITLE"), 1);
        }
        catch (Throwable t) {
            LGM.showDefaultExceptionHandler(t);
            result = JOptionPane.showConfirmDialog(frame, Messages.getString("LGM.KEEPCHANGES_ERROR"), Messages.getString("LGM.KEEPCHANGES_ERROR_TITLE"), 1, 0);
        }
        switch (result) {
            case 0: {
                Listener.getInstance().fc.save(LGM.currentFile.uri, LGM.currentFile.format);
            }
            case 1: {
                System.exit(0);
                break;
            }
        }
    }

    public static void showEventPanel() {
        if (eventDialog == null) {
            eventDialog = new JDialog(frame){
                private static final long serialVersionUID = -5724054718126872483L;

                @Override
                public void setVisible(boolean visible) {
                    super.setVisible(visible);
                    eventButton.setSelected(visible);
                }
            };
            eventDialog.setResizable(false);
            eventDialog.setDefaultCloseOperation(1);
            eventDialog.setIconImage(LGM.getIconForKey("Toolbar.EVENT_BUTTON").getImage());
            eventDialog.setTitle(Messages.getString("EventPanel.TITLE"));
            eventDialog.add(eventSelect);
            eventDialog.pack();
            eventDialog.setLocationRelativeTo(frame);
        }
        eventDialog.setVisible(true);
    }

    public static void showEventPanel(int function) {
        LGM.eventSelect.function.setValue(function);
        LGM.showEventPanel();
    }

    public static void hideEventPanel() {
        if (eventDialog != null) {
            eventDialog.setVisible(false);
        }
    }

    public static void toggleEventPanel() {
        if (eventDialog == null || !eventDialog.isVisible()) {
            LGM.showEventPanel();
        } else {
            LGM.hideEventPanel();
        }
    }

    public static void showPreferences() {
        if (prefFrame == null) {
            prefFrame = new PreferencesFrame();
        }
        prefFrame.setVisible(true);
    }

    public static void applyBackground(String bgloc) {
        URL url;
        ImageIcon bg = new ImageIcon(bgloc);
        if (bg.getIconWidth() == -1 && (url = LGM.class.getClassLoader().getResource(bgloc)) != null) {
            bg = new ImageIcon(url);
        }
        mdi.add((Component)new MDIBackground(bg), JLayeredPane.FRAME_CONTENT_LAYER);
    }

    public static void setDefaultExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LGM.showDefaultExceptionHandler(e);
            }
        });
    }

    public static void addDefaultExceptionHandler() {
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LGM.showDefaultExceptionHandler(e);
            }
        });
    }

    public static void showDefaultExceptionHandler(Throwable e) {
        String agnostics = ErrorDialog.generateAgnosticInformation();
        System.out.println(agnostics);
        e.printStackTrace();
        ErrorDialog errorDialog = ErrorDialog.getInstance();
        if (!errorDialog.isVisible()) {
            errorDialog.setVisible(true);
            errorDialog.setDebugInfo(agnostics);
        }
        errorDialog.appendDebugInfo(e);
    }

    public static GameSettings getSelectedConfig() {
        return (GameSettings)configsCombo.getSelectedItem();
    }

    public static class MDIBackground
    extends JComponent {
        private static final long serialVersionUID = 1L;
        ImageIcon image;

        public MDIBackground(ImageIcon icon) {
            this.image = icon;
            if (this.image == null) {
                return;
            }
            if (this.image.getIconWidth() <= 0) {
                this.image = null;
            }
        }

        @Override
        public int getWidth() {
            return mdi.getWidth();
        }

        @Override
        public int getHeight() {
            return mdi.getHeight();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image == null) {
                return;
            }
            int y = 0;
            while (y < this.getHeight()) {
                int x = 0;
                while (x < this.getWidth()) {
                    g.drawImage(this.image.getImage(), x, y, null);
                    x += this.image.getIconWidth();
                }
                y += this.image.getIconHeight();
            }
        }
    }

    public static interface PluginResource {
        public Class<? extends Resource<?, ?>> getKind();

        public ImageIcon getIcon();

        public String getName3();

        public String getName();

        public String getPlural();

        public String getPrefix();

        public ProjectFile.ResourceHolder<?> getResourceHolder();

        public ResourceFrame.ResourceFrameFactory getResourceFrameFactory();
    }

    public static interface ReloadListener {
        public void reloadPerformed(boolean var1);
    }

    public static abstract class SingletonPluginResource<T extends Resource<T, ?>>
    implements PluginResource {
        @Override
        public String getPlural() {
            return this.getName();
        }

        @Override
        public String getPrefix() {
            return null;
        }

        @Override
        public ProjectFile.ResourceHolder<?> getResourceHolder() {
            return new ProjectFile.SingletonResourceHolder<T>(this.getInstance());
        }

        public abstract T getInstance();
    }

    static final class SplashProgress {
        final SplashScreen splash;
        final Graphics2D splashGraphics;
        final JProgressBar bar;
        final Graphics barGraphics;
        private String text = null;
        final boolean TIMER = System.getProperty("lgm.progresstimer") != null;
        private long startTime;
        private long completeTime;
        private ArrayList<Integer> progressValues;
        private ArrayList<Long> progressTimes;

        SplashProgress() {
            this.splash = SplashScreen.getSplashScreen();
            if (this.splash != null) {
                this.splashGraphics = this.splash.createGraphics();
                Dimension sss = this.splash.getSize();
                Rectangle bb = new Rectangle(0, sss.height - 24, sss.width, 24);
                this.bar = new JProgressBar();
                this.bar.setBounds(bb);
                this.barGraphics = this.splashGraphics.create(bb.x, bb.y, bb.width, bb.height);
            } else {
                this.splashGraphics = null;
                this.bar = null;
                this.barGraphics = null;
            }
            if (this.TIMER) {
                this.progressValues = new ArrayList();
                this.progressTimes = new ArrayList();
            }
        }

        void start() {
            if (this.TIMER) {
                this.startTime = System.currentTimeMillis();
            }
            this.progress(0, Messages.getString("LGM.SPLASH_START"));
        }

        void complete() {
            if (this.TIMER) {
                this.completeTime = System.currentTimeMillis();
                long tt = this.completeTime - this.startTime;
                System.out.print("Progress/% ");
                for (Integer v : this.progressValues) {
                    System.out.print("\t" + v);
                }
                System.out.println();
                System.out.print("Time/ms ");
                for (Long t : this.progressTimes) {
                    System.out.print("\t" + t);
                }
                System.out.println();
                System.out.print("Actual progress/%");
                for (Long t : this.progressTimes) {
                    System.out.print("\t" + Math.round(100.0 * (double)t.longValue() / (double)tt));
                }
                System.out.println();
            }
        }

        void progress(int p) {
            this.progress(p, this.text);
        }

        void progress(int p, String t) {
            if (this.TIMER) {
                this.progressValues.add(p);
                this.progressTimes.add(System.currentTimeMillis() - this.startTime);
            }
            this.text = t;
            if (this.splash != null) {
                this.bar.setValue(p);
                this.bar.setStringPainted(t != null);
                this.bar.setString(t);
                this.update();
            }
        }

        private void update() {
            this.bar.paint(this.barGraphics);
            this.splash.update();
        }
    }
}

