/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.main;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.tree.TreeNode;
import org.lateralgm.components.CustomFileChooser;
import org.lateralgm.components.ErrorDialog;
import org.lateralgm.components.GmMenuBar;
import org.lateralgm.components.impl.CustomFileFilter;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.file.GMXFileReader;
import org.lateralgm.file.GMXFileWriter;
import org.lateralgm.file.GmFileReader;
import org.lateralgm.file.GmFileWriter;
import org.lateralgm.file.GmFormatException;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.file.ProjectFormatException;
import org.lateralgm.file.ResourceList;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Listener;
import org.lateralgm.main.OutputManager;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.PrefsStore;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Resource;

public class FileChooser {
    public static List<FileReader> readers = new ArrayList<FileReader>();
    public static List<FileWriter> writers = new ArrayList<FileWriter>();
    public static List<FileView> fileViews = new ArrayList<FileView>();
    static ProjectReader projectReader;
    static GMXIO gmxIO;
    FileWriter selectedWriter;
    CustomFileChooser fc = new CustomFileChooser("/org/lateralgm", "LAST_FILE_DIR");
    CustomFileChooser.FilterSet openFs = new CustomFileChooser.FilterSet();
    CustomFileChooser.FilterSet saveFs = new CustomFileChooser.FilterSet();
    FilterUnion openAllFilter = new FilterUnion(new FileFilter[0]);
    FilterUnion saveAllFilter = new FilterUnion(new FileFilter[0]);
    JCheckBox forceExt = new JCheckBox(Messages.getString("FileChooser.FORCE_EXT"), true);

    static {
        ProjectFile.interfaceProvider = new ProjectFile.DefaultInterfaceProvider(){

            @Override
            public void start() {
                LGM.showProgressDialog();
            }

            @Override
            public void done() {
                LGM.setProgressDialogVisible(false);
            }

            @Override
            public void init(final int max, final String titleKey) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LGM.initProgressDialog(0, max, this.translate(titleKey));
                    }
                });
            }

            @Override
            public void setProgress(final int percent, final String messageKey) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LGM.setProgress(percent, this.translate(messageKey));
                    }
                });
            }

            @Override
            public String translate(String key) {
                return Messages.getString(key);
            }

            @Override
            public String format(String key, Object ... arguments) {
                return Messages.format(key, arguments);
            }
        };
    }

    public static void addDefaultReadersAndWriters() {
        int[] gmvers;
        if (gmxIO == null) {
            gmxIO = new GMXIO();
            readers.add(gmxIO);
            writers.add(gmxIO);
        }
        if (projectReader != null) {
            return;
        }
        projectReader = new ProjectReader();
        readers.add(projectReader);
        int[] nArray = gmvers = new int[]{810, 800, 701, 600};
        int n = gmvers.length;
        int n2 = 0;
        while (n2 < n) {
            int gmver = nArray[n2];
            writers.add(new ProjectWriter(gmver));
            ++n2;
        }
    }

    public void addOpenFilters(GroupFilter gf) {
        FileChooser.addFilters(this.openFs, this.openAllFilter, gf);
    }

    public void addSaveFilters(GroupFilter gf) {
        FileChooser.addFilters(this.saveFs, this.saveAllFilter, gf);
    }

    public static void addFilters(CustomFileChooser.FilterSet fs, FilterUnion all, GroupFilter gf) {
        fs.add(gf.getGroupFilter());
        all.add(gf.getGroupFilter());
        FileFilter[] fileFilterArray = gf.getFilters();
        int n = fileFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileFilter ff = fileFilterArray[n2];
            fs.add(ff);
            ++n2;
        }
        if (all.size() == 2) {
            fs.add(0, all);
        }
    }

    public FileChooser() {
        this.fc.setFileView(new FileViewUnion());
        FileChooser.addDefaultReadersAndWriters();
        this.addOpenFilters(gmxIO);
        this.addOpenFilters(projectReader);
        this.selectedWriter = writers.get(0);
        this.addSaveFilters(gmxIO);
        this.addSaveFilters(new ProjectWriterFilter());
    }

    public static void setTitleURI(URI uri) {
        LGM.frame.setTitle(Messages.format("LGM.TITLE", FileChooser.getTitleFromURI(uri)));
    }

    private static String getTitleFromURI(URI uri) {
        if (uri == null) {
            return Messages.getString("LGM.NEWGAME");
        }
        try {
            return new File(uri).getName();
        }
        catch (IllegalArgumentException e) {
            return uri.toString();
        }
    }

    public void newFile() {
        FileChooser.setTitleURI(null);
        LGM.newRoot();
        LGM.currentFile = new ProjectFile();
        LGM.populateTree();
        this.fc.setSelectedFile(new File(new String()));
        this.selectedWriter = null;
        LGM.reload(true);
        OutputManager.append("\n" + Messages.getString("FileChooser.PROJECTCREATED") + ": " + new Date().toString());
    }

    public void openNewFile() {
        this.fc.setFilterSet(this.openFs);
        this.fc.setAccessory(null);
        if (this.fc.showOpenDialog(LGM.frame) != 0) {
            return;
        }
        File f = this.fc.getSelectedFile();
        if (f == null) {
            return;
        }
        this.open(f.toURI());
    }

    public void open(File file) {
        if (file == null || !file.exists()) {
            int result = JOptionPane.showConfirmDialog(LGM.frame, "Would you like to choose a different file?", "File Not Found", 0, 0);
            if (result == 0) {
                this.openNewFile();
            }
            return;
        }
        FileReader reader = FileChooser.findReader(file.toURI());
        if (reader == null) {
            String title = Messages.getString("FileChooser.UNRECOGNIZED_TITLE");
            String message = Messages.format("FileChooser.UNRECOGNIZED", file);
            JOptionPane.showMessageDialog(LGM.frame, message, title, 2);
            return;
        }
        this.open(file.toURI(), reader);
    }

    public void open(URI uri) {
        if (uri == null) {
            this.openNewFile();
            return;
        }
        FileReader reader = FileChooser.findReader(uri);
        if (reader == null) {
            String title = Messages.getString("FileChooser.UNRECOGNIZED_TITLE");
            String message = Messages.format("FileChooser.UNRECOGNIZED", uri);
            JOptionPane.showMessageDialog(LGM.frame, message, title, 2);
            return;
        }
        this.open(uri, reader);
    }

    private static void openExceptionHelper(Exception e) {
        LGM.populateTree();
        FileChooser.rebuildTree();
        LGM.showDefaultExceptionHandler(e);
        ErrorDialog.getInstance().setMessage(Messages.getString("FileChooser.ERROR_LOAD"));
        ErrorDialog.getInstance().setTitle(Messages.getString("FileChooser.ERROR_LOAD_TITLE"));
    }

    public void open(final URI uri, final FileReader reader) {
        if (uri == null) {
            return;
        }
        new SwingWorker<ProjectFile, Object>(){

            @Override
            protected ProjectFile doInBackground() throws Exception {
                LGM.addDefaultExceptionHandler();
                ProjectFile f = new ProjectFile();
                f.uri = uri;
                long startTime = System.currentTimeMillis();
                reader.read(uri.toURL().openStream(), f, uri, LGM.newRoot());
                long delta = System.currentTimeMillis() - startTime;
                System.out.println(ProjectFile.interfaceProvider.format("ProjectFileReader.LOADTIME", delta));
                return f;
            }

            @Override
            protected void done() {
                OutputManager.append("\n" + Messages.getString("FileChooser.PROJECTLOADED") + ": " + new Date().toString() + " " + uri.getPath());
                ProjectFile pf = null;
                try {
                    pf = (ProjectFile)this.get();
                }
                catch (InterruptedException e) {
                    FileChooser.openExceptionHelper(e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ProjectFormatException) {
                        ProjectFormatException pe = (ProjectFormatException)e.getCause();
                        pf = pe.file;
                    }
                    FileChooser.openExceptionHelper(e);
                }
                if (pf != null) {
                    LGM.currentFile = pf;
                }
                LGM.reload(true);
                if (pf != null) {
                    FileChooser.setTitleURI(uri);
                    PrefsStore.addRecentFile(uri.toString());
                    ((GmMenuBar)LGM.frame.getJMenuBar()).updateRecentFiles();
                    Listener.checkIdsInteractive(false);
                }
                FileChooser.this.selectedWriter = null;
                ProjectFile.interfaceProvider.done();
            }
        }.execute();
        ProjectFile.interfaceProvider.start();
    }

    public static FileReader findReader(URI uri) {
        for (FileReader fr : readers) {
            if (!fr.canRead(uri)) continue;
            return fr;
        }
        return null;
    }

    private static void rebuildTree() {
        int i = 0;
        while (i < LGM.root.getChildCount()) {
            TreeNode n = LGM.root.getChildAt(i);
            if (n instanceof ResNode) {
                ResNode rn = (ResNode)n;
                if (rn.status == 1 && rn.isInstantiable()) {
                    ResourceList rl = (ResourceList)LGM.currentFile.resMap.get(rn.kind);
                    for (Resource r : rl) {
                        if (r.getNode() != null) continue;
                        rn.add(new ResNode(r.getName(), 3, r.getClass(), r.reference));
                    }
                }
            }
            ++i;
        }
    }

    public boolean saveNewFile() {
        this.fc.setFilterSet(this.saveFs);
        this.fc.setAccessory(this.makeSelectionAccessory());
        URI uri = LGM.currentFile.uri;
        File file = uri == null ? null : new File(uri);
        this.fc.setSelectedFile(file);
        uri = null;
        do {
            if (this.fc.showSaveDialog(LGM.frame) != 0) {
                return false;
            }
            file = this.fc.getSelectedFile();
            if (this.forceExt.isSelected()) {
                String ext = this.selectedWriter.getExtension();
                if (!file.getName().endsWith(ext)) {
                    file = new File(String.valueOf(file.getPath()) + ext);
                }
            }
            if (this.selectedWriter.getFlavor().equals(ProjectFile.FormatFlavor.GMX) && file.getName().endsWith(".project.gmx")) {
                file = new File(String.valueOf(file.getAbsolutePath().replace(".project.gmx", ".gmx")) + '/' + file.getName());
                file.getParentFile().mkdir();
            }
            int result = 0;
            if (file.exists()) {
                result = JOptionPane.showConfirmDialog(LGM.frame, Messages.format("FileChooser.CONFIRM_REPLACE", file.getPath()), Messages.getString("FileChooser.CONFIRM_REPLACE_TITLE"), 1, 2);
            }
            if (result == 0) {
                uri = file.toURI();
            }
            if (result != 2) continue;
            return false;
        } while (uri == null);
        return this.save(uri, this.selectedWriter.getFlavor());
    }

    public boolean save(final URI uri, ProjectFile.FormatFlavor flavor) {
        this.selectedWriter = this.findWriter(flavor);
        System.out.println(this.selectedWriter == null ? "null writer" : this.selectedWriter.getSelectionName());
        if (uri == null || this.selectedWriter == null) {
            return this.saveNewFile();
        }
        LGM.currentFile.format = flavor;
        if (uri != LGM.currentFile.uri) {
            LGM.currentFile.uri = uri;
            FileChooser.setTitleURI(uri);
            PrefsStore.addRecentFile(uri.toString());
            ((GmMenuBar)LGM.frame.getJMenuBar()).updateRecentFiles();
        }
        LGM.commitAll();
        LGM.setWindowModified(false);
        String ext = this.selectedWriter.getExtension();
        if (!uri.getPath().endsWith(ext)) {
            int result = JOptionPane.showConfirmDialog(LGM.frame, Messages.format("FileChooser.CONFIRM_EXTENSION", ext, this.selectedWriter.getSelectionName()), uri.toString(), 1);
            if (result == 2) {
                return false;
            }
            if (result == 1) {
                return this.saveNewFile();
            }
        }
        if (Prefs.backupSave && !FileChooser.attemptBackup()) {
            return false;
        }
        SwingWorker<Object, Object> sw = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                LGM.addDefaultExceptionHandler();
                FileChooser.save(uri, FileChooser.this.selectedWriter);
                return null;
            }

            @Override
            protected void done() {
                ProjectFile.interfaceProvider.done();
            }
        };
        sw.execute();
        ProjectFile.interfaceProvider.start();
        try {
            sw.get();
            OutputManager.append("\n" + Messages.getString("FileChooser.PROJECTSAVED") + ": " + new Date().toString() + " " + uri.getPath());
        }
        catch (InterruptedException | ExecutionException e) {
            LGM.showDefaultExceptionHandler(e);
            JOptionPane.showMessageDialog(LGM.frame, Messages.format("FileChooser.ERROR_SAVE", uri, e.getClass().getName(), e.getMessage()), Messages.getString("FileChooser.ERROR_SAVE_TITLE"), 0);
            return false;
        }
        return true;
    }

    public static void save(URI uri, FileWriter writer) throws IOException, ProjectFormatException {
        System.out.println(uri);
        File pf = new File(uri).getParentFile();
        if (!pf.exists()) {
            pf.mkdir();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream os = Util.openURIOutputStream(uri);){
            writer.write(os, LGM.currentFile, LGM.root);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public FileWriter findWriter(ProjectFile.FormatFlavor flavor) {
        if (flavor == null) {
            System.out.println("null flavor");
            return null;
        }
        if (this.selectedWriter != null && this.selectedWriter.getFlavor() == flavor) {
            return this.selectedWriter;
        }
        FileWriter first = null;
        for (FileWriter writer : writers) {
            if (writer.getFlavor() != flavor) continue;
            if (first == null) {
                first = writer;
                continue;
            }
            System.out.println("two flavor writers");
            return null;
        }
        if (first == null) {
            System.out.println("No registered writer for flavor");
        }
        return first;
    }

    public static boolean attemptBackup() {
        if (FileChooser.pushBackups(new File(LGM.currentFile.uri))) {
            return true;
        }
        int result = JOptionPane.showOptionDialog(LGM.frame, Messages.format("FileChooser.ERROR_BACKUP", LGM.currentFile.uri), Messages.getString("FileChooser.ERROR_BACKUP_TITLE"), 0, 0, null, null, null);
        return result == 0;
    }

    private static boolean pushBackups(File f) {
        block11: {
            Object bf;
            String bn;
            String fn = f.getPath();
            int nb = Prefs.backupCopies;
            if (nb <= 0 || !new File(fn).exists()) {
                return true;
            }
            if (fn.endsWith(".gm6") || fn.endsWith(".gmk")) {
                bn = fn.substring(0, fn.length() - 4);
            } else if (fn.endsWith(".gm81")) {
                bn = fn.substring(0, fn.length() - 5);
            } else if (fn.endsWith(".project.gmx")) {
                fn = f.getParent();
                bn = fn.substring(0, fn.length() - 4);
            } else {
                bn = fn;
            }
            String ff = "%s.gb%d";
            int i = 1;
            while (i <= nb) {
                bf = String.format(ff, bn, i);
                if (!new File((String)bf).exists()) break;
                ++i;
            }
            if (i <= nb || Util.directoryDelete(new File(String.format(ff, bn, i = nb)))) {
                --i;
                while (i >= 0) {
                    bf = new File(i > 0 ? String.format(ff, bn, i) : fn);
                    if (((File)bf).renameTo(new File(String.format(ff, bn, i + 1)))) {
                        --i;
                        continue;
                    }
                    break block11;
                }
                return true;
            }
        }
        return false;
    }

    JPanel makeSelectionAccessory() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        ButtonGroup bg = new ButtonGroup();
        this.selectedWriter = this.findWriter(LGM.currentFile.format);
        if (this.selectedWriter == null) {
            this.selectedWriter = writers.get(0);
        }
        for (final FileWriter writer : writers) {
            JRadioButton b = new JRadioButton(writer.getSelectionName(), this.selectedWriter == writer);
            bg.add(b);
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileChooser.this.selectedWriter = writer;
                }
            });
        }
        JPanel r = new JPanel();
        r.setLayout(new BoxLayout(r, 3));
        r.add(new JScrollPane(p));
        r.add(this.forceExt);
        return r;
    }

    public static abstract class FileDropHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;
        public static final String MIME_URI_LIST = "uri-list";

        public boolean isDataFlavorSupported(DataFlavor df) {
            return df.isFlavorJavaFileListType() || df.isRepresentationClassReader() && MIME_URI_LIST.equals(df.getSubType());
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport evt) {
            return this.getSupportedFlavor(evt.getDataFlavors()) != null;
        }

        protected DataFlavor getSupportedFlavor(DataFlavor ... dfs) {
            DataFlavor[] dataFlavorArray = dfs;
            int n = dfs.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor df = dataFlavorArray[n2];
                if (this.isDataFlavorSupported(df)) {
                    return df;
                }
                ++n2;
            }
            return null;
        }

        public List<?> getDropList(TransferHandler.TransferSupport evt) {
            DataFlavor df;
            Transferable tr;
            block10: {
                tr = evt.getTransferable();
                df = this.getSupportedFlavor(evt.getDataFlavors());
                if (df == null) {
                    return null;
                }
                if (df.isFlavorJavaFileListType()) {
                    return (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                }
                if (df.isRepresentationClassReader() && MIME_URI_LIST.equals(df.getSubType())) break block10;
                return null;
            }
            try {
                String line;
                BufferedReader br = new BufferedReader(df.getReaderForText(tr));
                LinkedList<URI> uriList = new LinkedList<URI>();
                while ((line = br.readLine()) != null) {
                    try {
                        if (line.isEmpty() || line.length() == 1 && line.charAt(0) == '\u0000') continue;
                        uriList.add(new URI(line));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                br.close();
                return uriList;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    public static interface FileReader {
        public boolean canRead(URI var1);

        public void read(InputStream var1, ProjectFile var2, URI var3, ResNode var4) throws ProjectFormatException;
    }

    private class FileViewUnion
    extends FileView {
        private FileViewUnion() {
        }

        @Override
        public String getName(File f) {
            for (FileView fv : fileViews) {
                String val = fv.getName(f);
                if (val == null) continue;
                return val;
            }
            return super.getName(f);
        }

        @Override
        public String getDescription(File f) {
            for (FileView fv : fileViews) {
                String val = fv.getDescription(f);
                if (val == null) continue;
                return val;
            }
            return super.getDescription(f);
        }

        @Override
        public String getTypeDescription(File f) {
            for (FileView fv : fileViews) {
                String val = fv.getTypeDescription(f);
                if (val == null) continue;
                return val;
            }
            return super.getTypeDescription(f);
        }

        @Override
        public Icon getIcon(File f) {
            for (FileView fv : fileViews) {
                Icon val = fv.getIcon(f);
                if (val == null) continue;
                return val;
            }
            return super.getIcon(f);
        }

        @Override
        public Boolean isTraversable(File f) {
            for (FileView fv : fileViews) {
                Boolean val = fv.isTraversable(f);
                if (val == null) continue;
                return val;
            }
            return super.isTraversable(f);
        }
    }

    public static interface FileWriter {
        public void write(OutputStream var1, ProjectFile var2, ResNode var3) throws ProjectFormatException, IOException;

        public String getSelectionName();

        public String getExtension();

        public ProjectFile.FormatFlavor getFlavor();
    }

    public static class FilterUnion
    extends FileFilter {
        List<FileFilter> filters = new ArrayList<FileFilter>();

        public FilterUnion(FileFilter ... filters) {
            this.add(filters);
        }

        public void add(FileFilter ... filters) {
            FileFilter[] fileFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                FileFilter ff = fileFilterArray[n2];
                this.filters.add(ff);
                ++n2;
            }
        }

        public int size() {
            return this.filters.size();
        }

        @Override
        public boolean accept(File f) {
            for (FileFilter ff : this.filters) {
                if (!ff.accept(f)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return Messages.getString("FileChooser.ALL_SUPPORTED");
        }
    }

    protected static class GMXIO
    extends FileView
    implements FileReader,
    FileWriter,
    GroupFilter {
        static final String ext = ".project.gmx";
        CustomFileFilter filter = new CustomFileFilter(Messages.getString("FileChooser.FORMAT_GMX"), ".project.gmx");

        protected GMXIO() {
        }

        @Override
        public FileFilter getGroupFilter() {
            return this.filter;
        }

        @Override
        public FileFilter[] getFilters() {
            return new FileFilter[0];
        }

        @Override
        public boolean canRead(URI uri) {
            return this.filter.accept(new File(uri));
        }

        @Override
        public void read(InputStream in, ProjectFile file, URI uri, ResNode root) throws GmFormatException {
            GMXFileReader.readProjectFile(in, file, uri, root);
        }

        @Override
        public String getExtension() {
            return ext;
        }

        @Override
        public String getSelectionName() {
            return "GMX";
        }

        @Override
        public void write(OutputStream out, ProjectFile f, ResNode root) throws ProjectFormatException {
            try {
                GMXFileWriter.writeProjectFile(out, f, root);
            }
            catch (Exception e) {
                throw new GmFormatException(f, e);
            }
        }

        @Override
        public ProjectFile.FormatFlavor getFlavor() {
            return ProjectFile.FormatFlavor.GMX;
        }
    }

    public static interface GroupFilter {
        public FileFilter getGroupFilter();

        public FileFilter[] getFilters();
    }

    public class LGMDropHandler
    extends FileDropHandler {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean importData(TransferHandler.TransferSupport evt) {
            List<?> files = this.getDropList(evt);
            if (files == null || files.isEmpty()) {
                return false;
            }
            if (files.size() != 1) {
                return false;
            }
            Object o = files.get(0);
            if (o instanceof File) {
                FileChooser.this.open(((File)o).toURI());
                return true;
            }
            if (o instanceof URI) {
                FileChooser.this.open((URI)o);
                return true;
            }
            return false;
        }
    }

    protected static class ProjectReader
    implements FileReader,
    GroupFilter {
        protected CustomFileFilter[] filters;
        protected CustomFileFilter groupFilter;
        protected CustomFileFilter backupsFilter;

        protected ProjectReader() {
            String[] exts = new String[]{".gm81", ".gmk", ".gm6", ".gmd"};
            String[] descs = new String[]{"GM81", "GMK", "GM6", "GMD"};
            this.groupFilter = new CustomFileFilter(Messages.getString("FileChooser.FORMAT_READERS_GM"), exts);
            this.filters = new CustomFileFilter[exts.length + 1];
            int i = 0;
            while (i < exts.length) {
                this.filters[i] = new CustomFileFilter(Messages.getString("FileChooser.FORMAT_" + descs[i]), exts[i]);
                ++i;
            }
            String[] backupExts = new String[9];
            int i2 = 0;
            while (i2 < backupExts.length) {
                backupExts[i2] = ".gb" + (i2 + 1);
                ++i2;
            }
            this.filters[this.filters.length - 1] = this.backupsFilter = new CustomFileFilter(Messages.getString("FileChooser.FORMAT_GB"), backupExts);
        }

        @Override
        public FileFilter getGroupFilter() {
            return this.groupFilter;
        }

        @Override
        public FileFilter[] getFilters() {
            return this.filters;
        }

        @Override
        public boolean canRead(URI f) {
            File file = new File(f);
            return this.groupFilter.accept(file) || this.backupsFilter.accept(file);
        }

        @Override
        public void read(InputStream is, ProjectFile file, URI uri, ResNode root) throws ProjectFormatException {
            GmFileReader.readProjectFile(is, file, uri, root);
        }
    }

    protected static class ProjectWriter
    implements FileWriter {
        private int ver;

        public ProjectWriter(int ver) {
            this.ver = ver;
        }

        @Override
        public void write(OutputStream out, ProjectFile f, ResNode root) throws ProjectFormatException {
            try {
                GmFileWriter.writeProjectFile(out, f, root, this.ver);
            }
            catch (IOException e) {
                throw new GmFormatException(f, e);
            }
        }

        @Override
        public String getSelectionName() {
            return Integer.toString(this.ver);
        }

        @Override
        public ProjectFile.FormatFlavor getFlavor() {
            return ProjectFile.FormatFlavor.getVersionFlavor(this.ver);
        }

        @Override
        public String getExtension() {
            switch (this.ver) {
                case 530: {
                    return ".gmd";
                }
                case 600: {
                    return ".gm6";
                }
                case 701: 
                case 800: {
                    return ".gmk";
                }
                case 810: {
                    return ".gm81";
                }
            }
            throw new IllegalArgumentException(Integer.toString(this.ver));
        }
    }

    protected class ProjectWriterFilter
    implements GroupFilter {
        protected CustomFileFilter[] filters;
        protected CustomFileFilter groupFilter;

        protected ProjectWriterFilter() {
            String[] exts = new String[]{".gm81", ".gmk", ".gm6"};
            String[] descs = new String[]{"GM81", "GMK", "GM6"};
            this.groupFilter = new CustomFileFilter(Messages.getString("FileChooser.FORMAT_WRITERS_GM"), exts);
            this.filters = new CustomFileFilter[exts.length];
            int i = 0;
            while (i < exts.length) {
                this.filters[i] = new CustomFileFilter(Messages.getString("FileChooser.FORMAT_" + descs[i]), exts[i]);
                ++i;
            }
        }

        @Override
        public FileFilter[] getFilters() {
            return this.filters;
        }

        @Override
        public FileFilter getGroupFilter() {
            return this.groupFilter;
        }
    }
}

