/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JColorChooser;

public class JEColorButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private int paddingH = 6;
    private int paddingV = 4;
    private Color color = Color.WHITE;
    private String caption;
    private static BufferedImage nullColorPattern = null;
    private final List<ColorListener> colorListeners = new ArrayList<ColorListener>();

    private static void generateNullColorPattern() {
        nullColorPattern = new BufferedImage(5, 5, 6);
        Graphics g = nullColorPattern.getGraphics();
        g.setColor(Color.BLACK);
        g.drawLine(4, 0, 0, 4);
        g.dispose();
    }

    public JEColorButton() {
        this.addActionListener(new ClickListener());
    }

    public JEColorButton(Color c) {
        this();
        this.color = c;
    }

    public JEColorButton(Color c, String cap) {
        this(c);
        this.caption = cap;
    }

    public Color getColor() {
        return this.color;
    }

    public void setPadding(int paddingH, int paddingV) {
        this.paddingH = paddingH;
        this.paddingV = paddingV;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(48, 22);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(48, 22);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getSize();
        size.width -= this.paddingH << 1;
        size.height -= this.paddingV << 1;
        Rectangle myRect = new Rectangle(this.paddingH, this.paddingV, size.width, size.height);
        if (this.color != null) {
            g.setColor(this.color);
            g.fillRect(this.paddingH, this.paddingV, size.width, size.height);
        } else {
            if (nullColorPattern == null) {
                JEColorButton.generateNullColorPattern();
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(new TexturePaint(nullColorPattern, new Rectangle(0, 0, 5, 5)));
            g2.fill(myRect);
        }
        g.setColor(Color.BLACK);
        g.drawRect(this.paddingH, this.paddingV, size.width, size.height);
    }

    public void fireColorChange(ColorChangeEvent event) {
        for (ColorListener listener : this.colorListeners) {
            listener.colorChanged(event);
        }
    }

    public void addColorListener(ColorListener colorListener) {
        this.colorListeners.add(colorListener);
    }

    private final class ClickListener
    implements ActionListener {
        private ClickListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color nColor = JColorChooser.showDialog(JEColorButton.this, JEColorButton.this.caption, JEColorButton.this.color);
            if (nColor == null) {
                return;
            }
            if (!nColor.equals(JEColorButton.this.color)) {
                Color oColor = JEColorButton.this.color;
                JEColorButton.this.color = nColor;
                JEColorButton.this.fireColorChange(new ColorChangeEvent(oColor, JEColorButton.this.color, JEColorButton.this));
            }
        }
    }

    public static final class ColorChangeEvent {
        private final Color oldColor;
        private final Color newColor;
        private final JEColorButton sender;

        public ColorChangeEvent(Color oldColor, Color newColor, JEColorButton sender) {
            this.oldColor = oldColor;
            this.newColor = newColor;
            this.sender = sender;
        }

        public Color getOldColor() {
            return this.oldColor;
        }

        public Color getNewColor() {
            return this.newColor;
        }

        public JEColorButton getSender() {
            return this.sender;
        }
    }

    public static interface ColorListener {
        public void colorChanged(ColorChangeEvent var1);
    }
}

