/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit.preferences;

import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.lateralgm.joshedit.JoshText;
import org.lateralgm.joshedit.Runner;

public class KeybindingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String EMPTY_STRING = "";
    private static final ResourceBundle DEFAULTS = ResourceBundle.getBundle("org.lateralgm.joshedit.defaults");
    private static final ResourceBundle TRANSLATE = ResourceBundle.getBundle("org.lateralgm.joshedit.translate");
    public static final Preferences PREFS = Preferences.userRoot().node("/org/lateralgm/joshedit");
    JTable list;

    private static String keyToEnglish(String key2) {
        String[] pieces = key2.split("\\+");
        if (pieces.length == 0) {
            return null;
        }
        int mods = 0;
        if (pieces.length > 1) {
            if (pieces[0].contains("C")) {
                mods |= 0x80;
            }
            if (pieces[0].contains("S")) {
                mods |= 0x40;
            }
            if (pieces[0].contains("A")) {
                mods |= 0x200;
            }
            if (pieces[0].contains("M")) {
                mods |= 0x100;
            }
            if (pieces[0].contains("G")) {
                mods |= 0x2000;
            }
        }
        String lastPiece = pieces[pieces.length - 1];
        if (mods == 0) {
            return lastPiece;
        }
        return String.valueOf(InputEvent.getModifiersExText(mods)) + " + " + lastPiece;
    }

    public KeybindingsPanel() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(new JLabel(Runner.editorInterface.getString("Bindings.LIST_EXPLANATION")));
        KeystrokeTableModel model = new KeystrokeTableModel();
        this.list = new JTable(model);
        this.add(new JScrollPane(this.list));
        TableColumn c = this.list.getColumnModel().getColumn(1);
        c.setCellRenderer(new KeystrokeRenderer());
        c.setCellEditor(new KeystrokeEditor());
        System.out.println("Populate bindings");
        KeybindingsPanel.populateBindings(model);
    }

    static void populateBindings(KeystrokeTableModel model) {
        TreeMap<String, ArrayList<String>> items = new TreeMap<String, ArrayList<String>>();
        Preferences bindings = PREFS.node("bindings");
        try {
            String[] stringArray = bindings.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String act = bindings.get(key, null);
                if (act != null) {
                    ArrayList<String> a = (ArrayList<String>)items.get(act);
                    if (a == null) {
                        a = new ArrayList<String>();
                        items.put(act, a);
                    }
                    a.add(key);
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            System.err.println("Failed to read JoshEdit keybindings!");
        }
        if (model.getRowCount() == 0) {
            for (String key : DEFAULTS.keySet()) {
                String act = DEFAULTS.getString(key);
                ArrayList<String> a = (ArrayList<String>)items.get(act);
                if (a == null) {
                    a = new ArrayList<String>();
                    items.put(act, a);
                }
                a.add(key);
            }
        }
        for (Map.Entry i : items.entrySet()) {
            String act = (String)i.getKey();
            for (String key : (ArrayList)i.getValue()) {
                model.addRow(KeybindingsPanel.getString("bindings." + act, act), key);
                act = EMPTY_STRING;
            }
        }
    }

    public static String getString(String key, String def) {
        String r;
        try {
            r = TRANSLATE.getString(key);
        }
        catch (MissingResourceException e) {
            r = def == null ? String.valueOf('!') + key + '!' : def;
        }
        return PREFS.get(key, r);
    }

    public static void readMappings(InputMap im) {
        Preferences bindings = PREFS.node("bindings");
        try {
            boolean changed = false;
            String[] stringArray = bindings.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String act = bindings.get(key, null);
                if (act != null) {
                    changed = true;
                    im.put(JoshText.key(key), act);
                }
                ++n2;
            }
            if (changed) {
                return;
            }
        }
        catch (BackingStoreException e) {
            System.err.println("Failed to read JoshEdit keybindings!");
        }
        for (String key : DEFAULTS.keySet()) {
            String act = DEFAULTS.getString(key);
            im.put(JoshText.key(key), act);
        }
    }

    class KeystrokeEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private final KeystrokeSelector comp;

        public KeystrokeEditor() {
            this.comp = new KeystrokeSelector();
        }

        @Override
        public Object getCellEditorValue() {
            return this.comp.coreValue;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.comp.init(row, table, value.toString());
            return this.comp;
        }
    }

    class KeystrokeRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        KeystrokeRenderer() {
        }

        @Override
        public void setValue(Object value) {
            super.setValue(value == null ? KeybindingsPanel.EMPTY_STRING : (value instanceof String ? KeybindingsPanel.keyToEnglish((String)value) : value));
        }
    }

    class KeystrokeSelector
    extends JTextField {
        private static final long serialVersionUID = 1L;
        public String coreValue = "";
        private String beginValue = "";
        private JTable myTable;
        private int myRow;

        KeystrokeSelector() {
            this.setFocusTraversalKeysEnabled(false);
            this.setDragEnabled(false);
            this.setEditable(false);
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            String name;
            if (e.getID() != 401) {
                return;
            }
            if (e.getKeyCode() == 27) {
                this.coreValue = this.beginValue;
                super.setText(KeybindingsPanel.keyToEnglish(this.coreValue));
                return;
            }
            if (e.getKeyCode() == 8) {
                this.coreValue = KeybindingsPanel.EMPTY_STRING;
                super.setText(Runner.editorInterface.getString("Bindings.2"));
                return;
            }
            System.out.println(String.valueOf(e.getModifiersEx()) + " " + e.getKeyCode());
            if (e.getKeyCode() == 17 || e.getKeyCode() == 18 || e.getKeyCode() == 16 || e.getKeyCode() == 0) {
                return;
            }
            if (e.getModifiersEx() == 64 || e.getModifiersEx() == 0 && !e.isActionKey()) {
                return;
            }
            String mods = KeybindingsPanel.EMPTY_STRING;
            if (e.isControlDown()) {
                mods = String.valueOf(mods) + "C";
            }
            if (e.isAltDown()) {
                mods = String.valueOf(mods) + "A";
            }
            if (e.isShiftDown()) {
                mods = String.valueOf(mods) + "S";
            }
            if (e.isMetaDown()) {
                mods = String.valueOf(mods) + "M";
            }
            if (e.isAltGraphDown()) {
                mods = String.valueOf(mods) + "G";
            }
            if (mods.length() > 0) {
                mods = String.valueOf(mods) + "+";
            }
            if (!this.resolveCollision(name = String.valueOf(mods) + KeyEvent.getKeyText(e.getKeyCode()))) {
                return;
            }
            this.setText(name);
            this.fireActionPerformed();
        }

        private boolean resolveCollision(String name) {
            int row = 0;
            for (KeystrokeTableModel.Row i : ((KeystrokeTableModel)this.myTable.getModel()).rows) {
                if (i.key.equals(name) && row != this.myRow) {
                    boolean ret;
                    boolean bl = ret = JOptionPane.showConfirmDialog(null, String.format(Runner.editorInterface.getString("Bindings.ALREADY_SET"), i.desc), Runner.editorInterface.getString("Bindings.CONFLICT_CAP"), 0) == 0;
                    if (ret) {
                        i.key = KeybindingsPanel.EMPTY_STRING;
                        this.myTable.repaint();
                    }
                    return ret;
                }
                ++row;
            }
            return true;
        }

        @Override
        public void setText(String text) {
            this.coreValue = text;
            super.setText(KeybindingsPanel.keyToEnglish(text));
        }

        @Override
        public String getText() {
            return super.getText();
        }

        public String getValue() {
            return this.getText();
        }

        public void init(int row, JTable table, String initialKeyStroke) {
            this.myRow = row;
            this.myTable = table;
            this.beginValue = initialKeyStroke;
            this.setText(this.beginValue);
        }
    }

    class KeystrokeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        ArrayList<Row> rows = new ArrayList();

        public void addRow(String desc, String key) {
            this.rows.add(new Row(desc, key));
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? Runner.editorInterface.getString("Bindings.DESCRIPTION") : Runner.editorInterface.getString("Bindings.KEYSTROKES");
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return columnIndex == 0 ? this.rows.get((int)rowIndex).desc : this.rows.get((int)rowIndex).key;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                this.rows.get((int)rowIndex).desc = aValue.toString();
            } else {
                this.rows.get((int)rowIndex).key = aValue.toString();
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        class Row {
            String desc;
            String key;

            Row(String d, String k) {
                this.desc = d;
                this.key = k;
            }
        }
    }
}

