/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import org.lateralgm.joshedit.ColorProfile;
import org.lateralgm.joshedit.Runner;
import org.lateralgm.joshedit.TokenMarker;
import org.lateralgm.joshedit.swing.JEColorButton;

public class HighlightPreferences
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private static final String BLOCK_NAMESPACE = "Block.";
    private static final String EDITOR_NAMESPACE = "Editor.";
    private static final Pattern RGB_PATTERN = Pattern.compile("rgb\\(\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*,\\s*([0-9]+)\\)");

    public HighlightPreferences(TokenMarker.LanguageDescription[][] languages, Preferences prefs) {
        this.setTabPlacement(4);
        TokenMarker.LanguageDescription[][] languageDescriptionArray = languages;
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            TokenMarker.LanguageDescription[] langs;
            TokenMarker.LanguageDescription[] languageDescriptionArray2 = langs = languageDescriptionArray[n2];
            int n3 = langs.length;
            int n4 = 0;
            while (n4 < n3) {
                TokenMarker.LanguageDescription lang = languageDescriptionArray2[n4];
                this.addTab(lang.getName(), new LanguagePanel(lang, prefs.node(lang.getUnixName())));
                ++n4;
            }
            ++n2;
        }
    }

    public static ColorProfile readProfile(File properties, Set<String> correctOrder) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream is = new FileInputStream(properties);){
            props.load(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return HighlightPreferences.propertiesToColorProfile(props, correctOrder);
    }

    public static ColorProfile propertiesToColorProfile(Properties props, Set<String> correctOrder) {
        String blockPrefix = BLOCK_NAMESPACE.toUpperCase();
        String editorPrefix = EDITOR_NAMESPACE.toUpperCase();
        ColorProfile.Builder builder = ColorProfile.newBuilder();
        HashMap<String, ColorProfile.ColorProfileEntry> readEntries = correctOrder != null ? new HashMap<String, ColorProfile.ColorProfileEntry>() : null;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = ((String)entry.getKey()).toUpperCase();
            String value = (String)entry.getValue();
            if (key.equals("NAME")) {
                builder.setName(value);
                continue;
            }
            if (!key.startsWith(blockPrefix)) {
                if (key.startsWith(editorPrefix)) {
                    Color color = HighlightPreferences.decodeColor(value.toLowerCase());
                    builder.setColorByProperty(key.substring(EDITOR_NAMESPACE.length()), color);
                    continue;
                }
                System.err.println(String.format("Property \"%s\" not recognized", (String)entry.getKey()));
                continue;
            }
            key = key.substring(BLOCK_NAMESPACE.length());
            if (readEntries != null) {
                readEntries.put(key, HighlightPreferences.decode(key, value));
                continue;
            }
            builder.addProfileEntry(key, HighlightPreferences.decode(key, value));
        }
        if (correctOrder != null && readEntries != null) {
            for (String string : correctOrder) {
                if (readEntries.containsKey(string)) {
                    builder.addProfileEntry(string, (ColorProfile.ColorProfileEntry)readEntries.get(string));
                    readEntries.remove(string);
                    continue;
                }
                builder.add(string, ColorProfile.makeEntry(string, null, 0));
            }
            for (Map.Entry entry : readEntries.entrySet()) {
                builder.add((String)entry.getKey(), (ColorProfile.ColorProfileEntry)entry.getValue());
            }
        }
        return builder.build();
    }

    public static void writeProfile(ColorProfile profile, File properties) throws FileNotFoundException, IOException {
        String comments = String.format("Generated highlight theme \"%s\"", profile.getName(), new Date().toString());
        Properties props = HighlightPreferences.profileToProperties(profile);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream fos = new FileOutputStream(properties);){
            props.store(fos, comments);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Properties profileToProperties(ColorProfile profile) {
        Properties props = new Properties();
        for (Map.Entry<String, ColorProfile.ColorProfileEntry> entry : profile.entrySet()) {
            props.setProperty(BLOCK_NAMESPACE + entry.getKey(), HighlightPreferences.encode(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : profile.colorProperties()) {
            props.setProperty(EDITOR_NAMESPACE + entry.getKey(), HighlightPreferences.encodeColor((Color)entry.getValue()));
        }
        props.setProperty("Name", profile.getName());
        return props;
    }

    private static ColorProfile.ColorProfileEntry decode(String key, String value) {
        value = value.toLowerCase();
        int transform = 0;
        if (value.contains("ital")) {
            transform |= 2;
        }
        if (value.contains("bold")) {
            transform |= 1;
        }
        Color color = HighlightPreferences.decodeColor(value);
        return ColorProfile.makeEntry(key, color, transform);
    }

    private static Color decodeColor(String value) {
        Matcher m = RGB_PATTERN.matcher(value);
        Color color = Color.BLACK;
        if (m.find()) {
            int r = Integer.parseInt(m.group(1));
            int g = Integer.parseInt(m.group(2));
            int b = Integer.parseInt(m.group(3));
            color = new Color(r, g, b);
        }
        return color;
    }

    private static String encode(Color color, boolean bold, boolean ital) {
        String res = HighlightPreferences.encodeColor(color);
        if (bold) {
            res = String.valueOf(res) + " bold";
        }
        if (ital) {
            res = String.valueOf(res) + " italic";
        }
        return res;
    }

    private static String encodeColor(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return String.format("rgb(%d, %d, %d)", r, g, b);
    }

    private static String encode(ColorProfile.ColorProfileEntry value) {
        return HighlightPreferences.encode(value.color, (value.fontStyle & 1) != 0, (value.fontStyle & 2) != 0);
    }

    private static void prefsPutProperties(Preferences prefs, Properties props) {
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            prefs.put((String)e.getKey(), (String)e.getValue());
        }
    }

    private static Properties prefsReadProperties(Preferences prefs) {
        Properties props = new Properties();
        try {
            String[] stringArray = prefs.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                props.put(key, prefs.get(key, null));
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return props;
    }

    private static final class LanguagePanel
    extends JPanel
    implements ItemListener {
        private static final long serialVersionUID = 1L;
        private static final int SCROLLPANE_HEIGHT = 320;
        Map<String, JScrollPane> stylePanels = new HashMap<String, JScrollPane>();
        JPanel boxPanel;
        JComboBox<ProfileItem> languagePicker = new JComboBox();
        JButton addLangButton = new JButton(Runner.editorInterface.getString("LangPanel.NEW"));
        JButton delLangButton = new JButton(Runner.editorInterface.getString("LangPanel.DELETE"));
        JScrollPane scrollPane = null;
        private final Preferences prefs;

        public LanguagePanel(TokenMarker.LanguageDescription lang, Preferences prefs) {
            this.setLayout(new BoxLayout(this, 3));
            this.prefs = prefs;
            this.languagePicker.setEditable(false);
            this.add(this.buildBoxPanel());
            LinkedHashSet<String> correctOrder = new LinkedHashSet<String>();
            for (ColorProfile profile : lang.defaultProfiles()) {
                this.languagePicker.addItem(new ProfileItem(profile, null));
                for (String n : profile.keySet()) {
                    correctOrder.add(n);
                }
            }
            try {
                String[] stringArray = prefs.childrenNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String scheme = stringArray[n2];
                    Preferences schemeNode = prefs.node(scheme);
                    ColorProfile prof = HighlightPreferences.propertiesToColorProfile(HighlightPreferences.prefsReadProperties(schemeNode), correctOrder);
                    this.languagePicker.addItem(new ProfileItem(prof, schemeNode));
                    ++n2;
                }
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
            this.languagePicker.addItemListener(this);
            this.addLangButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    LanguagePanel.this.addClicked();
                }
            });
            this.delLangButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    LanguagePanel.this.deleteClicked();
                }
            });
            if (this.languagePicker.getItemCount() > 0) {
                this.displayCard((ProfileItem)this.languagePicker.getSelectedItem());
            }
        }

        private void addClicked() {
            ColorProfile curProfile = ((ProfileItem)this.languagePicker.getSelectedItem()).profile;
            String curName = curProfile.getName();
            String defNameFmt = Runner.editorInterface.getString("LangPanel.MY_COPY");
            String msg = Runner.editorInterface.getString("LangPanel.ENTER_NAME_PROMPT");
            String cap = Runner.editorInterface.getString("LangPanel.ENTER_NAME_CAP");
            String newName = String.format(defNameFmt, curName);
            int type = 3;
            if ((newName = (String)JOptionPane.showInputDialog(this, msg, cap, type, null, null, newName)) == null) {
                return;
            }
            String newNixName = newName.replaceAll("\\W", "_");
            try {
                while (this.prefs.nodeExists(newNixName)) {
                    newNixName = String.valueOf(newNixName) + "_";
                }
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
            Preferences node = this.prefs.node(newNixName);
            ColorProfile nProf = new ColorProfile(newName, curProfile);
            HighlightPreferences.prefsPutProperties(node, HighlightPreferences.profileToProperties(nProf));
            ProfileItem profileItem = new ProfileItem(nProf, node);
            this.languagePicker.addItem(profileItem);
            this.languagePicker.setSelectedItem(profileItem);
        }

        private void deleteClicked() {
            String deleteTitle;
            String confMessage = Runner.editorInterface.getString("LangPanel.CONFIRM_DELETE");
            int confirm = JOptionPane.showConfirmDialog(this, confMessage, deleteTitle = Runner.editorInterface.getString("LangPanel.DELETE_PROF_TITLE"), 2);
            if (confirm != 0) {
                return;
            }
            ProfileItem item = (ProfileItem)this.languagePicker.getSelectedItem();
            if (item.prefsEntry != null) {
                this.languagePicker.removeItem(item);
                this.stylePanels.remove(item.profile.getName());
                try {
                    item.prefsEntry.removeNode();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
        }

        private Component buildBoxPanel() {
            int padding = 4;
            this.boxPanel = new JPanel();
            this.boxPanel.setLayout(new BoxLayout(this.boxPanel, 2));
            this.boxPanel.add(this.languagePicker);
            this.boxPanel.add(Box.createRigidArea(new Dimension(4, 4)));
            this.boxPanel.add(this.addLangButton);
            this.boxPanel.add(Box.createRigidArea(new Dimension(4, 4)));
            this.boxPanel.add(this.delLangButton);
            this.boxPanel.setMaximumSize(new Dimension(this.boxPanel.getMaximumSize().width, this.languagePicker.getPreferredSize().height + 8));
            this.boxPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            return this.boxPanel;
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            ProfileItem item = (ProfileItem)event.getItem();
            this.displayCard(item);
        }

        private void displayCard(ProfileItem item) {
            ColorProfile prof = item.profile;
            boolean builtIn = item.prefsEntry == null;
            this.delLangButton.setEnabled(!builtIn);
            if (this.scrollPane != null) {
                this.remove(this.scrollPane);
            }
            if (this.stylePanels.containsKey(prof.getName())) {
                this.scrollPane = this.stylePanels.get(prof.getName());
            } else {
                this.scrollPane = new JScrollPane(new StylesPanel(prof, item.prefsEntry), 22, 30);
                Dimension preferred = this.scrollPane.getPreferredSize();
                if (preferred.height > 320) {
                    this.scrollPane.setPreferredSize(new Dimension(preferred.width, 320));
                }
                this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
                this.stylePanels.put(prof.getName(), this.scrollPane);
            }
            this.add(this.scrollPane);
            this.scrollPane.repaint();
        }
    }

    private static final class ProfileItem {
        public final ColorProfile profile;
        public final Preferences prefsEntry;

        public String toString() {
            return this.profile.getName();
        }

        public ProfileItem(ColorProfile prof, Preferences fileName) {
            this.profile = prof;
            this.prefsEntry = fileName;
        }
    }

    private static final class StylesPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        List<FormattingRow> rows = new ArrayList<FormattingRow>();
        SpringLayout springLayout = new SpringLayout();
        private final Preferences prefsNode;

        StylesPanel(ColorProfile prof, Preferences prefsNode) {
            this.prefsNode = prefsNode;
            this.setLayout(this.springLayout);
            boolean builtIn = prefsNode == null;
            for (Map.Entry<String, ColorProfile.ColorProfileEntry> entry : prof.entrySet()) {
                this.rows.add(new FormattingRow(entry.getKey(), entry.getValue(), !builtIn));
            }
            for (Map.Entry<String, Object> entry : prof.colorProperties()) {
                this.rows.add(new FormattingRow(entry.getKey(), (Color)entry.getValue(), !builtIn));
            }
            this.packLayout(3);
        }

        private void packLayout(int padding) {
            if (this.rows.size() < 1) {
                return;
            }
            Spring[] maxWidths = new Spring[this.rows.get(0).componentCount()];
            Spring[] maxSpanWidths = new Spring[this.rows.get(1).componentCount() - 1];
            int i = 0;
            while (i < maxWidths.length) {
                maxWidths[i] = Spring.constant(0);
                ++i;
            }
            i = 0;
            while (i < maxWidths.length - 1) {
                maxSpanWidths[i] = Spring.constant(0);
                ++i;
            }
            Spring padSpring = Spring.constant(padding);
            SpringLayout.Constraints parentConstraints = this.springLayout.getConstraints(this);
            for (FormattingRow row : this.rows) {
                row.computeMaxima(maxWidths, maxSpanWidths);
            }
            Spring tWidth = maxWidths[0];
            Spring dualPad = Spring.sum(padSpring, padSpring);
            Spring[] xs = new Spring[maxWidths.length];
            xs[0] = padSpring;
            int i2 = 1;
            while (i2 < xs.length) {
                xs[i2] = Spring.sum(dualPad, tWidth);
                tWidth = Spring.sum(padSpring, Spring.sum(tWidth, maxWidths[i2]));
                Spring spring = Spring.max(tWidth, maxSpanWidths[i2 - 1]);
                maxSpanWidths[i2 - 1] = spring;
                tWidth = spring;
                ++i2;
            }
            Spring y = padSpring;
            for (FormattingRow row : this.rows) {
                y = row.applyMaxima(maxWidths, maxSpanWidths, padSpring, xs, y);
            }
            parentConstraints.setConstraint("South", y);
            parentConstraints.setConstraint("East", Spring.sum(tWidth, dualPad));
        }

        private final class FormattingRow {
            private final String S_BOLD = Runner.editorInterface.getString("LangPanel.BOLD");
            private final String S_ITAL = Runner.editorInterface.getString("LangPanel.ITALIC");
            private final String S_PICK_COLOR = Runner.editorInterface.getString("LangPanel.PICK_COLOR");
            private final boolean colorOnly;
            private final JLabel label;
            private final JCheckBox chkBold;
            private final JCheckBox chkItal;
            private final JEColorButton colorButton;
            private final String prefsKey;
            private Spring maxHeight;

            FormattingRow(String key, ColorProfile.ColorProfileEntry e, boolean editable) {
                this.colorOnly = false;
                this.prefsKey = key;
                this.label = new JLabel(e.nlsName);
                StylesPanel.this.add(this.label);
                this.chkBold = new JCheckBox(this.S_BOLD, (e.fontStyle & 1) != 0);
                StylesPanel.this.add(this.chkBold);
                this.chkItal = new JCheckBox(this.S_ITAL, (e.fontStyle & 2) != 0);
                StylesPanel.this.add(this.chkItal);
                this.colorButton = new JEColorButton(e.color, this.S_PICK_COLOR);
                StylesPanel.this.add(this.colorButton);
                this.chkBold.setEnabled(editable);
                this.chkItal.setEnabled(editable);
                this.colorButton.setEnabled(editable);
                if (editable) {
                    this.addCheckListeners();
                    this.addColorListener();
                }
                this.label.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.label.getPreferredSize().height));
            }

            FormattingRow(String key, Color color, boolean editable) {
                this.colorOnly = true;
                this.prefsKey = key;
                this.label = new JLabel(ColorProfile.getPropertyNlsName(key));
                StylesPanel.this.add(this.label);
                this.colorButton = new JEColorButton(color, this.S_PICK_COLOR);
                StylesPanel.this.add(this.colorButton);
                this.chkItal = null;
                this.chkBold = null;
                this.colorButton.setEnabled(editable);
                if (editable) {
                    this.addColorListener();
                }
                this.label.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.label.getPreferredSize().height));
            }

            private void addColorListener() {
                this.colorButton.addColorListener(new JEColorButton.ColorListener(){

                    @Override
                    public void colorChanged(JEColorButton.ColorChangeEvent event) {
                        FormattingRow.this.updatePrefs();
                    }
                });
            }

            private void addCheckListeners() {
                this.chkBold.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FormattingRow.this.updatePrefs();
                    }
                });
                this.chkItal.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FormattingRow.this.updatePrefs();
                    }
                });
            }

            protected void updatePrefs() {
                Color color = this.colorButton.getColor();
                if (this.colorOnly) {
                    StylesPanel.this.prefsNode.put(HighlightPreferences.EDITOR_NAMESPACE + this.prefsKey, HighlightPreferences.encodeColor(color));
                    return;
                }
                boolean bold = this.chkBold.isSelected();
                boolean italic = this.chkItal.isSelected();
                StylesPanel.this.prefsNode.put(HighlightPreferences.BLOCK_NAMESPACE + this.prefsKey, HighlightPreferences.encode(color, bold, italic));
            }

            void computeMaxima(Spring[] maxWidths, Spring[] maxSpanWidths) {
                if (this.colorOnly) {
                    SpringLayout.Constraints c = StylesPanel.this.springLayout.getConstraints(this.label);
                    maxSpanWidths[1] = Spring.max(maxSpanWidths[1], c.getWidth());
                    this.maxHeight = c.getHeight();
                    c = StylesPanel.this.springLayout.getConstraints(this.colorButton);
                    maxWidths[3] = Spring.max(maxWidths[3], c.getWidth());
                    this.maxHeight = Spring.max(this.maxHeight, c.getHeight());
                    return;
                }
                int j = 0;
                this.maxHeight = Spring.constant(0);
                SpringLayout.Constraints[] constraintsArray = this.getConstraints();
                int n = constraintsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SpringLayout.Constraints c = constraintsArray[n2];
                    maxWidths[j] = Spring.max(maxWidths[j], c.getWidth());
                    this.maxHeight = Spring.max(this.maxHeight, c.getHeight());
                    ++j;
                    ++n2;
                }
            }

            private Spring applyMaxima(Spring[] maxWidths, Spring[] spanWidths, Spring padSpring, Spring[] xs, Spring y) {
                if (this.colorOnly) {
                    this.constrain(StylesPanel.this.springLayout.getConstraints(this.label), xs[0], y, spanWidths[1], this.maxHeight);
                    this.constrain(StylesPanel.this.springLayout.getConstraints(this.colorButton), xs[3], y, maxWidths[3], this.maxHeight);
                } else {
                    int j = 0;
                    SpringLayout.Constraints[] constraintsArray = this.getConstraints();
                    int n = constraintsArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SpringLayout.Constraints c = constraintsArray[n2];
                        this.constrain(c, xs[j], y, maxWidths[j++], this.maxHeight);
                        ++n2;
                    }
                }
                return Spring.sum(padSpring, Spring.sum(y, this.maxHeight));
            }

            private void constrain(SpringLayout.Constraints c, Spring x, Spring y, Spring width, Spring height) {
                c.setX(x);
                c.setY(y);
                c.setWidth(width);
                c.setHeight(height);
            }

            private SpringLayout.Constraints[] getConstraints() {
                return new SpringLayout.Constraints[]{StylesPanel.this.springLayout.getConstraints(this.label), StylesPanel.this.springLayout.getConstraints(this.chkBold), StylesPanel.this.springLayout.getConstraints(this.chkItal), StylesPanel.this.springLayout.getConstraints(this.colorButton)};
            }

            int componentCount() {
                return 4;
            }
        }
    }
}

