/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit.lexers;

import java.awt.Color;
import java.util.Collections;
import org.lateralgm.joshedit.ColorProfile;
import org.lateralgm.joshedit.DefaultKeywords;
import org.lateralgm.joshedit.DefaultTokenMarker;

public class ShaderHighlightingSchemes {
    private static final String S_HEX_LITERAL = "HEX_LITERAL";
    private static final String S_NUMERIC_LITERAL = "NUMERIC_LITERAL";
    private static final String S_SINGLEQ_STRING = "SINGLEQ_STRING";
    private static final String S_DOUBLEQ_STRING = "DOUBLEQ_STRING";
    private static final String S_LINE_COMMENT = "LINE_COMMENT";
    private static final String S_DOC_LINE_COMMENT = "FORMAL_LINE_COMMENT";
    private static final String S_BLOCK_COMMENT = "BLOCK_COMMENT";
    private static final String S_DOC_COMMENT = "FORMAL_COMMENT";
    private static final String S_OPS_AND_SEPS = "OPS_AND_SEPS";
    public static final String S_VARIABLES = "VARIABLES";
    public static final String S_CONSTANTS = "CONSTANTS";
    public static final String S_OPERATORS = "OPERATORS";
    public static final String S_CONSTRUCTS = "CONSTRUCTS";
    public static final String S_FUNCTIONS = "FUNCTIONS";
    private static final Color BLUE = new Color(0, 0, 255);
    private static final Color LIGHT_BLUE = new Color(128, 128, 255);
    private static final Color SLIGHTLY_LESS_LIGHT_BLUE = new Color(100, 100, 255);
    private static final Color BLUE_BLACK = new Color(20, 50, 90);
    private static final Color FOREST = new Color(13, 135, 13);
    private static final Color DARK_RED = new Color(200, 0, 0);
    private static final Color HALFASS_TURQUOIS = new Color(0, 100, 150);
    private static final Color BLACK = Color.BLACK;
    public static final ColorProfile ASS_BLASTERS_DX = ColorProfile.newBuilder("Ass Blasters DX").add("FORMAL_COMMENT", ColorProfile.makeEntry("FORMAL_COMMENT", LIGHT_BLUE, 1)).add("BLOCK_COMMENT", ColorProfile.makeEntry("BLOCK_COMMENT", FOREST, 2)).add("FORMAL_LINE_COMMENT", ColorProfile.makeEntry("FORMAL_LINE_COMMENT", LIGHT_BLUE, 1)).add("LINE_COMMENT", ColorProfile.makeEntry("LINE_COMMENT", FOREST, 2)).add("DOUBLEQ_STRING", ColorProfile.makeEntry("DOUBLEQ_STRING", BLUE, 0)).add("SINGLEQ_STRING", ColorProfile.makeEntry("SINGLEQ_STRING", BLUE, 0)).add("FUNCTIONS", ColorProfile.makeEntry("FUNCTIONS", HALFASS_TURQUOIS, 0)).add("CONSTRUCTS", ColorProfile.makeEntry("CONSTRUCTS", HALFASS_TURQUOIS, 1)).add("OPERATORS", ColorProfile.makeEntry("OPERATORS", BLACK, 1)).add("CONSTANTS", ColorProfile.makeEntry("CONSTANTS", DARK_RED, 0)).add("VARIABLES", ColorProfile.makeEntry("VARIABLES", BLUE, 2)).add("OPS_AND_SEPS", ColorProfile.makeEntry("OPS_AND_SEPS", DARK_RED, 0)).add("NUMERIC_LITERAL", ColorProfile.makeEntry("NUMERIC_LITERAL", BLUE_BLACK, 0)).add("HEX_LITERAL", ColorProfile.makeEntry("HEX_LITERAL", SLIGHTLY_LESS_LIGHT_BLUE, 0)).build();

    public static DefaultTokenMarker.BlockDescriptor[] cannedSchemes(ColorProfile profile) {
        return new DefaultTokenMarker.BlockDescriptor[]{new DefaultTokenMarker.BlockDescriptor(S_DOC_COMMENT, "/\\*(?=\\*)", "\\*/", profile), new DefaultTokenMarker.BlockDescriptor(S_BLOCK_COMMENT, "/(?=\\*)", "\\*/", profile), new DefaultTokenMarker.BlockDescriptor(S_DOC_LINE_COMMENT, "///", "$", profile), new DefaultTokenMarker.BlockDescriptor(S_LINE_COMMENT, "//", "$", profile), new DefaultTokenMarker.BlockDescriptor(S_DOUBLEQ_STRING, "\"", "\"", profile), new DefaultTokenMarker.BlockDescriptor(S_SINGLEQ_STRING, "'", "'", profile)};
    }

    public static DefaultTokenMarker.CharSymbolSet cannedCharSymbols(ColorProfile profile) {
        DefaultTokenMarker.CharSymbolSet css = new DefaultTokenMarker.CharSymbolSet(S_OPS_AND_SEPS, profile);
        char[] ca = "{[()]}!@%^&*-/+=?:~<>.,;".toCharArray();
        int i = 0;
        while (i < ca.length) {
            css.chars.add(Character.valueOf(ca[i]));
            ++i;
        }
        return css;
    }

    public static DefaultTokenMarker.KeywordSet putFunctionSet(DefaultKeywords.Function[] functionSet, ColorProfile profile, DefaultTokenMarker who) {
        DefaultTokenMarker.KeywordSet functions = who.addKeywordSet(S_FUNCTIONS, profile);
        DefaultKeywords.Function[] functionArray = functionSet;
        int n = functionSet.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultKeywords.Function f = functionArray[n2];
            Collections.addAll(functions.words, f.getName());
            ++n2;
        }
        return functions;
    }

    public static DefaultTokenMarker.KeywordSet putConstructSet(DefaultKeywords.Construct[] constructSet, ColorProfile profile, DefaultTokenMarker who) {
        DefaultTokenMarker.KeywordSet constructs = who.addKeywordSet(S_CONSTRUCTS, profile);
        DefaultKeywords.Construct[] constructArray = constructSet;
        int n = constructSet.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultKeywords.Construct c = constructArray[n2];
            Collections.addAll(constructs.words, c.getName());
            ++n2;
        }
        return constructs;
    }

    public static DefaultTokenMarker.KeywordSet putOperatorSet(DefaultKeywords.Operator[] operatorSet, ColorProfile profile, DefaultTokenMarker who) {
        DefaultTokenMarker.KeywordSet operators = who.addKeywordSet(S_OPERATORS, profile);
        DefaultKeywords.Operator[] operatorArray = operatorSet;
        int n = operatorSet.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultKeywords.Operator o = operatorArray[n2];
            Collections.addAll(operators.words, o.getName());
            ++n2;
        }
        return operators;
    }

    public static DefaultTokenMarker.KeywordSet putConstantSet(DefaultKeywords.Constant[] constantSet, ColorProfile profile, DefaultTokenMarker who) {
        DefaultTokenMarker.KeywordSet constants = who.addKeywordSet(S_CONSTANTS, profile);
        DefaultKeywords.Constant[] constantArray = constantSet;
        int n = constantSet.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultKeywords.Constant c = constantArray[n2];
            Collections.addAll(constants.words, c.getName());
            ++n2;
        }
        return constants;
    }

    public static DefaultTokenMarker.KeywordSet putVariableSet(DefaultKeywords.Variable[] variableSet, ColorProfile profile, DefaultTokenMarker who) {
        DefaultTokenMarker.KeywordSet variables = who.addKeywordSet(S_VARIABLES, profile);
        DefaultKeywords.Variable[] variableArray = variableSet;
        int n = variableSet.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultKeywords.Variable v = variableArray[n2];
            Collections.addAll(variables.words, v.getName());
            ++n2;
        }
        return variables;
    }

    public static DefaultTokenMarker.SimpleToken[] cannedTokens(ColorProfile profile) {
        return new DefaultTokenMarker.SimpleToken[]{new DefaultTokenMarker.SimpleToken(S_NUMERIC_LITERAL, "[0-9]+", profile), new DefaultTokenMarker.SimpleToken(S_HEX_LITERAL, "\\$[0-9A-Fa-f]+", profile)};
    }

    private ShaderHighlightingSchemes() {
    }
}

