/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit.lexers;

import java.util.Arrays;
import java.util.Collection;
import org.lateralgm.joshedit.ColorProfile;
import org.lateralgm.joshedit.DefaultKeywords;
import org.lateralgm.joshedit.DefaultTokenMarker;
import org.lateralgm.joshedit.TokenMarker;
import org.lateralgm.joshedit.lexers.HLSLKeywords;
import org.lateralgm.joshedit.lexers.ShaderHighlightingSchemes;

public class HLSLTokenMarker
extends DefaultTokenMarker
implements DefaultKeywords.HasKeywords {
    private final ColorProfile profile = ShaderHighlightingSchemes.ASS_BLASTERS_DX;
    static DefaultTokenMarker.KeywordSet resNames;
    static DefaultTokenMarker.KeywordSet scrNames;
    static DefaultTokenMarker.KeywordSet constructs;
    static DefaultTokenMarker.KeywordSet functions;
    static DefaultTokenMarker.KeywordSet operators;
    static DefaultTokenMarker.KeywordSet constants;
    static DefaultTokenMarker.KeywordSet variables;

    public static TokenMarker.LanguageDescription[] getLanguageDescriptions() {
        return new TokenMarker.LanguageDescription[]{new HLSLDescription()};
    }

    public HLSLTokenMarker() {
        Object[] objectArray = ShaderHighlightingSchemes.cannedSchemes(this.profile);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultTokenMarker.BlockDescriptor blockDescriptor = objectArray[n2];
            this.schemes.add(blockDescriptor);
            ++n2;
        }
        functions = ShaderHighlightingSchemes.putFunctionSet(HLSLKeywords.FUNCTIONS, this.profile, this);
        constructs = ShaderHighlightingSchemes.putConstructSet(HLSLKeywords.CONSTRUCTS, this.profile, this);
        operators = ShaderHighlightingSchemes.putOperatorSet(HLSLKeywords.OPERATORS, this.profile, this);
        constants = ShaderHighlightingSchemes.putConstantSet(HLSLKeywords.CONSTANTS, this.profile, this);
        variables = ShaderHighlightingSchemes.putVariableSet(HLSLKeywords.VARIABLES, this.profile, this);
        this.tmKeywords.add(functions);
        this.tmKeywords.add(constructs);
        this.tmKeywords.add(operators);
        this.tmKeywords.add(constants);
        this.tmKeywords.add(variables);
        this.tmChars.add(ShaderHighlightingSchemes.cannedCharSymbols(this.profile));
        objectArray = ShaderHighlightingSchemes.cannedTokens(this.profile);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object tok = objectArray[n2];
            this.otherTokens.add(tok);
            ++n2;
        }
    }

    @Override
    public DefaultKeywords.Keyword[][] getKeywords() {
        DefaultKeywords.Keyword[][] HLSL_KEYWORDS = new DefaultKeywords.Keyword[][]{HLSLKeywords.CONSTRUCTS, HLSLKeywords.FUNCTIONS, HLSLKeywords.VARIABLES, HLSLKeywords.OPERATORS, HLSLKeywords.CONSTANTS};
        return HLSL_KEYWORDS;
    }

    private static class HLSLDescription
    implements TokenMarker.LanguageDescription {
        private HLSLDescription() {
        }

        @Override
        public String getName() {
            return "HLSL";
        }

        @Override
        public String getUnixName() {
            return "hlsl";
        }

        @Override
        public Collection<ColorProfile> defaultProfiles() {
            return Arrays.asList(ShaderHighlightingSchemes.ASS_BLASTERS_DX);
        }
    }
}

