/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit.lexers;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.lateralgm.joshedit.ColorProfile;
import org.lateralgm.joshedit.DefaultKeywords;
import org.lateralgm.joshedit.DefaultTokenMarker;
import org.lateralgm.joshedit.LineNumberPanel;
import org.lateralgm.joshedit.TokenMarker;
import org.lateralgm.joshedit.lexers.GMLKeywords;

public class GMLTokenMarker
extends DefaultTokenMarker
implements DefaultKeywords.HasKeywords {
    private static final String S_HEX_LITERAL = "HEX_LITERAL";
    private static final String S_NUMERIC_LITERAL = "NUMERIC_LITERAL";
    private static final String S_SINGLEQ_STRING = "SINGLEQ_STRING";
    private static final String S_DOUBLEQ_STRING = "DOUBLEQ_STRING";
    private static final String S_LINE_COMMENT = "LINE_COMMENT";
    private static final String S_DOC_LINE_COMMENT = "FORMAL_LINE_COMMENT";
    private static final String S_BLOCK_COMMENT = "BLOCK_COMMENT";
    private static final String S_DOC_COMMENT = "FORMAL_COMMENT";
    private static final String S_VARIABLES = "VARIABLES";
    private static final String S_CONSTANTS = "CONSTANTS";
    private static final String S_OPERATORS = "OPERATORS";
    private static final String S_CONSTRUCTS = "CONSTRUCTS";
    private static final String S_FUNCTIONS = "FUNCTIONS";
    private static final String S_OPS_AND_SEPS = "OPS_AND_SEPS";
    private static final Color NAVY = new Color(0, 0, 200);
    private static final Color BLUE_BLACK = new Color(0, 0, 100);
    private static final Color FAGGOTRY_BLUE = new Color(54, 116, 186);
    private static final Color LIGHT_BLUE = new Color(100, 100, 255);
    private static final Color HALFASS_TURQUOIS = new Color(0, 100, 150);
    private static final Color FOREST = new Color(13, 135, 13);
    private static final Color DARK_RED = new Color(150, 0, 0);
    private static final Color GREEN = new Color(13, 165, 13);
    private static final Color BLUE = new Color(0, 0, 255);
    private static final Color RED = new Color(255, 0, 0);
    private static final Color MAGENTA = new Color(255, 0, 255);
    private static final Color LIGHT_RED = new Color(255, 100, 100);
    private static final ColorProfile PROFILE_ADVANCED_FAGGOTRY = ColorProfile.newBuilder("Advanced Faggotry").add("FORMAL_COMMENT", ColorProfile.makeEntry("FORMAL_COMMENT", FAGGOTRY_BLUE, 1)).add("BLOCK_COMMENT", ColorProfile.makeEntry("BLOCK_COMMENT", FOREST, 2)).add("FORMAL_LINE_COMMENT", ColorProfile.makeEntry("FORMAL_LINE_COMMENT", FAGGOTRY_BLUE, 1)).add("LINE_COMMENT", ColorProfile.makeEntry("LINE_COMMENT", FOREST, 2)).add("DOUBLEQ_STRING", ColorProfile.makeEntry("DOUBLEQ_STRING", BLUE_BLACK, 0)).add("SINGLEQ_STRING", ColorProfile.makeEntry("SINGLEQ_STRING", BLUE_BLACK, 0)).add("FUNCTIONS", ColorProfile.makeEntry("FUNCTIONS", HALFASS_TURQUOIS, 0)).add("CONSTRUCTS", ColorProfile.makeEntry("CONSTRUCTS", NAVY, 0)).add("OPERATORS", ColorProfile.makeEntry("OPERATORS", NAVY, 0)).add("CONSTANTS", ColorProfile.makeEntry("CONSTANTS", DARK_RED, 0)).add("VARIABLES", ColorProfile.makeEntry("VARIABLES", BLUE_BLACK, 2)).add("OPS_AND_SEPS", ColorProfile.makeEntry("OPS_AND_SEPS", NAVY, 0)).add("NUMERIC_LITERAL", ColorProfile.makeEntry("NUMERIC_LITERAL", DARK_RED, 0)).add("HEX_LITERAL", ColorProfile.makeEntry("HEX_LITERAL", LIGHT_BLUE, 0)).setBackgroundColor(Color.WHITE).setDefaultFontColor(Color.BLACK).setLineHighlightColor(new Color(230, 240, 255)).setWhitespaceColor(Color.RED).setMatchingCharColor(new Color(100, 100, 100)).setNoMatchingCharColor(Color.RED).setLineNumberColor(LineNumberPanel.DEFAULT_LIGHT_FOREGROUND).setLineNumberPanelColor(LineNumberPanel.DEFAULT_LIGHT_BACKGROUND).build();
    private static final ColorProfile PROFILE_CODE_BLOCKS = ColorProfile.newBuilder("Code::Blocks").add("FORMAL_COMMENT", ColorProfile.makeEntry("FORMAL_COMMENT", LIGHT_BLUE, 1)).add("BLOCK_COMMENT", ColorProfile.makeEntry("BLOCK_COMMENT", GREEN, 2)).add("FORMAL_LINE_COMMENT", ColorProfile.makeEntry("FORMAL_LINE_COMMENT", LIGHT_BLUE, 1)).add("LINE_COMMENT", ColorProfile.makeEntry("LINE_COMMENT", GREEN, 2)).add("DOUBLEQ_STRING", ColorProfile.makeEntry("DOUBLEQ_STRING", BLUE, 0)).add("SINGLEQ_STRING", ColorProfile.makeEntry("SINGLEQ_STRING", BLUE, 0)).add("FUNCTIONS", ColorProfile.makeEntry("FUNCTIONS", NAVY, 0)).add("CONSTRUCTS", ColorProfile.makeEntry("CONSTRUCTS", NAVY, 1)).add("OPERATORS", ColorProfile.makeEntry("OPERATORS", NAVY, 1)).add("CONSTANTS", ColorProfile.makeEntry("CONSTANTS", DARK_RED, 0)).add("VARIABLES", ColorProfile.makeEntry("VARIABLES", BLUE, 2)).add("OPS_AND_SEPS", ColorProfile.makeEntry("OPS_AND_SEPS", RED, 0)).add("NUMERIC_LITERAL", ColorProfile.makeEntry("NUMERIC_LITERAL", MAGENTA, 0)).add("HEX_LITERAL", ColorProfile.makeEntry("HEX_LITERAL", LIGHT_RED, 0)).setBackgroundColor(Color.WHITE).setDefaultFontColor(Color.BLACK).setLineHighlightColor(new Color(230, 240, 255)).setWhitespaceColor(Color.RED).setMatchingCharColor(new Color(100, 100, 100)).setNoMatchingCharColor(Color.RED).setLineNumberColor(LineNumberPanel.DEFAULT_LIGHT_FOREGROUND).setLineNumberPanelColor(LineNumberPanel.DEFAULT_LIGHT_BACKGROUND).build();
    private final ColorProfile profile = PROFILE_ADVANCED_FAGGOTRY;
    static DefaultTokenMarker.KeywordSet resNames;
    static DefaultTokenMarker.KeywordSet scrNames;
    static DefaultTokenMarker.KeywordSet constructs;
    static DefaultTokenMarker.KeywordSet functions;
    static DefaultTokenMarker.KeywordSet operators;
    static DefaultTokenMarker.KeywordSet constants;
    static DefaultTokenMarker.KeywordSet variables;
    private static final DefaultKeywords.Keyword[][] GML_KEYWORDS;

    static {
        GML_KEYWORDS = new DefaultKeywords.Keyword[][]{GMLKeywords.CONSTRUCTS, GMLKeywords.FUNCTIONS, GMLKeywords.VARIABLES, GMLKeywords.OPERATORS, GMLKeywords.CONSTANTS};
    }

    public static TokenMarker.LanguageDescription[] getLanguageDescriptions() {
        return new TokenMarker.LanguageDescription[]{new GMLDescription()};
    }

    public GMLTokenMarker() {
        DefaultKeywords.Keyword c;
        this.schemes.add(new DefaultTokenMarker.BlockDescriptor(S_DOC_COMMENT, "/\\*(?=\\*)", "\\*/", this.profile));
        this.schemes.add(new DefaultTokenMarker.BlockDescriptor(S_BLOCK_COMMENT, "/(?=\\*)", "\\*/", this.profile));
        this.schemes.add(new DefaultTokenMarker.BlockDescriptor(S_DOC_LINE_COMMENT, "///", "$", this.profile));
        this.schemes.add(new DefaultTokenMarker.BlockDescriptor(S_LINE_COMMENT, "//", "$", this.profile));
        this.schemes.add(new DefaultTokenMarker.BlockDescriptor(S_DOUBLEQ_STRING, "\"", "\"", this.profile));
        this.schemes.add(new DefaultTokenMarker.BlockDescriptor(S_SINGLEQ_STRING, "'", "'", this.profile));
        functions = this.addKeywordSet(S_FUNCTIONS, this.profile);
        DefaultKeywords.Keyword[] keywordArray = GMLKeywords.FUNCTIONS;
        int n = GMLKeywords.FUNCTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultKeywords.Function f = keywordArray[n2];
            Collections.addAll(GMLTokenMarker.functions.words, f.getName());
            ++n2;
        }
        constructs = this.addKeywordSet(S_CONSTRUCTS, this.profile);
        keywordArray = GMLKeywords.CONSTRUCTS;
        n = GMLKeywords.CONSTRUCTS.length;
        n2 = 0;
        while (n2 < n) {
            c = keywordArray[n2];
            Collections.addAll(GMLTokenMarker.constructs.words, c.getName());
            ++n2;
        }
        operators = this.addKeywordSet(S_OPERATORS, this.profile);
        keywordArray = GMLKeywords.OPERATORS;
        n = GMLKeywords.OPERATORS.length;
        n2 = 0;
        while (n2 < n) {
            DefaultKeywords.Keyword o = keywordArray[n2];
            Collections.addAll(GMLTokenMarker.operators.words, o.getName());
            ++n2;
        }
        constants = this.addKeywordSet(S_CONSTANTS, this.profile);
        keywordArray = GMLKeywords.CONSTANTS;
        n = GMLKeywords.CONSTANTS.length;
        n2 = 0;
        while (n2 < n) {
            c = keywordArray[n2];
            Collections.addAll(GMLTokenMarker.constants.words, c.getName());
            ++n2;
        }
        variables = this.addKeywordSet(S_VARIABLES, this.profile);
        keywordArray = GMLKeywords.VARIABLES;
        n = GMLKeywords.VARIABLES.length;
        n2 = 0;
        while (n2 < n) {
            DefaultKeywords.Keyword v = keywordArray[n2];
            Collections.addAll(GMLTokenMarker.variables.words, v.getName());
            ++n2;
        }
        this.tmKeywords.add(functions);
        this.tmKeywords.add(constructs);
        this.tmKeywords.add(operators);
        this.tmKeywords.add(constants);
        this.tmKeywords.add(variables);
        DefaultTokenMarker.CharSymbolSet css = new DefaultTokenMarker.CharSymbolSet(S_OPS_AND_SEPS, this.profile);
        char[] ca = "{[()]}!%^&*-/+=?:~<>.,;".toCharArray();
        int i = 0;
        while (i < ca.length) {
            css.chars.add(Character.valueOf(ca[i]));
            ++i;
        }
        this.tmChars.add(css);
        this.otherTokens.add(new DefaultTokenMarker.SimpleToken(S_NUMERIC_LITERAL, "[0-9]+", this.profile));
        this.otherTokens.add(new DefaultTokenMarker.SimpleToken(S_HEX_LITERAL, "\\$[0-9A-Fa-f]+", this.profile));
    }

    @Override
    public DefaultKeywords.Keyword[][] getKeywords() {
        return GML_KEYWORDS;
    }

    private static class GMLDescription
    implements TokenMarker.LanguageDescription {
        private GMLDescription() {
        }

        @Override
        public String getName() {
            return "GML";
        }

        @Override
        public String getUnixName() {
            return "gml";
        }

        @Override
        public Collection<ColorProfile> defaultProfiles() {
            return Arrays.asList(PROFILE_CODE_BLOCKS, PROFILE_ADVANCED_FAGGOTRY);
        }
    }
}

