/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit.lexers;

import java.util.Arrays;
import java.util.Collection;
import org.lateralgm.joshedit.ColorProfile;
import org.lateralgm.joshedit.DefaultKeywords;
import org.lateralgm.joshedit.DefaultTokenMarker;
import org.lateralgm.joshedit.TokenMarker;
import org.lateralgm.joshedit.lexers.GLSLKeywords;
import org.lateralgm.joshedit.lexers.ShaderHighlightingSchemes;

public class GLSLTokenMarker
extends DefaultTokenMarker
implements DefaultKeywords.HasKeywords {
    private final ColorProfile profile = ShaderHighlightingSchemes.ASS_BLASTERS_DX;
    static DefaultTokenMarker.KeywordSet resNames;
    static DefaultTokenMarker.KeywordSet scrNames;
    static DefaultTokenMarker.KeywordSet constructs;
    static DefaultTokenMarker.KeywordSet functions;
    static DefaultTokenMarker.KeywordSet operators;
    static DefaultTokenMarker.KeywordSet constants;
    static DefaultTokenMarker.KeywordSet variables;

    public static TokenMarker.LanguageDescription[] getLanguageDescriptions() {
        return new TokenMarker.LanguageDescription[]{new GLSLDescription()};
    }

    public GLSLTokenMarker() {
        Object[] objectArray = ShaderHighlightingSchemes.cannedSchemes(this.profile);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultTokenMarker.BlockDescriptor blockDescriptor = objectArray[n2];
            this.schemes.add(blockDescriptor);
            ++n2;
        }
        functions = ShaderHighlightingSchemes.putFunctionSet(GLSLKeywords.FUNCTIONS, this.profile, this);
        constructs = ShaderHighlightingSchemes.putConstructSet(GLSLKeywords.CONSTRUCTS, this.profile, this);
        operators = ShaderHighlightingSchemes.putOperatorSet(GLSLKeywords.OPERATORS, this.profile, this);
        constants = ShaderHighlightingSchemes.putConstantSet(GLSLKeywords.CONSTANTS, this.profile, this);
        variables = ShaderHighlightingSchemes.putVariableSet(GLSLKeywords.VARIABLES, this.profile, this);
        this.tmKeywords.add(functions);
        this.tmKeywords.add(constructs);
        this.tmKeywords.add(operators);
        this.tmKeywords.add(constants);
        this.tmKeywords.add(variables);
        this.tmChars.add(ShaderHighlightingSchemes.cannedCharSymbols(this.profile));
        objectArray = ShaderHighlightingSchemes.cannedTokens(this.profile);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object tok = objectArray[n2];
            this.otherTokens.add(tok);
            ++n2;
        }
    }

    @Override
    public DefaultKeywords.Keyword[][] getKeywords() {
        DefaultKeywords.Keyword[][] GLSL_KEYWORDS = new DefaultKeywords.Keyword[][]{GLSLKeywords.CONSTRUCTS, GLSLKeywords.FUNCTIONS, GLSLKeywords.VARIABLES, GLSLKeywords.OPERATORS, GLSLKeywords.CONSTANTS};
        return GLSL_KEYWORDS;
    }

    private static class GLSLDescription
    implements TokenMarker.LanguageDescription {
        private GLSLDescription() {
        }

        @Override
        public String getName() {
            return "GLSL";
        }

        @Override
        public String getUnixName() {
            return "glsl";
        }

        @Override
        public Collection<ColorProfile> defaultProfiles() {
            return Arrays.asList(ShaderHighlightingSchemes.ASS_BLASTERS_DX);
        }
    }
}

