/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit.lexers;

import java.util.Arrays;
import java.util.Collection;
import org.lateralgm.joshedit.ColorProfile;
import org.lateralgm.joshedit.DefaultKeywords;
import org.lateralgm.joshedit.DefaultTokenMarker;
import org.lateralgm.joshedit.TokenMarker;
import org.lateralgm.joshedit.lexers.GLESKeywords;
import org.lateralgm.joshedit.lexers.ShaderHighlightingSchemes;

public class GLESTokenMarker
extends DefaultTokenMarker
implements DefaultKeywords.HasKeywords {
    private final ColorProfile profile = ShaderHighlightingSchemes.ASS_BLASTERS_DX;
    static DefaultTokenMarker.KeywordSet resNames;
    static DefaultTokenMarker.KeywordSet scrNames;
    static DefaultTokenMarker.KeywordSet constructs;
    static DefaultTokenMarker.KeywordSet functions;
    static DefaultTokenMarker.KeywordSet operators;
    static DefaultTokenMarker.KeywordSet constants;
    static DefaultTokenMarker.KeywordSet variables;

    public static TokenMarker.LanguageDescription[] getLanguageDescriptions() {
        return new TokenMarker.LanguageDescription[]{new GLSLESDescription()};
    }

    public GLESTokenMarker() {
        Object[] objectArray = ShaderHighlightingSchemes.cannedSchemes(this.profile);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultTokenMarker.BlockDescriptor blockDescriptor = objectArray[n2];
            this.schemes.add(blockDescriptor);
            ++n2;
        }
        functions = ShaderHighlightingSchemes.putFunctionSet(GLESKeywords.FUNCTIONS, this.profile, this);
        constructs = ShaderHighlightingSchemes.putConstructSet(GLESKeywords.CONSTRUCTS, this.profile, this);
        operators = ShaderHighlightingSchemes.putOperatorSet(GLESKeywords.OPERATORS, this.profile, this);
        constants = ShaderHighlightingSchemes.putConstantSet(GLESKeywords.CONSTANTS, this.profile, this);
        variables = ShaderHighlightingSchemes.putVariableSet(GLESKeywords.VARIABLES, this.profile, this);
        this.tmKeywords.add(functions);
        this.tmKeywords.add(constructs);
        this.tmKeywords.add(operators);
        this.tmKeywords.add(constants);
        this.tmKeywords.add(variables);
        this.tmChars.add(ShaderHighlightingSchemes.cannedCharSymbols(this.profile));
        objectArray = ShaderHighlightingSchemes.cannedTokens(this.profile);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object tok = objectArray[n2];
            this.otherTokens.add(tok);
            ++n2;
        }
    }

    @Override
    public DefaultKeywords.Keyword[][] getKeywords() {
        DefaultKeywords.Keyword[][] GLES_KEYWORDS = new DefaultKeywords.Keyword[][]{GLESKeywords.CONSTRUCTS, GLESKeywords.FUNCTIONS, GLESKeywords.VARIABLES, GLESKeywords.OPERATORS, GLESKeywords.CONSTANTS};
        return GLES_KEYWORDS;
    }

    private static class GLSLESDescription
    implements TokenMarker.LanguageDescription {
        private GLSLESDescription() {
        }

        @Override
        public String getName() {
            return "GLSL ES";
        }

        @Override
        public String getUnixName() {
            return "glsl_es";
        }

        @Override
        public Collection<ColorProfile> defaultProfiles() {
            return Arrays.asList(ShaderHighlightingSchemes.ASS_BLASTERS_DX);
        }
    }
}

