/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit.lexers;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import org.lateralgm.joshedit.ColorProfile;
import org.lateralgm.joshedit.DefaultTokenMarker;
import org.lateralgm.joshedit.LineNumberPanel;
import org.lateralgm.joshedit.TokenMarker;

public class CPPTokenMarker
extends DefaultTokenMarker {
    private static final String S_PREPROCESSOR = "PREPROCESSOR";
    private static final String S_DOUBLEQ_STRING = "DOUBLEQ_STRING";
    private static final String S_CHARACTER_LIT = "CHARACTER_LIT";
    private static final String S_LINE_COMMENT = "LINE_COMMENT";
    private static final String S_LAZY_LINE_COMMENT = "LAZY_FORMAL_LINE_COMMENT";
    private static final String S_DOC_LINE_COMMENT = "FORMAL_LINE_COMMENT";
    private static final String S_BLOCK_COMMENT = "BLOCK_COMMENT";
    private static final String S_LAZY_COMMENT = "LAZY_FORMAL_COMMENT";
    private static final String S_FORMAL_COMMENT = "FORMAL_COMMENT";
    private static final String S_CONSTRUCTS = "CONSTRUCTS";
    private static final String S_OPS_AND_SEPS = "OPS_AND_SEPS";
    private static final String S_NUMERIC_LITERAL = "NUMERIC_LITERAL";
    private static final String S_HEX_LITERAL = "HEX_LITERAL";
    private static final Color RED = new Color(255, 0, 0);
    private static final Color MAGENTA = new Color(255, 0, 255);
    private static final Color LIGHT_RED = new Color(255, 100, 100);
    private static final Color CYAN = new Color(0, 255, 255);
    private static final Color NAVY = new Color(0, 0, 128);
    private static final Color ORANGE = new Color(255, 128, 0);
    private static final Color BLUE = new Color(0, 0, 255);
    private static final Color FOREST = new Color(13, 165, 13);
    private static final Color LIGHT_BLUE = new Color(128, 128, 255);
    private static final ColorProfile PROFILE_CODE_BLOCKS = ColorProfile.newBuilder("Code::Blocks").add("FORMAL_COMMENT", ColorProfile.makeEntry("FORMAL_COMMENT", LIGHT_BLUE, 1)).add("LAZY_FORMAL_COMMENT", ColorProfile.makeEntry("LAZY_FORMAL_COMMENT", LIGHT_BLUE, 1)).add("BLOCK_COMMENT", ColorProfile.makeEntry("BLOCK_COMMENT", FOREST, 2)).add("FORMAL_LINE_COMMENT", ColorProfile.makeEntry("FORMAL_LINE_COMMENT", LIGHT_BLUE, 1)).add("LAZY_FORMAL_LINE_COMMENT", ColorProfile.makeEntry("LAZY_FORMAL_LINE_COMMENT", LIGHT_BLUE, 1)).add("LINE_COMMENT", ColorProfile.makeEntry("LINE_COMMENT", FOREST, 2)).add("DOUBLEQ_STRING", ColorProfile.makeEntry("DOUBLEQ_STRING", BLUE, 0)).add("CHARACTER_LIT", ColorProfile.makeEntry("CHARACTER_LIT", ORANGE, 0)).add("PREPROCESSOR", ColorProfile.makeEntry("PREPROCESSOR", CYAN, 0)).add("CONSTRUCTS", ColorProfile.makeEntry("CONSTRUCTS", NAVY, 1)).add("OPS_AND_SEPS", ColorProfile.makeEntry("OPS_AND_SEPS", RED, 0)).add("HEX_LITERAL", ColorProfile.makeEntry("HEX_LITERAL", LIGHT_RED, 0)).add("NUMERIC_LITERAL", ColorProfile.makeEntry("NUMERIC_LITERAL", MAGENTA, 0)).setBackgroundColor(Color.WHITE).setDefaultFontColor(Color.BLACK).setLineHighlightColor(new Color(230, 240, 255)).setWhitespaceColor(Color.RED).setMatchingCharColor(new Color(100, 100, 100)).setNoMatchingCharColor(Color.RED).setLineNumberColor(LineNumberPanel.DEFAULT_LIGHT_FOREGROUND).setLineNumberPanelColor(LineNumberPanel.DEFAULT_LIGHT_BACKGROUND).build();
    private final ColorProfile profile = PROFILE_CODE_BLOCKS;

    public static TokenMarker.LanguageDescription[] getLanguageDescriptions() {
        return new TokenMarker.LanguageDescription[]{new CPPDescription()};
    }

    public CPPTokenMarker() {
        this.schemes.add(new DefaultTokenMarker.BlockDescriptor(S_FORMAL_COMMENT, "/\\*!", "\\*/", this.profile));
        this.schemes.add(new DefaultTokenMarker.BlockDescriptor(S_LAZY_COMMENT, "/\\*(?=\\*)", "\\*/", this.profile));
        this.schemes.add(new DefaultTokenMarker.BlockDescriptor(S_BLOCK_COMMENT, "/\\*", "\\*/", this.profile));
        this.schemes.add(new DefaultTokenMarker.BlockDescriptor(S_DOC_LINE_COMMENT, "//!", "$", this.profile));
        this.schemes.add(new DefaultTokenMarker.BlockDescriptor(S_LAZY_LINE_COMMENT, "///", "$", true, true, '\\', this.profile));
        this.schemes.add(new DefaultTokenMarker.BlockDescriptor(S_LINE_COMMENT, "//", "($)", true, true, '\\', this.profile));
        this.schemes.add(new DefaultTokenMarker.BlockDescriptor(S_DOUBLEQ_STRING, "\"", "($|\")", true, true, '\\', this.profile));
        this.schemes.add(new DefaultTokenMarker.BlockDescriptor(S_CHARACTER_LIT, "'", "($|')", true, true, '\\', this.profile));
        this.schemes.add(new DefaultTokenMarker.BlockDescriptor(S_PREPROCESSOR, "^(\\s*)#", "$", true, true, '\\', this.profile));
        DefaultTokenMarker.KeywordSet kws = this.addKeywordSet(S_CONSTRUCTS, NAVY, 1);
        String[] cppkws = new String[]{"if", "else", "do", "while", "for", "new", "delete", "this", "and", "or", "not"};
        int i = 0;
        while (i < cppkws.length) {
            kws.words.add(cppkws[i]);
            ++i;
        }
        this.tmKeywords.add(kws);
        DefaultTokenMarker.CharSymbolSet css = new DefaultTokenMarker.CharSymbolSet(S_OPS_AND_SEPS, this.profile);
        char[] ca = "{[()]}!%^&*-/+=?:~<>.,;".toCharArray();
        int i2 = 0;
        while (i2 < ca.length) {
            css.chars.add(Character.valueOf(ca[i2]));
            ++i2;
        }
        this.tmChars.add(css);
        this.otherTokens.add(new DefaultTokenMarker.SimpleToken(S_HEX_LITERAL, "0[Xx][0-9A-Fa-f]+[FfUuLlDd]*", this.profile));
        this.otherTokens.add(new DefaultTokenMarker.SimpleToken(S_NUMERIC_LITERAL, "[0-9]+[FfUuLlDd]*", this.profile));
    }

    private static class CPPDescription
    implements TokenMarker.LanguageDescription {
        private CPPDescription() {
        }

        @Override
        public String getName() {
            return "C++";
        }

        @Override
        public String getUnixName() {
            return "cpp";
        }

        @Override
        public Collection<ColorProfile> defaultProfiles() {
            return Arrays.asList(PROFILE_CODE_BLOCKS);
        }
    }
}

