/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.lateralgm.joshedit.Caret;
import org.lateralgm.joshedit.Code;
import org.lateralgm.joshedit.JoshText;
import org.lateralgm.joshedit.Line;

public class Selection
implements JoshText.Highlighter {
    ST type = ST.NORM;
    Code code;
    JoshText joshText;
    Caret caret;
    int col;
    int row;
    static Clipboard fallbackMCClipboard;
    WordSelHandler wordSelHandler = new WordSelHandler();
    LineSelHandler lineSelHandler = new LineSelHandler();
    SpecialSel special = new SpecialSel();

    public Selection(Code txt, JoshText joshTxt, Caret pt) {
        this.code = txt;
        this.joshText = joshTxt;
        this.caret = pt;
    }

    public Selection(Selection selection) {
        this.col = selection.col;
        this.row = selection.row;
        this.code = selection.code;
        this.caret = selection.caret;
    }

    public void deselect(boolean reset) {
        this.row = this.caret.row;
        this.col = this.caret.col;
        if (reset) {
            this.changeType(ST.NORM);
        }
    }

    public void deselectStart(boolean reset) {
        if (this.caret.row < this.row || this.caret.row == this.row && this.caret.col < this.col) {
            this.row = this.caret.row;
            this.col = this.caret.col;
        } else {
            this.caret.row = this.row;
            this.caret.col = this.col;
        }
        if (reset) {
            this.changeType(ST.NORM);
        }
    }

    public void deselectEnd(boolean reset) {
        if (this.row < this.caret.row || this.caret.row == this.row && this.col < this.caret.col) {
            this.row = this.caret.row;
            this.col = this.caret.col;
        } else {
            this.caret.row = this.row;
            this.caret.col = this.col;
        }
        if (reset) {
            this.changeType(ST.NORM);
        }
    }

    public void copy() {
        if (this.isEmpty()) {
            return;
        }
        StringSelection stringSelection = new StringSelection(this.getSelectedTextForCopy());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this.joshText);
    }

    public int getInsertRipple(String str) {
        if (this.type == ST.RECT) {
            return Math.abs(this.caret.row - this.row) + 1;
        }
        if (str.length() > 0 && str.charAt(str.length() - 1) == '\u0000') {
            return Math.max(str.split("(\r?\n|\r)", -1).length, 1);
        }
        return 1;
    }

    public int getPasteRipple() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        try {
            String str = (String)contents.getTransferData(DataFlavor.stringFlavor);
            return this.getInsertRipple(str);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    public int paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        try {
            String ins = (String)contents.getTransferData(DataFlavor.stringFlavor);
            if (ins.length() > 0 && ins.charAt(ins.length() - 1) == '\u0000') {
                return Math.min(this.row, this.caret.row) + Math.max(0, this.insertRect(ins.substring(0, ins.length() - 1)) - 1);
            }
            this.insert(ins);
            return this.caret.row;
        }
        catch (UnsupportedFlavorException e) {
            this.joshText.infoMessages.add("Clipboard contains no text.");
        }
        catch (IOException e) {
            this.joshText.infoMessages.add("Clipboard I/O error: Maybe it's massive?");
        }
        return this.caret.row;
    }

    public int middleClickPaste() {
        Clipboard a = Toolkit.getDefaultToolkit().getSystemSelection();
        if (a == null) {
            a = fallbackMCClipboard;
        }
        if (a == null) {
            return this.caret.row;
        }
        Transferable contents = a.getContents(null);
        try {
            String str = (String)contents.getTransferData(DataFlavor.stringFlavor);
            if (str.length() > 0 && str.charAt(str.length() - 1) == '\u0000') {
                return this.caret.row + Math.max(0, this.insertRect(str.substring(0, str.length() - 1)) - 1);
            }
            this.insert(str);
            return this.caret.row;
        }
        catch (UnsupportedFlavorException e) {
            this.joshText.infoMessages.add("Middle click paste: No data.");
            System.err.println("Middle click paste: No data.");
        }
        catch (IOException e) {
            this.joshText.infoMessages.add("Middle click paste: I/O Exception.");
            System.err.println("Middle click paste: I/O Exception.");
        }
        this.caret.positionChanged();
        return this.caret.row;
    }

    public int getMiddlePasteRipple() {
        Clipboard a = Toolkit.getDefaultToolkit().getSystemSelection();
        if (a == null) {
            a = fallbackMCClipboard;
        }
        if (a == null) {
            return 0;
        }
        Transferable contents = a.getContents(null);
        try {
            String str = (String)contents.getTransferData(DataFlavor.stringFlavor);
            return this.getInsertRipple(str);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    public void selectionChanged() {
        if (this.isEmpty()) {
            return;
        }
        Clipboard a = Toolkit.getDefaultToolkit().getSystemSelection();
        if (a == null) {
            a = fallbackMCClipboard;
        }
        if (a == null) {
            a = fallbackMCClipboard = new Clipboard("Improvised Middle-Click Clipboard");
        }
        StringSelection stringSelection = new StringSelection(this.getSelectedTextForCopy());
        a.setContents(stringSelection, this.joshText);
    }

    public void moveBegin() {
        if (this.row > this.caret.row) {
            this.row = this.caret.row;
            this.col = this.type == ST.RECT ? Math.min(this.caret.col, this.col) : this.caret.col;
        } else {
            this.caret.row = this.row;
            this.caret.col = this.type == ST.RECT ? Math.min(this.caret.col, this.col) : this.col;
        }
        this.type = ST.NORM;
    }

    public void moveEnd() {
        if (this.row > this.caret.row) {
            this.caret.row = this.row;
            this.caret.col = this.type == ST.RECT ? Math.max(this.caret.col, this.col) : this.col;
        } else {
            this.row = this.caret.row;
            this.col = this.type == ST.RECT ? Math.max(this.caret.col, this.col) : this.caret.col;
        }
        this.type = ST.NORM;
    }

    public boolean deleteSel() {
        if (this.isEmpty()) {
            return false;
        }
        switch (this.type) {
            case NORM: {
                if (this.row == this.caret.row) {
                    this.code.getsb(this.row).delete(Math.min(this.col, this.caret.col), Math.max(this.col, this.caret.col));
                    this.caret.col = this.col = Math.min(this.col, this.caret.col);
                    break;
                }
                if (this.row > this.caret.row) {
                    this.code.getsb(this.row).replace(0, this.col, this.code.getsb(this.caret.row).substring(0, this.caret.col));
                    while (this.row > this.caret.row) {
                        this.code.remove(--this.row);
                    }
                    this.col = this.caret.col;
                    break;
                }
                this.code.getsb(this.caret.row).replace(0, this.caret.col, this.code.getsb(this.row).substring(0, this.col));
                while (this.caret.row > this.row) {
                    this.code.remove(--this.caret.row);
                }
                this.caret.col = this.col;
                break;
            }
            case RECT: {
                int x1 = Math.min(this.col, this.caret.col);
                int x2 = Math.max(this.col, this.caret.col);
                int y = Math.min(this.row, this.caret.row);
                while (y <= Math.max(this.row, this.caret.row)) {
                    StringBuilder s = this.code.getsb(y);
                    int ax1 = this.joshText.column_to_index(y, x1);
                    int ax2 = this.joshText.column_to_index(y, x2);
                    if (ax1 < s.length()) {
                        s.delete(ax1, Math.min(ax2, s.length()));
                    }
                    ++y;
                }
                this.col = this.caret.col = x1;
                this.caret.colw = this.joshText.line_wid_at(this.caret.row, this.caret.col);
                return true;
            }
        }
        this.deselect(false);
        return true;
    }

    public boolean isEmpty() {
        switch (this.type) {
            case NORM: {
                return this.col == this.caret.col && this.row == this.caret.row;
            }
            case RECT: {
                return this.col == this.caret.col;
            }
        }
        return true;
    }

    public boolean isCompletelyEmpty() {
        return this.col == this.caret.col && this.row == this.caret.row;
    }

    public String getText() {
        if (this.isEmpty()) {
            return "";
        }
        if (this.row == this.caret.row) {
            return this.code.getsb(this.row).substring(Math.min(this.col, this.caret.col), Math.max(this.col, this.caret.col));
        }
        int f = Math.min(this.row, this.caret.row);
        int l = Math.max(this.row, this.caret.row);
        StringBuilder ret = new StringBuilder(this.code.getsb(f).substring(f == this.row ? this.col : this.caret.col));
        int y = f + 1;
        while (y < l) {
            ret.append(String.valueOf(System.getProperty("line.separator")) + this.code.getsb(y));
            ++y;
        }
        ret.append(String.valueOf(System.getProperty("line.separator")) + this.code.getsb(l).substring(0, l == this.row ? this.col : this.caret.col));
        return new String(ret);
    }

    public int duplicate() {
        switch (this.type) {
            case NORM: {
                if (this.isEmpty()) {
                    this.code.add(this.row + 1, new StringBuilder(this.code.getsb(this.row)));
                    return 1;
                }
                String n = this.getText();
                int res = Math.abs(this.caret.row - this.row) + 1;
                Selection ssel = new Selection(this);
                Caret scar = new Caret(this.caret);
                this.moveEnd();
                this.insert(n);
                this.resetcoords(ssel);
                this.caret.resetcoords(scar);
                return (res - 1) * 2;
            }
        }
        return 0;
    }

    private void resetcoords(Selection ssel) {
        this.col = ssel.col;
        this.row = ssel.row;
    }

    public void insert(char c) {
        switch (this.type) {
            case NORM: {
                this.deleteSel();
                this.code.getsb(this.caret.row).insert(this.caret.col++, c);
                this.col = this.caret.col;
                this.caret.colw = this.joshText.line_wid_at(this.caret.row, this.caret.col);
                break;
            }
            case RECT: {
                this.deleteSel();
                int y = Math.min(this.row, this.caret.row);
                while (y <= Math.max(this.row, this.caret.row)) {
                    if (!this.joshText.column_in_tab(y, this.caret.col)) {
                        StringBuilder s;
                        int ipos = this.joshText.column_to_index_unsafe(y, this.caret.col);
                        if (ipos > (s = this.code.getsb(y)).length()) {
                            StringBuilder spaces = new StringBuilder(ipos - s.length());
                            int i = 0;
                            while (i < ipos - s.length()) {
                                spaces.append(' ');
                                ++i;
                            }
                            s.append((CharSequence)spaces);
                        }
                        s.insert(ipos, c);
                    }
                    ++y;
                }
                this.col = ++this.caret.col;
                this.caret.colw = this.joshText.line_wid_at(this.caret.row, this.caret.col);
            }
        }
    }

    public void insert(String str) {
        String[] lines = str.split("(\r?\n|\r)", -1);
        if (lines.length > 0) {
            switch (this.type) {
                case NORM: {
                    this.deleteSel();
                    StringBuilder l1 = this.code.getsb(this.caret.row);
                    String resub = l1.substring(this.col);
                    l1.replace(this.col, l1.length(), lines[0]);
                    this.caret.col += lines[0].length();
                    int y = 1;
                    while (y < lines.length) {
                        this.code.add(++this.caret.row, lines[y]);
                        this.caret.col = lines[y].length();
                        ++y;
                    }
                    this.code.getsb(this.caret.row).append(resub);
                    this.col = this.caret.col;
                    this.row = this.caret.row;
                    this.caret.colw = this.joshText.line_wid_at(this.caret.row, this.caret.col);
                    break;
                }
                case RECT: {
                    this.deleteSel();
                    int sr = Math.min(this.caret.row, this.row);
                    int i = 0;
                    while (i <= Math.abs(this.caret.row - this.row)) {
                        StringBuilder s;
                        int ipos = this.joshText.column_to_index_unsafe(sr + i, this.caret.col);
                        if (ipos > (s = this.code.getsb(sr + i)).length()) {
                            StringBuilder spaces = new StringBuilder(ipos - s.length());
                            int si = 0;
                            while (si < ipos - s.length()) {
                                spaces.append(' ');
                                ++si;
                            }
                            s.append((CharSequence)spaces);
                        }
                        this.code.getsb(sr + i).insert(ipos, lines[i % lines.length]);
                        ++i;
                    }
                    break;
                }
            }
        }
    }

    public int insertRect(String str) {
        String[] lines = str.split("(\r?\n|\r)", -1);
        if (lines.length > 0) {
            switch (this.type) {
                case NORM: {
                    this.deleteSel();
                    int dcol = this.joshText.index_to_column(this.caret.row, this.caret.col);
                    while (this.caret.row + lines.length > this.code.size()) {
                        this.code.add(new Line(new StringBuilder("")));
                    }
                    int i = 0;
                    while (i < lines.length) {
                        int ipos = this.joshText.column_to_index_unsafe(this.caret.row + i, dcol);
                        StringBuilder sb = this.code.getsb(this.caret.row + i);
                        while (sb.length() < ipos) {
                            sb.append(' ');
                        }
                        sb.insert(ipos, lines[i]);
                        ++i;
                    }
                    return lines.length;
                }
                case RECT: {
                    if (this.caret.col == this.col) {
                        int sr = Math.min(this.row, this.caret.row);
                        int ld = Math.abs(this.caret.row - this.row);
                        int i = 0;
                        while (i < lines.length && i < ld + 1) {
                            this.code.getsb(sr + i).insert(this.joshText.column_to_index(sr + i, this.col), lines[i]);
                            ++i;
                        }
                        return i;
                    }
                    int maxw = Math.abs(this.caret.col - this.col);
                    int ld = Math.abs(this.caret.row - this.row);
                    int sr = Math.min(this.caret.row, this.row);
                    this.deleteSel();
                    int i = 0;
                    while (i < lines.length && i < ld + 1) {
                        String itxt = lines[i];
                        int ipos = this.joshText.column_to_index_unsafe(sr + i, this.col);
                        StringBuilder sb = this.code.getsb(sr + i);
                        while (ipos > sb.length()) {
                            sb.append(' ');
                        }
                        if (itxt.length() > maxw) {
                            itxt = itxt.substring(0, maxw);
                        } else if (ipos < sb.length()) {
                            while (itxt.length() < maxw) {
                                itxt = String.valueOf(itxt) + ' ';
                            }
                        }
                        sb.insert(ipos, itxt);
                        ++i;
                    }
                    return i;
                }
            }
        }
        return 0;
    }

    public SortedRegion getSortedRegion() {
        Point p1 = new Point(this.caret.col, this.caret.row);
        Point p2 = new Point(this.col, this.row);
        switch (this.type) {
            case RECT: {
                return new RectangleRegion(p1, p2);
            }
            case NORM: {
                return new RowFirstRegion(p1, p2);
            }
        }
        return null;
    }

    public boolean containsPoint(Point p) {
        Point colRow = this.joshText.mouseToPoint(p, this.type != ST.RECT);
        return this.contains(colRow.y, colRow.x);
    }

    public boolean contains(int rowNum, int colNum) {
        if (this.isEmpty()) {
            return false;
        }
        SortedRegion r = this.getSortedRegion();
        switch (this.type) {
            case RECT: {
                return rowNum >= r.getMinY() && rowNum <= r.getMaxY() && colNum >= r.getMinX() && colNum <= r.getMaxX();
            }
            case NORM: {
                if (rowNum < r.getMinY() || rowNum > r.getMaxY()) {
                    return false;
                }
                if (rowNum == r.getMinY() && colNum < r.getMinX()) {
                    return false;
                }
                return rowNum != r.getMaxY() || colNum <= r.getMaxX();
            }
        }
        return false;
    }

    @Override
    public void paint(Graphics g, Insets i, JoshText.CodeMetrics cm, int line_start, int line_end) {
        if (this.isEmpty()) {
            return;
        }
        new SortedRegionHighlighter(this.getSortedRegion(), this.type).paint(g, i, cm, line_start, line_end);
    }

    public void changeType(ST t) {
        if (this.type == t) {
            return;
        }
        this.type = t;
        if (t == ST.NORM) {
            this.col = this.joshText.column_to_index(this.row, this.col);
            this.caret.col = this.joshText.column_to_index(this.caret.row, this.caret.col);
            this.special.toNorm();
        } else {
            this.col = this.joshText.index_to_column(this.row, this.col);
            this.caret.col = this.joshText.index_to_column(this.caret.row, this.caret.col);
            this.special.toRect();
        }
    }

    public String getSelectedText() {
        SortedRegion r = this.getSortedRegion();
        int maxY = Math.min(r.getMaxY(), this.joshText.code.size());
        if (r.getMinY() == maxY) {
            StringBuilder line = this.joshText.code.getsb(r.getMinY());
            if (r.getMinX() >= line.length()) {
                return "";
            }
            return line.substring(r.getMinX(), Math.min(r.getMaxX(), line.length()));
        }
        switch (this.type) {
            case RECT: {
                StringBuilder sbr = new StringBuilder();
                int y = r.getMinY();
                while (y <= maxY) {
                    StringBuilder liner = this.joshText.code.getsb(y);
                    int bpos = this.joshText.column_to_index(y, r.getMinX());
                    if (bpos < liner.length()) {
                        sbr.append(liner.substring(bpos, Math.min(this.joshText.column_to_index(y, r.getMaxX()), liner.length())));
                    }
                    if (y != maxY) {
                        sbr.append('\n');
                    }
                    ++y;
                }
                return sbr.toString();
            }
            case NORM: {
                StringBuilder sbn = new StringBuilder(this.joshText.code.getsb(r.getMinY()).substring(r.getMinX()));
                int y = r.getMinY() + 1;
                while (y < maxY) {
                    sbn.append('\n').append((CharSequence)this.joshText.code.getsb(y));
                    ++y;
                }
                StringBuilder linen = this.joshText.code.getsb(maxY);
                sbn.append('\n').append(linen.substring(0, Math.min(r.getMaxX(), linen.length())));
                return sbn.toString();
            }
        }
        return null;
    }

    public String getSelectedTextForCopy() {
        String ret = this.getSelectedText();
        if (this.type == ST.RECT) {
            ret = String.valueOf(ret) + '\u0000';
        }
        return ret;
    }

    public void selectCaretWord() {
        StringBuilder sb = this.joshText.code.getsb(this.caret.row);
        this.special.spos = this.caret.getPositionRepresentation(this);
        this.special.epos = this.caret.getPositionRepresentation(this);
        int skind = JoshText.selGetKind(sb, this.special.spos);
        while (this.special.spos > 0 && JoshText.selOfKind(sb, this.special.spos - 1, skind)) {
            --this.special.spos;
        }
        while (++this.special.epos < sb.length() && JoshText.selOfKind(sb, this.special.epos, skind)) {
        }
        this.row = this.caret.row;
        this.col = this.special.spos;
        this.caret.col = this.special.epos;
        this.special.ssrow = this.caret.row;
        this.special.valid = true;
        if (this.type == ST.RECT) {
            this.special.toRect();
        }
    }

    class LineSelHandler
    implements SpecialSelectionHandler {
        LineSelHandler() {
        }

        @Override
        public void adjustSelection(SpecialSel ss) {
            block10: {
                if (Selection.this.row > Selection.this.caret.row) {
                    Selection.this.caret.col = 0;
                    Selection.this.col = Selection.this.code.getsb(Selection.this.row).length();
                } else if (Selection.this.row < Selection.this.caret.row) {
                    Selection.this.col = 0;
                    Selection.this.caret.col = Selection.this.code.getsb(Selection.this.caret.row).length();
                } else if (Selection.this.col < Selection.this.caret.col) {
                    Selection.this.col = 0;
                    Selection.this.caret.col = Selection.this.code.getsb(Selection.this.caret.row).length();
                } else {
                    Selection.this.caret.col = 0;
                    Selection.this.col = Selection.this.code.getsb(Selection.this.row).length();
                }
                if (Selection.this.type != ST.RECT) break block10;
                if (Selection.this.caret.col == 0) {
                    int i = Selection.this.caret.row;
                    while (i <= Selection.this.row) {
                        Selection.this.col = Math.max(Selection.this.col, Selection.this.joshText.index_to_column(i, Selection.this.code.getsb(i).length()));
                        ++i;
                    }
                } else {
                    int i = Selection.this.row;
                    while (i <= Selection.this.caret.row) {
                        Selection.this.caret.col = Math.max(Selection.this.caret.col, Selection.this.joshText.index_to_column(i, Selection.this.code.getsb(i).length()));
                        ++i;
                    }
                }
            }
        }
    }

    public static class RectangleRegion
    extends SortedRegion {
        public RectangleRegion(Point p1, Point p2) {
            super(p1, p2);
        }

        @Override
        protected void setSorted(Point p1, Point p2) {
            this.minPt = p1;
            this.maxPt = p2;
            if (p2.y < p1.y) {
                this.minPt = p2;
                this.maxPt = p1;
            }
            if (this.maxPt.x < this.minPt.x) {
                int minx = this.maxPt.x;
                this.maxPt.x = this.minPt.x;
                this.minPt.x = minx;
            }
        }
    }

    public static class RowFirstRegion
    extends SortedRegion {
        public RowFirstRegion(Point p1, Point p2) {
            super(p1, p2);
        }

        @Override
        protected void setSorted(Point p1, Point p2) {
            this.minPt = p1;
            this.maxPt = p2;
            if (p1.y == p2.y) {
                if (p2.x < p1.x) {
                    this.minPt = p2;
                    this.maxPt = p1;
                }
            } else if (p2.y < p1.y) {
                this.minPt = p2;
                this.maxPt = p1;
            }
        }
    }

    static enum ST {
        NORM,
        RECT;

    }

    public static class SimpleHighlighter
    implements JoshText.Highlighter {
        protected static final Color DEF_COL = new Color(200, 200, 220);
        protected int y;
        protected int x1;
        protected int x2;

        public SimpleHighlighter(int y, int x1, int x2) {
            this.y = y;
            this.x1 = x1;
            this.x2 = x2;
        }

        @Override
        public void paint(Graphics g, Insets i, JoshText.CodeMetrics cm, int line_start, int line_end) {
            g.setColor(DEF_COL);
            int gh = cm.lineHeight();
            int xx = cm.lineWidth(this.y, this.x1);
            g.fillRect(i.left + xx, i.top + this.y * gh, cm.lineWidth(this.y, this.x2) - xx, gh);
        }
    }

    public static abstract class SortedRegion {
        protected Point minPt;
        protected Point maxPt;

        public SortedRegion(Point p1, Point p2) {
            this.setSorted(p1, p2);
        }

        protected abstract void setSorted(Point var1, Point var2);

        public Point getMinPoint() {
            return this.minPt;
        }

        public Point getMaxPoint() {
            return this.maxPt;
        }

        public int getMinX() {
            return this.minPt.x;
        }

        public int getMinY() {
            return this.minPt.y;
        }

        public int getMaxX() {
            return this.maxPt.x;
        }

        public int getMaxY() {
            return this.maxPt.y;
        }
    }

    public static class SortedRegionHighlighter
    implements JoshText.Highlighter {
        SortedRegion r;
        ST type;
        static final Color DEF_COL = new Color(200, 200, 220);

        public SortedRegionHighlighter(SortedRegion r, ST type) {
            this.r = r;
            this.type = type;
        }

        @Override
        public void paint(Graphics g, Insets i, JoshText.CodeMetrics cm, int line_start, int line_end) {
            Color rc = g.getColor();
            g.setColor(DEF_COL);
            int gw = cm.glyphWidth();
            int gh = cm.lineHeight();
            if (this.type == ST.RECT) {
                g.fillRect(i.left + this.r.getMinX() * gw, i.top + this.r.getMinY() * gh, (this.r.getMaxX() - this.r.getMinX()) * gw, (this.r.getMaxY() - this.r.getMinY() + 1) * gh);
            } else if (this.r.getMaxY() == this.r.getMinY()) {
                new SimpleHighlighter(this.r.getMinY(), this.r.getMinX(), this.r.getMaxX()).paint(g, i, cm, line_start, line_end);
            } else if (this.type == ST.NORM) {
                Rectangle clip = g.getClipBounds();
                g.fillRect(i.left + cm.lineWidth(this.r.getMinY(), this.r.getMinX()), i.top + this.r.getMinY() * gh, clip.width - cm.lineWidth(this.r.getMinY(), this.r.getMinX()) - i.left + clip.x, gh);
                g.fillRect(i.left + clip.x, i.top + (this.r.getMinY() + 1) * gh, clip.width, (this.r.getMaxY() - this.r.getMinY() - 1) * gh);
                g.fillRect(i.left, i.top + this.r.getMaxY() * gh, cm.lineWidth(this.r.getMaxY(), this.r.getMaxX()), gh);
            }
            g.setColor(rc);
        }
    }

    class SpecialSel {
        boolean valid = false;
        public int ssrow;
        int spos = 0;
        int epos = 0;
        SpecialSelectionHandler ssh;
        int irow;
        int icol;

        SpecialSel() {
        }

        public void toNorm() {
            if (this.valid) {
                this.spos = Selection.this.joshText.column_to_index(this.ssrow, this.spos);
                this.epos = Selection.this.joshText.column_to_index(this.ssrow, this.epos);
            }
        }

        public void toRect() {
            if (this.valid) {
                this.spos = Selection.this.joshText.index_to_column(this.ssrow, this.spos);
                this.epos = Selection.this.joshText.index_to_column(this.ssrow, this.epos);
            }
        }

        public void setHandler(SpecialSelectionHandler specSelHandler) {
            this.valid = true;
            this.ssh = specSelHandler;
            this.icol = Selection.this.caret.col;
            this.irow = Selection.this.caret.row;
        }

        public void adjust() {
            this.ssh.adjustSelection(this);
        }
    }

    static interface SpecialSelectionHandler {
        public void adjustSelection(SpecialSel var1);
    }

    class WordSelHandler
    implements SpecialSelectionHandler {
        WordSelHandler() {
        }

        @Override
        public void adjustSelection(SpecialSel ss) {
            if (Selection.this.type == ST.RECT ? Selection.this.caret.col >= Selection.this.joshText.index_to_column(ss.irow, ss.icol) : Selection.this.caret.row > ss.irow || Selection.this.caret.row == ss.irow && Selection.this.caret.col >= ss.icol) {
                Selection.this.col = ss.icol;
                if (Selection.this.col > 0) {
                    --Selection.this.col;
                }
                StringBuilder sb = Selection.this.code.getsb(Selection.this.row);
                int st = JoshText.selGetKind(sb, Selection.this.col);
                while (Selection.this.col >= 0 && JoshText.selOfKind(sb, Selection.this.col, st)) {
                    --Selection.this.col;
                }
                ++Selection.this.col;
                sb = Selection.this.code.getsb(Selection.this.caret.row);
                if (Selection.this.type == ST.RECT) {
                    Selection.this.caret.col = Selection.this.joshText.column_to_index(Selection.this.caret.row, Selection.this.caret.col);
                }
                st = JoshText.selGetKind(sb, Selection.this.caret.col);
                int ep = Selection.this.caret.col;
                int sp = Selection.this.caret.col;
                while (sp >= 0 && JoshText.selOfKind(sb, sp, st)) {
                    --sp;
                }
                ++sp;
                while (ep < sb.length() && JoshText.selOfKind(sb, ep, st)) {
                    ++ep;
                }
                Selection.this.caret.col = Selection.this.type != ST.RECT ? (Selection.this.caret.col - sp > 0 || Selection.this.caret.col == ss.icol && Selection.this.caret.row == ss.irow ? ep : sp) : (Selection.this.caret.col - sp > 0 || sp == Selection.this.joshText.column_to_index(ss.irow, ss.icol) ? ep : sp);
            } else {
                StringBuilder sb = Selection.this.code.getsb(Selection.this.caret.row);
                if (Selection.this.type == ST.RECT) {
                    Selection.this.caret.col = Selection.this.joshText.column_to_index(Selection.this.caret.row, Selection.this.caret.col);
                }
                int st = JoshText.selGetKind(sb, Selection.this.caret.col);
                while (Selection.this.caret.col >= 0 && JoshText.selOfKind(sb, Selection.this.caret.col, st)) {
                    --Selection.this.caret.col;
                }
                ++Selection.this.caret.col;
                Selection.this.col = ss.icol;
                sb = Selection.this.code.getsb(Selection.this.row);
                st = JoshText.selGetKind(sb, Selection.this.col);
                while (Selection.this.col < sb.length() && JoshText.selOfKind(sb, Selection.this.col, st)) {
                    ++Selection.this.col;
                }
            }
            if (Selection.this.type == ST.RECT) {
                Selection.this.caret.col = Selection.this.joshText.index_to_column(Selection.this.caret.row, Selection.this.caret.col);
                Selection.this.col = Selection.this.joshText.index_to_column(Selection.this.row, Selection.this.col);
            }
        }
    }
}

