/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.lateralgm.joshedit.JoshTextPanel;
import org.lateralgm.joshedit.TokenMarker;
import org.lateralgm.joshedit.lexers.CPPTokenMarker;
import org.lateralgm.joshedit.lexers.GLESTokenMarker;
import org.lateralgm.joshedit.lexers.GLSLTokenMarker;
import org.lateralgm.joshedit.lexers.GMLTokenMarker;
import org.lateralgm.joshedit.lexers.HLSLTokenMarker;
import org.lateralgm.joshedit.preferences.HighlightPreferences;
import org.lateralgm.joshedit.preferences.KeybindingsPanel;

public class Runner {
    public static final ResourceBundle MESSAGES = ResourceBundle.getBundle("org.lateralgm.joshedit.translate");
    public static final Preferences PREFS = Preferences.userRoot().node("/org/lateralgm/joshedit");
    public static EditorInterface editorInterface = new EditorInterface(){

        @Override
        public ImageIcon getIconForKey(String key) {
            return Runner.getIconForKey(key);
        }

        @Override
        public String getString(String key) {
            return Runner.getString(key, null);
        }

        @Override
        public String getString(String key, String def) {
            return Runner.getString(key, def);
        }
    };

    public static void createAndShowGUI() {
        Runner.showCodeWindow(true);
    }

    public static void showCodeWindow(boolean closeExit) {
        JFrame f = new JFrame("Title");
        JoshTextPanel p = new JoshTextPanel(Runner.getDefaultCode());
        p.setTokenMarker(new GMLTokenMarker());
        f.setContentPane(p);
        f.pack();
        f.setLocationRelativeTo(null);
        if (closeExit) {
            f.setDefaultCloseOperation(3);
        }
        f.setVisible(true);
    }

    public static String[] getDefaultCode() {
        ArrayList<String> code = new ArrayList<String>();
        code.add("Hello, world");
        code.add("Bracket's' { test }");
        code.add("\tTab test line 1");
        code.add("\tTab test line 2");
        code.add("\tTab test line 3");
        code.add("End tab test line");
        code.add("derp\tCascading tab test");
        code.add("der\tCascading tab test");
        code.add("de\tCascading tab test");
        code.add("d\tCascading tab test");
        code.add("if (a = \"It's hard to think\")");
        code.add("  then b = c + 10; // That after all this time");
        code.add("else /* Everything is finally working.");
        code.add("        *wipes tear* */");
        code.add("  d = e * 20;");
        code.add("/** Okay, so there are probably");
        code.add("    some bugs to work out, but you");
        code.add("    have to admit... It looks nice. */");
        return code.toArray(new String[0]);
    }

    public static String[] splitLines(String text) {
        if (text == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(text.length() / 50);
        Scanner sc = new Scanner(text);
        while (sc.hasNextLine()) {
            list.add(sc.nextLine());
        }
        sc.close();
        return list.toArray(new String[0]);
    }

    public static void showBindingsWindow(boolean closeExit) {
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new BoxLayout(f.getContentPane(), 3));
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Bindings", new KeybindingsPanel());
        tabs.addTab("Colors", new HighlightPreferences(new TokenMarker.LanguageDescription[][]{CPPTokenMarker.getLanguageDescriptions(), GMLTokenMarker.getLanguageDescriptions(), GLSLTokenMarker.getLanguageDescriptions(), GLESTokenMarker.getLanguageDescriptions(), HLSLTokenMarker.getLanguageDescriptions()}, Preferences.userRoot().node("org/joshedit")));
        f.add(tabs);
        JPanel repanel = new JPanel();
        repanel.setLayout(new BoxLayout(repanel, 2));
        JButton ok = new JButton("OK");
        repanel.add(ok);
        JButton cancel = new JButton("Cancel");
        repanel.add(cancel);
        f.add(repanel);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        f.pack();
        f.setLocationRelativeTo(null);
        if (closeExit) {
            f.setDefaultCloseOperation(3);
        }
        f.setVisible(true);
    }

    public static void showFindWindow(boolean closeExit) {
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new BoxLayout(f.getContentPane(), 3));
    }

    public static ImageIcon findIcon(String filename) {
        URL url;
        String location = "org/lateralgm/joshedit/icons/" + filename;
        ImageIcon ico = new ImageIcon(location);
        if (ico.getIconWidth() == -1 && (url = Runner.class.getClassLoader().getResource(location)) != null) {
            ico = new ImageIcon(url);
        }
        return ico;
    }

    public static ImageIcon getIconForKey(String key) {
        Properties iconProps = new Properties();
        InputStream is = Runner.class.getClassLoader().getResourceAsStream("org/lateralgm/joshedit/icons.properties");
        try {
            iconProps.load(is);
        }
        catch (IOException e) {
            System.err.println("Unable to read icons.properties");
        }
        String filename = iconProps.getProperty(key, "");
        if (!filename.isEmpty()) {
            return Runner.findIcon(filename);
        }
        return null;
    }

    public static String getString(String key, String def) {
        String r;
        try {
            r = MESSAGES.getString(key);
        }
        catch (MissingResourceException e) {
            r = def == null ? String.valueOf('!') + key + '!' : def;
        }
        return PREFS.get(key, r);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Runner.createAndShowGUI();
            }
        });
    }

    public static interface EditorInterface {
        public ImageIcon getIconForKey(String var1);

        public String getString(String var1);

        public String getString(String var1, String var2);
    }
}

