/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.lateralgm.joshedit.Code;
import org.lateralgm.joshedit.FindDialog;
import org.lateralgm.joshedit.JoshText;
import org.lateralgm.joshedit.Runner;

public class QuickFind
extends JToolBar
implements FindDialog.FindNavigator {
    private static final long serialVersionUID = 1L;
    private static final Font FONT = new Font("SansSerif", 0, 12);
    private static final String S_FIND = Runner.editorInterface.getString("QuickFind.FIND_LBL");
    private static final String S_REPL = Runner.editorInterface.getString("QuickFind.REPLACE_LBL");
    private static final String B_HIGHL = Runner.editorInterface.getString("QuickFind.HIGHLIGHT");
    private static final String B_REPL = Runner.editorInterface.getString("QuickFind.REPLACE");
    private static final ImageIcon I_CLOSE = Runner.editorInterface.getIconForKey("QuickFind.CLOSE");
    private static final ImageIcon I_PREV = Runner.editorInterface.getIconForKey("QuickFind.PREV");
    private static final ImageIcon I_NEXT = Runner.editorInterface.getIconForKey("QuickFind.NEXT");
    private static final ImageIcon I_MARK = Runner.editorInterface.getIconForKey("QuickFind.MARK");
    private static final ImageIcon I_REPL = Runner.editorInterface.getIconForKey("QuickFind.REPL");
    private static final ImageIcon I_SET = Runner.editorInterface.getIconForKey("QuickFind.SET");
    public JButton close;
    public JButton prev;
    public JButton next;
    public JButton settings;
    public JLabel swapFnR;
    public JToggleButton highlight;
    public JButton bReplace;
    public JTextField tFind;
    public JTextField tReplace;
    public JoshText joshText;
    Mode mode = Mode.mode_find;
    protected Code.FindResults lastResult = null;
    public boolean boldFontOnHover = false;

    public QuickFind(JoshText text) {
        this.setFloatable(false);
        this.close = new JButton(I_CLOSE);
        this.add(this.close);
        this.swapFnR = new JLabel(S_FIND);
        this.add(this.swapFnR);
        this.tFind = new JTextField();
        this.add(this.tFind);
        this.tFind.setColumns(13);
        this.tReplace = new JTextField();
        this.add(this.tReplace);
        this.tReplace.setColumns(13);
        this.prev = new JButton(I_PREV);
        this.add(this.prev);
        this.next = new JButton(I_NEXT);
        this.add(this.next);
        this.highlight = new JToggleButton(B_HIGHL, I_MARK);
        this.add(this.highlight);
        this.bReplace = new JButton(B_REPL, I_REPL);
        this.add(this.bReplace);
        this.settings = new JButton(I_SET);
        this.add(this.settings);
        this.highlight.setFont(FONT);
        this.swapFnR.setFont(FONT);
        this.swapFnR.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.setPreferredSize(new Dimension(320, 24));
        this.setBorder(null);
        this.tReplace.setVisible(false);
        this.bReplace.setVisible(false);
        this.joshText = text;
        this.settings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.tFind.setSelectedItem(QuickFind.this.tFind.getText());
                FindDialog.getInstance().selectedJoshText = QuickFind.this.joshText;
                FindDialog.getInstance().setVisible(true);
            }
        });
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickFind.this.setVisible(false);
            }
        });
        this.prev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                QuickFind.this.findPrevious();
            }
        });
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                QuickFind.this.findNext();
            }
        });
        this.tFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((e.getModifiers() & 0x40) != 0 ^ FindDialog.backward.isSelected()) {
                    QuickFind.this.findPrevious();
                } else {
                    QuickFind.this.findNext();
                }
            }
        });
        this.bReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (QuickFind.this.lastResult == null || !QuickFind.this.isSelected(QuickFind.this.lastResult)) {
                    if (QuickFind.this.joshText.sel.isEmpty()) {
                        if (!FindDialog.backward.isSelected()) {
                            QuickFind.this.findNext();
                        } else {
                            QuickFind.this.findPrevious();
                        }
                    }
                } else {
                    QuickFind.this.doReplace();
                }
            }
        });
        this.swapFnR.addMouseListener(new MouseAdapter(){
            final Color HIGHLIGHT = new Color(0, 128, 255);

            @Override
            public void mouseExited(MouseEvent arg0) {
                Font mf;
                JComponent but = (JComponent)arg0.getSource();
                if (QuickFind.this.boldFontOnHover && ((mf = but.getFont()).getStyle() & 1) != 0) {
                    but.setFont(mf.deriveFont(mf.getStyle() & 0xFFFFFFFE));
                }
                but.setForeground(Color.BLACK);
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                Font mf;
                JComponent but = (JComponent)arg0.getSource();
                if (QuickFind.this.boldFontOnHover && ((mf = but.getFont()).getStyle() & 1) == 0) {
                    but.setFont(mf.deriveFont(mf.getStyle() | 1));
                }
                but.setForeground(this.HIGHLIGHT);
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                QuickFind.this.toggleMode();
            }
        });
        this.setVisible(false);
    }

    @Override
    public void doReplace() {
        JoshText.UndoPatch up = new JoshText.UndoPatch(this.joshText);
        this.joshText.sel.insert(this.tReplace.getText());
        up.realize(Math.max(this.joshText.caret.row, this.joshText.sel.row));
        this.joshText.storeUndo(up, 9);
        this.joshText.repaint();
    }

    protected void toggleMode() {
        if (this.mode != Mode.mode_find) {
            this.toggleModeFind();
        } else {
            this.toggleModeReplace();
        }
    }

    protected void toggleModeFind() {
        this.swapFnR.setText(S_FIND);
        this.tFind.setVisible(true);
        this.tReplace.setVisible(false);
        this.highlight.setVisible(true);
        this.bReplace.setVisible(false);
        this.mode = Mode.mode_find;
    }

    protected void toggleModeReplace() {
        this.swapFnR.setText(S_REPL);
        this.tFind.setVisible(false);
        this.tReplace.setVisible(true);
        this.highlight.setVisible(false);
        this.bReplace.setVisible(true);
        this.mode = Mode.mode_replace;
    }

    private void selectFind(Code.FindResults fr) {
        this.joshText.caret.row = fr.line;
        this.joshText.caret.col = fr.pos;
        this.joshText.sel.row = fr.endLine;
        this.joshText.sel.col = fr.endPos;
        this.joshText.caret.positionChanged();
        this.joshText.repaint();
    }

    protected boolean isSelected(Code.FindResults fr) {
        boolean res = this.joshText.caret.row == fr.line && this.joshText.caret.col == fr.pos && this.joshText.sel.row == fr.endLine && this.joshText.sel.col == fr.endPos;
        System.out.println("SELECTED: " + res);
        return res;
    }

    @Override
    public void findNext() {
        String ftext;
        if (FindDialog.wrap.isSelected() && this.joshText.caret.row == this.joshText.getLineCount() - 1) {
            this.joshText.caret.col = 0;
            this.joshText.caret.row = 0;
        }
        if ((ftext = this.tFind.getText()).length() == 0) {
            return;
        }
        if (FindDialog.regex.isSelected()) {
            Pattern p;
            try {
                p = Pattern.compile(ftext, 2);
            }
            catch (PatternSyntaxException pse) {
                System.out.println("Shit man, your expression sucks");
                return;
            }
            this.lastResult = this.joshText.code.findNext(p, this.joshText.caret.row, this.joshText.caret.col + (this.joshText.sel.isEmpty() ? 0 : 1));
            if (this.lastResult != null) {
                this.selectFind(this.lastResult);
            }
            return;
        }
        String[] findme = ftext.split("\r?\n");
        this.lastResult = this.joshText.code.findNext(findme, this.joshText.caret.row, this.joshText.caret.col + (this.joshText.sel.isEmpty() ? 0 : 1));
        if (this.lastResult != null) {
            this.selectFind(this.lastResult);
        }
    }

    @Override
    public void findPrevious() {
        String ftext;
        if (FindDialog.wrap.isSelected() && this.joshText.caret.row == this.joshText.getLineCount() - 1) {
            this.joshText.caret.col = 0;
            this.joshText.caret.row = 0;
        }
        if ((ftext = this.tFind.getText()).length() == 0) {
            return;
        }
        if (FindDialog.regex.isSelected()) {
            return;
        }
        String[] findme = ftext.split("\r?\n");
        this.lastResult = this.joshText.code.findPrevious(findme, this.joshText.caret.row, this.joshText.caret.col);
        if (this.lastResult != null) {
            this.selectFind(this.lastResult);
        }
    }

    @Override
    public void updateParameters(String find, String replace) {
        this.tFind.setText(find);
        this.tReplace.setText(replace);
    }

    @Override
    public void present() {
        this.setVisible(true);
        this.tFind.selectAll();
        this.tFind.grabFocus();
    }

    @Override
    public void replaceNext() {
        this.findNext();
        this.toggleModeReplace();
    }

    @Override
    public int replaceAll() {
        if (FindDialog.wrap.isSelected()) {
            this.joshText.caret.col = 0;
            this.joshText.caret.row = 0;
        }
        int count = 0;
        this.toggleModeReplace();
        String ftext = this.tFind.getText();
        if (ftext.length() == 0) {
            return count;
        }
        if (FindDialog.regex.isSelected()) {
            Pattern p;
            try {
                p = Pattern.compile(ftext, 2);
            }
            catch (PatternSyntaxException pse) {
                System.out.println("Shit man, your expression sucks");
                return count;
            }
            Boolean resultsExist = true;
            while (resultsExist.booleanValue()) {
                this.lastResult = this.joshText.code.findNext(p, this.joshText.caret.row, this.joshText.caret.col + (this.joshText.sel.isEmpty() ? 0 : 1));
                if (this.lastResult != null) {
                    this.selectFind(this.lastResult);
                    this.doReplace();
                    ++count;
                    continue;
                }
                resultsExist = false;
            }
            return count;
        }
        String[] findme = ftext.split("\r?\n");
        Boolean resultsExist = true;
        while (resultsExist.booleanValue()) {
            this.lastResult = this.joshText.code.findNext(findme, this.joshText.caret.row, this.joshText.caret.col + (this.joshText.sel.isEmpty() ? 0 : 1));
            if (this.lastResult != null) {
                this.selectFind(this.lastResult);
                this.doReplace();
                ++count;
                continue;
            }
            resultsExist = false;
        }
        return count;
    }

    @Override
    public void replacePrevious() {
        this.findPrevious();
        this.toggleModeReplace();
    }

    static enum Mode {
        mode_find,
        mode_replace;

    }
}

