/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.joshedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lateralgm.joshedit.ColorProfile;

public class LineNumberPanel
extends JPanel {
    public static final Color DEFAULT_LIGHT_BACKGROUND = new Color(220, 220, 220);
    public static final Color DEFAULT_LIGHT_FOREGROUND = new Color(170, 170, 170);
    private static final long serialVersionUID = 1L;
    protected FontMetrics metrics;
    protected int lines;
    protected boolean startZero;
    private Color fgColor = DEFAULT_LIGHT_FOREGROUND;
    private Color bgColor = DEFAULT_LIGHT_BACKGROUND;

    public LineNumberPanel(FontMetrics metrics, int lines, boolean startZero) {
        this.setFont(new Font("Monospace", 0, metrics.getFont().getSize()));
        this.metrics = metrics;
        this.lines = lines;
        this.startZero = startZero;
        this.resize();
    }

    public LineNumberPanel(JComponent textarea, int lines, boolean startZero) {
        this(textarea.getFontMetrics(textarea.getFont()), lines, startZero);
    }

    public void setLines(int lines) {
        this.lines = lines + (this.startZero ? 0 : 1);
        this.resize();
        this.repaint();
    }

    public void setColorProfile(ColorProfile prof) {
        if (prof.getLineNumberColor() != null) {
            this.fgColor = prof.getLineNumberColor();
        }
        if (prof.getLineNumberPanelColor() != null) {
            this.bgColor = prof.getLineNumberPanelColor();
        }
    }

    public int getLineNumberWidth(int maxline) {
        int[] widths = this.getFontMetrics(this.getFont()).getWidths();
        int maxAdvance = 0;
        int i = 48;
        while (i <= 57) {
            if (widths[i] > maxAdvance) {
                maxAdvance = widths[i];
            }
            ++i;
        }
        return maxAdvance * (int)Math.max(Math.log10(maxline - (this.startZero ? 1 : 0)) + 2.0, 2.0);
    }

    public void resize() {
        int width = this.getLineNumberWidth(this.lines);
        int height = this.metrics.getHeight() * (this.lines + 1);
        this.setPreferredSize(new Dimension(width + 3, height));
        this.revalidate();
    }

    public void printLineNumbers(Graphics g, int start, int count, int width) {
        Object map = Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            ((Graphics2D)g).addRenderingHints((Map)map);
        }
        int insetY = this.metrics.getLeading() + this.metrics.getAscent();
        int gh = this.metrics.getHeight();
        Dimension size = new Dimension(width, count * gh);
        int lineNum = start;
        int end = size.height;
        g.setColor(this.bgColor);
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(this.fgColor);
        g.setFont(this.getFont());
        int y = insetY;
        while (lineNum < this.lines && y <= end) {
            String str = Integer.toString(lineNum);
            int strw = (int)g.getFontMetrics().getStringBounds(str, g).getWidth();
            g.drawString(str, size.width - strw - 3, y);
            ++lineNum;
            y += gh;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Object map = Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            ((Graphics2D)g).addRenderingHints((Map)map);
        }
        Rectangle clip = this.getVisibleRect();
        clip.setSize(this.getWidth(), clip.height);
        int insetY = this.metrics.getLeading() + this.metrics.getAscent();
        int gh = this.metrics.getHeight();
        int lineNum = clip.y / gh;
        int start = lineNum * gh + insetY;
        int end = clip.y + clip.height + gh;
        if (!this.startZero) {
            ++lineNum;
        }
        g.setColor(this.bgColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.fgColor);
        g.setFont(this.getFont());
        int y = start;
        while (lineNum < this.lines && y <= end) {
            String str = Integer.toString(lineNum);
            int strw = (int)g.getFontMetrics().getStringBounds(str, g).getWidth();
            g.drawString(str, clip.width - strw - 3, y);
            ++lineNum;
            y += gh;
        }
    }
}

